/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.remote.ui.swtbot.tests.fetch;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.keyboard.Keystrokes;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCombo;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.ctf.core.tests.shared.LttngTraceGenerator;
import org.eclipse.tracecompass.tmf.remote.ui.swtbot.tests.TmfRemoteUISWTBotTestPlugin;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class FetchRemoteTracesTest {
    private static final String CONNECTION_NODE_NAME = "node1";
    private static final String CONNECTION_NODE_TEXT = "node1 (file://)";
    private static final String LTTNG_TRACE_FILE_PATTERN = ".*synthetic.*";
    private static final String FETCH_COMMAND_NAME = "Fetch Remote Traces...";
    private static final String PROFILE_NAME = "new profile";
    private static final String PROJECT_EXPLORER = "Project Explorer";
    private static final String PROJECT_NAME = "Test";
    private static final String SYSLOG_FILE_PATTERN = ".*syslog";
    private static final String TRACE_GROUP_NODE_TEXT;
    private static final String TRACE_LOCATION;
    private static final String TRACE_TYPE_LTTNG = "org.eclipse.linuxtools.lttng2.kernel.tracetype";
    private static final String TRACE_TYPE_SYSLOG = "org.eclipse.linuxtools.tmf.tests.stubs.trace.text.testsyslog";
    private static final String WELCOME_NAME = "welcome";
    private static SWTWorkbenchBot fBot;

    static {
        String traceLocation = "";
        try {
            Path resourcesPath = new Path("resources");
            File resourcesFile = FetchRemoteTracesTest.getBundleFile((IPath)resourcesPath);
            IPath subDirFullPath = new Path(resourcesFile.getAbsolutePath()).append("generated");
            File subDirFile = new File(subDirFullPath.toOSString());
            subDirFile.mkdir();
            IPath generatedTraceFullPath = subDirFullPath.append("synthetic-trace");
            File generatedTraceFile = new File(generatedTraceFullPath.toOSString());
            LttngTraceGenerator.generateLttngTrace((File)generatedTraceFile);
            traceLocation = new Path(resourcesFile.getAbsolutePath()).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        TRACE_LOCATION = traceLocation;
        TRACE_GROUP_NODE_TEXT = String.valueOf(TRACE_LOCATION) + " (recursive)";
    }

    private static File getBundleFile(IPath relativePath) throws URISyntaxException, IOException {
        return new File(FileLocator.toFileURL((URL)FileLocator.find((Bundle)TmfRemoteUISWTBotTestPlugin.getDefault().getBundle(), (IPath)relativePath, null)).toURI());
    }

    @BeforeClass
    public static void init() {
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        SWTBotUtils.initialize();
        SWTBotPreferences.TIMEOUT = 20000L;
        Logger.getRootLogger().addAppender((Appender)new NullAppender());
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView((String)WELCOME_NAME, (SWTWorkbenchBot)fBot);
        SWTBotUtils.switchToTracingPerspective();
        WaitUtils.waitForJobs();
    }

    @Test
    public void testImportAll() {
        FetchRemoteTracesTest.testImport(new Runnable(){

            @Override
            public void run() {
            }
        }, new Runnable(){

            @Override
            public void run() {
                TmfProjectElement project = TmfProjectRegistry.getProject((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(FetchRemoteTracesTest.PROJECT_NAME), (boolean)true);
                fBot.waitUntil((ICondition)new TraceCountCondition(project, 2));
                List traces = project.getTracesFolder().getTraces();
                Assert.assertEquals((long)2L, (long)traces.size());
                FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(0), "node1/resources/generated/synthetic-trace", FetchRemoteTracesTest.TRACE_TYPE_LTTNG);
                FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(1), "node1/resources/syslog", FetchRemoteTracesTest.TRACE_TYPE_SYSLOG);
            }
        });
    }

    @Test
    public void testImportOnlyOne() {
        FetchRemoteTracesTest.testImport(new Runnable(){

            @Override
            public void run() {
                SWTBotTree tree = fBot.tree();
                fBot.button("Deselect All").click();
                int length = tree.getAllItems().length;
                Assert.assertTrue((length > 0 ? 1 : 0) != 0);
                SWTBotTreeItem node = FetchRemoteTracesTest.getTreeItem(fBot, tree, new String[]{FetchRemoteTracesTest.CONNECTION_NODE_TEXT, TRACE_GROUP_NODE_TEXT}).getNode(1);
                Assert.assertEquals((Object)"syslog", (Object)node.getText());
                node.check();
            }
        }, new Runnable(){

            @Override
            public void run() {
                TmfProjectElement project = TmfProjectRegistry.getProject((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(FetchRemoteTracesTest.PROJECT_NAME), (boolean)true);
                fBot.waitUntil((ICondition)new TraceCountCondition(project, 1));
                List traces = project.getTracesFolder().getTraces();
                Assert.assertEquals((long)1L, (long)traces.size());
                FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(0), "node1/resources/syslog", FetchRemoteTracesTest.TRACE_TYPE_SYSLOG);
            }
        });
    }

    @Test
    public void testImportNothing() {
        FetchRemoteTracesTest.testImport(new Runnable(){

            @Override
            public void run() {
                fBot.button("Deselect All").click();
            }
        }, new Runnable(){

            @Override
            public void run() {
                TmfProjectElement project = TmfProjectRegistry.getProject((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(FetchRemoteTracesTest.PROJECT_NAME), (boolean)true);
                List traces = project.getTracesFolder().getTraces();
                Assert.assertEquals((long)0L, (long)traces.size());
            }
        });
    }

    @Test
    public void testEmptyFile() {
        FetchRemoteTracesTest.testImport(new Runnable(){

            @Override
            public void run() {
                SWTBotTree tree = fBot.tree();
                fBot.button("Deselect All").click();
                int length = tree.getAllItems().length;
                Assert.assertTrue((length > 0 ? 1 : 0) != 0);
                SWTBotTreeItem groupNode = FetchRemoteTracesTest.getTreeItem(fBot, tree, new String[]{FetchRemoteTracesTest.CONNECTION_NODE_TEXT, TRACE_GROUP_NODE_TEXT});
                Assert.assertEquals((long)2L, (long)groupNode.getItems().length);
            }
        }, new Runnable(){

            @Override
            public void run() {
                TmfProjectElement project = TmfProjectRegistry.getProject((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(FetchRemoteTracesTest.PROJECT_NAME), (boolean)true);
                List traces = project.getTracesFolder().getTraces();
                Assert.assertEquals((long)0L, (long)traces.size());
            }
        });
    }

    @Test
    public void testEditProfile() {
        FetchRemoteTracesTest.openRemoteProfilePreferences();
        FetchRemoteTracesTest.createProfile();
        FetchRemoteTracesTest.openRemoteProfilePreferences();
        SWTBotTree tree = fBot.tree(1);
        String[] traceGroupNodePath = new String[]{PROFILE_NAME, CONNECTION_NODE_TEXT, TRACE_GROUP_NODE_TEXT};
        SWTBotTreeItem traceGroupNode = FetchRemoteTracesTest.getTreeItem(fBot, tree, traceGroupNodePath);
        SWTBotTreeItem[] traceNodes = traceGroupNode.getItems();
        Assert.assertEquals((long)2L, (long)traceNodes.length);
        Assert.assertEquals((Object)LTTNG_TRACE_FILE_PATTERN, (Object)traceNodes[0].getText());
        Assert.assertEquals((Object)SYSLOG_FILE_PATTERN, (Object)traceNodes[1].getText());
        SWTBotTreeItem traceNode = traceGroupNode.getNode(LTTNG_TRACE_FILE_PATTERN);
        traceNode.select();
        fBot.button("Move Down").click();
        traceGroupNode = FetchRemoteTracesTest.getTreeItem(fBot, tree, traceGroupNodePath);
        traceNodes = traceGroupNode.getItems();
        Assert.assertEquals((long)2L, (long)traceNodes.length);
        Assert.assertEquals((Object)SYSLOG_FILE_PATTERN, (Object)traceNodes[0].getText());
        Assert.assertEquals((Object)LTTNG_TRACE_FILE_PATTERN, (Object)traceNodes[1].getText());
        traceNode = traceGroupNode.getNode(LTTNG_TRACE_FILE_PATTERN);
        traceNode.select();
        fBot.button("Move Up").click();
        traceGroupNode = FetchRemoteTracesTest.getTreeItem(fBot, tree, traceGroupNodePath);
        traceNodes = traceGroupNode.getItems();
        Assert.assertEquals((long)2L, (long)traceNodes.length);
        Assert.assertEquals((Object)LTTNG_TRACE_FILE_PATTERN, (Object)traceNodes[0].getText());
        Assert.assertEquals((Object)SYSLOG_FILE_PATTERN, (Object)traceNodes[1].getText());
        traceNode = traceGroupNode.getNode(LTTNG_TRACE_FILE_PATTERN);
        traceNode.select().contextMenu("Copy").click();
        traceNode.contextMenu("Paste").click();
        traceNodes = traceGroupNode.getItems();
        Assert.assertEquals((long)3L, (long)traceNodes.length);
        Assert.assertEquals((Object)LTTNG_TRACE_FILE_PATTERN, (Object)traceNodes[0].getText());
        Assert.assertEquals((Object)LTTNG_TRACE_FILE_PATTERN, (Object)traceNodes[1].getText());
        Assert.assertEquals((Object)SYSLOG_FILE_PATTERN, (Object)traceNodes[2].getText());
        traceNode = traceGroupNode.getNode(LTTNG_TRACE_FILE_PATTERN);
        traceNode.select().contextMenu("Cut").click();
        traceNode = traceGroupNode.getNode(SYSLOG_FILE_PATTERN);
        traceNode.select().contextMenu("Paste").click();
        traceNodes = traceGroupNode.getItems();
        Assert.assertEquals((long)3L, (long)traceNodes.length);
        Assert.assertEquals((Object)LTTNG_TRACE_FILE_PATTERN, (Object)traceNodes[0].getText());
        Assert.assertEquals((Object)SYSLOG_FILE_PATTERN, (Object)traceNodes[1].getText());
        Assert.assertEquals((Object)LTTNG_TRACE_FILE_PATTERN, (Object)traceNodes[2].getText());
        traceNode = traceGroupNode.getNode(LTTNG_TRACE_FILE_PATTERN);
        traceNode.select().contextMenu("Delete").click();
        traceNodes = traceGroupNode.getItems();
        Assert.assertEquals((long)2L, (long)traceNodes.length);
        Assert.assertEquals((Object)SYSLOG_FILE_PATTERN, (Object)traceNodes[0].getText());
        Assert.assertEquals((Object)LTTNG_TRACE_FILE_PATTERN, (Object)traceNodes[1].getText());
        traceNode = traceGroupNode.getNode(LTTNG_TRACE_FILE_PATTERN);
        traceNode.select().contextMenu("Copy").click();
        traceNode = traceGroupNode.select(new String[]{SYSLOG_FILE_PATTERN, LTTNG_TRACE_FILE_PATTERN});
        traceNode.pressShortcut(new KeyStroke[]{Keystrokes.DELETE});
        traceNodes = traceGroupNode.getItems();
        Assert.assertEquals((long)0L, (long)traceNodes.length);
        traceGroupNode.contextMenu("Paste").click();
        traceNodes = traceGroupNode.getItems();
        Assert.assertEquals((long)1L, (long)traceNodes.length);
        Assert.assertEquals((Object)LTTNG_TRACE_FILE_PATTERN, (Object)traceNodes[0].getText());
        fBot.button("OK").click();
        FetchRemoteTracesTest.deleteProfile();
    }

    private static void testImport(Runnable selectionFunctor, Runnable verifyTracesFunctor) {
        SWTBotUtils.createProject((String)PROJECT_NAME);
        WaitUtils.waitForJobs();
        SWTBotView projectExplorerBot = fBot.viewByTitle(PROJECT_EXPLORER);
        Assert.assertNotNull((String)"Cannot find Project Explorer", (Object)projectExplorerBot);
        projectExplorerBot.show();
        SWTBotTreeItem treeItem = FetchRemoteTracesTest.getTracesFolderTreeItem(projectExplorerBot);
        treeItem.contextMenu(FETCH_COMMAND_NAME).click();
        fBot.button("Manage Profiles").click();
        FetchRemoteTracesTest.createProfile();
        Assert.assertEquals((Object)PROFILE_NAME, (Object)fBot.comboBoxWithLabel("Profile name:").getText());
        Assert.assertEquals((Object)CONNECTION_NODE_TEXT, (Object)fBot.textWithLabel("Nodes:").getText());
        SWTBotButton button = fBot.button("Next >");
        fBot.waitUntil(Conditions.widgetIsEnabled((AbstractSWTBot)button));
        button.click();
        button = fBot.button("< Back");
        fBot.waitUntil(Conditions.widgetIsEnabled((AbstractSWTBot)button));
        button.click();
        Assert.assertEquals((Object)PROFILE_NAME, (Object)fBot.comboBoxWithLabel("Profile name:").getText());
        Assert.assertEquals((Object)CONNECTION_NODE_TEXT, (Object)fBot.textWithLabel("Nodes:").getText());
        button = fBot.button("Next >");
        fBot.waitUntil(Conditions.widgetIsEnabled((AbstractSWTBot)button));
        button.click();
        selectionFunctor.run();
        SWTBotShell shell = fBot.activeShell();
        button = fBot.button("Finish");
        fBot.waitUntil(Conditions.widgetIsEnabled((AbstractSWTBot)button));
        button.click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        WaitUtils.waitForJobs();
        verifyTracesFunctor.run();
        fBot.closeAllEditors();
        SWTBotUtils.deleteProject((String)PROJECT_NAME, (SWTWorkbenchBot)fBot);
        FetchRemoteTracesTest.deleteProfile();
    }

    private static void createProfile() {
        fBot.button("Add").click();
        SWTBotTree tree = fBot.tree(1);
        SWTBotTreeItem treeNode = FetchRemoteTracesTest.getTreeItem(fBot, tree, PROFILE_NAME, "name (ssh://userinfo@host:22)");
        treeNode.select();
        SWTBotText uriLabel = fBot.textWithLabel("URI:");
        uriLabel.setText("file://");
        SWTBotText nodeNameLabel = fBot.textWithLabel("Node name:");
        nodeNameLabel.setText(CONNECTION_NODE_NAME);
        SWTBotTreeItem traceRootNode = treeNode.getNode("/rootpath");
        traceRootNode.select();
        SWTBotText pathLabel = fBot.textWithLabel("Root path:");
        pathLabel.setText(TRACE_LOCATION);
        fBot.checkBox("Recursive").select();
        treeNode = traceRootNode.getNode(".*");
        treeNode.select();
        SWTBotText filePatternLabel = fBot.textWithLabel("File pattern:");
        filePatternLabel.setText(LTTNG_TRACE_FILE_PATTERN);
        traceRootNode.contextMenu("New Trace").click();
        treeNode = traceRootNode.getNode(".*");
        treeNode.select();
        filePatternLabel = fBot.textWithLabel("File pattern:");
        filePatternLabel.setText(SYSLOG_FILE_PATTERN);
        SWTBotCombo combo = fBot.comboBoxWithLabel("Trace type:");
        combo.setSelection("Test trace : Test Syslog");
        fBot.button("OK").click();
    }

    private static void testTrace(TmfTraceElement tmfTraceElement, String expectedTracePath, String traceType) {
        Assert.assertEquals((Object)traceType, (Object)tmfTraceElement.getTraceType());
        Path tracePath = new Path(tmfTraceElement.getElementPath());
        Assert.assertEquals((Object)expectedTracePath, (Object)tracePath.toString());
        SWTBotUtils.openEditor((SWTWorkbenchBot)fBot, (String)PROJECT_NAME, (IPath)tracePath);
    }

    private static void deleteProfile() {
        FetchRemoteTracesTest.openRemoteProfilePreferences();
        SWTBotTree tree = fBot.tree(1);
        SWTBotTreeItem treeNode = tree.getTreeItem(PROFILE_NAME);
        treeNode.select();
        fBot.button("Remove").click();
        Assert.assertEquals((long)0L, (long)tree.getAllItems().length);
        fBot.button("OK").click();
    }

    private static SWTBotTreeItem getTreeItem(SWTWorkbenchBot bot, SWTBotTree tree, String ... nodeNames) {
        if (nodeNames.length == 0) {
            return null;
        }
        SWTBotTreeItem currentNode = tree.getTreeItem(nodeNames[0]);
        int i = 1;
        while (i < nodeNames.length) {
            SWTBotTreeItem newNode;
            String nodeName = nodeNames[i];
            bot.waitUntil(ConditionHelpers.IsTreeChildNodeAvailable((String)nodeName, (SWTBotTreeItem)currentNode));
            currentNode = newNode = currentNode.getNode(nodeName);
            ++i;
        }
        return currentNode;
    }

    private static void openRemoteProfilePreferences() {
        SWTBotShell preferencesShell = SWTBotUtils.openPreferences((SWTBot)fBot);
        SWTBot bot = preferencesShell.bot();
        SWTBotTree tree = bot.tree(0);
        SWTBotTreeItem treeNode = tree.getTreeItem("Tracing");
        treeNode.select();
        treeNode.expand();
        bot.waitUntil(ConditionHelpers.IsTreeChildNodeAvailable((String)"Remote Profiles", (SWTBotTreeItem)treeNode));
        treeNode = treeNode.getNode("Remote Profiles");
        treeNode.select();
    }

    private static SWTBotTreeItem getTracesFolderTreeItem(SWTBotView projectExplorerBot) {
        SWTBotTreeItem treeItem = projectExplorerBot.bot().tree().getTreeItem(PROJECT_NAME);
        treeItem.select();
        treeItem.expand();
        return treeItem.getNode("Traces [0]");
    }

    private static class TraceCountCondition
    extends DefaultCondition {
        private final TmfProjectElement fProject;
        private final int fExpectedCount;

        public TraceCountCondition(TmfProjectElement project, int expectedNumber) {
            this.fProject = project;
            this.fExpectedCount = expectedNumber;
        }

        public boolean test() throws Exception {
            return this.fProject.getTracesFolder().getTraces().size() == this.fExpectedCount;
        }

        public String getFailureMessage() {
            return NLS.bind((String)"The project {0} does not contain {1} traces.", (Object)this.fProject.getName(), (Object)this.fExpectedCount);
        }
    }
}

