/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.viewers.events;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.tmf.core.io.BufferedRandomAccessFile;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.SDView;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.Frame;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class SDViewTest {
    private static final String UML2DVIEW_ID = "org.eclipse.linuxtools.tmf.ui.tmfUml2SDSyncView";
    private static final String XMLSTUB_ID = "org.eclipse.linuxtools.tmf.core.tests.xmlstub";
    private static final String TRACE_START = "<trace>";
    private static final String EVENT_BEGIN = "<event timestamp=\"";
    private static final String EVENT_MIDDLE1 = " \" name=\"";
    private static final String EVENT_MIDDLE2 = "\">";
    private static final String FIELD_SENDER = "<field name=\"sender\" value=\"";
    private static final String FIELD_RECEIVER = "<field name=\"receiver\" value=\"";
    private static final String FIELD_SIGNAL = "<field name=\"signal\" value=\"";
    private static final String FIELD_END = "\" type=\"string\" />";
    private static final String EVENT_END = "</event>";
    private static final String TRACE_END = "</trace>";
    private static final String PROJECT_NAME = "TestForFiltering";
    private static final Logger fLogger = Logger.getRootLogger();
    private static SWTWorkbenchBot fBot;
    private static File fFileLocation;

    private static String makeEvent(int ts, String eventName, String send, String recv, String signal) {
        return EVENT_BEGIN + Integer.toString(ts) + EVENT_MIDDLE1 + eventName + EVENT_MIDDLE2 + FIELD_SENDER + send + FIELD_END + FIELD_RECEIVER + recv + FIELD_END + FIELD_SIGNAL + signal + FIELD_END + EVENT_END + "\n";
    }

    @BeforeClass
    public static void init() throws IOException {
        SWTBotUtils.initialize();
        Thread.currentThread().setName("SWTBot Thread");
        SWTBotPreferences.TIMEOUT = 20000L;
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout()));
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView("welcome", fBot);
        SWTBotUtils.switchToTracingPerspective();
        WaitUtils.waitForJobs();
        fFileLocation = File.createTempFile("sample", ".xml");
        String[] eventNames = new String[]{"test:SEND", "test:RECEIVE"};
        String[] targets = new String[]{"peer1", "peer2"};
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedRandomAccessFile braf = new BufferedRandomAccessFile(fFileLocation, "rw");){
            braf.writeBytes(TRACE_START);
            int i = 0;
            while (i < 100) {
                braf.writeBytes(SDViewTest.makeEvent(i * i * 100, eventNames[i % 2], targets[i % 2], targets[(i + 1) % 2], Integer.toString(i % 2 + 1000)));
                ++i;
            }
            braf.writeBytes(TRACE_END);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Before
    public void beforeTest() {
        SWTBotUtils.createProject(PROJECT_NAME);
        SWTBotTreeItem treeItem = SWTBotUtils.selectTracesFolder(fBot, PROJECT_NAME);
        Assert.assertNotNull((Object)treeItem);
        SWTBotUtils.openTrace(PROJECT_NAME, fFileLocation.getAbsolutePath(), XMLSTUB_ID);
        SWTBotUtils.openView(UML2DVIEW_ID);
    }

    @AfterClass
    public static void cleanUp() {
        SWTBotUtils.closeViewById(UML2DVIEW_ID, fBot);
        fFileLocation.delete();
        fLogger.removeAllAppenders();
    }

    @After
    public void tearDown() {
        fBot.closeAllEditors();
        SWTBotUtils.deleteProject(PROJECT_NAME, fBot);
    }

    @Test
    public void testSDView() {
        SWTBotView viewBot = fBot.viewById(UML2DVIEW_ID);
        Assert.assertNotNull((Object)viewBot);
        viewBot.setFocus();
        WaitUtils.waitForJobs();
        List viewButtons = viewBot.getToolbarButtons();
        ArrayList<String> titles = new ArrayList<String>();
        for (SWTBotToolbarButton buttonBot : viewButtons) {
            titles.add(buttonBot.getToolTipText());
        }
        int commandKeyChar = 8984;
        String findShortcut = (Platform.getOS().equals("macosx") ? Character.valueOf('\u2318') : "Ctrl+") + "F";
        Object[] expected = new String[]{"Reset zoom factor", "Select", "Zoom in the diagram", "Zoom out the diagram", "Go to next page", "Go to previous page", "Go to first page", "Go to last page", "Find... (" + findShortcut + ")"};
        Assert.assertArrayEquals((String)"Buttons", (Object[])expected, (Object[])titles.toArray(new String[0]));
        SDView view = (SDView)viewBot.getViewReference().getPart(false);
        Frame frame = view.getFrame();
        Assert.assertEquals((long)2L, (long)frame.lifeLinesCount());
    }
}

