/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCheckBox;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCombo;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotRadio;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ImportTraceWizard;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.Messages;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class StandardImportGzipTraceTest {
    private static final String ROOT_FOLDER = "/";
    private static final String PROJECT_NAME = "Tracing";
    private static File fGzipTrace;
    private Wizard fWizard;
    private SWTWorkbenchBot fBot;
    protected static final Logger fLogger;

    static {
        fLogger = Logger.getRootLogger();
    }

    @BeforeClass
    public static void init() {
        SWTBotUtils.initialize();
        StandardImportGzipTraceTest.zipTrace();
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new NullAppender());
    }

    @Before
    public void setup() {
        this.createProject();
        SWTBotPreferences.TIMEOUT = 20000L;
    }

    @AfterClass
    public static void destroy() {
        fLogger.removeAllAppenders();
    }

    @After
    public void tearDown() {
        SWTBotUtils.deleteProject(PROJECT_NAME, this.fBot);
    }

    private void createProject() {
        this.fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView("Welcome", this.fBot);
        SWTBotUtils.switchToTracingPerspective();
        SWTBotUtils.createProject(PROJECT_NAME);
    }

    @Test
    public void testGzipImport() {
        String traceType = "Test trace : TMF Tests";
        String tracesNode = "Traces [1]";
        this.openImportWizard();
        this.selectImportFromArchive(fGzipTrace.getAbsolutePath());
        this.selectFolder(ROOT_FOLDER);
        SWTBotCheckBox checkBox = this.fBot.checkBox(Messages.ImportTraceWizard_CreateLinksInWorkspace);
        Assert.assertFalse((boolean)checkBox.isEnabled());
        SWTBotCombo comboBox = this.fBot.comboBoxWithLabel(Messages.ImportTraceWizard_TraceType);
        comboBox.setSelection("Test trace : TMF Tests");
        this.importFinish();
        Assert.assertNotNull((Object)fGzipTrace);
        String name = fGzipTrace.getName();
        Assert.assertNotNull((Object)name);
        Assert.assertTrue((name.length() > 3 ? 1 : 0) != 0);
        String traceName = name.substring(0, name.length() - 3);
        Assert.assertNotNull((Object)traceName);
        Assert.assertFalse((boolean)traceName.isEmpty());
        SWTBotView projectExplorer = this.fBot.viewById("org.eclipse.ui.navigator.ProjectExplorer");
        projectExplorer.setFocus();
        SWTBotTree tree = projectExplorer.bot().tree();
        SWTBotTreeItem treeItem = SWTBotUtils.getTreeItem(projectExplorer.bot(), tree, PROJECT_NAME, "Traces [1]", traceName);
        treeItem.doubleClick();
        WaitUtils.waitForJobs();
        SWTBot editorBot = SWTBotUtils.activeEventsEditor(this.fBot).bot();
        SWTBotTable editorTable = editorBot.table();
        String expectedContent1 = "Type-1";
        String expectedContent2 = "";
        editorBot.waitUntil(ConditionHelpers.isTableCellFilled(editorTable, "Type-1", 2, 2));
        editorBot.waitUntil(ConditionHelpers.isTableCellFilled(editorTable, "", 1, 0));
        String c22 = editorTable.cell(2, 2);
        String c10 = editorTable.cell(1, 0);
        Assert.assertEquals((Object)"Type-1", (Object)c22);
        Assert.assertEquals((Object)"", (Object)c10);
    }

    private static void zipTrace() {
        try {
            fGzipTrace = File.createTempFile("trace", ".gz");
            byte[] buffer = new byte[1024];
            Throwable throwable = null;
            Object var2_4 = null;
            try (GZIPOutputStream gzos = new GZIPOutputStream(new FileOutputStream(fGzipTrace));){
                Throwable throwable2 = null;
                Object var5_9 = null;
                try (FileInputStream in = new FileInputStream(TmfTestTrace.A_TEST_10K2.getFullPath());){
                    int len;
                    while ((len = in.read(buffer)) > 0) {
                        gzos.write(buffer, 0, len);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                gzos.finish();
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private void selectImportFromArchive(String archivePath) {
        SWTBotRadio button = this.fBot.radio("Select &archive file:");
        button.click();
        SWTBotCombo sourceCombo = this.fBot.comboBox(1);
        sourceCombo.setText(new File(archivePath).getAbsolutePath());
        SWTBotText text = this.fBot.text();
        text.setFocus();
    }

    private void openImportWizard() {
        this.fWizard = new ImportTraceWizard();
        UIThreadRunnable.asyncExec((VoidResult)new VoidResult(){

            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                if (workbench != null) {
                    IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
                    Shell shell = activeWorkbenchWindow.getShell();
                    Assert.assertNotNull((Object)shell);
                    ((ImportTraceWizard)StandardImportGzipTraceTest.this.fWizard).init(PlatformUI.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
                    WizardDialog dialog = new WizardDialog(shell, (IWizard)StandardImportGzipTraceTest.this.fWizard);
                    dialog.open();
                }
            }
        });
        this.fBot.waitUntil(ConditionHelpers.isWizardReady(this.fWizard));
    }

    private void selectFolder(String ... treePath) {
        SWTBotTree tree = this.fBot.tree();
        this.fBot.waitUntil(Conditions.widgetIsEnabled((AbstractSWTBot)tree));
        SWTBotTreeItem folderNode = SWTBotUtils.getTreeItem((SWTBot)this.fBot, tree, treePath);
        folderNode.check();
    }

    private void importFinish() {
        SWTBotShell shell = this.fBot.activeShell();
        SWTBotButton finishButton = this.fBot.button("Finish");
        finishButton.click();
        this.fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        WaitUtils.waitForJobs();
    }
}

