/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.inputoutput;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.Map;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.IoOperationType;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.LinuxTestCase;

public class IoTestCase
extends LinuxTestCase {
    public IoTestCase(String filename) {
        super(filename);
    }

    public Multimap<Integer, SectorCountInfo> getSectorCount() {
        return HashMultimap.create();
    }

    public Map<Integer, DiskInfo> getDiskInfo() {
        return Collections.EMPTY_MAP;
    }

    public static class DiskInfo {
        private final String fDeviceString;
        private final String fDiskName;
        private final boolean fActive;

        public DiskInfo(String deviceString, String diskname, boolean active) {
            this.fDeviceString = deviceString;
            this.fDiskName = diskname;
            this.fActive = active;
        }

        public String getDeviceString() {
            return this.fDeviceString;
        }

        public String getDeviceName() {
            return this.fDiskName;
        }

        public boolean hasActivity() {
            return this.fActive;
        }
    }

    public static class SectorCountInfo {
        private final long fTs;
        private final IoOperationType fType;
        private final long fSectors;

        public SectorCountInfo(long ts, IoOperationType type, long nbSectors) {
            this.fTs = ts;
            this.fType = type;
            this.fSectors = nbSectors;
        }

        public long getTimestamp() {
            return this.fTs;
        }

        public IoOperationType getType() {
            return this.fType;
        }

        public long getNbSectors() {
            return this.fSectors;
        }
    }
}

