/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.tests.callgraph;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.AbstractCalledFunction;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.CalledFunction;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.CalledFunctionFactory;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.CalledStringFunction;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.ICalledFunction;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CalledFunctionTest {
    private CalledStringFunction fFixture = null;
    private ICalledFunction f42Fixture;
    private ICalledFunction fHiFixture;

    @Before
    public void setup() {
        AbstractCalledFunction fixture = CalledFunctionFactory.create((long)10L, (long)1010L, (int)0, (ITmfStateValue)TmfStateValue.newValueString((String)"Hello"), (int)0, null);
        Assert.assertTrue((boolean)(fixture instanceof CalledStringFunction));
        this.fFixture = (CalledStringFunction)fixture;
        CalledStringFunction hiFixture = CalledFunctionFactory.create((long)20L, (long)50L, (int)1, (String)"Hi", (int)0, (ICalledFunction)this.fFixture);
        this.fHiFixture = hiFixture;
        AbstractCalledFunction fixture42 = CalledFunctionFactory.create((long)400L, (long)500L, (int)1, (ITmfStateValue)TmfStateValue.newValueLong((long)66L), (int)0, (ICalledFunction)this.fFixture);
        this.f42Fixture = fixture42;
        this.fFixture.addChild((ICalledFunction)fixture42);
        this.fFixture.addChild((ICalledFunction)hiFixture);
    }

    public void createValid() {
        Assert.assertNotNull((Object)CalledFunctionFactory.create((long)0L, (long)0L, (int)0, (ITmfStateValue)TmfStateValue.newValueLong((long)0L), (int)0, null));
        Assert.assertNotNull((Object)CalledFunctionFactory.create((long)0L, (long)0L, (int)0, (ITmfStateValue)TmfStateValue.newValueInt((int)0), (int)0, null));
        Assert.assertNotNull((Object)CalledFunctionFactory.create((long)0L, (long)0L, (int)0, (ITmfStateValue)TmfStateValue.newValueString((String)""), (int)0, null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void createInvalidDouble() {
        CalledFunctionFactory.create((long)0L, (long)0L, (int)0, (ITmfStateValue)TmfStateValue.newValueDouble((double)3.14), (int)0, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createInvalidNull() {
        CalledFunctionFactory.create((long)0L, (long)0L, (int)0, (ITmfStateValue)TmfStateValue.nullValue(), (int)0, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createInvalidTimeRange() {
        CalledFunctionFactory.create((long)10L, (long)-10L, (int)0, (String)"", (int)0, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createInvalidTimeRangeStateLong() {
        CalledFunctionFactory.create((long)10L, (long)-10L, (int)0, (ITmfStateValue)TmfStateValue.newValueLong((long)42L), (int)0, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createInvalidTimeRangeStateInteger() {
        CalledFunctionFactory.create((long)10L, (long)-10L, (int)0, (ITmfStateValue)TmfStateValue.newValueInt((int)42), (int)0, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createInvalidTimeRangeStateString() {
        CalledFunctionFactory.create((long)10L, (long)-10L, (int)0, (ITmfStateValue)TmfStateValue.newValueString((String)"42"), (int)0, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddChildSelf() {
        Assert.assertNotNull((Object)this.fFixture);
        Assert.assertNotNull((Object)this.f42Fixture);
        Assert.assertNotNull((Object)this.fHiFixture);
        this.fFixture.addChild((ICalledFunction)this.fFixture);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddChildCycle1() {
        Assert.assertNotNull((Object)this.fFixture);
        Assert.assertNotNull((Object)this.fHiFixture);
        Assert.assertNotNull((Object)this.f42Fixture);
        ((CalledStringFunction)this.fHiFixture).addChild(this.f42Fixture);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddChildCycle2() {
        ICalledFunction fixture42 = this.f42Fixture;
        Assert.assertNotNull((Object)this.fFixture);
        Assert.assertNotNull((Object)fixture42);
        Assert.assertNotNull((Object)this.fHiFixture);
        this.fFixture.addChild(fixture42);
        ((CalledFunction)fixture42).addChild((ICalledFunction)this.fFixture);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddChildCycle3() {
        Assert.assertNotNull((Object)this.fFixture);
        Assert.assertNotNull((Object)this.f42Fixture);
        Assert.assertNotNull((Object)this.fHiFixture);
        ((CalledFunction)this.f42Fixture).addChild(this.fHiFixture);
    }

    @Test
    public void testAddChildOk1() {
        Assert.assertNotNull((Object)this.fFixture);
        CalledFunction newchild = (CalledFunction)CalledFunctionFactory.create((long)100L, (long)200L, (int)1, (ITmfStateValue)TmfStateValue.newValueInt((int)100), (int)0, (ICalledFunction)this.fFixture);
        this.fFixture.addChild((ICalledFunction)newchild);
        ICalledFunction hiFixture = this.fHiFixture;
        ICalledFunction fixture42 = this.f42Fixture;
        Assert.assertNotNull((Object)hiFixture);
        Assert.assertNotNull((Object)fixture42);
        Assert.assertEquals((Object)ImmutableList.of((Object)fixture42, (Object)hiFixture, (Object)newchild), (Object)this.fFixture.getChildren());
        Assert.assertEquals(Collections.emptyList(), (Object)fixture42.getChildren());
        Assert.assertEquals(Collections.emptyList(), (Object)hiFixture.getChildren());
    }

    @Test
    public void testAddChildOk2() {
        Assert.assertNotNull((Object)this.fFixture);
        CalledStringFunction newchild = CalledFunctionFactory.create((long)450L, (long)490L, (int)1, (String)"OK", (int)0, (ICalledFunction)this.f42Fixture);
        ICalledFunction hiFixture = this.fHiFixture;
        ICalledFunction fixture42 = this.f42Fixture;
        Assert.assertNotNull((Object)hiFixture);
        Assert.assertNotNull((Object)fixture42);
        ((CalledFunction)fixture42).addChild((ICalledFunction)newchild);
        Assert.assertEquals((Object)ImmutableList.of((Object)fixture42, (Object)hiFixture), (Object)this.fFixture.getChildren());
        Assert.assertEquals((Object)ImmutableList.of((Object)newchild), (Object)this.f42Fixture.getChildren());
        Assert.assertEquals(Collections.emptyList(), (Object)this.fHiFixture.getChildren());
    }

    @Test
    public void testAddChildOk3() {
        Assert.assertNotNull((Object)this.fFixture);
        CalledStringFunction newchild = CalledFunctionFactory.create((long)450L, (long)490L, (int)1, (String)"OK", (int)0, (ICalledFunction)this.fHiFixture);
        ICalledFunction hiFixture = this.fHiFixture;
        ICalledFunction fixture42 = this.f42Fixture;
        Assert.assertNotNull((Object)hiFixture);
        Assert.assertNotNull((Object)fixture42);
        ((CalledStringFunction)hiFixture).addChild((ICalledFunction)newchild);
        Assert.assertEquals((Object)ImmutableList.of((Object)fixture42, (Object)hiFixture), (Object)this.fFixture.getChildren());
        Assert.assertEquals((Object)ImmutableList.of((Object)newchild), (Object)this.fHiFixture.getChildren());
        Assert.assertEquals(Collections.emptyList(), (Object)this.f42Fixture.getChildren());
    }

    @Test
    public void testCompareTo() {
        CalledStringFunction fixture = this.fFixture;
        Assert.assertEquals((long)0L, (long)fixture.compareTo((ISegment)fixture));
        Assert.assertTrue((fixture.compareTo((ISegment)this.f42Fixture) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.f42Fixture.compareTo((ISegment)fixture) > 0 ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCompareToBad() {
        CalledStringFunction fixture = this.fFixture;
        Assert.assertTrue((fixture.compareTo(null) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEquals() {
        Assert.assertEquals((Object)this.fFixture, (Object)this.fFixture);
        Assert.assertEquals((Object)this.fHiFixture, (Object)CalledFunctionFactory.create((long)20L, (long)50L, (int)1, (String)"Hi", (int)0, (ICalledFunction)this.fFixture));
        Assert.assertNotEquals((Object)this.fFixture, (Object)this.f42Fixture);
        Assert.assertNotEquals((Object)this.fFixture, (Object)this.fHiFixture);
        Assert.assertNotEquals((Object)this.fFixture, null);
        Assert.assertNotEquals((Object)this.fFixture, new ArrayList());
    }

    @Test
    public void testGetChildren() {
        ICalledFunction fixture42 = this.f42Fixture;
        ICalledFunction fixtureHi = this.fHiFixture;
        Assert.assertNotNull((Object)fixture42);
        Assert.assertNotNull((Object)fixtureHi);
        Assert.assertEquals((Object)ImmutableList.of((Object)fixture42, (Object)fixtureHi), (Object)this.fFixture.getChildren());
        Assert.assertEquals(Collections.emptyList(), (Object)fixture42.getChildren());
        Assert.assertEquals(Collections.emptyList(), (Object)fixtureHi.getChildren());
    }

    @Test
    public void testGetDepth() {
        Assert.assertEquals((long)0L, (long)this.fFixture.getDepth());
        Assert.assertEquals((long)1L, (long)this.fHiFixture.getDepth());
        Assert.assertEquals((long)1L, (long)this.f42Fixture.getDepth());
    }

    @Test
    public void testGetEnd() {
        Assert.assertEquals((long)1010L, (long)this.fFixture.getEnd());
        Assert.assertEquals((long)50L, (long)this.fHiFixture.getEnd());
        Assert.assertEquals((long)500L, (long)this.f42Fixture.getEnd());
    }

    @Test
    public void testGetParent() {
        Assert.assertEquals(null, (Object)this.fFixture.getParent());
        Assert.assertEquals((Object)this.fFixture, (Object)this.f42Fixture.getParent());
        Assert.assertEquals((Object)this.fFixture, (Object)this.fHiFixture.getParent());
    }

    @Test
    public void testGetProcessId() {
        Assert.assertEquals((long)0L, (long)this.fFixture.getProcessId());
        Assert.assertEquals((long)0L, (long)this.fHiFixture.getProcessId());
        Assert.assertEquals((long)0L, (long)this.f42Fixture.getProcessId());
    }

    @Test
    public void testGetSelfTime() {
        Assert.assertEquals((long)870L, (long)this.fFixture.getSelfTime());
        Assert.assertEquals((long)30L, (long)this.fHiFixture.getSelfTime());
        Assert.assertEquals((long)100L, (long)this.f42Fixture.getSelfTime());
    }

    @Test
    public void testGetStart() {
        Assert.assertEquals((long)10L, (long)this.fFixture.getStart());
        Assert.assertEquals((long)20L, (long)this.fHiFixture.getStart());
        Assert.assertEquals((long)400L, (long)this.f42Fixture.getStart());
    }

    @Test
    public void testHashCode() {
        Assert.assertEquals((long)this.f42Fixture.hashCode(), (long)this.f42Fixture.hashCode());
        AbstractCalledFunction calledFunction = CalledFunctionFactory.create((long)400L, (long)500L, (int)1, (ITmfStateValue)TmfStateValue.newValueLong((long)66L), (int)0, (ICalledFunction)this.fFixture);
        Assert.assertEquals((Object)this.f42Fixture, (Object)calledFunction);
        Assert.assertEquals((long)this.f42Fixture.hashCode(), (long)calledFunction.hashCode());
        calledFunction = CalledFunctionFactory.create((long)20L, (long)50L, (int)1, (String)"Hi", (int)0, (ICalledFunction)this.fFixture);
        Assert.assertEquals((Object)this.fHiFixture, (Object)calledFunction);
        Assert.assertEquals((long)this.fHiFixture.hashCode(), (long)calledFunction.hashCode());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"[10, 1010] Duration: 1000, Self Time: 870", (Object)this.fFixture.toString());
        Assert.assertEquals((Object)"[400, 500] Duration: 100, Self Time: 100", (Object)this.f42Fixture.toString());
        Assert.assertEquals((Object)"[20, 50] Duration: 30, Self Time: 30", (Object)this.fHiFixture.toString());
    }
}

