/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotLabel;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests.KernelTestBase;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotTimeGraph;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotTimeGraphEntry;
import org.junit.Assert;
import org.junit.Test;

public abstract class KernelTimeGraphViewTestBase
extends KernelTestBase {
    protected static final String SEPARATOR = "";

    protected abstract SWTBotView getViewBot();

    protected abstract List<String> getToolbarTooltips();

    protected abstract List<String> getLegendValues();

    protected abstract SWTBotView openView();

    @Test
    public void testToolbar() {
        List buttons = this.getViewBot().getToolbarButtons();
        List<String> tooltipsExpected = this.getToolbarTooltips();
        ArrayList<String> tooltips = new ArrayList<String>();
        for (SWTBotToolbarButton button : buttons) {
            tooltips.add(button.getToolTipText());
            Assert.assertTrue((String)(String.valueOf(button.getText()) + " enabled"), (boolean)button.isEnabled());
            Assert.assertTrue((String)(String.valueOf(button.getText()) + " visible"), (boolean)button.isVisible());
        }
        Assert.assertEquals(tooltipsExpected, tooltips);
    }

    @Test
    public void testLegend() {
        List<String> labelValues = this.getLegendValues();
        SWTBotToolbarButton legendButton = this.getViewBot().toolbarButton("Show Legend");
        legendButton.click();
        fBot.waitUntil(Conditions.shellIsActive((String)"States Transition Visualizer"));
        SWTBot bot = fBot.activeShell().bot();
        int i = 1;
        while (i <= labelValues.size()) {
            SWTBotLabel label = bot.label(i);
            Assert.assertNotNull((Object)label);
            Assert.assertEquals((Object)labelValues.get(i - 1), (Object)label.getText());
            ++i;
        }
        bot.button("OK").click();
    }

    @Test
    public void testOpenCloseOpen() {
        SWTBotView viewBot = this.openView();
        SWTBotTimeGraph tgBot = new SWTBotTimeGraph(viewBot.bot());
        Map<String, List<String>> before = KernelTimeGraphViewTestBase.getItemNames(tgBot);
        viewBot.close();
        viewBot = this.openView();
        tgBot = new SWTBotTimeGraph(viewBot.bot());
        Map<String, List<String>> after = KernelTimeGraphViewTestBase.getItemNames(tgBot);
        Assert.assertEquals(before, after);
    }

    private static @NonNull Map<String, List<String>> getItemNames(SWTBotTimeGraph tgBot) {
        HashMap<String, List<String>> returnStructure = new HashMap<String, List<String>>();
        SWTBotTimeGraphEntry[] sWTBotTimeGraphEntryArray = tgBot.getEntries();
        int n = sWTBotTimeGraphEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTimeGraphEntry element = sWTBotTimeGraphEntryArray[n2];
            returnStructure.put(element.getText(), Arrays.stream(element.getEntries()).map(tgEntry -> tgEntry.getText()).collect(Collectors.toList()));
            ++n2;
        }
        return returnStructure;
    }
}

