/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.analysis.Messages;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class OpenTraceStressTest {
    private static final String TRACE_TYPE = "org.eclipse.linuxtools.lttng2.kernel.tracetype";
    private static final String KERNEL_PERSPECTIVE_ID = "org.eclipse.linuxtools.lttng2.kernel.ui.perspective";
    private static final @NonNull CtfTestTrace CTF_TRACE = CtfTestTrace.SYNC_DEST;
    private static final String TRACE_PROJECT_NAME = "test";
    private static SWTWorkbenchBot workbenchbot;

    @BeforeClass
    public static void init() {
        SWTBotUtils.initialize();
        SWTBotPreferences.TIMEOUT = 20000L;
        workbenchbot = new SWTWorkbenchBot();
        SWTBotUtils.closeView((String)"Welcome", (SWTWorkbenchBot)workbenchbot);
        SWTBotUtils.switchToPerspective((String)KERNEL_PERSPECTIVE_ID);
        WaitUtils.waitForJobs();
    }

    @Test
    public void testOpenAndCloseConcurrency() {
        SWTBotUtils.createProject((String)TRACE_PROJECT_NAME);
        File fTestFile = new File(CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CTF_TRACE).getPath());
        CtfTmfTestTraceUtils.dispose((CtfTestTrace)CTF_TRACE);
        String path = fTestFile.getAbsolutePath();
        Assert.assertNotNull((Object)fTestFile);
        Assume.assumeTrue((boolean)fTestFile.exists());
        final MultiStatus status = new MultiStatus("lttn2.kernel.ui.swtbot.tests", 0, null, null);
        IJobManager mgr = Job.getJobManager();
        JobChangeAdapter changeListener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Job job = event.getJob();
                String jobNamePrefix = NLS.bind((String)Messages.TmfAbstractAnalysisModule_RunningAnalysis, (Object)"");
                if (job.getName().startsWith(jobNamePrefix) && job.getResult().getSeverity() == 4) {
                    status.add(job.getResult());
                }
            }
        };
        mgr.addJobChangeListener((IJobChangeListener)changeListener);
        int i = 0;
        while (i < 10) {
            SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)path, (String)TRACE_TYPE, (boolean)false);
            SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)path, (String)TRACE_TYPE, (boolean)false);
            SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)path, (String)TRACE_TYPE, (boolean)false);
            SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)path, (String)TRACE_TYPE, (boolean)false);
            SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)path, (String)TRACE_TYPE, (boolean)false);
            SWTBotUtils.delay((long)1000L);
            workbenchbot.closeAllEditors();
            if (!status.isOK()) {
                SWTBotUtils.deleteProject((String)TRACE_PROJECT_NAME, (SWTWorkbenchBot)workbenchbot);
                Assert.fail((String)OpenTraceStressTest.handleErrorStatus(status));
            }
            ++i;
        }
        SWTBotUtils.deleteProject((String)TRACE_PROJECT_NAME, (SWTWorkbenchBot)workbenchbot);
    }

    private static String handleErrorStatus(MultiStatus status) {
        StringBuilder sb = new StringBuilder();
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            Throwable childException;
            IStatus childStatus = iStatusArray[n2];
            StringBuilder childSb = new StringBuilder();
            if (!childStatus.getMessage().isEmpty()) {
                childSb.append(String.valueOf(childStatus.getMessage()) + '\n');
            }
            if ((childException = childStatus.getException()) != null) {
                String stackMessage;
                String reason = childException.getMessage();
                if (reason == null) {
                    reason = childException.toString();
                }
                if ((stackMessage = OpenTraceStressTest.getExceptionStackMessage(childException)) == null) {
                    stackMessage = reason;
                }
                childSb.append(stackMessage);
            }
            if (childSb.length() > 0) {
                childSb.insert(0, '\n');
                sb.append(childSb.toString());
            }
            ++n2;
        }
        return sb.toString();
    }

    private static String getExceptionStackMessage(Throwable exception) {
        String stackMessage = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        exception.printStackTrace(ps);
        ps.flush();
        try {
            baos.flush();
            stackMessage = baos.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stackMessage;
    }
}

