/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.tests;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemFactory;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.backend.StateHistoryBackendFactory;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StateSystem2DTest {
    private static final long START_TIME = 50L;
    private static final @NonNull String STRING_ATTRIBUTE = "String";
    private static final @NonNull String INTEGER_ATTRIBUTE = "Integer";
    private ITmfStateSystemBuilder fStateSystem;

    @Before
    public void setupStateSystem() {
        try {
            IStateHistoryBackend backend = null;
            try {
                backend = StateHistoryBackendFactory.createHistoryTreeBackendNewFile((String)"test", (File)((File)NonNullUtils.checkNotNull((Object)File.createTempFile("2Dtest", "ht"))), (int)0, (long)50L, (int)0);
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
            this.fStateSystem = StateSystemFactory.newStateSystem((IStateHistoryBackend)((IStateHistoryBackend)NonNullUtils.checkNotNull(backend)));
            int stringQuark = this.fStateSystem.getQuarkAbsoluteAndAdd(new String[]{STRING_ATTRIBUTE});
            int integerQuark = this.fStateSystem.getQuarkAbsoluteAndAdd(new String[]{INTEGER_ATTRIBUTE});
            this.fStateSystem.modifyAttribute(60L, (ITmfStateValue)TmfStateValue.newValueString((String)"String1"), stringQuark);
            this.fStateSystem.modifyAttribute(70L, (ITmfStateValue)TmfStateValue.newValueInt((int)0), integerQuark);
            this.fStateSystem.modifyAttribute(80L, (ITmfStateValue)TmfStateValue.newValueInt((int)1), integerQuark);
            this.fStateSystem.modifyAttribute(90L, (ITmfStateValue)TmfStateValue.newValueString((String)"String2"), stringQuark);
            this.fStateSystem.modifyAttribute(100L, (ITmfStateValue)TmfStateValue.newValueInt((int)2), integerQuark);
            this.fStateSystem.modifyAttribute(110L, (ITmfStateValue)TmfStateValue.newValueInt((int)3), integerQuark);
            this.fStateSystem.modifyAttribute(130L, (ITmfStateValue)TmfStateValue.newValueString((String)"String3"), stringQuark);
            this.fStateSystem.modifyAttribute(140L, (ITmfStateValue)TmfStateValue.newValueString((String)"String4"), stringQuark);
            this.fStateSystem.modifyAttribute(160L, (ITmfStateValue)TmfStateValue.newValueInt((int)4), integerQuark);
            this.fStateSystem.closeHistory(200L);
        }
        catch (StateValueTypeException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void tearDown() {
        this.fStateSystem.dispose();
        this.fStateSystem.removeFiles();
    }

    private static void testContinuous(Iterable<ITmfStateInterval> iterable, Collection<Integer> quarks, long start, long end, int totalCount) {
        TreeMultimap treeMap = TreeMultimap.create(Comparator.naturalOrder(), Comparator.comparing(ITmfStateInterval::getStartTime));
        iterable.forEach(arg_0 -> StateSystem2DTest.lambda$0((Multimap)treeMap, arg_0));
        Assert.assertEquals((long)totalCount, (long)treeMap.size());
        Assert.assertEquals((long)quarks.size(), (long)treeMap.keySet().size());
        for (Integer quark : quarks) {
            Collection orderedSet = treeMap.get((Object)quark);
            Assert.assertTrue((!orderedSet.isEmpty() ? 1 : 0) != 0);
            ITmfStateInterval previous = null;
            for (ITmfStateInterval interval : orderedSet) {
                if (previous == null) {
                    Assert.assertTrue((boolean)interval.intersects(start));
                } else {
                    Assert.assertEquals((long)(previous.getEndTime() + 1L), (long)interval.getStartTime());
                }
                previous = interval;
            }
            Assert.assertNotNull(previous);
            Assert.assertTrue((boolean)previous.intersects(end));
        }
    }

    @Test
    public void testContinuous2DQuery() {
        ITmfStateSystemBuilder ss = this.fStateSystem;
        Assert.assertNotNull((Object)ss);
        long end = ss.getCurrentEndTime();
        try {
            int stringQuark = this.fStateSystem.getQuarkAbsolute(new String[]{STRING_ATTRIBUTE});
            Iterable iterable = ss.query2D(Collections.singleton(stringQuark), 50L, end);
            StateSystem2DTest.testContinuous(iterable, Collections.singleton(stringQuark), 50L, end, 5);
            int integerQuark = this.fStateSystem.getQuarkAbsolute(new String[]{INTEGER_ATTRIBUTE});
            iterable = ss.query2D(Collections.singleton(integerQuark), 50L, end);
            StateSystem2DTest.testContinuous(iterable, Collections.singleton(integerQuark), 50L, end, 6);
            ImmutableList quarks = ImmutableList.of((Object)stringQuark, (Object)integerQuark);
            iterable = ss.query2D((Collection)quarks, 50L, end);
            StateSystem2DTest.testContinuous(iterable, (Collection<Integer>)quarks, 50L, end, 11);
        }
        catch (AttributeNotFoundException | StateSystemDisposedException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private static void testDiscrete(Iterable<ITmfStateInterval> iterable, Collection<Integer> quarks, Collection<Long> times, int totalCount) {
        HashSet<ITmfStateInterval> set = new HashSet<ITmfStateInterval>();
        int countTimeStamps = 0;
        for (ITmfStateInterval interval : iterable) {
            Assert.assertTrue((boolean)quarks.contains(interval.getAttribute()));
            Assert.assertTrue((boolean)set.add(interval));
            int timeStamps = (int)times.stream().filter(arg_0 -> ((ITmfStateInterval)interval).intersects(arg_0)).count();
            Assert.assertTrue((timeStamps > 0 ? 1 : 0) != 0);
            countTimeStamps += timeStamps;
        }
        Assert.assertEquals((long)totalCount, (long)set.size());
        Assert.assertEquals((long)(times.size() * quarks.size()), (long)countTimeStamps);
    }

    @Test
    public void testDiscrete2DQuery() {
        ITmfStateSystemBuilder ss = this.fStateSystem;
        Assert.assertNotNull((Object)ss);
        long end = ss.getCurrentEndTime();
        List times = StateSystemUtils.getTimes((long)50L, (long)end, (long)30L);
        Assert.assertEquals((long)6L, (long)times.size());
        Assert.assertTrue((boolean)Ordering.natural().isStrictlyOrdered((Iterable)times));
        try {
            int stringQuark = this.fStateSystem.getQuarkAbsolute(new String[]{STRING_ATTRIBUTE});
            Iterable iterable = ss.query2D(Collections.singleton(stringQuark), (Collection)times);
            StateSystem2DTest.testDiscrete(iterable, Collections.singleton(stringQuark), times, 4);
            int integerQuark = this.fStateSystem.getQuarkAbsolute(new String[]{INTEGER_ATTRIBUTE});
            iterable = ss.query2D(Collections.singleton(integerQuark), (Collection)times);
            StateSystem2DTest.testDiscrete(iterable, Collections.singleton(integerQuark), times, 4);
            ImmutableList quarks = ImmutableList.of((Object)stringQuark, (Object)integerQuark);
            iterable = ss.query2D((Collection)quarks, (Collection)times);
            StateSystem2DTest.testDiscrete(iterable, (Collection<Integer>)quarks, times, 8);
        }
        catch (AttributeNotFoundException | StateSystemDisposedException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private static /* synthetic */ void lambda$0(Multimap multimap, ITmfStateInterval interval) {
        Assert.assertTrue((boolean)multimap.put((Object)interval.getAttribute(), (Object)interval));
    }
}

