/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.tests.backend;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.interval.TmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.statesystem.core.tests.stubs.statevalues.CustomStateValueStub;
import org.junit.Assert;
import org.junit.Test;

public abstract class StateHistoryBackendTestBase {
    private static final ITmfStateValue INT_VAL1 = TmfStateValue.newValueInt((int)-42);
    private static final ITmfStateValue INT_VAL2 = TmfStateValue.newValueInt((int)675893);
    private static final ITmfStateValue LONG_VAL1 = TmfStateValue.newValueLong((long)-78L);
    private static final ITmfStateValue LONG_VAL2 = TmfStateValue.newValueLong((long)2234L);
    private static final ITmfStateValue DOUBLE_VAL1 = TmfStateValue.newValueDouble((double)-9.87);
    private static final ITmfStateValue DOUBLE_VAL2 = TmfStateValue.newValueDouble((double)50324.131643);
    private static final ITmfStateValue STR_VAL1 = TmfStateValue.newValueString((String)"A string");
    private static final ITmfStateValue STR_VAL2 = TmfStateValue.newValueString((String)"Another \u00e9\u00e8str");

    protected abstract IStateHistoryBackend getBackendForBuilding(long var1) throws IOException;

    protected IStateHistoryBackend getBackendForQuerying(IStateHistoryBackend backend) throws IOException {
        return backend;
    }

    protected final @Nullable IStateHistoryBackend prepareBackend(long startTime, long endTime, List<ITmfStateInterval> intervals) {
        try {
            IStateHistoryBackend backend = this.getBackendForBuilding(startTime);
            StateHistoryBackendTestBase.insertIntervals(backend, intervals);
            backend.finishedBuilding(Math.max(endTime, backend.getEndTime()));
            return this.getBackendForQuerying(backend);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }

    protected static void insertIntervals(IStateHistoryBackend backend, List<ITmfStateInterval> intervals) {
        for (ITmfStateInterval interval : intervals) {
            backend.insertPastState(interval.getStartTime(), interval.getEndTime(), interval.getAttribute(), interval.getStateValue());
        }
    }

    private static List<@Nullable ITmfStateInterval> prepareIntervalList(int nbAttrib) {
        ArrayList<@Nullable ITmfStateInterval> intervals = new ArrayList<ITmfStateInterval>(nbAttrib);
        int i = 0;
        while (i < nbAttrib) {
            intervals.add(null);
            ++i;
        }
        return intervals;
    }

    protected final IStateHistoryBackend buildAndQueryFullRange(long startTime, long endTime, int nbAttr, List<ITmfStateInterval> intervals, boolean allowNull) {
        IStateHistoryBackend backend = this.prepareBackend(startTime, endTime, intervals);
        Assert.assertNotNull((Object)backend);
        try {
            long t = backend.getStartTime();
            while (t <= backend.getEndTime()) {
                List<@Nullable ITmfStateInterval> stateInfo = StateHistoryBackendTestBase.prepareIntervalList(nbAttr);
                backend.doQuery(stateInfo, t);
                int attr = 0;
                while (attr < stateInfo.size()) {
                    ITmfStateInterval interval = stateInfo.get(attr);
                    if (!allowNull) {
                        Assert.assertTrue((String)("null interval at t=" + t + " for attr=" + attr), (interval != null ? 1 : 0) != 0);
                    }
                    if (interval != null) {
                        Assert.assertTrue((String)(interval + " does not intersect t=" + t), (boolean)interval.intersects(t));
                    }
                    ++attr;
                }
                ++t;
            }
            Assert.assertEquals((long)startTime, (long)backend.getStartTime());
            Assert.assertEquals((long)endTime, (long)backend.getEndTime());
        }
        catch (StateSystemDisposedException e) {
            Assert.fail((String)e.getMessage());
        }
        return backend;
    }

    @Test
    public void testCascadingIntervals() {
        int nbAttr = 10;
        long duration = 10L;
        long startTime = 0L;
        long endTime = 1000L;
        ArrayList<ITmfStateInterval> intervals = new ArrayList<ITmfStateInterval>();
        long t = 1L;
        while (t <= 1010L) {
            intervals.add((ITmfStateInterval)new TmfStateInterval(Math.max(0L, t - 10L), Math.min(1000L, t - 1L), (int)t % 10, (ITmfStateValue)TmfStateValue.newValueLong((long)t)));
            ++t;
        }
        this.buildAndQueryFullRange(0L, 1000L, 10, intervals, false);
    }

    @Test
    public void testFullIntervals() {
        int nbAttr = 1000;
        long startTime = 0L;
        long endTime = 1000L;
        ArrayList<ITmfStateInterval> intervals = new ArrayList<ITmfStateInterval>();
        int attr = 0;
        while (attr < 1000) {
            intervals.add((ITmfStateInterval)new TmfStateInterval(0L, 1000L, attr, (ITmfStateValue)TmfStateValue.newValueLong((long)attr)));
            ++attr;
        }
        this.buildAndQueryFullRange(0L, 1000L, 1000, intervals, false);
    }

    @Test
    public void testInsertQueryStateValues() {
        long startTime = 10L;
        long timeStep = 5L;
        int intQuark = 0;
        int longQuark = 1;
        int doubleQuark = 2;
        int strQuark = 3;
        int customQuark = 4;
        CustomStateValueStub.registerFactory();
        CustomStateValueStub customVal = new CustomStateValueStub(10, "a string");
        try {
            IStateHistoryBackend backend = this.getBackendForBuilding(startTime);
            Assert.assertNotNull((Object)backend);
            backend.insertPastState(startTime, startTime + timeStep, intQuark, INT_VAL1);
            ITmfStateInterval interval = backend.doSingularQuery(startTime, intQuark);
            Assert.assertEquals((String)"Int interval start time", (long)startTime, (long)interval.getStartTime());
            Assert.assertEquals((String)"Int interval end time", (long)(startTime + timeStep), (long)interval.getEndTime());
            Assert.assertEquals((String)"Int interval value", (Object)INT_VAL1, (Object)interval.getStateValue());
            backend.insertPastState(startTime, startTime + timeStep, longQuark, LONG_VAL1);
            interval = backend.doSingularQuery(startTime, longQuark);
            Assert.assertEquals((String)"Long interval start time", (long)startTime, (long)interval.getStartTime());
            Assert.assertEquals((String)"Long interval end time", (long)(startTime + timeStep), (long)interval.getEndTime());
            Assert.assertEquals((String)"Long interval value", (Object)LONG_VAL1, (Object)interval.getStateValue());
            backend.insertPastState(startTime, startTime + timeStep, doubleQuark, DOUBLE_VAL1);
            interval = backend.doSingularQuery(startTime, doubleQuark);
            Assert.assertEquals((String)"Double interval start time", (long)startTime, (long)interval.getStartTime());
            Assert.assertEquals((String)"Double interval end time", (long)(startTime + timeStep), (long)interval.getEndTime());
            Assert.assertEquals((String)"Double interval value", (Object)DOUBLE_VAL1, (Object)interval.getStateValue());
            backend.insertPastState(startTime, startTime + timeStep, strQuark, STR_VAL1);
            interval = backend.doSingularQuery(startTime, strQuark);
            Assert.assertEquals((String)"String interval start time", (long)startTime, (long)interval.getStartTime());
            Assert.assertEquals((String)"String interval end time", (long)(startTime + timeStep), (long)interval.getEndTime());
            Assert.assertEquals((String)"String interval value", (Object)STR_VAL1, (Object)interval.getStateValue());
            backend.insertPastState(startTime, startTime + timeStep, customQuark, (ITmfStateValue)customVal);
            interval = backend.doSingularQuery(startTime, customQuark);
            Assert.assertEquals((String)"Custom interval start time", (long)startTime, (long)interval.getStartTime());
            Assert.assertEquals((String)"Custom interval end time", (long)(startTime + timeStep), (long)interval.getEndTime());
            Assert.assertEquals((String)"Custom interval value", (Object)((Object)customVal), (Object)interval.getStateValue());
            backend.insertPastState(startTime + timeStep + 1L, startTime + 2L * timeStep, intQuark, INT_VAL2);
            backend.insertPastState(startTime + 2L * timeStep + 1L, startTime + 3L * timeStep, intQuark, INT_VAL1);
            interval = backend.doSingularQuery(startTime + timeStep, intQuark);
            Assert.assertEquals((String)"Int interval value", (Object)INT_VAL1, (Object)interval.getStateValue());
            interval = backend.doSingularQuery(startTime + timeStep + 1L, intQuark);
            Assert.assertEquals((String)"Int interval value", (Object)INT_VAL2, (Object)interval.getStateValue());
            interval = backend.doSingularQuery(startTime + 2L * timeStep, intQuark);
            Assert.assertEquals((String)"Int interval value", (Object)INT_VAL2, (Object)interval.getStateValue());
            interval = backend.doSingularQuery(startTime + 2L * timeStep + 1L, intQuark);
            Assert.assertEquals((String)"Int interval value", (Object)INT_VAL1, (Object)interval.getStateValue());
        }
        catch (IOException | StateSystemDisposedException | TimeRangeException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testBuildNowQueryLaterStateValues() {
        long startTime = 10L;
        long timeStep = 5L;
        int intQuark = 0;
        int longQuark = 1;
        int doubleQuark = 2;
        int strQuark = 3;
        int customQuark = 4;
        int nbAttribs = 5;
        CustomStateValueStub.registerFactory();
        CustomStateValueStub customVal = new CustomStateValueStub(10, "a string");
        CustomStateValueStub customVal2 = new CustomStateValueStub(Short.MAX_VALUE, "another string");
        try {
            IStateHistoryBackend backend = this.getBackendForBuilding(startTime);
            Assert.assertNotNull((Object)backend);
            long firstEnd = startTime + timeStep;
            long nextStart = firstEnd + 1L;
            long endTime = nextStart + timeStep;
            StateHistoryBackendTestBase.insertIntervals(backend, (List<ITmfStateInterval>)ImmutableList.of((Object)new TmfStateInterval(startTime, startTime + timeStep, intQuark, INT_VAL1), (Object)new TmfStateInterval(startTime, startTime + timeStep, longQuark, LONG_VAL1), (Object)new TmfStateInterval(startTime, startTime + timeStep, doubleQuark, DOUBLE_VAL1), (Object)new TmfStateInterval(startTime, startTime + timeStep, strQuark, STR_VAL1), (Object)new TmfStateInterval(startTime, startTime + timeStep, customQuark, (ITmfStateValue)customVal), (Object)new TmfStateInterval(nextStart, endTime, intQuark, INT_VAL2), (Object)new TmfStateInterval(nextStart, endTime, longQuark, LONG_VAL2), (Object)new TmfStateInterval(nextStart, endTime, doubleQuark, DOUBLE_VAL2), (Object)new TmfStateInterval(nextStart, endTime, strQuark, STR_VAL2), (Object)new TmfStateInterval(nextStart, endTime, customQuark, (ITmfStateValue)customVal2)));
            backend.finishedBuilding(endTime);
            Assert.assertEquals((long)endTime, (long)backend.getEndTime());
            IStateHistoryBackend backendQuery = this.getBackendForQuerying(backend);
            Assert.assertEquals((String)"Backend start time", (long)startTime, (long)backendQuery.getStartTime());
            Assert.assertEquals((String)"Backend end time", (long)endTime, (long)backendQuery.getEndTime());
            List<@Nullable ITmfStateInterval> intervals = StateHistoryBackendTestBase.prepareIntervalList(nbAttribs);
            backendQuery.doQuery(intervals, startTime);
            ITmfStateInterval interval = intervals.get(intQuark);
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((String)"Int value after read", (Object)INT_VAL1, (Object)interval.getStateValue());
            interval = intervals.get(longQuark);
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((String)"Long value after read", (Object)LONG_VAL1, (Object)interval.getStateValue());
            interval = intervals.get(doubleQuark);
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((String)"Double value after read", (Object)DOUBLE_VAL1, (Object)interval.getStateValue());
            interval = intervals.get(strQuark);
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((String)"String value after read", (Object)STR_VAL1, (Object)interval.getStateValue());
            interval = intervals.get(customQuark);
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((String)"String value after read", (Object)((Object)customVal), (Object)interval.getStateValue());
            backendQuery.doQuery(intervals, endTime);
            interval = intervals.get(intQuark);
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((String)"Int value after read", (Object)INT_VAL2, (Object)interval.getStateValue());
            interval = intervals.get(longQuark);
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((String)"Long value after read", (Object)LONG_VAL2, (Object)interval.getStateValue());
            interval = intervals.get(doubleQuark);
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((String)"Double value after read", (Object)DOUBLE_VAL2, (Object)interval.getStateValue());
            interval = intervals.get(strQuark);
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((String)"String value after read", (Object)STR_VAL2, (Object)interval.getStateValue());
            interval = intervals.get(customQuark);
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((String)"String value after read", (Object)((Object)customVal2), (Object)interval.getStateValue());
        }
        catch (IOException | StateSystemDisposedException | TimeRangeException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test(expected=TimeRangeException.class)
    public void testIntervalBeforeStart() {
        long startTime = 1000L;
        try {
            IStateHistoryBackend backend = this.getBackendForBuilding(startTime);
            backend.insertPastState(startTime - 1L, startTime + 1L, 0, INT_VAL1);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

