/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.tests.perf.historytree;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HistoryTreeBackend;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemFactory;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.backend.StateHistoryBackendFactory;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HistoryTreeBackendBenchmark {
    private static final @NonNull String TEST_PREFIX = "org.eclipse.tracecompass#History Tree Backend#";
    private static final @NonNull String TEST_BUILDING_ID = "Build: ";
    private static final @NonNull String TEST_SINGLE_QUERY_ID = "Single Queries: ";
    private static final @NonNull String TEST_FULL_QUERY_ID = "Full Queries: ";
    private static final @NonNull String TEST_QUERY_RANGE_ID = "Query History Range: ";
    private static final @NonNull String ROOT_NODE = "root";
    private static final int QUEUE_SIZE = 10000;
    private static final long SEED = 5575784704147L;
    private static final int QUERY_COUNT = 100;
    private static final int INTERVAL_AVG_TIME = 1000;
    private static final int DEFAULT_NB_ATTRIB = 1500;
    private static final int DEFAULT_NB_INTERVALS = 500;
    private static final int DEFAULT_LOOP_COUNT = 40;
    private File fTempFile;
    private final String fName;
    private final String fShortName;
    private final int fNbAttrib;
    private final int fNbAvgIntervals;
    private final int fNbLoops;
    private final HTBValues fValues;
    private final IIntervalDistribution fDistributionMethod;
    private static IIntervalDistribution UNIFORM = (r, l) -> {
        long nextLong = r.nextLong();
        long nextDelta = l + nextLong % l;
        return nextDelta;
    };
    private static IIntervalDistribution CLOSER_TO_LIMIT = (r, l) -> {
        double nextDouble = r.nextDouble();
        int sign = nextDouble < 0.0 ? -1 : 1;
        long nextDelta = l + (long)(Math.sqrt(nextDouble) * (double)l * (double)sign);
        return nextDelta;
    };
    private static IIntervalDistribution CLOSER_TO_LIMIT_10_PERCENT_OUTLIERS = (r, l) -> {
        long nextLong = Math.abs(r.nextLong());
        if (nextLong % 100L < 10L) {
            return l + (nextLong % 3L + 1L) * l + nextLong % l;
        }
        double nextDouble = r.nextDouble();
        int sign = nextDouble < 0.0 ? -1 : 1;
        long nextDelta = l + (long)(Math.sqrt(nextDouble) * (double)l * (double)sign);
        return nextDelta;
    };

    public HistoryTreeBackendBenchmark(String name, String shortName, int nbAttrib, int nbAvgIntervals, int nbLoops, HTBValues values, IIntervalDistribution distributionMethod) {
        this.fName = name;
        this.fShortName = shortName;
        this.fNbAttrib = nbAttrib;
        this.fNbAvgIntervals = nbAvgIntervals;
        this.fNbLoops = nbLoops;
        this.fValues = values;
        this.fDistributionMethod = distributionMethod;
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        return Arrays.asList({"Average case: 1500 attributes, integers, interval duration random around limit l with 75 percent within [0.5l, 1.5l]", "Average case", 1500, 500, 40, HTBValues.INTEGERS, CLOSER_TO_LIMIT}, {"Vertical scaling (more attributes)", "Vertical scaling", 3500, 500, 5, HTBValues.INTEGERS, CLOSER_TO_LIMIT}, {"Horizontal scaling (more intervals/attribute)", "Horizontal scaling", 1500, 20000, 10, HTBValues.INTEGERS, CLOSER_TO_LIMIT}, {"Interval durations uniformly distributed within [1, 2l]", "Uniform distribution of intervals", 1500, 500, 40, HTBValues.INTEGERS, UNIFORM}, {"Interval durations with 10 percent outliers > 2l", "Distribution with outliers", 1500, 500, 40, HTBValues.INTEGERS, CLOSER_TO_LIMIT_10_PERCENT_OUTLIERS}, {"Data type: strings", "Data type: strings", 1500, 500, 40, HTBValues.STRINGS, CLOSER_TO_LIMIT}, {"Data type: longs", "Data type: longs", 1500, 500, 40, HTBValues.LONGS, CLOSER_TO_LIMIT}, {"Data type: doubles", "Data type: doubles", 1500, 500, 40, HTBValues.DOUBLES, CLOSER_TO_LIMIT});
    }

    private void createFile() {
        try {
            this.fTempFile = File.createTempFile("tmpStateSystem", null);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private void deleteFile() {
        if (this.fTempFile != null) {
            this.fTempFile.delete();
            this.fTempFile = null;
        }
    }

    @Test
    public void testBenchmark() {
        long totalTime = this.fNbAvgIntervals * 1000;
        Performance perf = Performance.getDefault();
        PerformanceMeter pmBuild = perf.createPerformanceMeter("org.eclipse.tracecompass#History Tree Backend#Build: " + this.fName);
        perf.tagAsSummary(pmBuild, TEST_BUILDING_ID + this.fShortName, Dimension.CPU_TIME);
        PerformanceMeter pmSingleQuery = perf.createPerformanceMeter("org.eclipse.tracecompass#History Tree Backend#Single Queries: " + this.fName);
        perf.tagAsSummary(pmSingleQuery, TEST_SINGLE_QUERY_ID + this.fShortName, Dimension.CPU_TIME);
        PerformanceMeter pmFullQuery = perf.createPerformanceMeter("org.eclipse.tracecompass#History Tree Backend#Full Queries: " + this.fName);
        perf.tagAsSummary(pmFullQuery, TEST_FULL_QUERY_ID + this.fShortName, Dimension.CPU_TIME);
        PerformanceMeter pmRangeQuery = perf.createPerformanceMeter("org.eclipse.tracecompass#History Tree Backend#Query History Range: " + this.fName);
        perf.tagAsSummary(pmRangeQuery, TEST_QUERY_RANGE_ID + this.fShortName, Dimension.CPU_TIME);
        int i = 0;
        while (i < this.fNbLoops) {
            block12: {
                try {
                    try {
                        long ts;
                        QuarkEvent quarkEvent;
                        this.createFile();
                        IStateHistoryBackend backend = StateHistoryBackendFactory.createHistoryTreeBackendNewFile((String)TEST_BUILDING_ID, (File)((File)NonNullUtils.checkNotNull((Object)this.fTempFile)), (int)1, (long)1L, (int)10000);
                        ITmfStateSystemBuilder ss = StateSystemFactory.newStateSystem((IStateHistoryBackend)backend);
                        PriorityQueue<QuarkEvent> quarkEvents = new PriorityQueue<QuarkEvent>(this.fNbAttrib);
                        Random randomGenerator = new Random(5575784704147L);
                        int rootQuark = ss.getQuarkAbsoluteAndAdd(new String[]{ROOT_NODE});
                        int j = 0;
                        while (j < this.fNbAttrib) {
                            int quark = ss.getQuarkRelativeAndAdd(rootQuark, new String[]{String.valueOf(j)});
                            quarkEvents.add(new QuarkEvent(quark, Math.abs(randomGenerator.nextLong()) % 1000L + 1L, this.fValues.getValues()));
                            ++j;
                        }
                        pmBuild.start();
                        while ((quarkEvent = (QuarkEvent)quarkEvents.poll()) != null) {
                            long eventTime = quarkEvent.getNextEventTime();
                            ss.modifyAttribute(eventTime, quarkEvent.getNextValue(), quarkEvent.getQuark());
                            long nextDelta = this.fDistributionMethod.getNextEndTime(randomGenerator, 1000L);
                            long nextEndTime = eventTime + nextDelta;
                            if (nextEndTime > totalTime) continue;
                            quarkEvent.setNextEventTime(nextEndTime);
                            quarkEvents.add(quarkEvent);
                        }
                        ss.closeHistory(totalTime);
                        pmBuild.stop();
                        List subAttributes = ss.getSubAttributes(rootQuark, false);
                        pmSingleQuery.start();
                        int j2 = 0;
                        while (j2 < 100) {
                            ts = HistoryTreeBackendBenchmark.getNextRandomValue(randomGenerator, totalTime);
                            int attrib = (int)HistoryTreeBackendBenchmark.getNextRandomValue(randomGenerator, subAttributes.size());
                            ss.querySingleState(ts, attrib);
                            ++j2;
                        }
                        pmSingleQuery.stop();
                        pmRangeQuery.start();
                        j2 = 0;
                        while (j2 < 10) {
                            int attrib = (int)HistoryTreeBackendBenchmark.getNextRandomValue(randomGenerator, subAttributes.size());
                            StateSystemUtils.queryHistoryRange((ITmfStateSystem)ss, (int)attrib, (long)ss.getStartTime(), (long)ss.getCurrentEndTime());
                            ++j2;
                        }
                        pmRangeQuery.stop();
                        pmFullQuery.start();
                        j2 = 0;
                        while (j2 < 100) {
                            ts = HistoryTreeBackendBenchmark.getNextRandomValue(randomGenerator, totalTime);
                            ss.queryFullState(ts);
                            ++j2;
                        }
                        pmFullQuery.stop();
                        if (i == 0 && backend instanceof HistoryTreeBackend) {
                            HistoryTreeBackend htBackend = (HistoryTreeBackend)backend;
                            System.out.println("History tree file size: " + FileUtils.byteCountToDisplaySize((long)htBackend.getFileSize()));
                            System.out.println("Average node usage: " + htBackend.getAverageNodeUsage());
                        }
                        this.deleteFile();
                    }
                    catch (IOException | AttributeNotFoundException | StateSystemDisposedException | StateValueTypeException e) {
                        Assert.fail((String)e.getMessage());
                        this.deleteFile();
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    this.deleteFile();
                    throw throwable;
                }
                this.deleteFile();
            }
            ++i;
        }
        pmBuild.commit();
        pmSingleQuery.commit();
        pmFullQuery.commit();
        pmRangeQuery.commit();
    }

    private static long getNextRandomValue(Random randomGenerator, long limit) {
        long nextLong = Math.abs(randomGenerator.nextLong());
        long nextDelta = nextLong % limit + 1L;
        return nextDelta;
    }

    private static enum HTBValues {
        INTEGERS((List<ITmfStateValue>)ImmutableList.of((Object)TmfStateValue.newValueInt((int)1), (Object)TmfStateValue.newValueInt((int)2), (Object)TmfStateValue.newValueInt((int)3))),
        STRINGS((List<ITmfStateValue>)ImmutableList.of((Object)TmfStateValue.newValueString((String)"abc"), (Object)TmfStateValue.newValueString((String)"def"), (Object)TmfStateValue.newValueString((String)"wihi!"))),
        LONGS((List<ITmfStateValue>)ImmutableList.of((Object)TmfStateValue.newValueLong((long)Long.MAX_VALUE), (Object)TmfStateValue.newValueLong((long)1L), (Object)TmfStateValue.newValueLong((long)1234567L))),
        DOUBLES((List<ITmfStateValue>)ImmutableList.of((Object)TmfStateValue.newValueDouble((double)Double.MAX_VALUE), (Object)TmfStateValue.newValueDouble((double)1.0), (Object)TmfStateValue.newValueDouble((double)123.456)));

        private final List<ITmfStateValue> fValues;

        private HTBValues(List<ITmfStateValue> values) {
            this.fValues = values;
        }

        public List<ITmfStateValue> getValues() {
            return this.fValues;
        }
    }

    @FunctionalInterface
    private static interface IIntervalDistribution {
        public long getNextEndTime(Random var1, long var2);
    }

    private static class QuarkEvent
    implements Comparable<QuarkEvent> {
        private final int fQuark;
        private long fNextEventTime;
        private final List<ITmfStateValue> fPossibleValues;
        private int fNextValue = 0;

        public QuarkEvent(int quark, long nextEventTime, List<ITmfStateValue> valuesList) {
            this.fQuark = quark;
            this.fNextEventTime = nextEventTime;
            this.fPossibleValues = valuesList;
        }

        public int getQuark() {
            return this.fQuark;
        }

        public long getNextEventTime() {
            return this.fNextEventTime;
        }

        public void setNextEventTime(long t) {
            this.fNextEventTime = t;
        }

        public ITmfStateValue getNextValue() {
            ITmfStateValue value = this.fPossibleValues.get(this.fNextValue);
            ++this.fNextValue;
            if (this.fNextValue >= this.fPossibleValues.size()) {
                this.fNextValue = 0;
            }
            return value;
        }

        @Override
        public int compareTo(QuarkEvent other) {
            return Long.compare(this.fNextEventTime, other.getNextEventTime());
        }
    }
}

