/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.model;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.stateprovider.XmlStateSystemModule;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module.XmlUtilsTest;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TmfStateValueTest {
    private static final @NonNull String TEST_TRACE = "test_traces/testTrace4.xml";
    ITmfTrace fTrace;
    XmlStateSystemModule fModule;

    @Before
    public void setUp() throws TmfAnalysisException {
        ITmfTrace trace = XmlUtilsTest.initializeTrace(TEST_TRACE);
        XmlStateSystemModule module = XmlUtilsTest.initializeModule(TmfXmlTestFiles.STATE_VALUE_FILE);
        module.setTrace(trace);
        module.schedule();
        module.waitForCompletion();
        this.fTrace = trace;
        this.fModule = module;
    }

    @After
    public void cleanUp() {
        this.fTrace.dispose();
        this.fModule.dispose();
    }

    @Test
    public void testStateValueUpdate() throws AttributeNotFoundException, StateSystemDisposedException {
        XmlStateSystemModule module = this.fModule;
        Assert.assertNotNull((Object)module);
        ITmfStateSystem ss = module.getStateSystem();
        Assert.assertNotNull((Object)ss);
        int quark = ss.getQuarkAbsolute(new String[]{"update", "0"});
        int[] expectedStarts = new int[]{1, 3, 5, 7, 7};
        ITmfStateValue[] expectedValues = new ITmfStateValue[]{TmfStateValue.newValueString((String)"GOOD"), TmfStateValue.nullValue(), TmfStateValue.newValueString((String)"BAD"), TmfStateValue.nullValue()};
        XmlUtilsTest.verifyStateIntervals("testStateValueUpdate", ss, quark, expectedStarts, expectedValues);
    }

    @Test
    public void testStateValueModify() throws AttributeNotFoundException, StateSystemDisposedException {
        XmlStateSystemModule module = this.fModule;
        Assert.assertNotNull((Object)module);
        ITmfStateSystem ss = module.getStateSystem();
        Assert.assertNotNull((Object)ss);
        int quark = ss.getQuarkAbsolute(new String[]{"modify", "0"});
        int[] expectedStarts = new int[]{1, 3, 5, 7, 7};
        ITmfStateValue[] expectedValues = new ITmfStateValue[]{TmfStateValue.newValueString((String)"UNKNOWN"), TmfStateValue.newValueString((String)"GOOD"), TmfStateValue.newValueString((String)"UNKNOWN"), TmfStateValue.newValueString((String)"BAD")};
        XmlUtilsTest.verifyStateIntervals("testStateValueModify", ss, quark, expectedStarts, expectedValues);
    }

    @Test
    public void testStateValuePeek() throws AttributeNotFoundException, StateSystemDisposedException {
        XmlStateSystemModule module = this.fModule;
        Assert.assertNotNull((Object)module);
        ITmfStateSystem ss = module.getStateSystem();
        Assert.assertNotNull((Object)ss);
        int quark = ss.getQuarkAbsolute(new String[]{"stack"});
        int[] expectedStarts = new int[]{1, 5, 7, 7};
        ITmfStateValue[] expectedValues = new ITmfStateValue[]{TmfStateValue.newValueLong((long)1L), TmfStateValue.newValueLong((long)5L), TmfStateValue.newValueLong((long)1L)};
        XmlUtilsTest.verifyStackStateIntervals("testStateValueModify", ss, quark, expectedStarts, expectedValues);
    }

    @Test
    public void testStateValueMapping() throws AttributeNotFoundException, StateSystemDisposedException {
        XmlStateSystemModule module = this.fModule;
        Assert.assertNotNull((Object)module);
        ITmfStateSystem ss = module.getStateSystem();
        Assert.assertNotNull((Object)ss);
        int quark = ss.getQuarkAbsolute(new String[]{"mapped"});
        int[] expectedStarts = new int[]{1, 3, 5, 7, 7};
        ITmfStateValue[] expectedValues = new ITmfStateValue[]{TmfStateValue.newValueString((String)"TRUE"), TmfStateValue.newValueString((String)"FALSE"), TmfStateValue.newValueString((String)"TRUE"), TmfStateValue.newValueString((String)"FALSE")};
        XmlUtilsTest.verifyStateIntervals("testMappingGroups", ss, quark, expectedStarts, expectedValues);
    }

    @Test
    public void testStateValueHostId() throws AttributeNotFoundException, StateSystemDisposedException {
        XmlStateSystemModule module = this.fModule;
        Assert.assertNotNull((Object)module);
        ITmfStateSystem ss = module.getStateSystem();
        Assert.assertNotNull((Object)ss);
        int quark = ss.getQuarkAbsolute(new String[]{"hostID"});
        int[] expectedStarts = new int[]{1, 7};
        ITmfStateValue[] expectedValues = new ITmfStateValue[]{TmfStateValue.newValueString((String)"testTrace4.xml")};
        XmlUtilsTest.verifyStateIntervals("testHostId", ss, quark, expectedStarts, expectedValues);
    }
}

