/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.stateprovider;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.stateprovider.XmlStateSystemModule;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module.XmlUtilsTest;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.junit.Assert;
import org.junit.Test;

public class TmfXmlDoubleTest {
    private static final @NonNull String testTrace3 = "test_traces/testTrace3.xml";

    @Test
    public void testConditionsValidation() throws TmfAnalysisException, StateSystemDisposedException {
        ITmfTrace trace = XmlUtilsTest.initializeTrace(testTrace3);
        XmlStateSystemModule module = XmlUtilsTest.initializeModule(TmfXmlTestFiles.DOUBLES_FILE);
        module.setTrace(trace);
        module.schedule();
        module.waitForCompletion();
        ITmfStateSystem ss = module.getStateSystem();
        Assert.assertNotNull((Object)ss);
        List val = ss.queryFullState(2L);
        Assert.assertEquals((double)3.141592, (double)((ITmfStateInterval)val.get(0)).getStateValue().unboxDouble(), (double)Double.MIN_VALUE);
        val = ss.queryFullState(4L);
        Assert.assertEquals((double)2.71828, (double)((ITmfStateInterval)val.get(0)).getStateValue().unboxDouble(), (double)Double.MIN_VALUE);
        val = ss.queryFullState(6L);
        Assert.assertEquals((double)1.41421, (double)((ITmfStateInterval)val.get(0)).getStateValue().unboxDouble(), (double)Double.MIN_VALUE);
        trace.dispose();
        module.dispose();
    }
}

