/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.module;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class TmfXmlUtils {
    private TmfXmlUtils() {
    }

    public static List<@NonNull Element> getChildElements(Element parent, String elementTag) {
        NodeList nodes = parent.getElementsByTagName(elementTag);
        ArrayList<@NonNull Element> childElements = new ArrayList<Element>();
        int i = 0;
        while (i < nodes.getLength()) {
            Element node = (Element)nodes.item(i);
            if (node.getParentNode().equals(parent)) {
                childElements.add(node);
            }
            ++i;
        }
        return childElements;
    }

    public static Element getElementInFile(String filePath, @NonNull String elementType, @NonNull String elementId) {
        if (filePath == null) {
            return null;
        }
        Path path = new Path(filePath);
        File file = path.toFile();
        if (!(file != null && file.exists() && file.isFile() && XmlUtils.xmlValidate(file).isOK())) {
            return null;
        }
        try {
            Document doc = XmlUtils.getDocumentFromFile(file);
            NodeList nodes = doc.getElementsByTagName(elementType);
            Element foundNode = null;
            int i = 0;
            while (i < nodes.getLength()) {
                Element node = (Element)nodes.item(i);
                String id = node.getAttribute("id");
                if (id.equals(elementId)) {
                    foundNode = node;
                }
                ++i;
            }
            return foundNode;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return null;
        }
    }
}

