/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.tests.event;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EventContextTest {
    private static final @NonNull CtfTestTrace testTrace = CtfTestTrace.KERNEL_VM;
    private CtfTmfTrace fixture;
    private long startTime;
    private long endTime;

    @Before
    public void setUp() {
        this.fixture = CtfTmfTestTraceUtils.getTrace(testTrace);
        this.fixture.indexTrace(true);
        this.startTime = this.fixture.getStartTime().toNanos();
        this.endTime = this.fixture.getEndTime().toNanos();
    }

    @After
    public void tearDown() {
        if (this.fixture != null) {
            this.fixture.dispose();
        }
    }

    @Test
    public void testTrace() {
        Assert.assertEquals((long)1363700740555978750L, (long)this.startTime);
        Assert.assertEquals((long)1363700770550261288L, (long)this.endTime);
    }

    @Test
    public void testContextStart() {
        CtfTmfEvent firstEvent = this.getEventAt(this.startTime);
        long perfPageFault = (Long)firstEvent.getContent().getField(new String[]{"context._perf_page_fault"}).getValue();
        String procname = (String)firstEvent.getContent().getField(new String[]{"context._procname"}).getValue();
        long tid = (Long)firstEvent.getContent().getField(new String[]{"context._tid"}).getValue();
        Assert.assertEquals((long)613L, (long)perfPageFault);
        Assert.assertEquals((Object)"lttng-sessiond", (Object)procname);
        Assert.assertEquals((long)1230L, (long)tid);
    }

    @Test
    public void testContext1() {
        long time = this.startTime + 5000000000L;
        CtfTmfEvent event = this.getEventAt(time);
        long perfPageFault = (Long)event.getContent().getField(new String[]{"context._perf_page_fault"}).getValue();
        String procname = (String)event.getContent().getField(new String[]{"context._procname"}).getValue();
        long tid = (Long)event.getContent().getField(new String[]{"context._tid"}).getValue();
        Assert.assertEquals((long)6048L, (long)perfPageFault);
        Assert.assertEquals((Object)"swapper/0", (Object)procname);
        Assert.assertEquals((long)0L, (long)tid);
    }

    @Test
    public void testContext2() {
        long time = this.startTime + 10000000000L;
        CtfTmfEvent event = this.getEventAt(time);
        long perfPageFault = (Long)event.getContent().getField(new String[]{"context._perf_page_fault"}).getValue();
        String procname = (String)event.getContent().getField(new String[]{"context._procname"}).getValue();
        long tid = (Long)event.getContent().getField(new String[]{"context._tid"}).getValue();
        Assert.assertEquals((long)13258L, (long)perfPageFault);
        Assert.assertEquals((Object)"swapper/0", (Object)procname);
        Assert.assertEquals((long)0L, (long)tid);
    }

    @Test
    public void testContextMiddle() {
        long midTime = this.startTime + (this.endTime - this.startTime) / 2L;
        CtfTmfEvent midEvent = this.getEventAt(midTime);
        long perfPageFault = (Long)midEvent.getContent().getField(new String[]{"context._perf_page_fault"}).getValue();
        String procname = (String)midEvent.getContent().getField(new String[]{"context._procname"}).getValue();
        long tid = (Long)midEvent.getContent().getField(new String[]{"context._tid"}).getValue();
        Assert.assertEquals((long)19438L, (long)perfPageFault);
        Assert.assertEquals((Object)"swapper/0", (Object)procname);
        Assert.assertEquals((long)0L, (long)tid);
    }

    @Test
    public void testContext3() {
        long time = this.startTime + 20000000000L;
        CtfTmfEvent event = this.getEventAt(time);
        long perfPageFault = (Long)event.getContent().getField(new String[]{"context._perf_page_fault"}).getValue();
        String procname = (String)event.getContent().getField(new String[]{"context._procname"}).getValue();
        long tid = (Long)event.getContent().getField(new String[]{"context._tid"}).getValue();
        Assert.assertEquals((long)21507L, (long)perfPageFault);
        Assert.assertEquals((Object)"swapper/0", (Object)procname);
        Assert.assertEquals((long)0L, (long)tid);
    }

    @Test
    public void testContext4() {
        long time = this.startTime + 25000000000L;
        CtfTmfEvent event = this.getEventAt(time);
        long perfPageFault = (Long)event.getContent().getField(new String[]{"context._perf_page_fault"}).getValue();
        String procname = (String)event.getContent().getField(new String[]{"context._procname"}).getValue();
        long tid = (Long)event.getContent().getField(new String[]{"context._tid"}).getValue();
        Assert.assertEquals((long)21507L, (long)perfPageFault);
        Assert.assertEquals((Object)"swapper/0", (Object)procname);
        Assert.assertEquals((long)0L, (long)tid);
    }

    @Test
    public void testContextEnd() {
        CtfTmfEvent lastEvent = this.getEventAt(this.endTime);
        long perfPageFault = (Long)lastEvent.getContent().getField(new String[]{"context._perf_page_fault"}).getValue();
        String procname = (String)lastEvent.getContent().getField(new String[]{"context._procname"}).getValue();
        long tid = (Long)lastEvent.getContent().getField(new String[]{"context._tid"}).getValue();
        Assert.assertEquals((long)22117L, (long)perfPageFault);
        Assert.assertEquals((Object)"lttng-sessiond", (Object)procname);
        Assert.assertEquals((long)1230L, (long)tid);
    }

    private synchronized CtfTmfEvent getEventAt(long timestamp) {
        EventContextTestRequest req = new EventContextTestRequest(timestamp);
        this.fixture.sendRequest((ITmfEventRequest)req);
        try {
            req.waitForCompletion();
        }
        catch (InterruptedException e) {
            return null;
        }
        return req.getEvent();
    }

    private class EventContextTestRequest
    extends TmfEventRequest {
        private CtfTmfEvent retEvent;

        public EventContextTestRequest(long timestamp) {
            super(CtfTmfEvent.class, new TmfTimeRange(TmfTimestamp.fromNanos((long)timestamp), TmfTimestamp.BIG_CRUNCH), 0L, 1, ITmfEventRequest.ExecutionType.FOREGROUND);
            this.retEvent = null;
        }

        public void handleData(ITmfEvent event) {
            this.retEvent = (CtfTmfEvent)event;
        }

        public CtfTmfEvent getEvent() {
            return this.retEvent;
        }
    }
}

