/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.tests.shared;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.tests.shared.LttngTraceGenerator;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.tests.stubs.CtfTmfTraceStub;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;

@NonNullByDefault
public class CtfTmfTestTraceUtils {
    private static final Map<CtfTestTrace, CtfTmfTrace> CTF_TMF_TRACES = new HashMap<CtfTestTrace, CtfTmfTrace>();

    protected CtfTmfTestTraceUtils() {
    }

    public static synchronized CtfTmfTrace getTrace(CtfTestTrace ctfTrace) {
        return new CtfTmfTestTraceUtils().internalGetTrace(ctfTrace, CTF_TMF_TRACES, new CtfTmfTraceStub());
    }

    protected synchronized CtfTmfTrace internalGetTrace(CtfTestTrace ctfTrace, Map<CtfTestTrace, CtfTmfTrace> map, CtfTmfTrace trace) {
        String tracePath;
        try {
            tracePath = FileLocator.toFileURL((URL)ctfTrace.getTraceURL()).getPath();
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
        this.internalDispose(ctfTrace, map);
        try {
            trace.initTrace(null, tracePath, CtfTmfEvent.class);
        }
        catch (TmfTraceException e) {
            throw new RuntimeException(e);
        }
        map.put(ctfTrace, trace);
        return trace;
    }

    public static synchronized void dispose(CtfTestTrace ctfTrace) {
        new CtfTmfTestTraceUtils().internalDispose(ctfTrace, CTF_TMF_TRACES);
    }

    protected synchronized void internalDispose(CtfTestTrace ctfTrace, Map<CtfTestTrace, CtfTmfTrace> map) {
        CtfTmfTrace trace = map.remove(ctfTrace);
        if (trace != null) {
            trace.dispose();
        }
    }

    public static CtfTmfTrace getSyntheticTrace() {
        CtfTmfTrace trace = new CtfTmfTrace();
        try {
            trace.initTrace(null, LttngTraceGenerator.getPath(), CtfTmfEvent.class);
        }
        catch (TmfTraceException e) {
            throw new IllegalStateException();
        }
        return trace;
    }
}

