/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.tests.temp.headless;

import java.util.Vector;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;

public class RequestBenchmark
extends TmfEventRequest {
    private static final String TRACE_PATH = "../org.eclipse.tracecompass.ctf.core.tests/traces/kernel";
    private static final int NB_OF_PASS = 100;
    private static int nbEvent = 0;
    private static TmfExperiment fExperiment = null;
    private static Vector<Double> benchs = new Vector();
    static long prev;
    static long done;

    static {
        done = 0L;
    }

    private RequestBenchmark(Class<? extends ITmfEvent> dataType, TmfTimeRange range, int nbRequested) {
        super(dataType, range, 0L, nbRequested, ITmfEventRequest.ExecutionType.FOREGROUND);
    }

    public static void main(String[] args) {
        try {
            ITmfTrace[] traces = new ITmfTrace[]{new CtfTmfTrace()};
            traces[0].initTrace(null, TRACE_PATH, CtfTmfEvent.class);
            fExperiment = new TmfExperiment(CtfTmfEvent.class, "Headless", traces, 5000, null);
            RequestBenchmark request = null;
            int x = 0;
            while (x < 100) {
                request = new RequestBenchmark(CtfTmfEvent.class, TmfTimeRange.ETERNITY, Integer.MAX_VALUE);
                fExperiment.sendRequest((ITmfEventRequest)request);
                ++x;
            }
            prev = System.nanoTime();
        }
        catch (NullPointerException traces) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleData(ITmfEvent event) {
        super.handleData(event);
        ++nbEvent;
    }

    public void handleCompleted() {
        long next = System.nanoTime();
        double val = next - prev;
        int nbEvent2 = nbEvent;
        nbEvent = 0;
        prev = next;
        benchs.add(val /= (double)nbEvent2);
        if (benchs.size() == 100) {
            try {
                System.out.println("Nb events : " + nbEvent2);
                for (double value : benchs) {
                    System.out.print(String.valueOf(value) + ", ");
                }
                fExperiment.sendRequest(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void handleSuccess() {
    }

    public void handleFailure() {
    }

    public void handleCancel() {
    }
}

