/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.tests.trace;

import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.synchronization.TimestampTransformFactory;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.Assert;
import org.junit.Test;

public class CtfTmfReadBoundsTest {
    @Test
    public void testRapidBounds() {
        CtfTmfTrace trace = CtfTmfTestTraceUtils.getTrace(CtfTestTrace.TRACE2);
        try {
            ITmfTimestamp start = trace.readStart();
            Assert.assertNotNull((String)"Failed to read CtfTmfTrace start time", (Object)start);
            Assert.assertEquals((long)1331668247314038062L, (long)start.toNanos());
            ITmfTimestamp end = trace.readEnd();
            Assert.assertNotNull((String)"Failed to read CtfTmfTrace end time", (Object)end);
            Assert.assertEquals((long)1331668259053641544L, (long)end.toNanos());
        }
        finally {
            CtfTmfTestTraceUtils.dispose(CtfTestTrace.TRACE2);
        }
    }

    @Test
    public void testRapidBoundsWithTransform() throws TmfTraceException {
        CtfTmfTrace trace = CtfTmfTestTraceUtils.getTrace(CtfTestTrace.TRACE2);
        CtfTmfTrace traceWithOffset = new CtfTmfTrace();
        traceWithOffset.setTimestampTransform(TimestampTransformFactory.createWithOffset((long)500000000L));
        traceWithOffset.initTrace(null, trace.getPath(), CtfTmfEvent.class);
        try {
            ITmfTimestamp start = traceWithOffset.readStart();
            Assert.assertNotNull((String)"Failed to read CtfTmfTrace start time", (Object)start);
            Assert.assertEquals((long)1331668247814038062L, (long)start.toNanos());
            ITmfTimestamp end = traceWithOffset.readEnd();
            Assert.assertNotNull((String)"Failed to read CtfTmfTrace end time", (Object)end);
            Assert.assertEquals((long)1331668259553641544L, (long)end.toNanos());
        }
        finally {
            traceWithOffset.dispose();
            TmfTraceManager.deleteSupplementaryFiles((ITmfTrace)traceWithOffset);
            CtfTmfTestTraceUtils.dispose(CtfTestTrace.TRACE2);
        }
    }
}

