/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.tests.trace;

import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTraceValidationStatus;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CtfTmfTraceValidateTest {
    private static final Path BASE_PATH = Paths.get("../org.eclipse.tracecompass.ctf.core.tests", "traces");
    private static final Path CTF_SUITE_BASE_PATH = Paths.get("../org.eclipse.tracecompass.ctf.core.tests", "traces", "ctf-testsuite", "tests", "1.8");
    private String fTrace;
    private int fServerity;
    private int fConfidence;
    private boolean fHasException;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getTracePaths() throws Exception {
        LinkedList<Object[]> dirs = new LinkedList<Object[]>();
        CtfTmfTraceValidateTest.addDirsFrom(dirs, CTF_SUITE_BASE_PATH.resolve(Paths.get("regression", "metadata", "pass", "literal-integers")), 0, 10, false);
        URI tracePath = FileLocator.toFileURL((URL)CtfTestTrace.KERNEL.getTraceURL()).toURI();
        CtfTmfTraceValidateTest.addDirsFrom(dirs, Paths.get(tracePath), 0, 10, false);
        CtfTmfTraceValidateTest.addDirsFrom(dirs, CTF_SUITE_BASE_PATH.resolve(Paths.get("regression", "metadata", "fail", "enum-empty")), 2, 1, true);
        CtfTmfTraceValidateTest.addDirsFrom(dirs, CTF_SUITE_BASE_PATH.resolve(Paths.get("regression", "metadata", "fail", "lttng-modules-2.0-pre1")), 2, 1, true);
        CtfTmfTraceValidateTest.addDirsFrom(dirs, BASE_PATH.resolve(Paths.get("synctraces.tar.gz", new String[0])), 4, 1, false);
        return dirs;
    }

    private static void addDirsFrom(List<Object[]> dirs, Path path, int severity, int confidence, boolean hasException) {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        Object[] array = new Object[]{path.toString(), severity, confidence, hasException};
        dirs.add(array);
    }

    public CtfTmfTraceValidateTest(String trace, int severity, int confidence, boolean hasException) {
        this.fTrace = trace;
        this.fServerity = severity;
        this.fConfidence = confidence;
        this.fHasException = hasException;
    }

    @Test
    public void testValidate() {
        CtfTmfTrace trace = new CtfTmfTrace();
        IStatus status = trace.validate(null, this.fTrace);
        Assert.assertEquals((String)this.toString(), (long)this.fServerity, (long)status.getSeverity());
        if (this.fHasException) {
            Assert.assertNotNull((String)this.toString(), (Object)status.getException());
        }
        switch (status.getSeverity()) {
            case 0: {
                Assert.assertTrue((boolean)(status instanceof CtfTraceValidationStatus));
                CtfTraceValidationStatus ctfStatus = (CtfTraceValidationStatus)status;
                Assert.assertEquals((String)this.toString(), (long)this.fConfidence, (long)ctfStatus.getConfidence());
                Assert.assertNotNull((Object)ctfStatus.getEnvironment());
                break;
            }
            case 2: {
                Assert.assertTrue((boolean)(status instanceof TraceValidationStatus));
                TraceValidationStatus ctfStatus = (TraceValidationStatus)status;
                Assert.assertEquals((long)this.fConfidence, (long)ctfStatus.getConfidence());
                break;
            }
            case 4: {
                break;
            }
            default: {
                Assert.fail();
            }
        }
        Assert.assertEquals((long)this.fServerity, (long)status.getSeverity());
        trace.dispose();
    }
}

