/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.utils.TableCollection;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.editors.TmfEventsEditor;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotTimeGraph;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.ui.IEditorReference;
import org.hamcrest.Matcher;
import org.swtchart.Chart;

public final class ConditionHelpers {
    private ConditionHelpers() {
    }

    public static ICondition IsTreeNodeAvailable(final String name, final SWTBotTree tree) {
        return new SWTBotTestCondition(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean test() throws Exception {
                try {
                    SWTBotTreeItem[] treeItems;
                    SWTBotTreeItem[] sWTBotTreeItemArray = treeItems = tree.getAllItems();
                    int n = treeItems.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            return false;
                        }
                        SWTBotTreeItem ti = sWTBotTreeItemArray[n2];
                        String text = ti.getText();
                        if (text.equals(name)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }

            @Override
            public String getFailureMessage() {
                return NLS.bind((String)"No child of tree {0} found with text {1}. Child items: {2}", (Object[])new String[]{tree.toString(), name, Arrays.toString(tree.getAllItems())});
            }
        };
    }

    public static ICondition isTableItemAvailable(final String name, final SWTBotTable table) {
        return new SWTBotTestCondition(){

            @Override
            public boolean test() throws Exception {
                try {
                    return table.containsItem(name);
                }
                catch (Exception exception) {
                    return false;
                }
            }

            @Override
            public String getFailureMessage() {
                return NLS.bind((String)"No child of table {0} found with text ''{1}''.", (Object)table, (Object)name);
            }
        };
    }

    public static ICondition IsTreeChildNodeAvailable(final String name, final SWTBotTreeItem treeItem) {
        return new SWTBotTestCondition(){

            @Override
            public boolean test() throws Exception {
                try {
                    return treeItem.getNode(name) != null;
                }
                catch (Exception exception) {
                    return false;
                }
            }

            @Override
            public String getFailureMessage() {
                return NLS.bind((String)"No child of tree item {0} found with text ''{1}''. Child items: {2}", (Object[])new String[]{treeItem.toString(), name, Arrays.toString(treeItem.getItems())});
            }
        };
    }

    public static ICondition isTreeChildNodeRemoved(final int length, final SWTBotTreeItem treeItem) {
        return new SWTBotTestCondition(){

            @Override
            public boolean test() throws Exception {
                try {
                    return treeItem.getNodes().size() == length;
                }
                catch (Exception exception) {
                    return false;
                }
            }

            @Override
            public String getFailureMessage() {
                return NLS.bind((String)"Child of tree item {0} found with text ''{1}'' not removed. Child items: {2}", (Object[])new String[]{treeItem.toString(), String.valueOf(length), Arrays.toString(treeItem.getItems())});
            }
        };
    }

    public static ICondition treeItemCount(final SWTBotTreeItem treeItem, final int count) {
        return new SWTBotTestCondition(){

            @Override
            public boolean test() throws Exception {
                return treeItem.rowCount() == count;
            }

            @Override
            public String getFailureMessage() {
                return NLS.bind((String)"Tree item count: {0} expected: {1}", (Object)treeItem.rowCount(), (Object)count);
            }
        };
    }

    public static ICondition isWizardReady(final Wizard wizard) {
        return new SWTBotTestCondition(){

            @Override
            public boolean test() throws Exception {
                return wizard.getShell() != null;
            }
        };
    }

    public static ICondition isWizardOnPage(final Wizard wizard, final IWizardPage page) {
        return new SWTBotTestCondition(){

            @Override
            public boolean test() throws Exception {
                if (wizard == null || page == null) {
                    return false;
                }
                IWizardContainer container = wizard.getContainer();
                if (container == null) {
                    return false;
                }
                IWizardPage currentPage = container.getCurrentPage();
                return page.equals(currentPage);
            }
        };
    }

    public static ICondition ViewIsClosed(final SWTBotView view) {
        return new SWTBotTestCondition(){

            @Override
            public boolean test() throws Exception {
                return view != null && !view.isActive();
            }
        };
    }

    public static ICondition isTableCellFilled(final SWTBotTable table, final String content, final int row, final int column) {
        return new SWTBotTestCondition(){

            @Override
            public boolean test() throws Exception {
                String cell;
                block3: {
                    try {
                        cell = table.cell(row, column);
                        if (cell != null) break block3;
                        return false;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                return cell.contains(content);
            }

            @Override
            public String getFailureMessage() {
                String cell = table.cell(row, column);
                if (cell == null) {
                    return NLS.bind((String)"Cell absent, expected: {0}", (Object)content);
                }
                return NLS.bind((String)"Cell content: {0} expected: {1}", (Object)cell, (Object)content);
            }
        };
    }

    public static ICondition isEditorOpened(final SWTWorkbenchBot bot, final String title) {
        return new SWTBotTestCondition(){

            @Override
            public boolean test() throws Exception {
                Matcher withPartName = WidgetMatcherFactory.withPartName((String)title);
                return !bot.editors(withPartName).isEmpty();
            }
        };
    }

    public static ICondition selectionRange(final TmfTimeRange range) {
        return new SWTBotTestCondition(){

            @Override
            public boolean test() throws Exception {
                return TmfTraceManager.getInstance().getCurrentTraceContext().getSelectionRange().equals((Object)range);
            }

            @Override
            public String getFailureMessage() {
                return NLS.bind((String)"Selection range: {0} expected: {1}", (Object)TmfTraceManager.getInstance().getCurrentTraceContext().getSelectionRange(), (Object)range);
            }
        };
    }

    public static ICondition windowRange(final TmfTimeRange range) {
        return new SWTBotTestCondition(){

            @Override
            public boolean test() throws Exception {
                return TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().equals((Object)range);
            }

            @Override
            public String getFailureMessage() {
                return NLS.bind((String)"Window range: {0} expected: {1}", (Object)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange(), (Object)range);
            }
        };
    }

    public static ICondition treeSelectionContains(final SWTBotTree tree, final int column, final String text) {
        return new SWTBotTestCondition(){

            @Override
            public boolean test() throws Exception {
                TableCollection selection = tree.selection();
                int row = 0;
                while (row < selection.rowCount()) {
                    if (selection.get(row, column).equals(text)) {
                        return true;
                    }
                    ++row;
                }
                return false;
            }

            @Override
            public String getFailureMessage() {
                return NLS.bind((String)"Tree selection [0,{0}]: {1} expected: {2}", (Object[])new Object[]{column, tree.selection().get(0, column), text});
            }
        };
    }

    public static ICondition timeGraphSelectionContains(final SWTBotTimeGraph timeGraph, final int column, final String text) {
        return new SWTBotTestCondition(){

            @Override
            public boolean test() throws Exception {
                TableCollection selection = timeGraph.selection();
                int row = 0;
                while (row < selection.rowCount()) {
                    if (selection.get(row, column).equals(text)) {
                        return true;
                    }
                    ++row;
                }
                return false;
            }

            @Override
            public String getFailureMessage() {
                return NLS.bind((String)"Time graph selection [0,{0}]: {1} expected: {2}", (Object[])new Object[]{column, timeGraph.selection().get(0, column), text});
            }
        };
    }

    public static ICondition selectionInEventsTable(SWTWorkbenchBot bot, long selectionTime) {
        return new EventsTableSelectionCondition(bot, selectionTime);
    }

    public static ICondition timeGraphIsReadyCondition(AbstractTimeGraphView view, @NonNull TmfTimeRange selectionRange, @NonNull ITmfTimestamp visibleTime) {
        return new TimeGraphIsReadyCondition(view, selectionRange, visibleTime);
    }

    public static ICondition xyViewerIsReadyCondition(TmfXYChartViewer viewer) {
        return new XYViewerIsReadyCondition(viewer);
    }

    public static ICondition numberOfEventsInTrace(ITmfTrace trace, long nbEvents) {
        return new NumberOfEventsCondition(trace, nbEvents);
    }

    public static ICondition numberOfSeries(Chart chart, int numberOfSeries) {
        return new NumberOfSeries(chart, numberOfSeries);
    }

    public static ICondition treeItemHasChildren(SWTBotTreeItem treeItem) {
        return new TreeItemHasChildren(treeItem);
    }

    public static final class ActiveEventsEditor
    extends DefaultCondition {
        private final SWTWorkbenchBot fWorkbenchBot;
        private SWTBotEditor fEditor;
        private String fEditorTitle;

        public ActiveEventsEditor(SWTWorkbenchBot workbenchBot, String editorTitle) {
            this.fWorkbenchBot = workbenchBot;
            this.fEditorTitle = editorTitle;
        }

        public boolean test() throws Exception {
            List editors = this.fWorkbenchBot.editors(WidgetMatcherFactory.withPartId((String)"org.eclipse.linuxtools.tmf.ui.editors.events"));
            for (SWTBotEditor e : editors) {
                if (!e.isActive()) continue;
                if (this.fEditorTitle != null && !this.fEditorTitle.equals(e.getTitle())) {
                    return false;
                }
                this.fEditor = e;
                return true;
            }
            return false;
        }

        public String getFailureMessage() {
            String editorMessage = this.fEditorTitle != null ? " " + this.fEditorTitle : "";
            return "Active events editor" + editorMessage + " not found";
        }

        public SWTBotEditor getActiveEditor() {
            return this.fEditor;
        }
    }

    private static class EventsTableSelectionCondition
    extends DefaultCondition {
        private long fSelectionTime;
        private SWTWorkbenchBot fBot;
        private long fCurValue;

        private EventsTableSelectionCondition(SWTWorkbenchBot bot, long selectionTime) {
            this.fBot = bot;
            this.fSelectionTime = selectionTime;
        }

        public boolean test() throws Exception {
            StructuredSelection eventsTableSelection = this.getEventsTableSelection();
            if (eventsTableSelection.isEmpty()) {
                return false;
            }
            this.fCurValue = ((ITmfEvent)eventsTableSelection.getFirstElement()).getTimestamp().getValue();
            return this.fCurValue == this.fSelectionTime;
        }

        public String getFailureMessage() {
            return "The selection in the table was not an event with timestamp " + this.fSelectionTime + ". Actual is " + this.fCurValue;
        }

        private StructuredSelection getEventsTableSelection() {
            return (StructuredSelection)UIThreadRunnable.syncExec((Result)new Result<StructuredSelection>(){

                public StructuredSelection run() {
                    SWTBotEditor eventsEditor = SWTBotUtils.activeEventsEditor(fBot);
                    TmfEventsEditor part = (TmfEventsEditor)((IEditorReference)eventsEditor.getReference()).getPart(false);
                    StructuredSelection selection = (StructuredSelection)part.getSelection();
                    return selection;
                }
            });
        }
    }

    private static class NumberOfEventsCondition
    extends DefaultCondition {
        private ITmfTrace fTrace;
        private long fNbEvents;

        private NumberOfEventsCondition(ITmfTrace trace, long nbEvents) {
            this.fTrace = trace;
            this.fNbEvents = nbEvents;
        }

        public boolean test() throws Exception {
            return this.fTrace.getNbEvents() == this.fNbEvents;
        }

        public String getFailureMessage() {
            return String.valueOf(this.fTrace.getName()) + " did not contain the expected number of " + this.fNbEvents + " events. Current: " + this.fTrace.getNbEvents();
        }
    }

    private static class NumberOfSeries
    extends DefaultCondition {
        private String fFailureMessage;
        private Chart fChart;
        private final int fNumberOfSeries;

        public NumberOfSeries(Chart chart, int numberOfSeries) {
            this.fChart = chart;
            this.fNumberOfSeries = numberOfSeries;
        }

        public boolean test() throws Exception {
            int length = this.fChart.getSeriesSet().getSeries().length;
            if (length != this.fNumberOfSeries) {
                this.fFailureMessage = "Chart did not contain the expected number series. Actual " + length + ", expected " + this.fNumberOfSeries;
                return false;
            }
            return true;
        }

        public String getFailureMessage() {
            return this.fFailureMessage;
        }
    }

    public static class ProjectElementHasChild
    extends DefaultCondition {
        private final SWTBotTreeItem fParentItem;
        private final String fName;
        private final String fRegex;
        private SWTBotTreeItem fItem = null;

        public ProjectElementHasChild(SWTBotTreeItem parentItem, String name) {
            this.fParentItem = parentItem;
            this.fName = name;
            this.fRegex = String.valueOf(Pattern.quote(name)) + "(\\s\\[(.*)+?\\])?";
        }

        public boolean test() throws Exception {
            this.fParentItem.expand();
            SWTBotTreeItem[] sWTBotTreeItemArray = this.fParentItem.getItems();
            int n = sWTBotTreeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                SWTBotTreeItem item = sWTBotTreeItemArray[n2];
                if (item.getText().matches(this.fRegex)) {
                    this.fItem = item;
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public String getFailureMessage() {
            return NLS.bind((String)"No child of {0} found with name {1}", (Object)this.fParentItem.getText(), (Object)this.fName);
        }

        public SWTBotTreeItem getItem() {
            return this.fItem;
        }
    }

    public static abstract class SWTBotTestCondition
    implements ICondition {
        public abstract boolean test() throws Exception;

        public final void init(SWTBot bot) {
        }

        public String getFailureMessage() {
            return null;
        }
    }

    private static class TimeGraphIsReadyCondition
    extends DefaultCondition {
        private @NonNull TmfTimeRange fSelectionRange;
        private @NonNull ITmfTimestamp fVisibleTime;
        private AbstractTimeGraphView fView;
        private String fFailureMessage;

        private TimeGraphIsReadyCondition(AbstractTimeGraphView view, @NonNull TmfTimeRange selectionRange, @NonNull ITmfTimestamp visibleTime) {
            this.fView = view;
            this.fSelectionRange = selectionRange;
            this.fVisibleTime = visibleTime;
        }

        public boolean test() throws Exception {
            ICondition selectionRangeCondition = ConditionHelpers.selectionRange(this.fSelectionRange);
            if (!selectionRangeCondition.test()) {
                this.fFailureMessage = selectionRangeCondition.getFailureMessage();
                return false;
            }
            @NonNull TmfTimeRange curWindowRange = TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange();
            if (!curWindowRange.contains(this.fVisibleTime)) {
                this.fFailureMessage = "Current window range " + curWindowRange + " does not contain " + this.fVisibleTime;
                return false;
            }
            if (this.fView.isDirty()) {
                this.fFailureMessage = "Time graph is dirty";
                return false;
            }
            return true;
        }

        public String getFailureMessage() {
            return this.fFailureMessage;
        }
    }

    private static final class TreeItemHasChildren
    extends DefaultCondition {
        private SWTBotTreeItem fTreeItem;

        public TreeItemHasChildren(SWTBotTreeItem treeItem) {
            this.fTreeItem = treeItem;
        }

        public boolean test() throws Exception {
            return this.fTreeItem.getItems().length > 0;
        }

        public String getFailureMessage() {
            return NLS.bind((String)"No child of tree item {0} found.", (Object[])new String[]{this.fTreeItem.toString()});
        }
    }

    private static class XYViewerIsReadyCondition
    extends DefaultCondition {
        private TmfXYChartViewer fViewer;
        private String fFailureMessage;

        private XYViewerIsReadyCondition(TmfXYChartViewer view) {
            this.fViewer = view;
        }

        public boolean test() throws Exception {
            if (this.fViewer.isDirty()) {
                this.fFailureMessage = "Time graph is dirty";
                return false;
            }
            return true;
        }

        public String getFailureMessage() {
            return this.fFailureMessage;
        }
    }
}

