/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.ArrayResult;
import org.eclipse.swtbot.swt.finder.results.ListResult;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.waits.WaitForObjectCondition;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBotControl;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotRootMenu;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.ITimeDataProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;

public class SWTBotTimeGraphEntry
extends AbstractSWTBotControl<TimeGraphControl> {
    private final ITimeGraphEntry fEntry;

    public SWTBotTimeGraphEntry(TimeGraphControl w, ITimeGraphEntry entry) throws WidgetNotFoundException {
        super((Control)w);
        this.fEntry = entry;
    }

    protected SWTBotRootMenu contextMenu(final Control control) throws WidgetNotFoundException {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                Rectangle bounds = ((TimeGraphControl)SWTBotTimeGraphEntry.this.widget).getItemBounds(SWTBotTimeGraphEntry.this.fEntry);
                if (bounds == null) {
                    return;
                }
                Point location = ((TimeGraphControl)SWTBotTimeGraphEntry.this.widget).toDisplay(bounds.x, bounds.y);
                Event event = new Event();
                event.time = (int)System.currentTimeMillis();
                event.display = control.getDisplay();
                event.widget = control;
                event.x = location.x + ((TimeGraphControl)SWTBotTimeGraphEntry.this.widget).getTimeDataProvider().getNameSpace() / 2;
                event.y = location.y + bounds.height / 2;
                control.notifyListeners(35, event);
            }
        });
        this.select();
        WaitForObjectCondition waitForMenu = Conditions.waitForPopupMenu((Control)control);
        new SWTBot().waitUntilWidgetAppears((ICondition)waitForMenu);
        return new SWTBotRootMenu((Menu)waitForMenu.get(0));
    }

    public SWTBotTimeGraphEntry[] getEntries() {
        return (SWTBotTimeGraphEntry[])this.syncExec((ArrayResult)new ArrayResult<SWTBotTimeGraphEntry>(){

            public SWTBotTimeGraphEntry[] run() {
                ArrayList<SWTBotTimeGraphEntry> entries = new ArrayList<SWTBotTimeGraphEntry>();
                ITimeGraphEntry[] iTimeGraphEntryArray = ((TimeGraphControl)SWTBotTimeGraphEntry.this.widget).getExpandedElements();
                int n = iTimeGraphEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITimeGraphEntry entry = iTimeGraphEntryArray[n2];
                    if (SWTBotTimeGraphEntry.this.fEntry.equals(entry.getParent())) {
                        entries.add(new SWTBotTimeGraphEntry((TimeGraphControl)SWTBotTimeGraphEntry.this.widget, entry));
                    }
                    ++n2;
                }
                return entries.toArray(new SWTBotTimeGraphEntry[0]);
            }
        });
    }

    public void click(long time) {
        Point p = this.getPointForTime(time);
        if (p == null) {
            return;
        }
        this.clickXY(p.x, p.y);
    }

    public void doubleClick(long time) {
        Point p = this.getPointForTime(time);
        if (p == null) {
            return;
        }
        this.doubleClickXY(p.x, p.y);
    }

    private Point getPointForTime(long time) {
        return (Point)UIThreadRunnable.syncExec(() -> {
            ITimeDataProvider timeDataProvider = ((TimeGraphControl)this.widget).getTimeDataProvider();
            if (timeDataProvider.getTime0() > time || timeDataProvider.getTime1() < time) {
                return null;
            }
            int x = ((TimeGraphControl)this.widget).getXForTime(time);
            Rectangle bounds = ((TimeGraphControl)this.widget).getItemBounds(this.fEntry);
            int y = bounds.y + bounds.height / 2;
            return new Point(x, y);
        });
    }

    public SWTBotTimeGraphEntry getEntry(String name) {
        AtomicReference found = new AtomicReference();
        WaitUtils.waitUntil(timegraph -> {
            List entries = this.syncExec((ListResult)new ListResult<ITimeGraphEntry>(){

                public List<ITimeGraphEntry> run() {
                    return Arrays.asList(timegraph.getExpandedElements());
                }
            });
            ITableLabelProvider labelProvider = timegraph.getLabelProvider();
            for (ITimeGraphEntry entry : entries) {
                String label;
                if (!this.fEntry.equals(entry.getParent())) continue;
                String string2 = label = labelProvider == null ? entry.getName() : labelProvider.getColumnText((Object)entry, 0);
                if (!name.equals(label)) continue;
                found.set(entry);
                return true;
            }
            return false;
        }, (Object)((TimeGraphControl)this.widget), (String)("Timed out waiting for time graph entry " + name));
        return new SWTBotTimeGraphEntry((TimeGraphControl)this.widget, (ITimeGraphEntry)found.get());
    }

    public String getText() {
        return this.getText(0);
    }

    public String getText(int column) {
        ITableLabelProvider labelProvider = ((TimeGraphControl)this.widget).getLabelProvider();
        return labelProvider != null ? labelProvider.getColumnText((Object)this.fEntry, column) : (column == 0 ? this.fEntry.getName() : "");
    }

    public SWTBotTimeGraphEntry select() {
        this.syncExec(new VoidResult(){

            public void run() {
                ((TimeGraphControl)SWTBotTimeGraphEntry.this.widget).setFocus();
                ((TimeGraphControl)SWTBotTimeGraphEntry.this.widget).selectItem(SWTBotTimeGraphEntry.this.fEntry, false);
                ((TimeGraphControl)SWTBotTimeGraphEntry.this.widget).fireSelectionChanged();
            }
        });
        return this;
    }
}

