/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.viewers.events;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.tracecompass.tmf.core.io.BufferedRandomAccessFile;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotSash;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotTimeGraph;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class TmfAlignTimeAxisTest {
    private static final int SYNC_DELAY = 1000;
    private static final String TRACE_START = "<trace>";
    private static final String EVENT_BEGIN = "<event timestamp=\"";
    private static final String EVENT_MIDDLE = " \" name=\"event\"><field name=\"field\" value=\"";
    private static final String EVENT_END = "\" type=\"int\" /></event>";
    private static final String TRACE_END = "</trace>";
    private static final String PROJET_NAME = "TestAxisAlignment";
    private static final int NUM_EVENTS = 100;
    private static final float EDITOR_AREA_RATIO = 0.1f;
    private static final Logger fLogger = Logger.getRootLogger();
    private static SWTWorkbenchBot fBot;
    private static File fLocation;

    private static String makeEvent(int ts, int val) {
        return EVENT_BEGIN + Integer.toString(ts) + EVENT_MIDDLE + Integer.toString(val) + EVENT_END + "\n";
    }

    @BeforeClass
    public static void init() throws IOException {
        SWTBotUtils.initialize();
        Thread.currentThread().setName("SWTBot Thread");
        SWTBotPreferences.TIMEOUT = 20000L;
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout()));
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        SWTBotUtils.closeView("welcome", bot);
        SWTBotUtils.switchToTracingPerspective();
        WaitUtils.waitForJobs();
        fLocation = File.createTempFile("sample", ".xml");
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedRandomAccessFile braf = new BufferedRandomAccessFile(fLocation, "rw");){
            braf.writeBytes(TRACE_START);
            int i = 0;
            while (i < 100) {
                braf.writeBytes(TmfAlignTimeAxisTest.makeEvent(i * 100, i % 4));
                ++i;
            }
            braf.writeBytes(TRACE_END);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        SWTBotUtils.createProject(PROJET_NAME);
        SWTBotUtils.selectTracesFolder(bot, PROJET_NAME);
    }

    @AfterClass
    public static void cleanup() {
        SWTBotUtils.deleteProject(PROJET_NAME, new SWTWorkbenchBot());
        fLocation.delete();
        fLogger.removeAllAppenders();
    }

    @Before
    public void before() {
        SWTBotUtils.openTrace(PROJET_NAME, fLocation.getAbsolutePath(), "org.eclipse.linuxtools.tmf.core.tests.xmlstub");
    }

    @After
    public void after() {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        SWTBotUtils.activeEventsEditor(bot).close();
        SWTBotUtils.switchToTracingPerspective();
        SWTBotUtils.closeSecondaryShells(fBot);
    }

    @Test
    public void testMoveHistogramOthersFollow() {
        fBot = new SWTWorkbenchBot();
        TmfAlignTimeAxisTest.switchToPerspective("org.eclipse.linuxtools.tmf.test.align.1");
        TmfAlignTimeAxisTest.testAligned("org.eclipse.linuxtools.tmf.ui.views.histogram", "org.eclipse.linuxtools.tmf.ui.views.callstack", "org.eclipse.linuxtools.tmf.ui.views.timechart");
    }

    @Test
    public void testMoveCallstackOthersFollow() {
        fBot = new SWTWorkbenchBot();
        TmfAlignTimeAxisTest.switchToPerspective("org.eclipse.linuxtools.tmf.test.align.1");
        TmfAlignTimeAxisTest.testAligned("org.eclipse.linuxtools.tmf.ui.views.callstack", "org.eclipse.linuxtools.tmf.ui.views.histogram", "org.eclipse.linuxtools.tmf.ui.views.timechart");
    }

    @Test
    public void testOverlappingHistogramMove() {
        fBot = new SWTWorkbenchBot();
        TmfAlignTimeAxisTest.switchToPerspective("org.eclipse.linuxtools.tmf.test.align.2");
        TmfAlignTimeAxisTest.testAligned("org.eclipse.linuxtools.tmf.ui.views.histogram", "org.eclipse.linuxtools.tmf.ui.views.callstack");
    }

    @Test
    public void testOverlappingCallstackMove() {
        fBot = new SWTWorkbenchBot();
        TmfAlignTimeAxisTest.switchToPerspective("org.eclipse.linuxtools.tmf.test.align.2");
        TmfAlignTimeAxisTest.testAligned("org.eclipse.linuxtools.tmf.ui.views.callstack", "org.eclipse.linuxtools.tmf.ui.views.histogram");
    }

    @Test
    public void testNotOverlappingHistogramMove() {
        fBot = new SWTWorkbenchBot();
        TmfAlignTimeAxisTest.switchToPerspective("org.eclipse.linuxtools.tmf.test.align.3");
        TmfAlignTimeAxisTest.testAligned("org.eclipse.linuxtools.tmf.ui.views.histogram", "org.eclipse.linuxtools.tmf.ui.views.timechart");
        TmfAlignTimeAxisTest.testNotAligned("org.eclipse.linuxtools.tmf.ui.views.histogram", "org.eclipse.linuxtools.tmf.ui.views.callstack");
    }

    @Test
    public void testNotOverlappingCallstackMove() {
        fBot = new SWTWorkbenchBot();
        TmfAlignTimeAxisTest.switchToPerspective("org.eclipse.linuxtools.tmf.test.align.3");
        TmfAlignTimeAxisTest.testNotAligned("org.eclipse.linuxtools.tmf.ui.views.callstack", "org.eclipse.linuxtools.tmf.ui.views.histogram", "org.eclipse.linuxtools.tmf.ui.views.timechart");
    }

    private static void switchToPerspective(String id) {
        SWTBotUtils.switchToPerspective(id);
        WaitUtils.waitForJobs();
        SWTBotUtils.delay(1000L);
    }

    private static AbstractSWTBot<?> getAlignmentControl(String viewId) {
        SWTBotView viewBot = fBot.viewById(viewId);
        switch (viewId) {
            case "org.eclipse.linuxtools.tmf.ui.views.histogram": {
                return new SWTBotSash((Sash)viewBot.bot().widget(WidgetOfType.widgetOfType(Sash.class)));
            }
            case "org.eclipse.linuxtools.tmf.ui.views.callstack": 
            case "org.eclipse.linuxtools.tmf.ui.views.timechart": {
                return new SWTBotTimeGraph((TimeGraphControl)viewBot.bot().widget(WidgetOfType.widgetOfType(TimeGraphControl.class)));
            }
        }
        return null;
    }

    private static void testAligned(String masterView, String ... slaveViews) {
        int offset = 50;
        AbstractSWTBot<?> master = TmfAlignTimeAxisTest.getAlignmentControl(masterView);
        int masterOrigin = TmfAlignTimeAxisTest.getAlignmentPosition(master);
        HashMap slaveMap = new HashMap();
        String[] stringArray = slaveViews;
        int n = slaveViews.length;
        int n2 = 0;
        while (n2 < n) {
            String slaveView = stringArray[n2];
            AbstractSWTBot<?> slave = TmfAlignTimeAxisTest.getAlignmentControl(slaveView);
            int slaveOrigin = TmfAlignTimeAxisTest.getAlignmentPosition(slave);
            slaveMap.put(slave, slaveOrigin);
            ++n2;
        }
        TmfAlignTimeAxisTest.setAlignmentPosition(master, masterOrigin + 50);
        Assert.assertEquals((float)(masterOrigin + 50), (float)TmfAlignTimeAxisTest.getAlignmentPosition(master), (float)2.0f);
        for (Map.Entry slave : slaveMap.entrySet()) {
            Assert.assertEquals((float)((Integer)slave.getValue() + 50), (float)TmfAlignTimeAxisTest.getAlignmentPosition((AbstractSWTBot)slave.getKey()), (float)2.0f);
        }
        TmfAlignTimeAxisTest.setAlignmentPosition(master, masterOrigin);
    }

    private static void testNotAligned(String masterView, String ... nonSlaveViews) {
        int offset = 50;
        AbstractSWTBot<?> master = TmfAlignTimeAxisTest.getAlignmentControl(masterView);
        int masterOrigin = TmfAlignTimeAxisTest.getAlignmentPosition(master);
        HashMap nonSlaveMap = new HashMap();
        String[] stringArray = nonSlaveViews;
        int n = nonSlaveViews.length;
        int n2 = 0;
        while (n2 < n) {
            String nonSlaveView = stringArray[n2];
            AbstractSWTBot<?> nonSlave = TmfAlignTimeAxisTest.getAlignmentControl(nonSlaveView);
            int nonSlaveOrigin = TmfAlignTimeAxisTest.getAlignmentPosition(nonSlave);
            nonSlaveMap.put(nonSlave, nonSlaveOrigin);
            ++n2;
        }
        TmfAlignTimeAxisTest.setAlignmentPosition(master, masterOrigin + 50);
        Assert.assertEquals((float)(masterOrigin + 50), (float)TmfAlignTimeAxisTest.getAlignmentPosition(master), (float)2.0f);
        for (Map.Entry nonSlave : nonSlaveMap.entrySet()) {
            Assert.assertEquals((long)((Integer)nonSlave.getValue()).intValue(), (long)TmfAlignTimeAxisTest.getAlignmentPosition((AbstractSWTBot)nonSlave.getKey()));
        }
        TmfAlignTimeAxisTest.setAlignmentPosition(master, masterOrigin);
    }

    private static int getAlignmentPosition(AbstractSWTBot<?> control) {
        if (control instanceof SWTBotSash) {
            Rectangle bounds = ((SWTBotSash)control).getBounds();
            return bounds.x + bounds.width / 2;
        }
        if (control instanceof SWTBotTimeGraph) {
            return ((SWTBotTimeGraph)control).getNameSpace();
        }
        return 0;
    }

    private static void setAlignmentPosition(AbstractSWTBot<?> control, int position) {
        if (control instanceof SWTBotSash) {
            SWTBotSash sash = (SWTBotSash)control;
            Rectangle bounds = sash.getBounds();
            Point dst = new Point(position, bounds.y + bounds.height / 2);
            sash.drag(dst);
        } else if (control instanceof SWTBotTimeGraph) {
            ((SWTBotTimeGraph)control).setNameSpace(position);
        }
        WaitUtils.waitForJobs();
        SWTBotUtils.delay(1000L);
    }

    public static class AlignPerspectiveFactory1
    implements IPerspectiveFactory {
        public static final String ID = "org.eclipse.linuxtools.tmf.test.align.1";

        public void createInitialLayout(IPageLayout layout) {
            if (layout == null) {
                return;
            }
            layout.setEditorAreaVisible(true);
            layout.setEditorAreaVisible(true);
            IFolderLayout topLeftFolder = layout.createFolder("topLeftFolder", 1, 0.4f, "org.eclipse.ui.editorss");
            topLeftFolder.addView("org.eclipse.ui.navigator.ProjectExplorer");
            IFolderLayout topRightFolder = layout.createFolder("topRightFolder", 4, 0.1f, "org.eclipse.ui.editorss");
            topRightFolder.addView("org.eclipse.linuxtools.tmf.ui.views.histogram");
            IFolderLayout middleRightFolder = layout.createFolder("middleRightFolder", 4, 0.5f, "topRightFolder");
            middleRightFolder.addView("org.eclipse.linuxtools.tmf.ui.views.callstack");
            IFolderLayout bottomRightFolder = layout.createFolder("bottomRightFolder", 4, 0.65f, "middleRightFolder");
            bottomRightFolder.addView("org.eclipse.linuxtools.tmf.ui.views.timechart");
            layout.addPerspectiveShortcut(ID);
            layout.addNewWizardShortcut("org.eclipse.linuxtools.tmf.ui.views.ui.wizards.newProject");
        }
    }

    public static class AlignPerspectiveFactory2
    implements IPerspectiveFactory {
        public static final String ID = "org.eclipse.linuxtools.tmf.test.align.2";

        public void createInitialLayout(IPageLayout layout) {
            if (layout == null) {
                return;
            }
            layout.setEditorAreaVisible(true);
            layout.setEditorAreaVisible(true);
            IFolderLayout topLeftFolder = layout.createFolder("topLeftFolder", 1, 0.4f, "org.eclipse.ui.editorss");
            topLeftFolder.addView("org.eclipse.ui.navigator.ProjectExplorer");
            IFolderLayout middleRightFolder = layout.createFolder("middleRightFolder", 4, 0.1f, "org.eclipse.ui.editorss");
            middleRightFolder.addView("org.eclipse.linuxtools.tmf.ui.views.histogram");
            middleRightFolder.addView("org.eclipse.linuxtools.tmf.ui.views.timechart");
            IFolderLayout bottomRightFolder = layout.createFolder("bottomRightFolder", 4, 0.65f, "middleRightFolder");
            bottomRightFolder.addView("org.eclipse.linuxtools.tmf.ui.views.callstack");
            layout.addPerspectiveShortcut(ID);
            layout.addNewWizardShortcut("org.eclipse.linuxtools.tmf.ui.views.ui.wizards.newProject");
        }
    }

    public static class AlignPerspectiveFactory3
    implements IPerspectiveFactory {
        public static final String ID = "org.eclipse.linuxtools.tmf.test.align.3";

        public void createInitialLayout(IPageLayout layout) {
            if (layout == null) {
                return;
            }
            layout.setEditorAreaVisible(true);
            layout.setEditorAreaVisible(true);
            IFolderLayout topLeftFolder = layout.createFolder("topLeftFolder", 1, 0.4f, "org.eclipse.ui.editorss");
            topLeftFolder.addView("org.eclipse.ui.navigator.ProjectExplorer");
            IFolderLayout bottomLeftFolder = layout.createFolder("bottomLeftFolder", 4, 0.5f, "topLeftFolder");
            bottomLeftFolder.addView("org.eclipse.linuxtools.tmf.ui.views.callstack");
            IFolderLayout middleRightFolder = layout.createFolder("middleRightFolder", 4, 0.1f, "org.eclipse.ui.editorss");
            middleRightFolder.addView("org.eclipse.linuxtools.tmf.ui.views.histogram");
            IFolderLayout bottomRightFolder = layout.createFolder("bottomRightFolder", 4, 0.65f, "middleRightFolder");
            bottomRightFolder.addView("org.eclipse.linuxtools.tmf.ui.views.timechart");
            layout.addPerspectiveShortcut(ID);
            layout.addNewWizardShortcut("org.eclipse.linuxtools.tmf.ui.views.ui.wizards.newProject");
        }
    }
}

