/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.actions;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.ui.actions.TraceImportOperation;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.ui.PlatformUI;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TraceImportOperationTest {
    private static String fSourcePath;
    private static TmfTraceFolder fDestFolder;

    @BeforeClass
    public static void beforeClass() throws Exception {
        URL resource = TmfCoreTestPlugin.getDefault().getBundle().getResource("testfiles");
        fSourcePath = FileLocator.toFileURL((URL)resource).toURI().getPath();
        IProject project = TmfProjectRegistry.createProject((String)"Test Project", null, null);
        TmfProjectElement projectElement = TmfProjectRegistry.getProject((IProject)project, (boolean)true);
        TmfTraceFolder tracesFolder = (TmfTraceFolder)NonNullUtils.checkNotNull((Object)projectElement.getTracesFolder());
        tracesFolder.getResource().getFolder("Folder").create(false, true, null);
        fDestFolder = (TmfTraceFolder)tracesFolder.getChildren().stream().filter(element -> element.getName().equals("Folder")).findFirst().get();
    }

    @AfterClass
    public static void afterClass() throws CoreException {
        if (fDestFolder != null) {
            fDestFolder.getProject().getResource().delete(true, null);
        }
    }

    @Test
    public void test() throws Exception {
        TraceImportOperation operation = new TraceImportOperation(fSourcePath, fDestFolder);
        PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)operation);
        TraceImportOperationTest.validateImport(fSourcePath, fDestFolder);
    }

    private static void validateImport(String sourcePath, TmfTraceFolder destFolder) {
        File[] files;
        HashMap map = new HashMap();
        destFolder.getChildren().forEach(element -> {
            ITmfProjectModelElement iTmfProjectModelElement = map.put(element.getName(), element);
        });
        File source = new File(sourcePath);
        File[] fileArray = files = source.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            ITmfProjectModelElement element2 = (ITmfProjectModelElement)map.get(file.getName());
            if (element2 != null) {
                if (file.isDirectory()) {
                    Assert.assertTrue((String)file.toString(), (boolean)(element2 instanceof TmfTraceFolder));
                    TraceImportOperationTest.validateImport(file.getAbsolutePath(), (TmfTraceFolder)element2);
                } else {
                    Assert.assertTrue((String)file.toString(), (boolean)(element2 instanceof TmfTraceElement));
                    TmfTraceElement traceElement = (TmfTraceElement)element2;
                    Assert.assertNotNull((String)file.toString(), (Object)traceElement.getTraceType());
                    Assert.assertTrue((String)file.toString(), (boolean)traceElement.getResource().isLinked());
                }
            }
            ++n2;
        }
    }
}

