/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.timegraph;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerConfigXmlParser;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerSet;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.markers.MarkerUtils;
import org.eclipse.tracecompass.tmf.core.signal.TmfMarkerEventSourceUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTimestampFormatUpdateSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceAdapterManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.TmfUiRefreshHandler;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentInfo;
import org.eclipse.tracecompass.tmf.ui.views.ITmfTimeAligned;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.ITimeGraphEntryComparator;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.Messages;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.ShowFindDialogAction;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphBookmarkListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphContentProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider2;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphRangeListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphTimeListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphBookmarkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphContentProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphRangeUpdateEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEventSource;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.MarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IDE;

public abstract class AbstractTimeGraphView
extends TmfView
implements ITmfTimeAligned,
IResourceChangeListener {
    protected static final int ALL_LEVELS = -1;
    private static final Pattern RGBA_PATTERN = Pattern.compile("RGBA \\{(\\d+), (\\d+), (\\d+), (\\d+)\\}");
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(AbstractTimeGraphView.class);
    private TimeGraphViewer fTimeGraphViewer;
    private AtomicInteger fDirty = new AtomicInteger();
    private final Object fZoomThreadResultLock = new Object();
    private ITmfTrace fTrace;
    private IFile fEditorFile;
    private List<TimeGraphEntry> fEntryList;
    private final Map<ITmfTrace, List<TimeGraphEntry>> fEntryListMap = new HashMap<ITmfTrace, List<TimeGraphEntry>>();
    private final Map<ITmfTrace, @NonNull ViewerFilter[]> fFiltersMap = new HashMap<ITmfTrace, ViewerFilter[]>();
    private final Map<ITmfTrace, ViewContext> fViewContext = new HashMap<ITmfTrace, ViewContext>();
    private final Map<ITmfTrace, List<IMarkerEventSource>> fMarkerEventSourcesMap = new HashMap<ITmfTrace, List<IMarkerEventSource>>();
    private final Map<ITmfTrace, Job> fBuildJobMap = new HashMap<ITmfTrace, Job>();
    private long fStartTime = -1L;
    private long fEndTime = -1L;
    private final int fDisplayWidth;
    private ZoomThread fZoomThread;
    private Action fNextResourceAction;
    private Action fPreviousResourceAction;
    private Comparator<ITimeGraphEntry> fEntryComparator = null;
    private State fRedrawState = State.IDLE;
    private final Object fSyncObj = new Object();
    private final TimeGraphPresentationProvider fPresentation;
    private String[] fColumns;
    private Comparator<ITimeGraphEntry>[] fColumnComparators;
    private ITableLabelProvider fLabelProvider = new TreeLabelProvider();
    private @NonNull ITimeGraphContentProvider fTimeGraphContentProvider = new TimeGraphContentProvider();
    private int[] fWeight = new int[]{1, 3};
    private String[] fFilterColumns;
    private ITreeContentProvider fFilterContentProvider;
    private TreeLabelProvider fFilterLabelProvider;
    private int fAutoExpandLevel = -1;
    private int fInitialSortColumn = 0;
    private int fCurrentSortColumn = 0;
    private int fSortDirection = 1024;
    private volatile boolean fIsRevealSelection = false;
    private final @NonNull MenuManager fEntryMenuManager = new MenuManager();
    private TimeGraphPartListener fPartListener;
    private static final ShowFindDialogAction FIND_ACTION = new ShowFindDialogAction();
    private ActionHandler fFindActionHandler;
    private IHandlerActivation fFindHandlerActivation;
    private final FindTarget fFindTarget;
    private MenuManager fMarkerSetMenu;

    public AbstractTimeGraphView(String id, TimeGraphPresentationProvider pres) {
        super(id);
        this.fPresentation = pres;
        this.fDisplayWidth = Display.getDefault().getBounds().width;
        this.fFindTarget = new FindTarget();
    }

    protected TimeGraphViewer getTimeGraphViewer() {
        return this.fTimeGraphViewer;
    }

    protected ITimeGraphPresentationProvider2 getPresentationProvider() {
        return this.fPresentation;
    }

    protected void setTreeColumns(String[] columns) {
        this.setTreeColumns(columns, null, 0);
    }

    protected void setTreeColumns(String[] columns, Comparator<ITimeGraphEntry>[] comparators, int initialSortColumn) {
        this.checkPartNotCreated();
        this.fColumns = columns;
        this.fColumnComparators = comparators;
        this.fInitialSortColumn = initialSortColumn;
    }

    protected void setTreeLabelProvider(TreeLabelProvider tlp) {
        this.checkPartNotCreated();
        this.fLabelProvider = tlp;
    }

    protected void setTimeGraphContentProvider(@NonNull ITimeGraphContentProvider tgcp) {
        this.checkPartNotCreated();
        this.fTimeGraphContentProvider = tgcp;
    }

    protected void setWeight(int[] weights) {
        this.fWeight = weights;
        if (this.fTimeGraphViewer != null) {
            this.fTimeGraphViewer.setWeights(weights);
        }
    }

    protected void setFilterColumns(String[] filterColumns) {
        this.checkPartNotCreated();
        this.fFilterColumns = filterColumns;
    }

    protected void setFilterContentProvider(ITreeContentProvider contentProvider) {
        this.checkPartNotCreated();
        this.fFilterContentProvider = contentProvider;
    }

    protected void setFilterLabelProvider(TreeLabelProvider labelProvider) {
        this.checkPartNotCreated();
        this.fFilterLabelProvider = labelProvider;
    }

    private void checkPartNotCreated() {
        if (this.getParentComposite() != null) {
            throw new IllegalStateException("This method must be called before createPartControl.");
        }
    }

    protected int getDisplayWidth() {
        return this.fDisplayWidth;
    }

    protected Comparator<ITimeGraphEntry> getEntryComparator() {
        return this.fEntryComparator;
    }

    protected void setEntryComparator(Comparator<ITimeGraphEntry> comparator) {
        this.fEntryComparator = comparator;
    }

    protected ITmfTrace getTrace() {
        return this.fTrace;
    }

    protected long getStartTime() {
        return this.fStartTime;
    }

    protected void setStartTime(long time) {
        this.fStartTime = time;
    }

    protected long getEndTime() {
        return this.fEndTime;
    }

    protected void setEndTime(long time) {
        this.fEndTime = time;
    }

    protected void setAutoExpandLevel(int level) {
        this.fAutoExpandLevel = level;
        if (this.fTimeGraphViewer != null) {
            this.fTimeGraphViewer.setAutoExpandLevel(level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected @Nullable List<TimeGraphEntry> getEntryList(ITmfTrace trace) {
        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
        synchronized (map) {
            return this.fEntryListMap.get(trace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putEntryList(ITmfTrace trace, List<TimeGraphEntry> list) {
        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
        synchronized (map) {
            this.fEntryListMap.put(trace, new CopyOnWriteArrayList<TimeGraphEntry>(list));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToEntryList(ITmfTrace trace, List<TimeGraphEntry> list) {
        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
        synchronized (map) {
            List<TimeGraphEntry> entryList = this.fEntryListMap.get(trace);
            if (entryList == null) {
                this.fEntryListMap.put(trace, new CopyOnWriteArrayList<TimeGraphEntry>(list));
            } else {
                for (TimeGraphEntry entry : list) {
                    if (entryList.contains(entry)) continue;
                    entryList.add(entry);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromEntryList(ITmfTrace trace, List<TimeGraphEntry> list) {
        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
        synchronized (map) {
            List<TimeGraphEntry> entryList = this.fEntryListMap.get(trace);
            if (entryList != null) {
                entryList.removeAll(list);
            }
        }
    }

    protected String getNextText() {
        return Messages.AbstractTimeGraphtView_NextText;
    }

    protected String getNextTooltip() {
        return Messages.AbstractTimeGraphView_NextTooltip;
    }

    protected String getPrevText() {
        return Messages.AbstractTimeGraphView_PreviousText;
    }

    protected String getPrevTooltip() {
        return Messages.AbstractTimeGraphView_PreviousTooltip;
    }

    FindTarget getFindTarget() {
        return this.fFindTarget;
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.fTimeGraphViewer = new TimeGraphViewer(parent, 0);
        if (this.fLabelProvider != null) {
            this.fTimeGraphViewer.setTimeGraphLabelProvider(this.fLabelProvider);
        }
        if (this.fColumns != null) {
            this.fTimeGraphViewer.setColumns(this.fColumns);
            if (this.fColumnComparators != null) {
                this.createColumnSelectionListener(this.fTimeGraphViewer.getTree());
            }
        }
        this.fTimeGraphViewer.setTimeGraphContentProvider(this.fTimeGraphContentProvider);
        this.fTimeGraphViewer.setFilterContentProvider((ITreeContentProvider)(this.fFilterContentProvider != null ? this.fFilterContentProvider : this.fTimeGraphContentProvider));
        this.fTimeGraphViewer.setFilterLabelProvider(this.fFilterLabelProvider);
        this.fTimeGraphViewer.setFilterColumns(this.fFilterColumns);
        this.fTimeGraphViewer.setTimeGraphProvider(this.fPresentation);
        this.fTimeGraphViewer.setAutoExpandLevel(this.fAutoExpandLevel);
        this.fTimeGraphViewer.setWeights(this.fWeight);
        this.fTimeGraphViewer.addRangeListener(new ITimeGraphRangeListener(){

            @Override
            public void timeRangeUpdated(TimeGraphRangeUpdateEvent event) {
                long startTime = event.getStartTime();
                long endTime = event.getEndTime();
                TmfTimeRange range = new TmfTimeRange(TmfTimestamp.fromNanos((long)startTime), TmfTimestamp.fromNanos((long)endTime));
                AbstractTimeGraphView.this.broadcast((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)AbstractTimeGraphView.this, range));
                AbstractTimeGraphView.this.startZoomThread(startTime, endTime);
            }
        });
        this.fTimeGraphViewer.addTimeListener(new ITimeGraphTimeListener(){

            @Override
            public void timeSelected(TimeGraphTimeEvent event) {
                ITmfTimestamp startTime = TmfTimestamp.fromNanos((long)event.getBeginTime());
                ITmfTimestamp endTime = TmfTimestamp.fromNanos((long)event.getEndTime());
                AbstractTimeGraphView.this.broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)AbstractTimeGraphView.this, startTime, endTime));
            }
        });
        this.fTimeGraphViewer.addBookmarkListener(new ITimeGraphBookmarkListener(){

            @Override
            public void bookmarkAdded(final TimeGraphBookmarkEvent event) {
                try {
                    ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            IMarkerEvent bookmark = event.getBookmark();
                            IMarker marker = AbstractTimeGraphView.this.fEditorFile.createMarker("org.eclipse.core.resources.bookmark");
                            marker.setAttribute("message", (Object)bookmark.getLabel());
                            marker.setAttribute("time", (Object)Long.toString(bookmark.getTime()));
                            if (bookmark.getDuration() > 0L) {
                                marker.setAttribute("duration", (Object)Long.toString(bookmark.getDuration()));
                                marker.setAttribute("location", (Object)NLS.bind((String)org.eclipse.tracecompass.internal.tmf.ui.Messages.TmfMarker_LocationTimeRange, (Object)TmfTimestamp.fromNanos((long)bookmark.getTime()), (Object)TmfTimestamp.fromNanos((long)(bookmark.getTime() + bookmark.getDuration()))));
                            } else {
                                marker.setAttribute("location", (Object)NLS.bind((String)org.eclipse.tracecompass.internal.tmf.ui.Messages.TmfMarker_LocationTime, (Object)TmfTimestamp.fromNanos((long)bookmark.getTime())));
                            }
                            marker.setAttribute("color", (Object)bookmark.getColor().toString());
                        }
                    }, null);
                }
                catch (CoreException e) {
                    Activator.getDefault().logError(e.getMessage());
                }
            }

            @Override
            public void bookmarkRemoved(TimeGraphBookmarkEvent event) {
                try {
                    IMarker[] markers;
                    IMarkerEvent bookmark = event.getBookmark();
                    IMarker[] iMarkerArray = markers = AbstractTimeGraphView.this.fEditorFile.findMarkers("org.eclipse.core.resources.bookmark", false, 0);
                    int n = markers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarker marker = iMarkerArray[n2];
                        if (bookmark.getLabel().equals(marker.getAttribute("message")) && Long.toString(bookmark.getTime()).equals(marker.getAttribute("time", null)) && Long.toString(bookmark.getDuration()).equals(marker.getAttribute("duration", Long.toString(0L))) && bookmark.getColor().toString().equals(marker.getAttribute("color"))) {
                            marker.delete();
                            break;
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    Activator.getDefault().logError(e.getMessage());
                }
            }
        });
        this.fTimeGraphViewer.setTimeFormat(Utils.TimeFormat.CALENDAR);
        IStatusLineManager statusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fTimeGraphViewer.getTimeGraphControl().setStatusLineManager(statusLineManager);
        this.makeActions();
        this.contributeToActionBars();
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        if (trace != null) {
            this.traceSelected(new TmfTraceSelectedSignal((Object)this, trace));
        }
        this.getSite().setSelectionProvider(this.fTimeGraphViewer.getSelectionProvider());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        this.createContextMenu();
        this.fPartListener = new TimeGraphPartListener();
        this.getSite().getPage().addPartListener((IPartListener)this.fPartListener);
    }

    public void setFocus() {
        this.fTimeGraphViewer.setFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        super.dispose();
        Map<ITmfTrace, Job> map = this.fBuildJobMap;
        synchronized (map) {
            this.fBuildJobMap.values().forEach(buildJob -> buildJob.cancel());
        }
        if (this.fZoomThread != null) {
            this.fZoomThread.cancel();
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.getSite().getPage().removePartListener((IPartListener)this.fPartListener);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IMarkerDelta[] iMarkerDeltaArray = event.findMarkerDeltas("org.eclipse.core.resources.bookmark", false);
        int n = iMarkerDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta delta = iMarkerDeltaArray[n2];
            if (delta.getResource().equals((Object)this.fEditorFile)) {
                this.fTimeGraphViewer.setBookmarks(AbstractTimeGraphView.refreshBookmarks(this.fEditorFile));
                this.redraw();
                return;
            }
            ++n2;
        }
    }

    private static List<IMarkerEvent> refreshBookmarks(IFile editorFile) {
        ArrayList<IMarkerEvent> bookmarks = new ArrayList<IMarkerEvent>();
        if (editorFile == null || !editorFile.exists()) {
            return bookmarks;
        }
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = editorFile.findMarkers("org.eclipse.core.resources.bookmark", false, 0);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                Matcher matcher;
                IMarker marker = iMarkerArray[n2];
                String label = marker.getAttribute("message", null);
                String time = marker.getAttribute("time", null);
                String duration = marker.getAttribute("duration", Long.toString(0L));
                String rgba = marker.getAttribute("color", null);
                if (label != null && time != null && rgba != null && (matcher = RGBA_PATTERN.matcher(rgba)).matches()) {
                    try {
                        int red = Integer.valueOf(matcher.group(1));
                        int green = Integer.valueOf(matcher.group(2));
                        int blue = Integer.valueOf(matcher.group(3));
                        int alpha = Integer.valueOf(matcher.group(4));
                        RGBA color = new RGBA(red, green, blue, alpha);
                        bookmarks.add(new MarkerEvent(null, Long.valueOf(time), Long.valueOf(duration), IMarkerEvent.BOOKMARKS, color, label, true));
                    }
                    catch (NumberFormatException e) {
                        Activator.getDefault().logError(e.getMessage());
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage());
        }
        return bookmarks;
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        this.loadTrace(signal.getTrace());
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        if (signal.getTrace() == this.fTrace) {
            return;
        }
        this.loadTrace(signal.getTrace());
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        this.resetView(signal.getTrace());
        if (signal.getTrace() == this.fTrace) {
            this.fTrace = null;
            this.fEditorFile = null;
            this.setStartTime(-1L);
            this.setEndTime(-1L);
            this.refresh();
        }
    }

    @TmfSignalHandler
    public void selectionRangeUpdated(TmfSelectionRangeUpdatedSignal signal) {
        if (signal.getSource() == this || this.fTrace == null) {
            return;
        }
        final long beginTime = signal.getBeginTime().toNanos();
        final long endTime = signal.getEndTime().toNanos();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (AbstractTimeGraphView.this.fTimeGraphViewer.getControl().isDisposed()) {
                    return;
                }
                if (beginTime == endTime) {
                    AbstractTimeGraphView.this.fTimeGraphViewer.setSelectedTime(beginTime, true);
                } else {
                    AbstractTimeGraphView.this.fTimeGraphViewer.setSelectionRange(beginTime, endTime, true);
                }
                AbstractTimeGraphView.this.synchingToTime(AbstractTimeGraphView.this.fTimeGraphViewer.getSelectionBegin());
            }
        });
    }

    @TmfSignalHandler
    public void windowRangeUpdated(TmfWindowRangeUpdatedSignal signal) {
        if (signal.getSource() == this || this.fTrace == null) {
            return;
        }
        if (signal.getCurrentRange().getIntersection(this.fTrace.getTimeRange()) == null) {
            return;
        }
        final long startTime = signal.getCurrentRange().getStartTime().toNanos();
        final long endTime = signal.getCurrentRange().getEndTime().toNanos();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (AbstractTimeGraphView.this.fTimeGraphViewer.getControl().isDisposed()) {
                    return;
                }
                AbstractTimeGraphView.this.fTimeGraphViewer.setStartFinishTime(startTime, endTime);
                AbstractTimeGraphView.this.startZoomThread(startTime, endTime);
            }
        });
    }

    @TmfSignalHandler
    public void updateTimeFormat(TmfTimestampFormatUpdateSignal signal) {
        this.fTimeGraphViewer.refresh();
    }

    @TmfSignalHandler
    public void markerEventSourceUpdated(TmfMarkerEventSourceUpdatedSignal signal) {
        this.getTimeGraphViewer().setMarkerCategories(this.getMarkerCategories());
        this.getTimeGraphViewer().setMarkers(null);
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTrace(ITmfTrace trace) {
        if (this.fZoomThread != null) {
            this.fZoomThread.cancel();
            this.fZoomThread = null;
        }
        if (this.fTrace != null) {
            this.fFiltersMap.put(this.fTrace, this.fTimeGraphViewer.getFilters());
            this.fViewContext.put(this.fTrace, new ViewContext(this.fCurrentSortColumn, this.fSortDirection, this.fTimeGraphViewer.getSelection()));
        }
        this.fTrace = trace;
        TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.FINE, (String)"TimeGraphView:LoadingTrace", (Object[])new Object[]{"trace", trace.getName(), "viewId", this.getViewId()});
        this.restoreViewContext();
        this.fEditorFile = TmfTraceManager.getInstance().getTraceEditorFile(trace);
        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
        synchronized (map) {
            this.fEntryList = this.fEntryListMap.get(this.fTrace);
            if (this.fEntryList == null) {
                this.rebuild();
            } else {
                this.setStartTime(this.fTrace.getStartTime().toNanos());
                this.setEndTime(this.fTrace.getEndTime().toNanos());
                this.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void rebuild() {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            final TraceCompassLogUtils.FlowScopeLog parentLogger = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "TimeGraphView:Rebuilding", new Object[0]).setCategory(this.getViewId()).build();
            try {
                this.setStartTime(Long.MAX_VALUE);
                this.setEndTime(Long.MIN_VALUE);
                this.refresh();
                final ITmfTrace viewTrace = this.fTrace;
                if (viewTrace == null) {
                    return;
                }
                this.resetView(viewTrace);
                ArrayList markerEventSources = new ArrayList();
                Map<ITmfTrace, Job> map = this.fBuildJobMap;
                synchronized (map) {
                    for (final ITmfTrace trace : this.getTracesToBuild(viewTrace)) {
                        if (trace == null) break;
                        @NonNull List adapters = TmfTraceAdapterManager.getAdapters((ITmfTrace)trace, IMarkerEventSource.class);
                        markerEventSources.addAll(adapters);
                        Job buildJob = new Job(String.valueOf(this.getTitle()) + Messages.AbstractTimeGraphView_BuildJob){

                            protected IStatus run(IProgressMonitor monitor) {
                                new BuildRunnable(trace, viewTrace, parentLogger).run(monitor);
                                monitor.done();
                                return Status.OK_STATUS;
                            }
                        };
                        this.fBuildJobMap.put(trace, buildJob);
                        buildJob.schedule();
                    }
                }
                this.fMarkerEventSourcesMap.put(viewTrace, markerEventSources);
                return;
            }
            finally {
                if (parentLogger == null) return;
                parentLogger.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    protected void synchingToTime(long time) {
    }

    protected @NonNull Iterable<ITmfTrace> getTracesToBuild(@Nullable ITmfTrace trace) {
        return TmfTraceManager.getTraceSet((ITmfTrace)trace);
    }

    protected abstract void buildEntryList(@NonNull ITmfTrace var1, @NonNull ITmfTrace var2, @NonNull IProgressMonitor var3);

    protected abstract @Nullable List<@NonNull ITimeEvent> getEventList(@NonNull TimeGraphEntry var1, long var2, long var4, long var6, @NonNull IProgressMonitor var8);

    protected @Nullable List<@NonNull ILinkEvent> getLinkList(long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
        return new ArrayList<ILinkEvent>();
    }

    protected @NonNull List<String> getViewMarkerCategories() {
        return new ArrayList<String>();
    }

    protected @NonNull List<IMarkerEvent> getViewMarkerList(long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
        return new ArrayList<IMarkerEvent>();
    }

    protected @NonNull List<IMarkerEvent> getTraceMarkerList(long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
        ArrayList<IMarkerEvent> markers = new ArrayList<IMarkerEvent>();
        for (IMarkerEventSource markerEventSource : this.getMarkerEventSources(this.fTrace)) {
            markers.addAll(markerEventSource.getMarkerList(startTime, endTime, resolution, monitor));
        }
        return markers;
    }

    protected @NonNull List<String> getMarkerCategories() {
        LinkedHashSet<String> categories = new LinkedHashSet<String>(this.getViewMarkerCategories());
        for (IMarkerEventSource markerEventSource : this.getMarkerEventSources(this.fTrace)) {
            categories.addAll(markerEventSource.getMarkerCategories());
        }
        return new ArrayList<String>(categories);
    }

    private @NonNull List<IMarkerEventSource> getMarkerEventSources(ITmfTrace trace) {
        List<IMarkerEventSource> markerEventSources = this.fMarkerEventSourcesMap.get(trace);
        if (markerEventSources == null) {
            markerEventSources = Collections.emptyList();
        }
        return markerEventSources;
    }

    protected void refresh() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (final TraceCompassLogUtils.FlowScopeLog parentLogger = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "RefreshRequested", new Object[0]).setCategory(this.getViewId()).build();){
            final boolean zoomThread = Thread.currentThread() instanceof ZoomThread;
            TmfUiRefreshHandler.getInstance().queueUpdate(this, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    Throwable throwable = null;
                    Object var2_3 = null;
                    try {
                        TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "TimeGraphView:Refresh", new Object[0]).setParentScope(parentLogger).build();
                        try {
                            boolean inputChanged;
                            if (AbstractTimeGraphView.this.fTimeGraphViewer.getControl().isDisposed()) {
                                return;
                            }
                            AbstractTimeGraphView.this.fDirty.incrementAndGet();
                            Map map = AbstractTimeGraphView.this.fEntryListMap;
                            synchronized (map) {
                                AbstractTimeGraphView.this.fEntryList = (List)AbstractTimeGraphView.this.fEntryListMap.get(AbstractTimeGraphView.this.fTrace);
                                if (AbstractTimeGraphView.this.fEntryList == null) {
                                    AbstractTimeGraphView.this.fEntryList = new CopyOnWriteArrayList();
                                } else if (AbstractTimeGraphView.this.fEntryComparator != null) {
                                    ArrayList list = new ArrayList(AbstractTimeGraphView.this.fEntryList);
                                    Collections.sort(list, AbstractTimeGraphView.this.fEntryComparator);
                                    Iterator iterator = list.iterator();
                                    while (true) {
                                        if (!iterator.hasNext()) {
                                            AbstractTimeGraphView.this.fEntryList.clear();
                                            AbstractTimeGraphView.this.fEntryList.addAll(list);
                                            break;
                                        }
                                        ITimeGraphEntry entry = (ITimeGraphEntry)iterator.next();
                                        AbstractTimeGraphView.this.sortChildren(entry, AbstractTimeGraphView.this.fEntryComparator);
                                    }
                                }
                            }
                            boolean bl = inputChanged = AbstractTimeGraphView.this.fEntryList != AbstractTimeGraphView.this.fTimeGraphViewer.getInput();
                            if (inputChanged) {
                                AbstractTimeGraphView.this.fTimeGraphViewer.setInput(AbstractTimeGraphView.this.fEntryList);
                                AbstractTimeGraphView.this.fTimeGraphViewer.setFilters((ViewerFilter[])AbstractTimeGraphView.this.fFiltersMap.get(AbstractTimeGraphView.this.fTrace));
                                AbstractTimeGraphView.this.fTimeGraphViewer.setLinks(null);
                                AbstractTimeGraphView.this.fTimeGraphViewer.setBookmarks(AbstractTimeGraphView.refreshBookmarks(AbstractTimeGraphView.this.fEditorFile));
                                AbstractTimeGraphView.this.fTimeGraphViewer.setMarkerCategories(AbstractTimeGraphView.this.getMarkerCategories());
                                AbstractTimeGraphView.this.fTimeGraphViewer.setMarkers(null);
                                AbstractTimeGraphView.this.applyViewContext();
                            } else {
                                AbstractTimeGraphView.this.fTimeGraphViewer.refresh();
                            }
                            if (AbstractTimeGraphView.this.fIsRevealSelection) {
                                AbstractTimeGraphView.this.fIsRevealSelection = false;
                                AbstractTimeGraphView.this.fTimeGraphViewer.setSelection(AbstractTimeGraphView.this.fTimeGraphViewer.getSelection(), true);
                            }
                            long startBound = AbstractTimeGraphView.this.fStartTime == Long.MAX_VALUE ? -1L : AbstractTimeGraphView.this.fStartTime;
                            long endBound = AbstractTimeGraphView.this.fEndTime == Long.MIN_VALUE ? -1L : AbstractTimeGraphView.this.fEndTime;
                            AbstractTimeGraphView.this.fTimeGraphViewer.setTimeBounds(startBound, endBound);
                            TmfTraceContext ctx = TmfTraceManager.getInstance().getCurrentTraceContext();
                            long selectionBeginTime = AbstractTimeGraphView.this.fTrace == null ? -1L : ctx.getSelectionRange().getStartTime().toNanos();
                            long selectionEndTime = AbstractTimeGraphView.this.fTrace == null ? -1L : ctx.getSelectionRange().getEndTime().toNanos();
                            long startTime = AbstractTimeGraphView.this.fTrace == null ? -1L : ctx.getWindowRange().getStartTime().toNanos();
                            long endTime = AbstractTimeGraphView.this.fTrace == null ? -1L : ctx.getWindowRange().getEndTime().toNanos();
                            startTime = AbstractTimeGraphView.this.fStartTime == Long.MAX_VALUE ? -1L : Math.max(startTime, AbstractTimeGraphView.this.fStartTime);
                            endTime = AbstractTimeGraphView.this.fEndTime == Long.MIN_VALUE ? -1L : Math.min(endTime, AbstractTimeGraphView.this.fEndTime);
                            AbstractTimeGraphView.this.fTimeGraphViewer.setSelectionRange(selectionBeginTime, selectionEndTime, false);
                            AbstractTimeGraphView.this.fTimeGraphViewer.setStartFinishTime(startTime, endTime);
                            if (inputChanged && selectionBeginTime != -1L) {
                                AbstractTimeGraphView.this.synchingToTime(selectionBeginTime);
                            }
                            if (!zoomThread) {
                                AbstractTimeGraphView.this.startZoomThread(startTime, endTime);
                            }
                            AbstractTimeGraphView.this.fDirty.decrementAndGet();
                            return;
                        }
                        finally {
                            if (log == null) return;
                            log.close();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                            throw throwable;
                        }
                        if (throwable == throwable2) throw throwable;
                        throwable.addSuppressed(throwable2);
                        throw throwable;
                    }
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void redraw() {
        Object object = this.fSyncObj;
        synchronized (object) {
            if (this.fRedrawState != State.IDLE) {
                this.fRedrawState = State.PENDING;
                return;
            }
            this.fRedrawState = State.BUSY;
        }
        object = null;
        Object var2_3 = null;
        try (final TraceCompassLogUtils.FlowScopeLog flowParent = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "RedrawRequested", new Object[0]).setCategory(this.getViewId()).build();){
            Display.getDefault().asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    Throwable throwable = null;
                    Object var2_3 = null;
                    try {
                        TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "TimeGraphView:Redraw", new Object[0]).setParentScope(flowParent).build();
                        try {
                            if (AbstractTimeGraphView.this.fTimeGraphViewer.getControl().isDisposed()) {
                                return;
                            }
                            AbstractTimeGraphView.this.fTimeGraphViewer.getControl().redraw();
                            AbstractTimeGraphView.this.fTimeGraphViewer.getControl().update();
                            Object object = AbstractTimeGraphView.this.fSyncObj;
                            synchronized (object) {
                                if (AbstractTimeGraphView.this.fRedrawState == State.PENDING) {
                                    AbstractTimeGraphView.this.fRedrawState = State.IDLE;
                                    AbstractTimeGraphView.this.redraw();
                                } else {
                                    AbstractTimeGraphView.this.fRedrawState = State.IDLE;
                                }
                                return;
                            }
                        }
                        finally {
                            if (log == null) return;
                            log.close();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                            throw throwable;
                        }
                        if (throwable == throwable2) throw throwable;
                        throwable.addSuppressed(throwable2);
                        throw throwable;
                    }
                }
            });
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
    }

    private void sortChildren(ITimeGraphEntry entry, Comparator<ITimeGraphEntry> comparator) {
        if (entry instanceof TimeGraphEntry) {
            ((TimeGraphEntry)entry).sortChildren(comparator);
        }
        for (ITimeGraphEntry iTimeGraphEntry : entry.getChildren()) {
            this.sortChildren(iTimeGraphEntry, comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void startZoomThread(long startTime, long endTime) {
        block15: {
            Throwable throwable = null;
            Object var6_5 = null;
            try (TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "TimeGraphView:ZoomThreadCreated", new Object[0]).setCategory(this.getViewId()).build();){
                long clampedStartTime = this.fStartTime == Long.MAX_VALUE ? startTime : Math.min(Math.max(startTime, this.fStartTime), this.fEndTime);
                long clampedEndTime = this.fEndTime == Long.MIN_VALUE ? endTime : Math.max(Math.min(endTime, this.fEndTime), this.fStartTime);
                this.fDirty.incrementAndGet();
                boolean restart = false;
                ZoomThread zoomThread = this.fZoomThread;
                if (zoomThread != null) {
                    zoomThread.cancel();
                    if (zoomThread.fZoomStartTime == clampedStartTime && zoomThread.fZoomEndTime == clampedEndTime) {
                        restart = true;
                    }
                }
                long resolution = Math.max(1L, (clampedEndTime - clampedStartTime) / (long)this.fDisplayWidth);
                this.fZoomThread = zoomThread = this.createZoomThread(clampedStartTime, clampedEndTime, resolution, restart);
                if (zoomThread != null) {
                    zoomThread.setScopeId(log.getId());
                    Object object = this.fZoomThreadResultLock;
                    synchronized (object) {
                        zoomThread.start();
                        break block15;
                    }
                }
                this.fDirty.decrementAndGet();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    protected @Nullable ZoomThread createZoomThread(long startTime, long endTime, long resolution, boolean restart) {
        List<TimeGraphEntry> entryList = this.fEntryList;
        if (entryList == null) {
            return null;
        }
        return new ZoomThreadByEntry(entryList, startTime, endTime, resolution);
    }

    private void makeActions() {
        this.fPreviousResourceAction = this.fTimeGraphViewer.getPreviousItemAction();
        this.fPreviousResourceAction.setText(this.getPrevText());
        this.fPreviousResourceAction.setToolTipText(this.getPrevTooltip());
        this.fNextResourceAction = this.fTimeGraphViewer.getNextItemAction();
        this.fNextResourceAction.setText(this.getNextText());
        this.fNextResourceAction.setToolTipText(this.getNextTooltip());
    }

    protected MenuManager getMarkerSetMenu() {
        if (this.fMarkerSetMenu != null) {
            return this.fMarkerSetMenu;
        }
        this.fMarkerSetMenu = new MenuManager(Messages.AbstractTimeGraphView_MarkerSetMenuText);
        this.fMarkerSetMenu.setRemoveAllWhenShown(true);
        this.fMarkerSetMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                MarkerSetAction noneAction = new MarkerSetAction(null);
                MarkerSet defaultMarkerSet = MarkerUtils.getDefaultMarkerSet();
                String defaultMarkerSetId = defaultMarkerSet == null ? null : defaultMarkerSet.getId();
                noneAction.setChecked(defaultMarkerSetId == null);
                mgr.add((IAction)noneAction);
                List markerSets = MarkerConfigXmlParser.getMarkerSets();
                for (MarkerSet markerSet : markerSets) {
                    MarkerSetAction action = new MarkerSetAction(markerSet);
                    action.setChecked(markerSet.getId().equals(defaultMarkerSetId));
                    mgr.add((IAction)action);
                }
                mgr.add((IContributionItem)new Separator());
                mgr.add((IAction)new Action(Messages.AbstractTimeGraphView_MarkerSetEditActionText){

                    public void run() {
                        MarkerConfigXmlParser.initMarkerSets();
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IFileStore fileStore = EFS.getLocalFileSystem().getStore(MarkerConfigXmlParser.MARKER_CONFIG_PATH);
                        try {
                            IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                        }
                        catch (PartInitException e) {
                            Activator.getDefault().logError("Error opening editor on " + MarkerConfigXmlParser.MARKER_CONFIG_PATH, e);
                        }
                    }
                });
            }
        });
        return this.fMarkerSetMenu;
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
        this.fillLocalMenu(bars.getMenuManager());
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        if (this.fFilterColumns != null && this.fFilterLabelProvider != null && this.fFilterColumns.length > 0) {
            manager.add((IAction)this.fTimeGraphViewer.getShowFilterDialogAction());
        }
        manager.add((IAction)this.fTimeGraphViewer.getShowLegendAction());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fTimeGraphViewer.getResetScaleAction());
        manager.add((IAction)this.fTimeGraphViewer.getPreviousEventAction());
        manager.add((IAction)this.fTimeGraphViewer.getNextEventAction());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fTimeGraphViewer.getToggleBookmarkAction());
        manager.add((IAction)this.fTimeGraphViewer.getPreviousMarkerAction());
        manager.add((IAction)this.fTimeGraphViewer.getNextMarkerAction());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fPreviousResourceAction);
        manager.add((IAction)this.fNextResourceAction);
        manager.add((IAction)this.fTimeGraphViewer.getZoomInAction());
        manager.add((IAction)this.fTimeGraphViewer.getZoomOutAction());
        manager.add((IContributionItem)new Separator());
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IContributionItem)this.fTimeGraphViewer.getMarkersMenu());
        manager.add((IContributionItem)this.getMarkerSetMenu());
    }

    @Override
    public TmfTimeViewAlignmentInfo getTimeViewAlignmentInfo() {
        if (this.fTimeGraphViewer == null) {
            return null;
        }
        return this.fTimeGraphViewer.getTimeViewAlignmentInfo();
    }

    @Override
    public int getAvailableWidth(int requestedOffset) {
        if (this.fTimeGraphViewer == null) {
            return 0;
        }
        return this.fTimeGraphViewer.getAvailableWidth(requestedOffset);
    }

    @Override
    public void performAlign(int offset, int width) {
        if (this.fTimeGraphViewer != null) {
            this.fTimeGraphViewer.performAlign(offset, width);
        }
    }

    public boolean isDirty() {
        if (this.fTrace == null) {
            return false;
        }
        TmfTraceContext ctx = TmfTraceManager.getInstance().getCurrentTraceContext();
        long startTime = ctx.getWindowRange().getStartTime().toNanos();
        long endTime = ctx.getWindowRange().getEndTime().toNanos();
        if (this.fTimeGraphViewer.getTime0() != startTime || this.fTimeGraphViewer.getTime1() != endTime) {
            return true;
        }
        if (this.fZoomThread == null) {
            return this.fDirty.get() != 0;
        }
        return this.fDirty.get() != 0 || this.fZoomThread.getZoomStartTime() != startTime || this.fZoomThread.getZoomEndTime() != endTime;
    }

    private void createColumnSelectionListener(final Tree tree) {
        int i = 0;
        while (i < this.fColumnComparators.length) {
            final int index = i;
            final Comparator<ITimeGraphEntry> comp = this.fColumnComparators[index];
            final TreeColumn column = tree.getColumn(i);
            if (comp != null) {
                column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TreeColumn prevSortcolumn = tree.getSortColumn();
                        int direction = tree.getSortDirection();
                        direction = prevSortcolumn == column ? (direction == 1024 ? 128 : 1024) : 1024;
                        tree.setSortColumn(column);
                        tree.setSortDirection(direction);
                        AbstractTimeGraphView.this.fSortDirection = direction;
                        AbstractTimeGraphView.this.fCurrentSortColumn = index;
                        Comparator comparator = comp;
                        if (comparator instanceof ITimeGraphEntryComparator) {
                            ((ITimeGraphEntryComparator)comparator).setDirection(direction);
                        }
                        if (direction != 1024) {
                            comparator = (Comparator)NonNullUtils.checkNotNull(Collections.reverseOrder(comparator));
                        }
                        AbstractTimeGraphView.this.setEntryComparator(comparator);
                        AbstractTimeGraphView.this.fIsRevealSelection = true;
                        AbstractTimeGraphView.this.fTimeGraphViewer.getControl().setFocus();
                        AbstractTimeGraphView.this.refresh();
                    }
                });
            }
            ++i;
        }
    }

    private void restoreViewContext() {
        ViewContext viewContext = this.fViewContext.get(this.fTrace);
        if (this.fColumnComparators != null) {
            this.fSortDirection = 1024;
            this.fCurrentSortColumn = this.fInitialSortColumn;
            if (viewContext != null) {
                this.fSortDirection = viewContext.getSortDirection();
                this.fCurrentSortColumn = viewContext.getSortColumn();
            }
            if (this.fCurrentSortColumn < this.fColumnComparators.length && this.fColumnComparators[this.fCurrentSortColumn] != null) {
                Comparator comparator = this.fColumnComparators[this.fCurrentSortColumn];
                if (comparator instanceof ITimeGraphEntryComparator) {
                    ((ITimeGraphEntryComparator)comparator).setDirection(this.fSortDirection);
                }
                if (this.fSortDirection != 1024) {
                    comparator = (Comparator)NonNullUtils.checkNotNull(Collections.reverseOrder(comparator));
                }
                this.setEntryComparator(comparator);
            }
        }
    }

    private void applyViewContext() {
        ViewContext viewContext = this.fViewContext.get(this.fTrace);
        if (this.fColumnComparators != null) {
            Tree tree = this.fTimeGraphViewer.getTree();
            TreeColumn column = tree.getColumn(this.fCurrentSortColumn);
            tree.setSortDirection(this.fSortDirection);
            tree.setSortColumn(column);
        }
        this.fTimeGraphViewer.getControl().setFocus();
        if (viewContext != null && viewContext.getSelection() != null) {
            this.fTimeGraphViewer.setSelection(viewContext.getSelection(), true);
        }
        this.fViewContext.remove(this.fTrace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetView(ITmfTrace viewTrace) {
        if (viewTrace == null) {
            return;
        }
        Map<ITmfTrace, Object> map = this.fBuildJobMap;
        synchronized (map) {
            for (ITmfTrace trace : this.getTracesToBuild(viewTrace)) {
                Job buildJob = this.fBuildJobMap.remove(trace);
                if (buildJob == null) continue;
                buildJob.cancel();
            }
        }
        map = this.fEntryListMap;
        synchronized (map) {
            this.fEntryListMap.remove(viewTrace);
        }
        this.fViewContext.remove(viewTrace);
        this.fFiltersMap.remove(viewTrace);
        this.fMarkerEventSourcesMap.remove(viewTrace);
        if (viewTrace == this.fTrace && this.fZoomThread != null) {
            this.fZoomThread.cancel();
            this.fZoomThread = null;
        }
    }

    private void createContextMenu() {
        this.fEntryMenuManager.setRemoveAllWhenShown(true);
        final TimeGraphControl timeGraphControl = this.getTimeGraphViewer().getTimeGraphControl();
        final Menu entryMenu = this.fEntryMenuManager.createContextMenu((Control)timeGraphControl);
        timeGraphControl.addTimeGraphEntryMenuListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent event) {
                Point p = timeGraphControl.toControl(event.x, event.y);
                if (p.x < AbstractTimeGraphView.this.getTimeGraphViewer().getNameSpace()) {
                    timeGraphControl.setMenu(entryMenu);
                } else {
                    timeGraphControl.setMenu(null);
                    event.doit = false;
                }
            }
        });
        this.fEntryMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AbstractTimeGraphView.this.fillTimeGraphEntryContextMenu((IMenuManager)AbstractTimeGraphView.this.fEntryMenuManager);
                AbstractTimeGraphView.this.fEntryMenuManager.add((IContributionItem)new GroupMarker("additions"));
            }
        });
        this.getSite().registerContextMenu(this.fEntryMenuManager, this.fTimeGraphViewer.getSelectionProvider());
    }

    protected void fillTimeGraphEntryContextMenu(@NonNull IMenuManager menuManager) {
    }

    private class BuildRunnable {
        private final @NonNull ITmfTrace fBuildTrace;
        private final @NonNull ITmfTrace fParentTrace;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull TraceCompassLogUtils.FlowScopeLog fScope;

        public BuildRunnable(@NonNull ITmfTrace trace, @NonNull ITmfTrace parentTrace, TraceCompassLogUtils.FlowScopeLog log) {
            this.fBuildTrace = trace;
            this.fParentTrace = parentTrace;
            this.fScope = log;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(IProgressMonitor monitor) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "TimeGraphView:BuildThread", new Object[]{"trace", this.fBuildTrace.getName()}).setParentScope(this.fScope).build();){
                AbstractTimeGraphView.this.buildEntryList(this.fBuildTrace, this.fParentTrace, (IProgressMonitor)NonNullUtils.checkNotNull((Object)monitor));
                Map map = AbstractTimeGraphView.this.fBuildJobMap;
                synchronized (map) {
                    AbstractTimeGraphView.this.fBuildJobMap.remove(this.fBuildTrace);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    class FindTarget {
        FindTarget() {
        }

        public ITimeGraphEntry getSelection() {
            return AbstractTimeGraphView.this.fTimeGraphViewer.getSelection();
        }

        public void selectAndReveal(@NonNull ITimeGraphEntry entry) {
            AbstractTimeGraphView.this.fTimeGraphViewer.selectAndReveal(entry);
        }

        public ITimeGraphEntry[] getEntries() {
            TimeGraphViewer viewer = AbstractTimeGraphView.this.getTimeGraphViewer();
            return viewer.getTimeGraphContentProvider().getElements(viewer.getInput());
        }

        public Shell getShell() {
            return AbstractTimeGraphView.this.getSite().getShell();
        }
    }

    private class MarkerSetAction
    extends Action {
        private MarkerSet fMarkerSet;

        public MarkerSetAction(MarkerSet markerSet) {
            super(markerSet == null ? Messages.AbstractTimeGraphView_MarkerSetNoneActionText : markerSet.getName(), 8);
            this.fMarkerSet = markerSet;
        }

        public void runWithEvent(Event event) {
            if (this.isChecked()) {
                MarkerUtils.setDefaultMarkerSet(this.fMarkerSet);
                AbstractTimeGraphView.this.broadcast((TmfSignal)new TmfMarkerEventSourceUpdatedSignal((Object)AbstractTimeGraphView.this));
            }
        }
    }

    private static enum State {
        IDLE,
        BUSY,
        PENDING;

    }

    class TimeGraphPartListener
    implements IPartListener {
        TimeGraphPartListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void partActivated(IWorkbenchPart part) {
            if (part == AbstractTimeGraphView.this) {
                ShowFindDialogAction showFindDialogAction = FIND_ACTION;
                synchronized (showFindDialogAction) {
                    if (AbstractTimeGraphView.this.fFindActionHandler == null) {
                        AbstractTimeGraphView.this.fFindActionHandler = new ActionHandler((IAction)FIND_ACTION);
                    }
                    if (AbstractTimeGraphView.this.fFindHandlerActivation == null) {
                        Object service = PlatformUI.getWorkbench().getService(IHandlerService.class);
                        AbstractTimeGraphView.this.fFindHandlerActivation = ((IHandlerService)service).activateHandler(ActionFactory.FIND.getCommandId(), (IHandler)AbstractTimeGraphView.this.fFindActionHandler);
                    }
                }
            }
            FIND_ACTION.partActivated(part);
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (part == AbstractTimeGraphView.this && AbstractTimeGraphView.this.fFindHandlerActivation != null) {
                Object service = PlatformUI.getWorkbench().getService(IHandlerService.class);
                ((IHandlerService)service).deactivateHandler(AbstractTimeGraphView.this.fFindHandlerActivation);
                AbstractTimeGraphView.this.fFindHandlerActivation = null;
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }

    protected static class TreeLabelProvider
    implements ITableLabelProvider,
    ILabelProvider {
        protected TreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            TimeGraphEntry entry = (TimeGraphEntry)element;
            if (columnIndex == 0) {
                return entry.getName();
            }
            return new String();
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            TimeGraphEntry entry = (TimeGraphEntry)element;
            return entry.getName();
        }
    }

    private static class ViewContext {
        private int fSortColumnIndex;
        private int fSortDirection;
        private @Nullable ITimeGraphEntry fSelection;

        ViewContext(int sortColunm, int sortDirection, ITimeGraphEntry selection) {
            this.fSortColumnIndex = sortColunm;
            this.fSortDirection = sortDirection;
            this.fSelection = selection;
        }

        public int getSortColumn() {
            return this.fSortColumnIndex;
        }

        public int getSortDirection() {
            return this.fSortDirection;
        }

        public ITimeGraphEntry getSelection() {
            return this.fSelection;
        }
    }

    protected abstract class ZoomThread
    extends Thread {
        private final long fZoomStartTime;
        private final long fZoomEndTime;
        private final long fResolution;
        private int fScopeId;
        private final @NonNull IProgressMonitor fMonitor;

        public ZoomThread(long startTime, long endTime, long resolution) {
            super(String.valueOf(AbstractTimeGraphView.this.getName()) + " zoom");
            this.fScopeId = -1;
            this.fZoomStartTime = startTime;
            this.fZoomEndTime = endTime;
            this.fResolution = resolution;
            this.fMonitor = new NullProgressMonitor();
        }

        public long getZoomStartTime() {
            return this.fZoomStartTime;
        }

        public long getZoomEndTime() {
            return this.fZoomEndTime;
        }

        public long getResolution() {
            return this.fResolution;
        }

        public @NonNull IProgressMonitor getMonitor() {
            return this.fMonitor;
        }

        public void cancel() {
            this.fMonitor.setCanceled(true);
        }

        @Override
        public final void run() {
            Throwable throwable = null;
            Object var2_3 = null;
            try (TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "TimeGraphView:ZoomThread", new Object[]{"start", this.fZoomStartTime, "end", this.fZoomEndTime}).setCategoryAndId(AbstractTimeGraphView.this.getViewId(), this.fScopeId).build();){
                this.doRun();
                AbstractTimeGraphView.this.fDirty.decrementAndGet();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void applyResults(Runnable runnable) {
            Object object = AbstractTimeGraphView.this.fZoomThreadResultLock;
            synchronized (object) {
                if (this == AbstractTimeGraphView.this.fZoomThread) {
                    runnable.run();
                }
            }
        }

        public abstract void doRun();

        public void setScopeId(int scopeId) {
            this.fScopeId = scopeId;
        }
    }

    private class ZoomThreadByEntry
    extends ZoomThread {
        private final @NonNull List<TimeGraphEntry> fZoomEntryList;

        public ZoomThreadByEntry(List<TimeGraphEntry> entryList, long startTime, long endTime, long resolution) {
            super(startTime, endTime, resolution);
            this.fZoomEntryList = entryList;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void doRun() {
            var1_1 = null;
            var2_3 = null;
            try {
                log = new TraceCompassLogUtils.ScopeLog(AbstractTimeGraphView.access$0(), Level.FINER, "ZoomThread:GettingStates", new Object[0]);
                try {
                    var5_10 = this.fZoomEntryList.iterator();
                    while (true) {
                        entry = var5_10.next();
                        if (this.getMonitor().isCanceled()) {
                            log.addData("canceled", (Object)true);
                            return;
                        }
                        if (entry == null) {
                            break;
                        }
                        this.zoom(entry, this.getMonitor());
                        break;
                    }
                }
                finally {
                    if (var5_10.hasNext()) ** continue;
                }
            }
            catch (Throwable var2_4) {
                if (var1_1 == null) {
                    var1_1 = var2_4;
                } else if (var1_1 != var2_4) {
                    var1_1.addSuppressed(var2_4);
                }
                throw var1_1;
            }
            var2_3 = null;
            var3_7 = null;
            try {
                linkLog = new TraceCompassLogUtils.ScopeLog(AbstractTimeGraphView.access$0(), Level.FINER, "ZoomThread:GettingLinks", new Object[0]);
                try {
                    events = AbstractTimeGraphView.this.getLinkList(this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution(), this.getMonitor());
                }
                finally {
                    if (linkLog != null) {
                        linkLog.close();
                    }
                }
            }
            catch (Throwable var3_8) {
                if (var2_3 == null) {
                    var2_3 = var3_8;
                } else if (var2_3 != var3_8) {
                    var2_3.addSuppressed(var3_8);
                }
                throw var2_3;
            }
            var2_3 = null;
            var3_7 = null;
            try {
                markerLoglog = new TraceCompassLogUtils.ScopeLog(AbstractTimeGraphView.access$0(), Level.FINER, "ZoomThread:GettingMarkers", new Object[0]);
                try {
                    markers = new ArrayList<IMarkerEvent>(AbstractTimeGraphView.this.getViewMarkerList(this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution(), this.getMonitor()));
                    markers.addAll(AbstractTimeGraphView.this.getTraceMarkerList(this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution(), this.getMonitor()));
                    this.applyResults((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$0(java.util.List java.util.List ), ()V)((ZoomThreadByEntry)this, events, markers));
                }
                finally {
                    if (markerLoglog != null) {
                        markerLoglog.close();
                    }
                }
            }
            catch (Throwable var3_9) {
                if (var2_3 == null) {
                    var2_3 = var3_9;
                } else if (var2_3 != var3_9) {
                    var2_3.addSuppressed(var3_9);
                }
                throw var2_3;
            }
        }

        private void zoom(@NonNull TimeGraphEntry entry, @NonNull IProgressMonitor monitor) {
            if (this.getZoomStartTime() <= AbstractTimeGraphView.this.fStartTime && this.getZoomEndTime() >= AbstractTimeGraphView.this.fEndTime) {
                this.applyResults(() -> entry.setZoomedEventList(null));
            } else {
                List<ITimeEvent> zoomedEventList = AbstractTimeGraphView.this.getEventList(entry, this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution(), monitor);
                if (zoomedEventList != null) {
                    this.applyResults(() -> entry.setZoomedEventList(zoomedEventList));
                }
            }
            AbstractTimeGraphView.this.redraw();
            for (TimeGraphEntry child : entry.getChildren()) {
                if (monitor.isCanceled()) {
                    return;
                }
                this.zoom(child, monitor);
            }
        }

        private /* synthetic */ void lambda$0(List list, List list2) {
            if (list != null) {
                AbstractTimeGraphView.this.fTimeGraphViewer.setLinks(list);
            }
            AbstractTimeGraphView.this.fTimeGraphViewer.setMarkerCategories(AbstractTimeGraphView.this.getMarkerCategories());
            AbstractTimeGraphView.this.fTimeGraphViewer.setMarkers(list2);
            AbstractTimeGraphView.this.redraw();
        }
    }
}

