/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.awt.Color;
import java.text.Format;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfCommonXAxisModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfXYDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.viewmodel.ICommonXAxisModel;
import org.eclipse.tracecompass.tmf.core.viewmodel.IYSeries;
import org.eclipse.tracecompass.tmf.core.viewmodel.YSeries;
import org.eclipse.tracecompass.tmf.ui.colors.X11Color;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentInfo;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentSignal;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfChartTimeStampFormat;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.CommonXAxisModelBuilder;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXLineChartTooltipProvider;
import org.swtchart.Chart;
import org.swtchart.IBarSeries;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;
import org.swtchart.LineStyle;
import org.swtchart.Range;

public abstract class TmfCommonXLineChartViewer
extends TmfXYChartViewer {
    private static final String DIRTY_UNDERFLOW_ERROR = "Dirty underflow error";
    private static final double DEFAULT_MAXY = Double.MIN_VALUE;
    private static final double DEFAULT_MINY = Double.MAX_VALUE;
    private static final int DEFAULT_WIDTH = 1;
    private static final long BUILD_UPDATE_TIMEOUT = 500L;
    private static final double RESOLUTION = 1.0;
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(TmfCommonXLineChartViewer.class);
    private final Map<String, org.eclipse.swt.graphics.Color> fColors = new HashMap<String, org.eclipse.swt.graphics.Color>();
    private static final Map<@NonNull String, org.eclipse.swt.graphics.Color> SYSTEM_COLORS = new LinkedHashMap<String, org.eclipse.swt.graphics.Color>();
    private static final Pattern PATTERN;
    private static final Map<String, LineStyle> LINE_STYLES;
    private final CommonXAxisModelBuilder fModelBuilder = new CommonXAxisModelBuilder();
    private double fResolution;
    private UpdateThread fUpdateThread;
    private final AtomicInteger fDirty = new AtomicInteger();
    private int fOverrideNbPoints = 0;
    private ITmfXYDataProvider fXYDataProvider;

    static {
        SYSTEM_COLORS.put("BLUE", Display.getDefault().getSystemColor(9));
        SYSTEM_COLORS.put("RED", Display.getDefault().getSystemColor(3));
        SYSTEM_COLORS.put("GREEN", Display.getDefault().getSystemColor(5));
        SYSTEM_COLORS.put("MAGENTA", Display.getDefault().getSystemColor(11));
        SYSTEM_COLORS.put("CYAN", Display.getDefault().getSystemColor(13));
        SYSTEM_COLORS.put("DARK_BLUE", Display.getDefault().getSystemColor(10));
        SYSTEM_COLORS.put("DARK_RED", Display.getDefault().getSystemColor(4));
        SYSTEM_COLORS.put("DARK_GREEN", Display.getDefault().getSystemColor(6));
        SYSTEM_COLORS.put("DARK_MAGENTA", Display.getDefault().getSystemColor(12));
        SYSTEM_COLORS.put("DARK_CYAN", Display.getDefault().getSystemColor(14));
        SYSTEM_COLORS.put("DARK_YELLOW", Display.getDefault().getSystemColor(8));
        SYSTEM_COLORS.put("BLACK", Display.getDefault().getSystemColor(2));
        SYSTEM_COLORS.put("GRAY", Display.getDefault().getSystemColor(15));
        SYSTEM_COLORS.put("YELLOW", Display.getDefault().getSystemColor(7));
        PATTERN = Pattern.compile("\\s*(\\d{1,3})\\s*(\\d{1,3})\\s*(\\d{1,3})");
        LINE_STYLES = ImmutableMap.of((Object)"solid", (Object)LineStyle.SOLID, (Object)"dash", (Object)LineStyle.DASH, (Object)"dot", (Object)LineStyle.DOT, (Object)"dashdot", (Object)LineStyle.DASHDOT, (Object)"dashdotdot", (Object)LineStyle.DASHDOTDOT);
    }

    public TmfCommonXLineChartViewer(Composite parent, String title, String xLabel, String yLabel) {
        super(parent, title, xLabel, yLabel);
        this.fModelBuilder.setTitle(title);
        this.getSwtChart().getTitle().setVisible(false);
        this.getSwtChart().getLegend().setPosition(1024);
        this.getSwtChart().getAxisSet().getXAxes()[0].getTitle().setVisible(false);
        this.setResolution(1.0);
        this.setTooltipProvider(new TmfCommonXLineChartTooltipProvider(this));
    }

    protected void setResolution(double resolution) {
        this.fResolution = resolution;
    }

    protected void setDataProvider(ITmfXYDataProvider dataProvider) {
        this.fXYDataProvider = dataProvider;
    }

    @Override
    public void loadTrace(ITmfTrace trace) {
        super.loadTrace(trace);
        this.reinitialize();
    }

    private @NonNull String getViewerId() {
        return this.getClass().getName();
    }

    public ICommonXAxisModel getModel() {
        return this.fModelBuilder.build();
    }

    private Runnable newUiInitializeRunnable(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull TraceCompassLogUtils.FlowScopeLog enclosingScope) {
        return () -> {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                TraceCompassLogUtils.FlowScopeLog uiScope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:UiInitialization", new Object[0]).setParentScope(enclosingScope).build();
                try {
                    if (this.getSwtChart().isDisposed()) {
                        return;
                    }
                    try {
                        this.clearContent();
                        this.createSeries();
                        return;
                    }
                    finally {
                        if (this.fDirty.decrementAndGet() < 0) {
                            Activator.getDefault().logError(DIRTY_UNDERFLOW_ERROR, new Throwable());
                        }
                    }
                }
                finally {
                    if (uiScope == null) return;
                    uiScope.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        };
    }

    private Runnable newIntializeRunnable(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull TraceCompassLogUtils.FlowScopeLog scope) {
        return () -> {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                TraceCompassLogUtils.FlowScopeLog tracer = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:InitializeThread", new Object[0]).setParentScope(scope).build();
                try {
                    this.initializeDataSource();
                    if (this.getSwtChart().isDisposed()) {
                        return;
                    }
                    TmfCommonXLineChartViewer.getDisplay().asyncExec(this.newUiInitializeRunnable(tracer));
                    return;
                }
                finally {
                    if (tracer == null) return;
                    tracer.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        };
    }

    protected void reinitialize() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:ReinitializeRequested", new Object[0]).setCategory(this.getViewerId()).build();){
            this.fModelBuilder.setXValues(new double[0]);
            this.fDirty.incrementAndGet();
            Thread thread = new Thread(this.newIntializeRunnable(scope));
            thread.start();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void initializeDataSource() {
    }

    private synchronized void newUpdateThread(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull TraceCompassLogUtils.FlowScopeLog fScope) {
        if (this.getSwtChart().isDisposed()) {
            return;
        }
        int numRequests = this.fOverrideNbPoints != 0 ? this.fOverrideNbPoints : (int)((double)this.getSwtChart().getPlotArea().getBounds().width * this.fResolution);
        this.fUpdateThread = new UpdateThread(numRequests, fScope);
        this.fUpdateThread.start();
    }

    public synchronized void setNbPoints(int nbPoints) {
        if (nbPoints < 0) {
            throw new IllegalArgumentException("Number of points cannot be negative");
        }
        this.fOverrideNbPoints = nbPoints;
        this.updateContent();
    }

    private synchronized void updateThreadFinished(UpdateThread thread) {
        if (thread == this.fUpdateThread) {
            this.fUpdateThread = null;
        }
    }

    protected synchronized void cancelUpdate() {
        if (this.fUpdateThread != null) {
            this.fUpdateThread.cancel();
        }
    }

    @Override
    protected void updateContent() {
        this.cancelUpdate();
        Throwable throwable = null;
        Object var2_3 = null;
        try (final TraceCompassLogUtils.FlowScopeLog parentScope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:ContentUpdateRequested", new Object[0]).setCategory(this.getViewerId()).build();){
            this.fDirty.incrementAndGet();
            TmfCommonXLineChartViewer.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Throwable throwable = null;
                    Object var2_3 = null;
                    try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:CreatingUpdateThread", new Object[0]).setParentScope(parentScope).build();){
                        TmfCommonXLineChartViewer.this.newUpdateThread(scope);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected static final double[] getXAxis(long start, long end, int nb) {
        long steps = end - start;
        int nbVals = nb;
        if (steps < (long)nb && (nbVals = (int)steps) <= 0) {
            nbVals = 1;
        }
        double step = (double)steps / (double)nbVals;
        double[] timestamps = new double[nbVals];
        double curTime = 1.0;
        int i = 0;
        while (i < nbVals) {
            timestamps[i] = curTime;
            curTime += step;
            ++i;
        }
        return timestamps;
    }

    protected final void setXAxis(double @NonNull [] xaxis) {
        this.fModelBuilder.setXValues(xaxis);
    }

    private void extractXYModelAndUpdateViewModel(ITmfCommonXAxisModel model) {
        long[] xValuesRequested = model.getXAxis();
        double[] xValuesToDisplay = new double[xValuesRequested.length];
        long offset = this.getTimeOffset();
        int i = 0;
        while (i < xValuesRequested.length) {
            xValuesToDisplay[i] = xValuesRequested[i] - offset;
            ++i;
        }
        this.setXAxis(xValuesToDisplay);
        Map yData = model.getYData();
        for (Map.Entry entry : yData.entrySet()) {
            this.setSeries((String)entry.getKey(), ((IYModel)entry.getValue()).getData());
        }
    }

    protected void updateData(long start, long end, int nb, IProgressMonitor monitor) {
        TimeQueryFilter filters = this.createQueryFilter(start, end, nb);
        this.updateData(filters, monitor);
    }

    protected @NonNull TimeQueryFilter createQueryFilter(long start, long end, int nb) {
        return new TimeQueryFilter(start, end, nb);
    }

    private void updateData(@NonNull TimeQueryFilter filters, IProgressMonitor monitor) {
        if (this.fXYDataProvider == null) {
            TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.WARNING, (String)"Data provider for this viewer is not available", (Object[])new Object[0]);
            return;
        }
        boolean isComplete = false;
        do {
            ITmfResponse.Status status;
            TmfModelResponse response;
            ITmfCommonXAxisModel model;
            if ((model = (ITmfCommonXAxisModel)(response = this.fXYDataProvider.fetchXY(filters, monitor)).getModel()) != null) {
                this.extractXYModelAndUpdateViewModel(model);
                this.updateDisplay();
            }
            if ((status = response.getStatus()) == ITmfResponse.Status.COMPLETED) {
                isComplete = true;
                continue;
            }
            if (status == ITmfResponse.Status.FAILED || status == ITmfResponse.Status.CANCELLED) {
                TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.WARNING, (String)response.getStatusMessage(), (Object[])new Object[0]);
                isComplete = true;
                continue;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.INFO, (String)e.getMessage(), (Object[])new Object[0]);
            }
        } while (!isComplete);
    }

    protected void setSeries(String seriesName, double[] seriesValues) {
        Objects.requireNonNull(seriesName, "Series name cannot be null");
        Objects.requireNonNull(seriesValues, "Series values cannot be null");
        String seriesType = this.getSeriesType(seriesName);
        this.fModelBuilder.addYSeries((IYSeries)new YSeries(seriesType, this.getSeriesColor(seriesName), this.getWidth(seriesName), this.getSeriesStyle(seriesType), seriesName, seriesValues));
    }

    protected int getWidth(@NonNull String seriesName) {
        return 1;
    }

    protected @NonNull String getSeriesType(@NonNull String seriesName) {
        return "line";
    }

    protected @Nullable String getSeriesColor(@NonNull String seriesName) {
        return (String)Iterables.get(SYSTEM_COLORS.keySet(), (int)(this.getModel().getSeries().size() % SYSTEM_COLORS.size()));
    }

    protected @Nullable String getSeriesStyle(@NonNull String seriesType) {
        return TmfCommonXLineChartViewer.getLineStyle(seriesType, this.getModel().getSeries().size());
    }

    @Deprecated
    protected ILineSeries addSeries(String seriesName) {
        if (seriesName == null) {
            return null;
        }
        IYSeries ySeries = this.getModel().findSeries(seriesName);
        if (ySeries != null && ySeries.getSeriesType() == "bar") {
            return null;
        }
        return (ILineSeries)this.addSeries2(seriesName);
    }

    protected ISeries addSeries2(String seriesName) {
        if (seriesName == null) {
            return null;
        }
        ISeriesSet seriesSet = this.getSwtChart().getSeriesSet();
        int seriesCount = seriesSet.getSeries().length;
        ICommonXAxisModel currentModel = this.getModel();
        IYSeries ySeries = currentModel.findSeries(seriesName);
        if (ySeries == null) {
            this.setSeries(seriesName, new double[currentModel.getXAxis().length]);
            currentModel = this.getModel();
            ySeries = currentModel.findSeries(seriesName);
        }
        if (ySeries == null) {
            return null;
        }
        String colorTxt = ySeries.getColor();
        org.eclipse.swt.graphics.Color color = this.getColor(seriesName, colorTxt);
        if (ySeries.getSeriesType() == "bar") {
            IBarSeries barSeries = (IBarSeries)seriesSet.createSeries(ISeries.SeriesType.BAR, seriesName);
            barSeries.enableStack(true);
            barSeries.setBarColor(color);
            barSeries.setBarPadding(0);
            barSeries.setVisible(true);
            return barSeries;
        }
        ILineSeries lineSeries = (ILineSeries)seriesSet.createSeries(ISeries.SeriesType.LINE, seriesName);
        boolean isScatter = "scatter".equals(ySeries.getSeriesType());
        lineSeries.enableArea("area".equals(ySeries.getSeriesType()));
        lineSeries.setLineStyle(!isScatter ? LINE_STYLES.get(TmfCommonXLineChartViewer.getLineStyle(ySeries.getSeriesType(), seriesCount)) : LineStyle.NONE);
        lineSeries.setSymbolType(isScatter ? ILineSeries.PlotSymbolType.DIAMOND : ILineSeries.PlotSymbolType.NONE);
        lineSeries.setLineColor(color);
        lineSeries.setVisible(true);
        return lineSeries;
    }

    private org.eclipse.swt.graphics.Color getColor(String seriesName, String colorTxt) {
        org.eclipse.swt.graphics.Color color;
        org.eclipse.swt.graphics.Color sysColor = SYSTEM_COLORS.get(colorTxt);
        if (sysColor != null) {
            return sysColor;
        }
        RGB rgb = X11Color.toRGB(colorTxt);
        if (rgb == null) {
            rgb = TmfCommonXLineChartViewer.parseX11Rgb(colorTxt);
        }
        if (rgb == null) {
            rgb = TmfCommonXLineChartViewer.parseWebRgb(colorTxt);
        }
        if (rgb != null) {
            color = new org.eclipse.swt.graphics.Color((Device)Display.getDefault(), rgb);
            this.fColors.put(seriesName, color);
        } else {
            color = Display.getDefault().getSystemColor(2);
        }
        return color;
    }

    private static RGB parseWebRgb(String colorTxt) {
        Color elem = Color.decode(colorTxt);
        if (elem != null) {
            return new RGB(elem.getRed(), elem.getGreen(), elem.getBlue());
        }
        return null;
    }

    private static RGB parseX11Rgb(String colorTxt) {
        Matcher matcher = PATTERN.matcher(colorTxt);
        if (matcher.matches()) {
            int r = Integer.parseInt(matcher.group(1));
            int g = Integer.parseInt(matcher.group(2));
            int b = Integer.parseInt(matcher.group(3));
            return new RGB(r, g, b);
        }
        return null;
    }

    private static String getLineStyle(String seriesType, int seriesCount) {
        if (!"scatter".equals(seriesType)) {
            String[] styleStrings = LINE_STYLES.keySet().toArray(new String[LINE_STYLES.size()]);
            return styleStrings[seriesCount / SYSTEM_COLORS.size() % styleStrings.length];
        }
        return "none";
    }

    protected void deleteSeries(String seriesName) {
        org.eclipse.swt.graphics.Color color;
        ISeriesSet seriesSet = this.getSwtChart().getSeriesSet();
        ISeries series = seriesSet.getSeries(seriesName);
        if (series != null) {
            seriesSet.deleteSeries(series.getId());
        }
        if ((color = this.fColors.get(seriesName)) != null) {
            color.dispose();
        }
        this.fModelBuilder.deleteSeries(seriesName);
    }

    protected void updateDisplay() {
        this.updateDisplay(this.getModel());
    }

    protected void updateDisplay(ICommonXAxisModel model) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (final TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:UpdateDisplayRequested", new Object[0]).setCategory(this.getViewerId()).build();){
            final ICommonXAxisModel seriesValues = model;
            this.fDirty.incrementAndGet();
            Display.getDefault().asyncExec(new Runnable(){
                final TmfChartTimeStampFormat tmfChartTimeStampFormat;
                {
                    this.tmfChartTimeStampFormat = new TmfChartTimeStampFormat(TmfCommonXLineChartViewer.this.getTimeOffset());
                }

                /*
                 * Unable to fully structure code
                 */
                @Override
                public void run() {
                    try {
                        var1_1 = null;
                        var2_3 = null;
                        try {
                            log = new TraceCompassLogUtils.FlowScopeLogBuilder(TmfCommonXLineChartViewer.access$0(), Level.FINE, "CommonXLineChart:UpdateDisplay", new Object[0]).setParentScope(scope).build();
                            try {
                                if (!TmfCommonXLineChartViewer.access$4(TmfCommonXLineChartViewer.this).isDisposed()) {
                                    xValues = seriesValues.getXAxis();
                                    maxy = 4.9E-324;
                                    miny = 1.7976931348623157E308;
                                    end = TmfCommonXLineChartViewer.this.getWindowEndTime() - TmfCommonXLineChartViewer.this.getWindowStartTime();
                                    if (end > 0.0) {
                                        for (IYSeries entry : seriesValues.getSeries().values()) {
                                            series = TmfCommonXLineChartViewer.access$4(TmfCommonXLineChartViewer.this).getSeriesSet().getSeries(entry.getLabel());
                                            if (series == null) {
                                                series = TmfCommonXLineChartViewer.this.addSeries2(entry.getLabel());
                                            }
                                            if (series == null) {
                                                while (true) {
                                                    if (TmfCommonXLineChartViewer.access$1(TmfCommonXLineChartViewer.this).decrementAndGet() < 0) {
                                                        Activator.getDefault().logError("Dirty underflow error", new Throwable());
                                                    }
                                                    return;
                                                }
                                            }
                                            series.setXSeries(xValues);
                                            var18_19 = entry.getDatapoints();
                                            var17_17 = var18_19.length;
                                            var16_16 = 0;
                                            while (var16_16 < var17_17) {
                                                value = var18_19[var16_16];
                                                maxy = Math.max(maxy, value);
                                                miny = Math.min(miny, value);
                                                ++var16_16;
                                            }
                                            series.setYSeries(entry.getDatapoints());
                                        }
                                        if (maxy == 4.9E-324) {
                                            maxy = 1.0;
                                        }
                                    } else {
                                        TmfCommonXLineChartViewer.this.clearContent();
                                        end = 1.0;
                                    }
                                    xTick = TmfCommonXLineChartViewer.access$4(TmfCommonXLineChartViewer.this).getAxisSet().getXAxis(0).getTick();
                                    xTick.setFormat((Format)this.tmfChartTimeStampFormat);
                                    start = 0.0;
                                    TmfCommonXLineChartViewer.access$4(TmfCommonXLineChartViewer.this).getAxisSet().getXAxis(0).setRange(new Range(0.0, end));
                                    if (maxy > miny) {
                                        TmfCommonXLineChartViewer.access$4(TmfCommonXLineChartViewer.this).getAxisSet().getYAxis(0).setRange(new Range(miny, maxy));
                                    }
                                    TmfCommonXLineChartViewer.access$4(TmfCommonXLineChartViewer.this).redraw();
                                    if (TmfCommonXLineChartViewer.this.isSendTimeAlignSignals()) {
                                        viewPos = TmfCommonXLineChartViewer.this.getParent().getParent().toDisplay(0, 0);
                                        axisPos = TmfCommonXLineChartViewer.access$4((TmfCommonXLineChartViewer)TmfCommonXLineChartViewer.this).toDisplay((int)0, (int)0).x + TmfCommonXLineChartViewer.this.getPointAreaOffset();
                                        timeAxisOffset = axisPos - viewPos.x;
                                        timeAlignmentInfo = new TmfTimeViewAlignmentInfo(TmfCommonXLineChartViewer.this.getControl().getShell(), viewPos, timeAxisOffset);
                                        TmfSignalManager.dispatchSignal((TmfSignal)new TmfTimeViewAlignmentSignal(TmfCommonXLineChartViewer.this, timeAlignmentInfo, true));
                                    }
                                }
                            }
                            finally {
                                if (log == null) ** continue;
                                log.close();
                            }
                        }
                        catch (Throwable var2_4) {
                            if (var1_1 == null) {
                                var1_1 = var2_4;
                            } else if (var1_1 != var2_4) {
                                var1_1.addSuppressed(var2_4);
                            }
                            throw var1_1;
                        }
                    }
                    finally {
                        if (TmfCommonXLineChartViewer.access$1(TmfCommonXLineChartViewer.this).decrementAndGet() < 0) {
                            Activator.getDefault().logError("Dirty underflow error", new Throwable());
                        }
                    }
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void createSeries() {
    }

    @Override
    protected void clearContent() {
        this.getSwtChart().getAxisSet().getXAxis(0).getTick().setFormat(null);
        super.clearContent();
    }

    @Override
    public boolean isDirty() {
        return super.isDirty() || this.fDirty.get() != 0;
    }

    static /* synthetic */ Chart access$4(TmfCommonXLineChartViewer tmfCommonXLineChartViewer) {
        return tmfCommonXLineChartViewer.getSwtChart();
    }

    private class UpdateThread
    extends Thread {
        private final IProgressMonitor fMonitor;
        private final int fNumRequests;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull TraceCompassLogUtils.FlowScopeLog fScope;

        public UpdateThread(@NonNull int numRequests, TraceCompassLogUtils.FlowScopeLog log) {
            super("Line chart update");
            this.fNumRequests = numRequests;
            this.fMonitor = new NullProgressMonitor();
            this.fScope = log;
        }

        @Override
        public void run() {
            Throwable throwable = null;
            Object var2_3 = null;
            try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:UpdateThread", new Object[]{"numRequests=", this.fNumRequests}).setParentScope(this.fScope).build();){
                try {
                    TmfCommonXLineChartViewer.this.updateData(TmfCommonXLineChartViewer.this.getWindowStartTime(), TmfCommonXLineChartViewer.this.getWindowEndTime(), this.fNumRequests, this.fMonitor);
                }
                finally {
                    if (TmfCommonXLineChartViewer.this.fDirty.decrementAndGet() < 0) {
                        Activator.getDefault().logError(TmfCommonXLineChartViewer.DIRTY_UNDERFLOW_ERROR, new Throwable());
                    }
                }
                TmfCommonXLineChartViewer.this.updateThreadFinished(this);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        public void cancel() {
            TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.FINE, (String)"CommonXLineChart:UpdateThreadCanceled", (Object[])new Object[0]);
            this.fMonitor.setCanceled(true);
        }
    }
}

