/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.tests.inputoutput;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.InputOutputAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.InputOutputInformationProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.inputoutput.AbstractTestInputOutput;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.LinuxTestCase;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.inputoutput.IoTestFactory;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class InputOutputInformationProviderTest
extends AbstractTestInputOutput {
    private final LinuxTestCase fTestCase;
    private final int fDiskCount;

    public InputOutputInformationProviderTest(String testName, LinuxTestCase test, int diskCount) {
        this.fTestCase = test;
        this.fDiskCount = diskCount;
    }

    @After
    public void tearDown() {
        super.deleteTrace();
    }

    @Override
    protected @NonNull InputOutputAnalysisModule setUp(String fileName) {
        InputOutputAnalysisModule module = super.setUp(fileName);
        TmfTestHelper.executeAnalysis((IAnalysisModule)module);
        return module;
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        return Arrays.asList({IoTestFactory.SIMPLE_REQUESTS.getTraceFileName(), IoTestFactory.SIMPLE_REQUESTS, 1}, {IoTestFactory.SIMPLE_NO_STATEDUMP.getTraceFileName(), IoTestFactory.SIMPLE_NO_STATEDUMP, 1}, {IoTestFactory.TWO_DEVICES.getTraceFileName(), IoTestFactory.TWO_DEVICES, 3});
    }

    @Test
    public void testGetDisks() {
        InputOutputAnalysisModule module = this.setUp(this.fTestCase.getTraceFileName());
        Collection disks = InputOutputInformationProvider.getDisks((InputOutputAnalysisModule)module);
        Assert.assertEquals((long)this.fDiskCount, (long)disks.size());
    }
}

