/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.tests.kernelmemoryusage;

import java.io.File;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelmemoryusage.KernelMemoryAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.Activator;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.trace.TmfXmlKernelTraceStub;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KernelMemoryStateProviderTest {
    private static final String KERNEL_MEMORY_USAGE_FILE = "testfiles/KernelMemoryAnalysis_testTrace.xml";
    private static final long PAGE_SIZE = 4096L;
    private ITmfTrace fTrace;
    private KernelMemoryAnalysisModule fModule = null;
    private SortedMap<Long, Long> threadEvent = new TreeMap<Long, Long>();

    private static void deleteSuppFiles(ITmfTrace trace) {
        File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
        File[] fileArray = suppDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
    }

    @Before
    public void setUp() {
        TmfXmlKernelTraceStub trace = new TmfXmlKernelTraceStub();
        IPath filePath = Activator.getAbsoluteFilePath(KERNEL_MEMORY_USAGE_FILE);
        IStatus status = trace.validate(null, filePath.toOSString());
        if (!status.isOK()) {
            Assert.fail((String)status.getException().getMessage());
        }
        try {
            trace.initTrace(null, filePath.toOSString(), TmfEvent.class);
        }
        catch (TmfTraceException e) {
            Assert.fail((String)e.getMessage());
        }
        KernelMemoryStateProviderTest.deleteSuppFiles((ITmfTrace)trace);
        ((TmfTrace)trace).traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
        this.fModule = (KernelMemoryAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelMemoryAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.core.kernelmemory");
        Assert.assertNotNull((Object)this.fModule);
        this.fTrace = trace;
    }

    @After
    public void tearDown() {
        KernelMemoryStateProviderTest.deleteSuppFiles(this.fTrace);
        this.fTrace.dispose();
    }

    @Test
    public void testAnalysisExecution() {
        Assert.assertNull((Object)this.fModule.getStateSystem());
        Assert.assertTrue((boolean)TmfTestHelper.executeAnalysis((IAnalysisModule)this.fModule));
        Assert.assertNotNull((Object)this.fModule.getStateSystem());
    }

    @Test
    public void testAllocationDeallocationMemory() {
        this.fModule.schedule();
        this.fModule.waitForCompletion();
        ITmfStateSystem ss = this.fModule.getStateSystem();
        Assert.assertNotNull((Object)ss);
        Assert.assertEquals((long)1L, (long)ss.getStartTime());
        Assert.assertEquals((long)30L, (long)ss.getCurrentEndTime());
        long totalMemory = 0L;
        this.threadEvent.put(1L, 4096L);
        this.threadEvent.put(2L, -4096L);
        this.threadEvent.put(3L, -4096L);
        this.threadEvent.put(17L, 16384L);
        this.threadEvent.put(22L, -4096L);
        this.threadEvent.put(28L, -4096L);
        this.threadEvent.put(29L, 4096L);
        this.threadEvent.put(30L, 4096L);
        for (Map.Entry<Long, Long> entry : this.threadEvent.entrySet()) {
            try {
                int tidQuark = ss.getQuarkAbsolute(new String[]{"other"});
                ITmfStateInterval kernelState = ss.querySingleState(entry.getKey().longValue(), tidQuark);
                long value = kernelState.getStateValue().unboxLong();
                Assert.assertEquals((long)(totalMemory += entry.getValue().longValue()), (long)value);
            }
            catch (AttributeNotFoundException | StateSystemDisposedException e) {
                Assert.fail((String)e.getMessage());
            }
        }
    }
}

