/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.ui.swtbot.tests.memoryusage;

import java.io.IOException;
import java.net.URL;
import java.util.DoubleSummaryStatistics;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBotAssert;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBotControl;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.kernelmemoryusage.KernelMemoryUsageView;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.swtchart.Chart;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;
import org.swtchart.Range;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class KernelMemoryUsageTest {
    private static final String TRACE_TYPE = "org.eclipse.linuxtools.lttng2.kernel.tracetype";
    private static final String PROJECT_NAME = "test";
    private static final String VIEW_ID = "org.eclipse.tracecompass.analysis.os.linux.ui.kernelmemoryusageview";
    private static final Logger fLogger = Logger.getRootLogger();
    private Chart fChart;
    private KernelMemoryUsageView fKernelMemoryUsageView = null;

    @BeforeClass
    public static void beforeClass() {
        SWTBotUtils.initialize();
        Thread.currentThread().setName("SWTBotTest");
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        SWTBotUtils.closeView((String)"welcome", (SWTWorkbenchBot)bot);
        SWTBotUtils.switchToTracingPerspective();
        WaitUtils.waitForJobs();
    }

    @Before
    public void setupView() throws SecurityException, IllegalArgumentException {
        SWTBotUtils.openView((String)VIEW_ID);
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        SWTBotView viewBot = bot.viewById(VIEW_ID);
        final IViewReference viewReference = viewBot.getViewReference();
        IViewPart viewPart = (IViewPart)UIThreadRunnable.syncExec((Result)new Result<IViewPart>(){

            public IViewPart run() {
                return viewReference.getView(true);
            }
        });
        Assert.assertNotNull((Object)viewPart);
        if (!(viewPart instanceof KernelMemoryUsageView)) {
            Assert.fail((String)"Could not instanciate view");
        }
        this.fKernelMemoryUsageView = (KernelMemoryUsageView)viewPart;
        this.fChart = (Chart)viewBot.bot().widget(WidgetOfType.widgetOfType(Chart.class));
        Assert.assertNotNull((Object)this.fChart);
    }

    @After
    public void closeView() {
        SWTWorkbenchBot swtWorkbenchBot = new SWTWorkbenchBot();
        SWTBotView viewBot = swtWorkbenchBot.viewById(VIEW_ID);
        viewBot.close();
    }

    @Test
    public void testWithTrace() throws IOException, SecurityException, IllegalArgumentException {
        String tracePath = FileLocator.toFileURL((URL)CtfTestTrace.ARM_64_BIT_HEADER.getTraceURL()).getPath();
        long rangeStart = 1412670961274443542L;
        long rangeEnd = 1412670961298823940L;
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        SWTBotView view = bot.viewById(VIEW_ID);
        view.close();
        bot.waitUntil(ConditionHelpers.ViewIsClosed((SWTBotView)view));
        SWTBotUtils.createProject((String)PROJECT_NAME);
        SWTBotUtils.openTrace((String)PROJECT_NAME, (String)tracePath, (String)TRACE_TYPE);
        WaitUtils.waitForJobs();
        this.setupView();
        WaitUtils.waitForJobs();
        Chart chart = this.fChart;
        Assert.assertNotNull((Object)chart);
        bot.waitUntil(ConditionHelpers.numberOfSeries((Chart)chart, (int)1));
        SWTBotChart chartBot = new SWTBotChart(chart);
        SWTBotAssert.assertVisible((AbstractSWTBot)chartBot);
        Assert.assertEquals((Object)"", (Object)chartBot.getToolTipText());
        @NonNull TmfTimeRange traceWindowRange = TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange();
        Assert.assertEquals((String)"Unexpected trace window range", (long)100000000L, (long)(traceWindowRange.getEndTime().getValue() - traceWindowRange.getStartTime().getValue()));
        Range range = chart.getAxisSet().getXAxes()[0].getRange();
        Assert.assertEquals((String)"Unexpected X-axis range", (double)1.0E8, (double)(range.upper - range.lower), (double)0.0);
        ISeriesSet seriesSet = this.fChart.getSeriesSet();
        Assert.assertNotNull((Object)seriesSet);
        ISeries[] series = seriesSet.getSeries();
        Assert.assertNotNull((Object)series);
        TmfTimeRange windowRange = new TmfTimeRange(TmfTimestamp.fromNanos((long)rangeStart), TmfTimestamp.fromNanos((long)rangeEnd));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, windowRange));
        bot.waitUntil(ConditionHelpers.xyViewerIsReadyCondition((TmfXYChartViewer)this.fKernelMemoryUsageView.getChartViewer()));
        range = chart.getAxisSet().getXAxes()[0].getRange();
        Assert.assertEquals((double)(rangeEnd - rangeStart), (double)(range.upper - range.lower), (double)0.0);
        Assert.assertEquals((long)1L, (long)series.length);
        int i = 0;
        while (i < series.length) {
            Assert.assertTrue((boolean)(series[i] instanceof ILineSeries));
            ++i;
        }
        DoubleSummaryStatistics stats = new DoubleSummaryStatistics();
        double[] dArray = series[0].getYSeries();
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double data = dArray[n2];
            stats.accept(data);
            ++n2;
        }
        Assert.assertEquals((double)839680.0, (double)stats.getMin(), (double)1.0);
        Assert.assertEquals((double)929792.0, (double)stats.getMax(), (double)1.0);
        Assert.assertEquals((double)870849.823129, (double)stats.getAverage(), (double)1000.0);
        bot.closeAllEditors();
        SWTBotUtils.deleteProject((String)PROJECT_NAME, (SWTWorkbenchBot)bot);
    }

    private static class SWTBotChart
    extends AbstractSWTBotControl<Chart> {
        public SWTBotChart(Chart w) throws WidgetNotFoundException {
            super((Control)w);
        }
    }
}

