/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.perf.analysis.kernel;

import java.io.File;
import java.util.List;
import java.util.Random;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelThreadInformationProvider;
import org.eclipse.tracecompass.lttng2.kernel.core.trace.LttngKernelTrace;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.junit.Assert;
import org.junit.Test;

public class KernelAnalysisUsageBenchmark {
    private static final String TEST_GET_RUNNING_THREAD = "Kernel: Threads On CPU";
    private static final String TEST_FULL_QUERIES = "Kernel: Full Queries";
    private static final int LOOP_COUNT = 25;
    private static final long SEED = 65423897234L;
    private static final int NUM_CPU_QUERIES = 20000;
    private static final int NUM_FULL_QUERIES = 20000;

    @Test
    public void testTrace2() {
        KernelAnalysisUsageBenchmark.runTest(CtfTestTrace.TRACE2, "Trace2");
    }

    @Test
    public void testManyThreads() {
        KernelAnalysisUsageBenchmark.runTest(CtfTestTrace.MANY_THREADS, "ManyThreads");
    }

    @Test
    public void testDjangoHttpd() {
        KernelAnalysisUsageBenchmark.runTest(CtfTestTrace.DJANGO_HTTPD, "Django httpd");
    }

    private static KernelAnalysisModule getModule(@NonNull CtfTestTrace testTrace, @NonNull LttngKernelTrace trace) {
        KernelAnalysisModule module = null;
        String path = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)testTrace).getPath();
        try {
            module = new KernelAnalysisModule();
            module.setId("test");
            trace.initTrace(null, path, CtfTmfEvent.class);
            module.setTrace((ITmfTrace)trace);
            TmfTestHelper.executeAnalysis((IAnalysisModule)module);
        }
        catch (TmfAnalysisException | TmfTraceException e) {
            Assert.fail((String)e.getMessage());
        }
        return module;
    }

    private static void deleteSupplementaryFiles(ITmfTrace trace) {
        File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
        File[] fileArray = suppDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
    }

    private static void runTest(@NonNull CtfTestTrace testTrace, String testName) {
        LttngKernelTrace trace = new LttngKernelTrace();
        KernelAnalysisUsageBenchmark.deleteSupplementaryFiles((ITmfTrace)trace);
        KernelAnalysisModule module = KernelAnalysisUsageBenchmark.getModule(testTrace, trace);
        KernelAnalysisUsageBenchmark.benchmarkGetThreadOnCpu(testName, module);
        KernelAnalysisUsageBenchmark.benchmarkFullQueries(testName, module);
        KernelAnalysisUsageBenchmark.deleteSupplementaryFiles((ITmfTrace)trace);
        module.dispose();
        trace.dispose();
        CtfTmfTestTraceUtils.dispose((CtfTestTrace)testTrace);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void benchmarkGetThreadOnCpu(String testName, KernelAnalysisModule module) {
        Integer threadOnCpu;
        Performance perf = Performance.getDefault();
        PerformanceMeter pmRunningThread = perf.createPerformanceMeter("org.eclipse.linuxtools#LTTng kernel analysis#" + testName + ": " + TEST_GET_RUNNING_THREAD);
        perf.tagAsSummary(pmRunningThread, "Kernel: Threads On CPU(" + testName + ')', Dimension.CPU_TIME);
        @Nullable ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            Assert.fail((String)"The state system is null");
            return;
        }
        int cpuCount = -1;
        try {
            int cpusQuark = ss.getQuarkAbsolute(new String[]{"CPUs"});
            @NonNull @NonNull List cpus = ss.getSubAttributes(cpusQuark, false);
            cpuCount = cpus.size();
        }
        catch (AttributeNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        if (cpuCount < 1) {
            Assert.fail((String)"Impossible to get the number of CPUs");
        }
        long startTime = ss.getStartTime();
        long endTime = ss.getCurrentEndTime();
        long step = Math.floorDiv(endTime - startTime, 20000L);
        if (step < 1L) {
            Assert.fail((String)"Trace is too short to run the get thread on CPU benchmark");
        }
        if ((threadOnCpu = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)0L, (long)endTime)) == null) {
            Assert.fail((String)"null thread on CPU at the end of the trace. Something is not right with the state system");
        }
        int i = 0;
        while (i < 25) {
            Random randomGenerator = new Random(65423897234L);
            pmRunningThread.start();
            long nextTime = startTime;
            while (nextTime < endTime) {
                int cpu = Math.abs(randomGenerator.nextInt()) % cpuCount;
                KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)cpu, (long)nextTime);
                nextTime += step;
            }
            pmRunningThread.stop();
            ++i;
        }
        pmRunningThread.commit();
    }

    private static void benchmarkFullQueries(String testName, KernelAnalysisModule module) {
        Performance perf = Performance.getDefault();
        PerformanceMeter pmRunningThread = perf.createPerformanceMeter("org.eclipse.linuxtools#LTTng kernel analysis#" + testName + ": " + TEST_FULL_QUERIES);
        perf.tagAsSummary(pmRunningThread, "Kernel: Full Queries(" + testName + ')', Dimension.CPU_TIME);
        @Nullable ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            Assert.fail((String)"The state system is null");
            return;
        }
        long startTime = ss.getStartTime();
        long endTime = ss.getCurrentEndTime();
        long step = Math.floorDiv(endTime - startTime, 20000L);
        if (step < 1L) {
            Assert.fail((String)"Trace is too short to run the get full queries benchmark");
        }
        int i = 0;
        while (i < 25) {
            pmRunningThread.start();
            long nextTime = startTime;
            while (nextTime < endTime) {
                try {
                    ss.queryFullState(nextTime);
                }
                catch (StateSystemDisposedException e) {
                    Assert.fail((String)e.getMessage());
                }
                nextTime += step;
            }
            pmRunningThread.stop();
            ++i;
        }
        pmRunningThread.commit();
    }
}

