/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.io.diskioactivity.DiskIOActivityView;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.XYDataProviderBaseTest;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXLineChartViewer;
import org.eclipse.ui.IViewPart;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.swtchart.Chart;
import org.swtchart.ISeries;
import org.swtchart.LineStyle;

@Ignore(value="Intermittent failure in test cases. Fixed in master branch")
public class DisksIOViewTest
extends XYDataProviderBaseTest {
    private static final RGB RED = new RGB(255, 0, 0);
    private static final RGB BLUE = new RGB(0, 0, 255);
    private static final int NUMBER_OF_POINT = 50;
    private static final int MORE_POINTS = 100;
    private static final @NonNull String TITLE = "Disk I/O View";
    private static final @NonNull String READ_SERIES_NAME = "8,0 read";
    private static final @NonNull String WRITE_SERIES_NAME = "8,0 write";
    private static final @NonNull ITmfTimestamp START_TIME_WHERE_THERE_IS_DISK_ACTIVITY = TmfTimestamp.fromNanos((long)1332170686646030906L);
    private static final @NonNull ITmfTimestamp END_TIME_WHERE_THERE_IS_DISK_ACTIVITY = TmfTimestamp.fromNanos((long)1332170686658688158L);

    @Test
    public void testDiskView() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        IViewPart viewSite = this.getSWTBotView().getViewReference().getView(true);
        Assert.assertTrue((boolean)(viewSite instanceof DiskIOActivityView));
        TmfCommonXLineChartViewer chartViewer = DisksIOViewTest.getChartViewer((IViewPart)viewSite);
        Assert.assertNotNull((Object)chartViewer);
        fBot.waitUntil(ConditionHelpers.xyViewerIsReadyCondition((TmfXYChartViewer)chartViewer));
        Chart chart = this.getChart();
        Assert.assertNotNull((Object)chart);
        WaitUtils.waitUntil(c -> c.getSeriesSet().getSeries().length > 0, (Object)chart, (String)"No data available");
        chartViewer.setNbPoints(50);
        WaitUtils.waitUntil(json -> this.isChartDataValid(chart, (String)json, new String[]{WRITE_SERIES_NAME}), (Object)"resources/disk0-res50.json", (String)"Chart data is not valid");
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, new TmfTimeRange(START_TIME_WHERE_THERE_IS_DISK_ACTIVITY, END_TIME_WHERE_THERE_IS_DISK_ACTIVITY)));
        fBot.waitUntil(ConditionHelpers.windowRange((TmfTimeRange)new TmfTimeRange(START_TIME_WHERE_THERE_IS_DISK_ACTIVITY, END_TIME_WHERE_THERE_IS_DISK_ACTIVITY)));
        fBot.waitUntil(ConditionHelpers.xyViewerIsReadyCondition((TmfXYChartViewer)chartViewer));
        this.verifyChartStyle();
        WaitUtils.waitUntil(json -> this.isChartDataValid(chart, (String)json, new String[]{WRITE_SERIES_NAME}), (Object)"resources/disk1-res50.json", (String)"Chart data is not valid");
        chartViewer.setNbPoints(100);
        this.verifyChartStyle();
        WaitUtils.waitUntil(json -> this.isChartDataValid(chart, (String)json, new String[]{WRITE_SERIES_NAME}), (Object)"resources/disk2-res100.json", (String)"Chart data is not valid");
    }

    private void verifyChartStyle() {
        this.verifySeriesStyle(READ_SERIES_NAME, ISeries.SeriesType.LINE, BLUE, LineStyle.SOLID, true);
        this.verifySeriesStyle(WRITE_SERIES_NAME, ISeries.SeriesType.LINE, RED, LineStyle.SOLID, true);
    }

    protected String getMainSeriesName() {
        return READ_SERIES_NAME;
    }

    protected String getTitle() {
        return TITLE;
    }

    protected String getViewID() {
        return "org.eclipse.tracecompass.analysis.os.linux.views.diskioactivity";
    }

    protected ITmfTrace getTestTrace() {
        return CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.KERNEL);
    }
}

