/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.kernelmemoryusage.KernelMemoryUsageView;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.XYDataProviderBaseTest;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXLineChartViewer;
import org.eclipse.ui.IViewPart;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.swtchart.Chart;
import org.swtchart.ISeries;
import org.swtchart.LineStyle;

@Ignore(value="Intermittent failure in test cases. Fixed in master branch")
public class KernelMemoryUsageViewTest
extends XYDataProviderBaseTest {
    private static final @NonNull String TOTAL_SERIES_NAME = "Total";
    private static final @NonNull String TITLE = "Relative Kernel Memory Usage";
    private static final RGB RED = new RGB(255, 0, 0);
    private static final RGB BLUE = new RGB(0, 0, 255);
    private static final int NUMBER_OF_POINT = 50;
    private static final int MORE_POINTS = 100;

    @Test
    public void testKernelMemoryView() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        IViewPart viewSite = this.getSWTBotView().getViewReference().getView(true);
        Assert.assertTrue((boolean)(viewSite instanceof KernelMemoryUsageView));
        TmfCommonXLineChartViewer chartViewer = KernelMemoryUsageViewTest.getChartViewer((IViewPart)viewSite);
        Assert.assertNotNull((Object)chartViewer);
        fBot.waitUntil(ConditionHelpers.xyViewerIsReadyCondition((TmfXYChartViewer)chartViewer));
        Chart chart = this.getChart();
        Assert.assertNotNull((Object)chart);
        WaitUtils.waitUntil(c -> c.getSeriesSet().getSeries().length > 0, (Object)chart, (String)"No data available");
        chartViewer.setNbPoints(50);
        this.verifyChartStyle(null);
        WaitUtils.waitUntil(json -> this.isChartDataValid(chart, (String)json, new String[0]), (Object)"resources/kernel-memory-res50.json", (String)"Chart data is not valid");
        String selectedThread = "496";
        SWTBotTree treeBot = this.getSWTBotView().bot().tree();
        WaitUtils.waitUntil(tree -> tree.rowCount() >= 5, (Object)treeBot, (String)"Did not finish loading");
        treeBot.getTreeItem(selectedThread).click();
        chartViewer.setNbPoints(100);
        WaitUtils.waitUntil(c -> c.getSeriesSet().getSeries().length >= 2, (Object)chart, (String)"Only total available");
        this.verifyChartStyle(selectedThread);
        WaitUtils.waitUntil(json -> this.isChartDataValid(chart, (String)json, new String[]{selectedThread}), (Object)"resources/kernel-memory-res100Selected.json", (String)"Chart data is not valid");
    }

    private void verifyChartStyle(String selectedThread) {
        this.verifySeriesStyle(TOTAL_SERIES_NAME, ISeries.SeriesType.LINE, BLUE, LineStyle.SOLID, false);
        if (selectedThread != null) {
            this.verifySeriesStyle(selectedThread, ISeries.SeriesType.LINE, RED, LineStyle.SOLID, false);
        }
    }

    protected @NonNull String getMainSeriesName() {
        return TOTAL_SERIES_NAME;
    }

    protected @NonNull String getTitle() {
        return TITLE;
    }

    protected String getViewID() {
        return "org.eclipse.tracecompass.analysis.os.linux.ui.kernelmemoryusageview";
    }

    protected ITmfTrace getTestTrace() {
        return CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.ARM_64_BIT_HEADER);
    }
}

