/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.swtbot.swt.finder.utils.FileUtils;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.analysis.os.linux.core.signals.TmfCpuSelectedSignal;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage.CpuUsageView;
import org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests.KernelTestBase;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.viewmodel.ICommonXAxisModel;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXLineChartViewer;
import org.eclipse.tracecompass.tmf.ui.views.TmfChartView;
import org.eclipse.ui.IViewPart;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.swtchart.Chart;

@Ignore(value="Intermittent failure in test cases. Fixed in master branch")
public class ResourcesAndCpuViewTest
extends KernelTestBase {
    private SWTBotView fViewBotRv;
    private SWTBotView fViewBotCpu;

    @Override
    @Before
    public void before() {
        this.fViewBotRv = fBot.viewByPartName("Resources");
        SWTBotUtils.openView((String)"org.eclipse.tracecompass.analysis.os.linux.views.cpuusage");
        this.fViewBotCpu = fBot.viewById("org.eclipse.tracecompass.analysis.os.linux.views.cpuusage");
        this.fViewBotCpu.show();
        this.fViewBotRv.show();
        try {
            SWTBotUtils.openTrace((String)"test", (String)Paths.get(FileLocator.toFileURL((URL)CtfTestTrace.ARM_64_BIT_HEADER.getTraceURL()).toURI()).toString(), (String)"org.eclipse.linuxtools.lttng2.kernel.tracetype");
        }
        catch (IOException | URISyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
        SWTBotUtils.activateEditor((SWTWorkbenchBot)fBot, (String)"bug446190");
        this.fViewBotRv.setFocus();
    }

    @Test
    public void testSignals() {
        Widget widget = this.fViewBotRv.getWidget();
        Assert.assertNotNull((Object)widget);
        ITmfTrace activeTrace = TmfTraceManager.getInstance().getActiveTrace();
        Assert.assertNotNull((Object)activeTrace);
        TmfCpuSelectedSignal signal = new TmfCpuSelectedSignal((Object)widget, -1, activeTrace);
        ResourcesAndCpuViewTest.broadcast((TmfSignal)signal);
        Assert.assertEquals((String)"Before signal - CPU Usage Title", (Object)"CPU Usage", (Object)this.getTitle());
        Assert.assertEquals((String)"Before signal - Thread Table", (long)12L, (long)this.getTableCount());
        this.fViewBotRv.setFocus();
        signal = new TmfCpuSelectedSignal((Object)widget, 1, activeTrace);
        ResourcesAndCpuViewTest.broadcast((TmfSignal)signal);
        Assert.assertEquals((String)"After signal - CPU Usage Title", (Object)"CPU Usage 1", (Object)this.getTitle());
        Assert.assertEquals((String)"After signal - Thread Table", (long)4L, (long)this.getTableCount());
        signal = new TmfCpuSelectedSignal((Object)widget, 3, activeTrace);
        ResourcesAndCpuViewTest.broadcast((TmfSignal)signal);
        Assert.assertEquals((String)"After signal 2 - CPU Usage Title", (Object)"CPU Usage 1, 3", (Object)this.getTitle());
        Assert.assertEquals((String)"After signal 2 - Thread Table", (long)8L, (long)this.getTableCount());
        signal = new TmfCpuSelectedSignal((Object)widget, -1, activeTrace);
        ResourcesAndCpuViewTest.broadcast((TmfSignal)signal);
        Assert.assertEquals((String)"After signal clear - CPU Usage Title", (Object)"CPU Usage", (Object)this.getTitle());
        Assert.assertEquals((String)"After signal clear - Thread Table", (long)12L, (long)this.getTableCount());
    }

    @Test
    public void testCpuView() {
        IViewPart viewSite = this.fViewBotCpu.getViewReference().getView(true);
        Assert.assertTrue((boolean)(viewSite instanceof CpuUsageView));
        TmfCommonXLineChartViewer chartViewer = ResourcesAndCpuViewTest.getChartViewer(viewSite);
        Assert.assertNotNull((Object)chartViewer);
        try {
            WaitUtils.waitUntil(viewer -> !viewer.getModel().getSeries().isEmpty(), (Object)chartViewer, (String)"No data available");
            chartViewer.setNbPoints(10);
            ICondition xyViewerIsReadyCondition = ConditionHelpers.xyViewerIsReadyCondition((TmfXYChartViewer)chartViewer);
            fBot.waitUntil(xyViewerIsReadyCondition);
            UIThreadRunnable.syncExec(() -> ((TmfCommonXLineChartViewer)chartViewer).refresh());
            String jsonT0 = FileUtils.read((String)"resources/t0-res10.json");
            ICommonXAxisModel model = chartViewer.getModel();
            Assert.assertEquals((Object)jsonT0, (Object)model.toString());
            SWTBotTree treeBot = this.fViewBotCpu.bot().tree();
            WaitUtils.waitUntil(tree -> tree.rowCount() >= 7, (Object)treeBot, (String)"Did not finish loading");
            treeBot.getTreeItem("496").click();
            WaitUtils.waitUntil(viewer -> viewer.getModel().getSeries().size() > 1, (Object)chartViewer, (String)"Only total available");
            UIThreadRunnable.syncExec(() -> chartViewer.refresh());
            String jsonT1 = FileUtils.read((String)"resources/t0-res10Selected.json");
            fBot.waitUntil(xyViewerIsReadyCondition);
            model = chartViewer.getModel();
            Assert.assertEquals((Object)jsonT1, (Object)model.toString());
            chartViewer.setNbPoints(100);
            UIThreadRunnable.syncExec(() -> chartViewer.refresh());
            WaitUtils.waitUntil(viewer -> viewer.getModel().getXAxis().length >= 99, (Object)chartViewer, (String)"Too few elements");
            String jsonHD = FileUtils.read((String)"resources/t0-res100Selected.json");
            fBot.waitUntil(xyViewerIsReadyCondition);
            model = chartViewer.getModel();
            Assert.assertEquals((Object)jsonHD, (Object)model.toString());
            chartViewer.setNbPoints(10);
            ITmfTrace activeTrace = TmfTraceManager.getInstance().getActiveTrace();
            Assert.assertNotNull((Object)activeTrace);
            this.fViewBotRv.getToolbarButtons().stream().filter(button -> button.getToolTipText().contains("Reset")).findAny().get().click();
            String jsonAll = FileUtils.read((String)"resources/tAll-res10.json");
            fBot.waitUntil(xyViewerIsReadyCondition);
            model = chartViewer.getModel();
            Assert.assertEquals((Object)jsonAll, (Object)model.toString());
        }
        finally {
            chartViewer.setNbPoints(0);
        }
    }

    private static TmfCommonXLineChartViewer getChartViewer(IViewPart viewSite) {
        try {
            CpuUsageView cpuView = (CpuUsageView)viewSite;
            Method viewer = TmfChartView.class.getDeclaredMethod("getChartViewer", new Class[0]);
            viewer.setAccessible(true);
            TmfCommonXLineChartViewer chartViewer = (TmfCommonXLineChartViewer)viewer.invoke((Object)cpuView, new Object[0]);
            return chartViewer;
        }
        catch (Exception e) {
            Assert.fail((String)("Reflection error: " + e.getMessage()));
            return null;
        }
    }

    private static void broadcast(TmfSignal signal) {
        UIThreadRunnable.syncExec(() -> TmfSignalManager.dispatchSignal((TmfSignal)signal));
        WaitUtils.waitForJobs();
    }

    private String getTitle() {
        this.fViewBotCpu.setFocus();
        Matcher matcher = WidgetOfType.widgetOfType(Chart.class);
        Chart chart = (Chart)this.fViewBotCpu.bot().widget(matcher);
        return chart.getTitle().getText();
    }

    private int getTableCount() {
        this.fViewBotCpu.setFocus();
        Matcher matcher = WidgetOfType.widgetOfType(Tree.class);
        SWTBotTree treeBot = new SWTBotTree((Tree)this.fViewBotCpu.bot().widget(matcher));
        int count = 0;
        SWTBotTreeItem[] sWTBotTreeItemArray = treeBot.getAllItems();
        int n = sWTBotTreeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem bot = sWTBotTreeItemArray[n2];
            String text = bot.getText();
            if (!text.isEmpty()) {
                ++count;
            }
            ++n2;
        }
        return count;
    }
}

