/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests;

import java.io.IOException;
import java.net.URL;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotTimeGraph;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public abstract class TimegraphViewExpandStateTestBase {
    private static final String FLIPPING_ENDIANNESS = "flipping-endianness";
    private static final String BUG446190 = "bug446190";
    protected static final String KERNEL_TRACE_TYPE = "org.eclipse.linuxtools.lttng2.kernel.tracetype";
    protected static final String KERNEL_PERSPECTIVE_ID = "org.eclipse.linuxtools.lttng2.kernel.ui.perspective";
    protected static final String TRACE_PROJECT_NAME = "test";
    protected static SWTWorkbenchBot fBot;
    private static final Logger fLogger;

    static {
        fLogger = Logger.getRootLogger();
    }

    @BeforeClass
    public static void beforeClass() throws IOException {
        SWTBotUtils.initialize();
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView((String)"welcome", (SWTWorkbenchBot)fBot);
        SWTBotUtils.switchToPerspective((String)KERNEL_PERSPECTIVE_ID);
        SWTBotUtils.createProject((String)TRACE_PROJECT_NAME);
        WaitUtils.waitForJobs();
        String tracePath1 = FileLocator.toFileURL((URL)CtfTestTrace.ARM_64_BIT_HEADER.getTraceURL()).getPath();
        SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)tracePath1, (String)KERNEL_TRACE_TYPE);
        String tracePath2 = FileLocator.toFileURL((URL)CtfTestTrace.FLIPPING_ENDIANNESS.getTraceURL()).getPath();
        SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)tracePath2, (String)KERNEL_TRACE_TYPE);
    }

    @AfterClass
    public static void afterClass() {
        SWTBotUtils.deleteProject((String)TRACE_PROJECT_NAME, (SWTWorkbenchBot)fBot);
        fLogger.removeAllAppenders();
    }

    @Before
    public void before() {
        SWTBotUtils.openView((String)this.getViewId());
    }

    @After
    public void after() {
        fBot.closeAllEditors();
        SWTBotUtils.closeSecondaryShells((SWTWorkbenchBot)fBot);
    }

    private SWTBotView getViewBot() {
        return fBot.viewByTitle(this.getViewTitle());
    }

    protected abstract String getViewId();

    protected abstract String getViewTitle();

    protected abstract String[] getItemLabel();

    @Test
    public void testExpandedState() {
        SWTBotTimeGraph timegraphBot = new SWTBotTimeGraph(this.getViewBot().bot());
        SWTBotUtils.activateEditor((SWTWorkbenchBot)fBot, (String)BUG446190);
        WaitUtils.waitUntil(root -> timegraphBot.getEntries()[0].getText().equals(root), (Object)BUG446190, (String)"Failed to activate editor bug446190");
        timegraphBot.expandAll();
        int count1 = timegraphBot.getExpandedElementCount();
        String[] stringArray = this.getItemLabel();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            timegraphBot.expandEntry(false, new String[]{BUG446190, label});
            ++n2;
        }
        int count2 = timegraphBot.getExpandedElementCount();
        Assert.assertTrue((String)("Expanded entries count sould be less than " + count1 + " but actual value is " + count2), (count2 < count1 ? 1 : 0) != 0);
        int count3 = TimegraphViewExpandStateTestBase.switchBetweenTraces(timegraphBot);
        Assert.assertEquals((String)("Expanded entries count is " + count3 + " but it should be " + count2), (long)count2, (long)count3);
        timegraphBot.collapseAll();
        int count4 = TimegraphViewExpandStateTestBase.switchBetweenTraces(timegraphBot);
        Assert.assertTrue((String)("Expanded entries count sould be less than " + count3 + " but actual value is " + count4), (count4 < count3 ? 1 : 0) != 0);
        int count5 = TimegraphViewExpandStateTestBase.switchBetweenTraces(timegraphBot);
        Assert.assertEquals((String)("Expanded entries count is " + count5 + " but it should be " + count4), (long)count4, (long)count5);
    }

    private static int switchBetweenTraces(SWTBotTimeGraph timegraphBot) {
        SWTBotUtils.activateEditor((SWTWorkbenchBot)fBot, (String)FLIPPING_ENDIANNESS);
        WaitUtils.waitUntil(root -> timegraphBot.getEntries()[0].getText().equals(root), (Object)FLIPPING_ENDIANNESS, (String)"Failed to activate editor flipping-endianness");
        SWTBotUtils.activateEditor((SWTWorkbenchBot)fBot, (String)BUG446190);
        WaitUtils.waitUntil(root -> timegraphBot.getEntries()[0].getText().equals(root), (Object)BUG446190, (String)"Failed to activate editor bug446190");
        return timegraphBot.getExpandedElementCount();
    }
}

