/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.ui.swtbot.tests;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.tracecompass.internal.lttng2.ust.ui.views.memusage.MemoryUsageView;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.XYDataProviderBaseTest;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXLineChartViewer;
import org.eclipse.ui.IViewPart;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.swtchart.Chart;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;
import org.swtchart.LineStyle;

@Ignore(value="Intermittent failure in test cases. Fixed in master branch")
@RunWith(value=SWTBotJunit4ClassRunner.class)
public class MemoryUsageViewTest
extends XYDataProviderBaseTest {
    private static final int EXPECTED_NUM_SERIES = 4;
    private static final RGB RED = new RGB(255, 0, 0);
    private static final RGB BLUE = new RGB(0, 0, 255);
    private static final RGB GREEN = new RGB(0, 255, 0);
    private static final RGB MAGENTA = new RGB(255, 0, 255);
    private static final @NonNull String TITLE = "Relative Kernel Memory Usage";
    private static final @NonNull String FIRST_SERIES_NAME = "challenger (10611)";
    private static final @NonNull String SECOND_SERIES_NAME = "master_player (10618)";
    private static final @NonNull String THIRD_SERIES_NAME = "challenger (10604)";
    private static final @NonNull String FOURTH_SERIES_NAME = "master_player (10613)";

    @Test
    public void testOpenMemoryUsage() {
        SWTBotView viewBot = fBot.viewById("org.eclipse.linuxtools.lttng2.ust.memoryusage");
        viewBot.setFocus();
        Matcher matcher = WidgetOfType.widgetOfType(Chart.class);
        Chart chart = (Chart)viewBot.bot().widget(matcher);
        fBot.waitUntil(ConditionHelpers.numberOfSeries((Chart)chart, (int)4));
        ISeriesSet seriesSet = chart.getSeriesSet();
        ISeries[] series = seriesSet.getSeries();
        int i = 0;
        while (i < series.length) {
            Assert.assertTrue((boolean)(series[i] instanceof ILineSeries));
            ++i;
        }
    }

    @Test
    public void testMemoryUsage() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        IViewPart viewSite = this.getSWTBotView().getViewReference().getView(true);
        Assert.assertTrue((boolean)(viewSite instanceof MemoryUsageView));
        TmfCommonXLineChartViewer chartViewer = MemoryUsageViewTest.getChartViewer((IViewPart)viewSite);
        Assert.assertNotNull((Object)chartViewer);
        fBot.waitUntil(ConditionHelpers.xyViewerIsReadyCondition((TmfXYChartViewer)chartViewer));
        Chart chart = this.getChart();
        Assert.assertNotNull((Object)chart);
        WaitUtils.waitUntil(c -> c.getSeriesSet().getSeries().length > 3, (Object)chart, (String)"No data available");
        chartViewer.setNbPoints(50);
        WaitUtils.waitUntil(json -> this.isChartDataValid(chart, (String)json, new String[]{SECOND_SERIES_NAME, THIRD_SERIES_NAME, FOURTH_SERIES_NAME}), (Object)"resources/memory-res50.json", (String)"Chart data is not valid");
        this.verifyChartStyle();
    }

    private void verifyChartStyle() {
        this.verifySeriesStyle(FIRST_SERIES_NAME, ISeries.SeriesType.LINE, BLUE, LineStyle.SOLID, false);
        this.verifySeriesStyle(SECOND_SERIES_NAME, ISeries.SeriesType.LINE, RED, LineStyle.SOLID, false);
        this.verifySeriesStyle(THIRD_SERIES_NAME, ISeries.SeriesType.LINE, GREEN, LineStyle.SOLID, false);
        this.verifySeriesStyle(FOURTH_SERIES_NAME, ISeries.SeriesType.LINE, MAGENTA, LineStyle.SOLID, false);
    }

    protected @NonNull String getMainSeriesName() {
        return FIRST_SERIES_NAME;
    }

    protected @NonNull String getTitle() {
        return TITLE;
    }

    protected String getViewID() {
        return "org.eclipse.linuxtools.lttng2.ust.memoryusage";
    }

    protected ITmfTrace getTestTrace() {
        return CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.MEMORY_ANALYSIS);
    }
}

