/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.stateprovider;

import java.nio.file.Paths;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternStateProvider;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.stateprovider.XmlProviderTestBase;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.junit.Assert;
import org.junit.Test;

public class PatternProvidersTest
extends XmlProviderTestBase {
    @Test(expected=IllegalArgumentException.class)
    public void testInvalidInput() {
        ITmfTrace trace = this.getTrace();
        Assert.assertNotNull((Object)trace);
        Assert.assertNotNull((Object)new XmlPatternStateProvider(trace, "Bla", Paths.get("", new String[0]), segment -> {}));
    }

    @Override
    protected CtfTestTrace getTestTrace() {
        return CtfTestTrace.ARM_64_BIT_HEADER;
    }

    @Override
    protected TmfXmlTestFiles getXmlFile() {
        return TmfXmlTestFiles.VALID_PATTERN_FILE;
    }

    @Override
    protected @NonNull String getAnalysisNodeName() {
        return "pattern";
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testSegmentStore() {
        Assert.assertTrue((boolean)this.getModule().waitForCompletion((IProgressMonitor)new NullProgressMonitor()));
        @NonNull ISegmentStore ss = ((ISegmentStoreProvider)this.getModule()).getSegmentStore();
        Assert.assertNotNull((Object)ss);
        Assert.assertFalse((boolean)ss.isEmpty());
    }
}

