/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.event;

import java.text.ParseException;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimePreferences;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.service.prefs.BackingStoreException;

public class TmfTimestampFormatTest {
    private static final String TEST_PATTERN = "HH:mm:ss.SSS";
    private static final TimeZone TEST_TIME_ZONE = TimeZone.getTimeZone(TimeZone.getAvailableIDs(0)[0]);
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final Locale CA = Locale.CANADA;
    private static final TmfTimestampFormat tsf = new TmfTimestampFormat("yyyy-MM-dd HH:mm:ss.SSSSSSSSS", GMT, CA);
    private static final TmfTimestampFormat tsf1 = new TmfTimestampFormat("HH:mm:ss.SSS");
    private static final TmfTimestampFormat tsf2 = new TmfTimestampFormat("HH:mm:ss.SSS", TEST_TIME_ZONE);

    @Test
    public void testDefaultConstructor() {
        TmfTimestampFormat ts0 = new TmfTimestampFormat();
        Assert.assertEquals((Object)"HH:mm:ss.SSS SSS SSS", (Object)ts0.toPattern());
    }

    @Test
    public void testValueConstructor() {
        Assert.assertEquals((Object)TEST_PATTERN, (Object)tsf1.toPattern());
    }

    @Test
    public void testValueTimeZoneConstructor() {
        Assert.assertEquals((Object)TEST_PATTERN, (Object)tsf2.toPattern());
        Assert.assertEquals((Object)TEST_TIME_ZONE, (Object)tsf2.getTimeZone());
    }

    @Test
    public void testUpdateDefaultFormats() {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.tracecompass.tmf.core");
        String dateTimeTestValue = "HH:mm:ss:";
        node.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.datime", dateTimeTestValue);
        String subSecTestValue = "SSS SSS SSS:";
        node.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.subsec", subSecTestValue);
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        TmfTimestampFormat.updateDefaultFormats();
        String expected = String.valueOf(dateTimeTestValue) + "." + subSecTestValue;
        String expected2 = "TTT." + subSecTestValue;
        Assert.assertEquals((Object)expected, (Object)TmfTimestampFormat.getDefaulTimeFormat().toPattern());
        Assert.assertEquals((Object)expected2, (Object)TmfTimestampFormat.getDefaulIntervalFormat().toPattern());
        node.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.datime", "HH:mm:ss");
        node.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.subsec", "SSS SSS SSS");
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        TmfTimestampFormat.updateDefaultFormats();
    }

    @Test
    public void testGetDefaulTimeFormat() {
        Assert.assertEquals((Object)TmfTimestampFormat.getDefaulTimeFormat().toPattern(), (Object)TmfTimePreferences.getTimePattern());
    }

    @Test
    public void testGetDefaulIntervalFormat() {
        Assert.assertEquals((Object)TmfTimestampFormat.getDefaulIntervalFormat().toPattern(), (Object)TmfTimePreferences.getIntervalPattern());
    }

    @Test
    public void testParseSeconds() throws ParseException {
        Assert.assertEquals((long)7777777777123456789L, (long)new TmfTimestampFormat("TTTTTTTTTT.SSSSSSSSS").parseValue("7777777777.123456789"));
        Assert.assertEquals((long)7777777777123456789L, (long)new TmfTimestampFormat("T.SSSSSSSSS").parseValue("7777777777.123456789"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("TTTTTTTTTT.SSSSSSSSS").parseValue("0000000007.123456789"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("TTTTTTTTTT.SSSSSSSSS").parseValue("7.123456789"));
        Assert.assertEquals((long)7123456780L, (long)new TmfTimestampFormat("TTTTTTTTTT.SSSSSSSSS").parseValue("7.12345678"));
        Assert.assertEquals((long)7123456700L, (long)new TmfTimestampFormat("TTTTTTTTTT.SSSSSSSSS").parseValue("7.1234567"));
        Assert.assertEquals((long)7123456000L, (long)new TmfTimestampFormat("TTTTTTTTTT.SSSSSSSSS").parseValue("7.123456"));
        Assert.assertEquals((long)7123450000L, (long)new TmfTimestampFormat("TTTTTTTTTT.SSSSSSSSS").parseValue("7.12345"));
        Assert.assertEquals((long)7123400000L, (long)new TmfTimestampFormat("TTTTTTTTTT.SSSSSSSSS").parseValue("7.1234"));
        Assert.assertEquals((long)7123000000L, (long)new TmfTimestampFormat("TTTTTTTTTT.SSSSSSSSS").parseValue("7.123"));
        Assert.assertEquals((long)7120000000L, (long)new TmfTimestampFormat("TTTTTTTTTT.SSSSSSSSS").parseValue("7.12"));
        Assert.assertEquals((long)7100000000L, (long)new TmfTimestampFormat("TTTTTTTTTT.SSSSSSSSS").parseValue("7.1"));
        Assert.assertEquals((long)7000000000L, (long)new TmfTimestampFormat("TTTTTTTTTT.SSSSSSSSS").parseValue("7."));
        Assert.assertEquals((long)7000000000L, (long)new TmfTimestampFormat("TTTTTTTTTT.SSSSSSSSS").parseValue("7"));
        Assert.assertEquals((long)123456789L, (long)new TmfTimestampFormat("TTTTTTTTTT.SSSSSSSSS").parseValue(".123456789"));
        Assert.assertEquals((long)123456789L, (long)new TmfTimestampFormat(".SSSSSSSSS").parseValue(".123456789"));
        Assert.assertEquals((long)123456780L, (long)new TmfTimestampFormat(".SSSSSSSS").parseValue(".123456789"));
        Assert.assertEquals((long)123456700L, (long)new TmfTimestampFormat(".SSSSSSS").parseValue(".123456789"));
        Assert.assertEquals((long)123456000L, (long)new TmfTimestampFormat(".SSSSSS").parseValue(".123456789"));
        Assert.assertEquals((long)123450000L, (long)new TmfTimestampFormat(".SSSSS").parseValue(".123456789"));
        Assert.assertEquals((long)123400000L, (long)new TmfTimestampFormat(".SSSS").parseValue(".123456789"));
        Assert.assertEquals((long)123000000L, (long)new TmfTimestampFormat(".SSS").parseValue(".123456789"));
        Assert.assertEquals((long)120000000L, (long)new TmfTimestampFormat(".SS").parseValue(".123456789"));
        Assert.assertEquals((long)100000000L, (long)new TmfTimestampFormat(".S").parseValue(".123456789"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("T.SSSSSSSSS").parseValue("7.123456789"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("T.SSS SSS SSS").parseValue("7.123 456 789"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("T.SSS SSS SSS").parseValue("7.123456789"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("T.SSS.SSS.SSS").parseValue("7.123.456.789"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("T.SSS.SSS.SSS").parseValue("7.123456789"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("T.SSS,SSS,SSS").parseValue("7.123,456,789"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("T.SSS,SSS,SSS").parseValue("7.123456789"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("T.SSS-SSS-SSS").parseValue("7.123-456-789"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("T.SSS-SSS-SSS").parseValue("7.123456789"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("T.SSS_SSS_SSS").parseValue("7.123_456_789"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("T.SSS_SSS_SSS").parseValue("7.123456789"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("T.SSS:SSS:SSS").parseValue("7.123:456:789"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("T.SSS:SSS:SSS").parseValue("7.123456789"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("T.SSS;SSS;SSS").parseValue("7.123;456;789"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("T.SSS;SSS;SSS").parseValue("7.123456789"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("T.SSS/SSS/SSS").parseValue("7.123/456/789"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("T.SSS/SSS/SSS").parseValue("7.123456789"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("T.SSS''SSS''SSS").parseValue("7.123'456'789"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("T.SSS''SSS''SSS").parseValue("7.123456789"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("T.SSS\"SSS\"SSS").parseValue("7.123\"456\"789"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("T.SSS\"SSS\"SSS").parseValue("7.123456789"));
        Assert.assertEquals((long)7000000000L, (long)new TmfTimestampFormat("T. SSSSSSSSS").parseValue("7..123456789"));
        Assert.assertEquals((long)7100000000L, (long)new TmfTimestampFormat("T.S SSSSSSSS").parseValue("7.1,23456789"));
        Assert.assertEquals((long)7120000000L, (long)new TmfTimestampFormat("T.SS SSSSSSS").parseValue("7.12-3456789"));
        Assert.assertEquals((long)7123000000L, (long)new TmfTimestampFormat("T.SSS SSSSSS").parseValue("7.123_456789"));
        Assert.assertEquals((long)7123400000L, (long)new TmfTimestampFormat("T.SSSS SSSSS").parseValue("7.1234:56789"));
        Assert.assertEquals((long)7123450000L, (long)new TmfTimestampFormat("T.SSSSS SSSS").parseValue("7.12345;6789"));
        Assert.assertEquals((long)7123456000L, (long)new TmfTimestampFormat("T.SSSSSS SSS").parseValue("7.123456/789"));
        Assert.assertEquals((long)7123456700L, (long)new TmfTimestampFormat("T.SSSSSSS SS").parseValue("7.1234567'89"));
        Assert.assertEquals((long)7123456780L, (long)new TmfTimestampFormat("T.SSSSSSSS S").parseValue("7.12345678\"9"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("T 's'.SSS ms SSS us SSS ns").parseValue("7 s.123 ms 456 us 789 ns"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("T 'S'.SSS 'MS' SSS 'US' SSS 'NS'").parseValue("7 S.123 MS 456 US 789 NS"));
        Assert.assertEquals((long)7123000000L, (long)new TmfTimestampFormat("T.SSSSSSSSS").parseValue("7 s.123 ms 456 ns 789"));
        Assert.assertEquals((long)0L, (long)new TmfTimestampFormat("T.").parseValue("0.123456789"));
        Assert.assertEquals((long)0L, (long)new TmfTimestampFormat("T.S").parseValue("."));
        Assert.assertEquals((long)0L, (long)new TmfTimestampFormat(".S").parseValue("7."));
        Assert.assertEquals((long)0L, (long)new TmfTimestampFormat("T.S").parseValue("-."));
        Assert.assertEquals((long)0L, (long)new TmfTimestampFormat("T.S").parseValue("-0"));
        Assert.assertEquals((long)-100000000L, (long)new TmfTimestampFormat("T.S").parseValue("-0.1"));
        Assert.assertEquals((long)-100000000L, (long)new TmfTimestampFormat("T.S").parseValue("-.1"));
        Assert.assertEquals((long)-7000000000L, (long)new TmfTimestampFormat("T.S").parseValue("-7"));
        Assert.assertEquals((long)-7000000000L, (long)new TmfTimestampFormat("T.S").parseValue("-7."));
        Assert.assertEquals((long)-7000000000L, (long)new TmfTimestampFormat("T.S").parseValue("-7.0"));
        Assert.assertEquals((long)-7100000000L, (long)new TmfTimestampFormat("T.S").parseValue("-7.1"));
    }

    @Test
    public void testUnitOfSecondsFormat() throws ParseException {
        Assert.assertEquals((Object)"000000071.234567890", (Object)new TmfTimestampFormat("TTTTTTTTTd.SSSSSSSSS").format(7123456789L));
        Assert.assertEquals((Object)"71.234567890", (Object)new TmfTimestampFormat("Td.SSSSSSSSS").format(7123456789L));
        Assert.assertEquals((Object)"71.23456789", (Object)new TmfTimestampFormat("Td.SSSSSSSS").format(7123456789L));
        Assert.assertEquals((Object)"000000712.345678900", (Object)new TmfTimestampFormat("TTTTTTTTTc.SSSSSSSSS").format(7123456789L));
        Assert.assertEquals((Object)"712.345678900", (Object)new TmfTimestampFormat("Tc.SSSSSSSSS").format(7123456789L));
        Assert.assertEquals((Object)"712.3456789", (Object)new TmfTimestampFormat("Tc.SSSSSSS").format(7123456789L));
        Assert.assertEquals((Object)"000007123.456789000", (Object)new TmfTimestampFormat("TTTTTTTTTm.SSSSSSSSS").format(7123456789L));
        Assert.assertEquals((Object)"7123.456789000", (Object)new TmfTimestampFormat("Tm.SSSSSSSSS").format(7123456789L));
        Assert.assertEquals((Object)"7123.456789", (Object)new TmfTimestampFormat("Tm.SSSSSS").format(7123456789L));
        Assert.assertEquals((Object)"007123456.789000000", (Object)new TmfTimestampFormat("TTTTTTTTTu.SSSSSSSSS").format(7123456789L));
        Assert.assertEquals((Object)"7123456.789000000", (Object)new TmfTimestampFormat("Tu.SSSSSSSSS").format(7123456789L));
        Assert.assertEquals((Object)"7123456.789", (Object)new TmfTimestampFormat("Tu.SSS").format(7123456789L));
        Assert.assertEquals((Object)"7123456789.000000000", (Object)new TmfTimestampFormat("TTTTTTTTTn.SSSSSSSSS").format(7123456789L));
        Assert.assertEquals((Object)"7123456789.000000000", (Object)new TmfTimestampFormat("Tn.SSSSSSSSS").format(7123456789L));
        Assert.assertEquals((Object)"7123456789", (Object)new TmfTimestampFormat("Tn").format(7123456789L));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("Td.SSSSSSSS").parseValue("71.23456789"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("Tc.SSSSSSS").parseValue("712.3456789"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("Tm.SSSSSS").parseValue("7123.456789"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("Tu.SSS").parseValue("7123456.789"));
        Assert.assertEquals((long)7123456789L, (long)new TmfTimestampFormat("Tn").parseValue("7123456789"));
        Assert.assertEquals((long)-100000L, (long)new TmfTimestampFormat("Tm.S").parseValue("-0.1"));
        Assert.assertEquals((long)-100000L, (long)new TmfTimestampFormat("Tm.S").parseValue("-.1"));
        Assert.assertEquals((long)-7000000L, (long)new TmfTimestampFormat("Tm.S").parseValue("-7"));
        Assert.assertEquals((long)-7000000L, (long)new TmfTimestampFormat("Tm.S").parseValue("-7."));
        Assert.assertEquals((long)-7000000L, (long)new TmfTimestampFormat("Tm.S").parseValue("-7.0"));
        Assert.assertEquals((long)-7100000L, (long)new TmfTimestampFormat("Tm.S").parseValue("-7.1"));
        Assert.assertEquals((Object)"9223372036854775807", (Object)new TmfTimestampFormat("Tn").format(Long.MAX_VALUE));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)new TmfTimestampFormat("Tn").parseValue("9223372036854775807"));
        Assert.assertEquals((Object)"-9223372036854775808", (Object)new TmfTimestampFormat("Tn").format(Long.MIN_VALUE));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)new TmfTimestampFormat("Tn").parseValue("-9223372036854775808"));
    }

    @Test
    public void testParseDateTime() throws ParseException {
        long time = new TmfTimestampFormat("yyyy", GMT, CA).parseValue("2014");
        Assert.assertEquals((Object)"2014-01-01 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("YYYY", GMT, CA).parseValue("2014");
        Assert.assertEquals((Object)"2013-12-29 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("MM", GMT, CA).parseValue("11");
        Assert.assertEquals((Object)"1970-11-01 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("ww", GMT, CA).parseValue("01");
        Assert.assertEquals((Object)"1969-12-28 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("DDD", GMT, CA).parseValue("100");
        Assert.assertEquals((Object)"1970-04-10 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("F", GMT, CA).parseValue("2");
        Assert.assertEquals((Object)"1970-01-11 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("EEE", GMT, CA).parseValue("Mon");
        Assert.assertEquals((Object)"1970-01-05 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("u", GMT, CA).parseValue("1");
        Assert.assertEquals((Object)"1970-01-05 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("dd", GMT, CA).parseValue("22");
        Assert.assertEquals((Object)"1970-01-22 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("HH", GMT, CA).parseValue("12");
        Assert.assertEquals((Object)"1970-01-01 12:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("kk", GMT, CA).parseValue("24");
        Assert.assertEquals((Object)"1970-01-01 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("KK", GMT, CA).parseValue("12");
        Assert.assertEquals((Object)"1970-01-01 12:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("hh", GMT, CA).parseValue("12");
        Assert.assertEquals((Object)"1970-01-01 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("mm", GMT, CA).parseValue("34");
        Assert.assertEquals((Object)"1970-01-01 00:34:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("ss", GMT, CA).parseValue("56");
        Assert.assertEquals((Object)"1970-01-01 00:00:56.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("yyyy-MM", GMT, CA).parseValue("2014-11");
        Assert.assertEquals((Object)"2014-11-01 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("yyyy-MM-dd", GMT, CA).parseValue("2014-11-22");
        Assert.assertEquals((Object)"2014-11-22 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("yyyy-MM-dd HH", GMT, CA).parseValue("2014-11-22 12");
        Assert.assertEquals((Object)"2014-11-22 12:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("yyyy-MM-dd HH:mm", GMT, CA).parseValue("2014-11-22 12:34");
        Assert.assertEquals((Object)"2014-11-22 12:34:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("yyyy-MM-dd HH:mm:ss", GMT, CA).parseValue("2014-11-22 12:34:56");
        Assert.assertEquals((Object)"2014-11-22 12:34:56.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("yyyy-MM-dd HH:mm:ss.SSS", GMT, CA).parseValue("2014-11-22 12:34:56.123");
        Assert.assertEquals((Object)"2014-11-22 12:34:56.123000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("yyyy-ww", GMT, CA).parseValue("2014-01");
        Assert.assertEquals((Object)"2013-12-29 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("yyyy-DDD", GMT, CA).parseValue("2014-100");
        Assert.assertEquals((Object)"2014-04-10 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("yyyy-MM-F", GMT, CA).parseValue("2014-11-2");
        Assert.assertEquals((Object)"2014-11-09 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("yyyy-MM-EEE", GMT, CA).parseValue("2014-11-Mon");
        Assert.assertEquals((Object)"2014-11-03 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("yyyy-MM-u", GMT, CA).parseValue("2014-11-1");
        Assert.assertEquals((Object)"2014-11-03 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("yyyy MM dd HH mm ss SSS SSS SSS", GMT, CA).parseValue("2014 11 22 12 34 56 123 456 789");
        Assert.assertEquals((Object)"2014-11-22 12:34:56.123456789", (Object)tsf.format(time));
        time = new TmfTimestampFormat("yyyy.MM.dd.HH.mm.ss.SSS.SSS.SSS", GMT, CA).parseValue("2014.11.22.12.34.56.123.456.789");
        Assert.assertEquals((Object)"2014-11-22 12:34:56.123456789", (Object)tsf.format(time));
        time = new TmfTimestampFormat("yyyy,MM,dd,HH,mm,ss,SSS,SSS,SSS", GMT, CA).parseValue("2014,11,22,12,34,56,123,456,789");
        Assert.assertEquals((Object)"2014-11-22 12:34:56.123456789", (Object)tsf.format(time));
        time = new TmfTimestampFormat("yyyy-MM-dd-HH-mm-ss-SSS-SSS-SSS", GMT, CA).parseValue("2014-11-22-12-34-56-123-456-789");
        Assert.assertEquals((Object)"2014-11-22 12:34:56.123456789", (Object)tsf.format(time));
        time = new TmfTimestampFormat("yyyy_MM_dd_HH_mm_ss_SSS_SSS_SSS", GMT, CA).parseValue("2014_11_22_12_34_56_123_456_789");
        Assert.assertEquals((Object)"2014-11-22 12:34:56.123456789", (Object)tsf.format(time));
        time = new TmfTimestampFormat("yyyy:MM:dd:HH:mm:ss:SSS:SSS:SSS", GMT, CA).parseValue("2014:11:22:12:34:56:123:456:789");
        Assert.assertEquals((Object)"2014-11-22 12:34:56.123456789", (Object)tsf.format(time));
        time = new TmfTimestampFormat("yyyy;MM;dd;HH;mm;ss;SSS;SSS;SSS", GMT, CA).parseValue("2014;11;22;12;34;56;123;456;789");
        Assert.assertEquals((Object)"2014-11-22 12:34:56.123456789", (Object)tsf.format(time));
        time = new TmfTimestampFormat("yyyy/MM/dd/HH/mm/ss/SSS/SSS/SSS", GMT, CA).parseValue("2014/11/22/12/34/56/123/456/789");
        Assert.assertEquals((Object)"2014-11-22 12:34:56.123456789", (Object)tsf.format(time));
        time = new TmfTimestampFormat("yyyy''MM''dd''HH''mm''ss''SSS''SSS''SSS", GMT, CA).parseValue("2014'11'22'12'34'56'123'456'789");
        Assert.assertEquals((Object)"2014-11-22 12:34:56.123456789", (Object)tsf.format(time));
        time = new TmfTimestampFormat("yyyy\"MM\"dd\"HH\"mm\"ss\"SSS\"SSS\"SSS", GMT, CA).parseValue("2014\"11\"22\"12\"34\"56\"123\"456\"789");
        Assert.assertEquals((Object)"2014-11-22 12:34:56.123456789", (Object)tsf.format(time));
        time = new TmfTimestampFormat("yyyy MM dd HH mm ss SSS SSS SSS", GMT, CA).parseValue("2014  11  22  12  34  56  123 456 789");
        Assert.assertEquals((Object)"2014-11-22 12:34:56.123456789", (Object)tsf.format(time));
        time = new TmfTimestampFormat("yyyy MM dd HH mm ss SSS SSS SSS", GMT, CA).parseValue("2014  1  2  3  4  5 123 456 789");
        Assert.assertEquals((Object)"2014-01-02 03:04:05.123456789", (Object)tsf.format(time));
        time = new TmfTimestampFormat("yyyy MM dd HH mm ss SSS SSS SSS", GMT, CA).parseValue("2014 \t 1 \t 2 \t 3 \t 4 \t 5 \t 123 456 789");
        Assert.assertEquals((Object)"2014-01-02 03:04:05.123456789", (Object)tsf.format(time));
        time = new TmfTimestampFormat("yyyy-MM-dd HH:mm:ss.SSS", GMT, CA).parseValue("1970-01-01 00:00:00.000");
        Assert.assertEquals((Object)"1970-01-01 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("yyyy-MM-dd HH:mm:ss.SSS", GMT, CA).parseValue("1969-12-31 23:59:59.123");
        Assert.assertEquals((Object)"1969-12-31 23:59:59.123000000", (Object)tsf.format(time));
    }

    @Test
    public void testParseDateTimeWithRef() throws ParseException {
        long ref = tsf.parseValue("2014-11-22 12:34:56.123456789");
        long time = new TmfTimestampFormat("yyyy", GMT, CA).parseValue("1970", ref);
        Assert.assertEquals((Object)"1970-01-01 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("YYYY", GMT, CA).parseValue("1970", ref);
        Assert.assertEquals((Object)"1969-12-28 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("MM", GMT, CA).parseValue("01", ref);
        Assert.assertEquals((Object)"2014-01-01 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("ww", GMT, CA).parseValue("01", ref);
        Assert.assertEquals((Object)"2014-01-04 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("DDD", GMT, CA).parseValue("1", ref);
        Assert.assertEquals((Object)"2014-01-01 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("F", GMT, CA).parseValue("2", ref);
        Assert.assertEquals((Object)"2014-11-08 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("EEE", GMT, CA).parseValue("Mon", ref);
        Assert.assertEquals((Object)"2014-11-17 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("u", GMT, CA).parseValue("1", ref);
        Assert.assertEquals((Object)"2014-11-17 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("dd", GMT, CA).parseValue("01", ref);
        Assert.assertEquals((Object)"2014-11-01 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("HH", GMT, CA).parseValue("00", ref);
        Assert.assertEquals((Object)"2014-11-22 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("kk", GMT, CA).parseValue("24", ref);
        Assert.assertEquals((Object)"2014-11-22 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("KK", GMT, CA).parseValue("00", ref);
        Assert.assertEquals((Object)"2014-11-22 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("hh", GMT, CA).parseValue("12", ref);
        Assert.assertEquals((Object)"2014-11-22 00:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("mm", GMT, CA).parseValue("00", ref);
        Assert.assertEquals((Object)"2014-11-22 12:00:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("ss", GMT, CA).parseValue("00", ref);
        Assert.assertEquals((Object)"2014-11-22 12:34:00.000000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat(".S", GMT, CA).parseValue(".9", ref);
        Assert.assertEquals((Object)"2014-11-22 12:34:56.900000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("T.S", GMT, CA).parseValue("8.9", ref);
        Assert.assertEquals((Object)"1970-01-01 00:00:08.900000000", (Object)tsf.format(time));
        time = new TmfTimestampFormat("T.S", GMT, CA).parseValue(".9", ref);
        Assert.assertEquals((Object)"1970-01-01 00:00:00.900000000", (Object)tsf.format(time));
    }
}

