/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.trace;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.counters.core.aspects.CounterAspect;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.TestAnalysis;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TmfTraceUtilsTest {
    private static final @NonNull TestEventAspect TEST_ASPECT = new TestEventAspect();
    private static final TmfTestTrace TEST_TRACE = TmfTestTrace.A_TEST_10K;
    private TmfTrace fTrace;
    private static final @NonNull Collection<ITmfEventAspect<?>> EVENT_ASPECTS;

    static {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new TmfCpuAspect(){

            public Integer resolve(ITmfEvent event) {
                return 1;
            }
        });
        builder.addAll((Iterable)TmfTrace.BASE_ASPECTS);
        EVENT_ASPECTS = builder.build();
    }

    @Before
    public void setUp() {
        try {
            this.fTrace = new TmfTraceStubWithAspects(TEST_TRACE.getFullPath());
            TmfSignalManager.deregister((Object)this.fTrace);
            this.fTrace.indexTrace(true);
        }
        catch (TmfTraceException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void tearDown() {
        this.fTrace.dispose();
        this.fTrace = null;
    }

    @Test
    public void testGetModulesByClass() {
        TestAnalysis module2;
        TmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        trace.traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
        Iterable testModules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, TestAnalysis.class);
        Assert.assertTrue((boolean)testModules.iterator().hasNext());
        int count = 0;
        for (TestAnalysis module2 : testModules) {
            Assert.assertNotNull((Object)((Object)module2));
            ++count;
        }
        Assert.assertTrue((count >= 2 ? 1 : 0) != 0);
        module2 = (TestAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, TestAnalysis.class, (String)"org.eclipse.linuxtools.tmf.core.tests.analysis.test");
        Assert.assertNotNull((Object)((Object)module2));
        IAnalysisModule traceModule = trace.getAnalysisModule("org.eclipse.linuxtools.tmf.core.tests.analysis.test");
        Assert.assertNotNull((Object)traceModule);
        Assert.assertEquals((Object)((Object)module2), (Object)traceModule);
    }

    @Test
    public void testResolveEventAspectsOfClassForEvent() {
        TmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        ITmfContext context = trace.seekEvent(0L);
        ITmfEvent event = trace.getNext(context);
        Assert.assertNotNull((Object)event);
        Object cpuObj = TmfTraceUtils.resolveEventAspectOfClassForEvent((ITmfTrace)trace, TmfCpuAspect.class, (ITmfEvent)event);
        Assert.assertNotNull((Object)cpuObj);
        Assert.assertEquals((Object)1, (Object)cpuObj);
    }

    @Test
    public void testResolveEventAspectsOfNameForEvent() {
        TmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        ITmfContext context = trace.seekEvent(0L);
        ITmfEvent event = trace.getNext(context);
        Assert.assertNotNull((Object)event);
        Object cpuObj = TmfTraceUtils.resolveAspectOfNameForEvent((ITmfTrace)trace, (String)"cpu", (ITmfEvent)event);
        Assert.assertNotNull((Object)cpuObj);
        Assert.assertEquals((Object)1, (Object)cpuObj);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testGetAspects() {
        TmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        @NonNull Iterable aspect = TmfTraceUtils.getEventAspects((ITmfTrace)trace, TestEventAspect.class);
        Assert.assertNotNull((Object)aspect);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)aspect));
        Assert.assertTrue((boolean)Iterables.contains((Iterable)aspect, (Object)TEST_ASPECT));
        @NonNull Iterable cpuAspect = TmfTraceUtils.getEventAspects((ITmfTrace)trace, TmfCpuAspect.class);
        Assert.assertNotNull((Object)cpuAspect);
        Assert.assertEquals((Object)"CPU", (Object)((ITmfEventAspect)cpuAspect.iterator().next()).getName());
        @NonNull Iterable badAspect = TmfTraceUtils.getEventAspects((ITmfTrace)trace, CounterAspect.class);
        Assert.assertNotNull((Object)badAspect);
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)badAspect));
    }

    @Test
    public void testAdditionalAspects() {
        TmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        ITmfContext context = trace.seekEvent(0L);
        ITmfEvent event = trace.getNext(context);
        Assert.assertNotNull((Object)event);
        Object obj = TmfTraceUtils.resolveEventAspectOfClassForEvent((ITmfTrace)trace, TestEventAspect.class, (ITmfEvent)event);
        Assert.assertNull((Object)obj);
        obj = TmfTraceUtils.resolveAspectOfNameForEvent((ITmfTrace)trace, (String)"test", (ITmfEvent)event);
        Assert.assertNull((Object)obj);
        Integer val = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)trace, TestEventAspect.class, (ITmfEvent)event);
        Assert.assertNull((Object)val);
        TmfTraceUtils.registerEventAspect((ITmfEventAspect)TEST_ASPECT);
        obj = TmfTraceUtils.resolveEventAspectOfClassForEvent((ITmfTrace)trace, TestEventAspect.class, (ITmfEvent)event);
        Assert.assertNotNull((Object)obj);
        Assert.assertEquals((Object)TestEventAspect.RESOLVED_VALUE, (Object)obj);
        obj = TmfTraceUtils.resolveAspectOfNameForEvent((ITmfTrace)trace, (String)"test", (ITmfEvent)event);
        Assert.assertNotNull((Object)obj);
        Assert.assertEquals((Object)TestEventAspect.RESOLVED_VALUE, (Object)obj);
        val = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)trace, TestEventAspect.class, (ITmfEvent)event);
        Assert.assertNotNull((Object)val);
        Assert.assertEquals((Object)TestEventAspect.RESOLVED_VALUE, (Object)val);
    }

    private static class TestEventAspect
    implements ITmfEventAspect<Integer> {
        public static final Integer RESOLVED_VALUE = 2;
        public static final @NonNull String ASPECT_NAME = "test";

        private TestEventAspect() {
        }

        public @NonNull String getName() {
            return ASPECT_NAME;
        }

        public @NonNull String getHelpText() {
            return ASPECT_NAME;
        }

        public @Nullable Integer resolve(@NonNull ITmfEvent event) {
            return RESOLVED_VALUE;
        }
    }

    private static class TmfTraceStubWithAspects
    extends TmfTraceStub {
        public TmfTraceStubWithAspects(String path) throws TmfTraceException {
            super(path, 1000, false, null);
        }

        public Iterable<ITmfEventAspect<?>> getEventAspects() {
            return EVENT_ASPECTS;
        }
    }
}

