/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.callstack;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.core.Activator;

public final class FunctionNameMapper {
    private static final Pattern REMOVE_ZEROS_PATTERN = Pattern.compile("^0+(?!$)");

    private FunctionNameMapper() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @Nullable Map<Long, String> mapFromNmTextFile(File mappingFile) {
        TreeMap<Long, String> map;
        block18: {
            map = new TreeMap<Long, String>();
            try {
                Throwable throwable = null;
                Object var3_6 = null;
                try {
                    FileReader fr = new FileReader(mappingFile);
                    try {
                        try (BufferedReader reader = new BufferedReader(fr);){
                            Pattern pattern = Pattern.compile("([0-9a-f]+)([\\s][a-zA-Z][\\s])(.+)");
                            String line = reader.readLine();
                            while (line != null) {
                                Matcher matcher = pattern.matcher(line);
                                if (matcher.find()) {
                                    long address = Long.parseLong(FunctionNameMapper.stripLeadingZeros(matcher.group(1)), 16);
                                    String name = matcher.group(3);
                                    map.put(address, name);
                                }
                                line = reader.readLine();
                            }
                        }
                        if (fr == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (fr == null) throw throwable;
                        fr.close();
                        throw throwable;
                    }
                    fr.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!map.isEmpty()) return ImmutableMap.copyOf(map);
        return null;
    }

    public static @Nullable Map<Long, String> mapFromBinaryFile(File file) {
        TreeMap<Long, String> map = new TreeMap<Long, String>();
        IBinaryParser.IBinaryObject binaryObject = FunctionNameMapper.getBinaryObject(file);
        if (binaryObject != null) {
            IBinaryParser.ISymbol[] symbols;
            IBinaryParser.ISymbol[] iSymbolArray = symbols = binaryObject.getSymbols();
            int n = symbols.length;
            int n2 = 0;
            while (n2 < n) {
                IBinaryParser.ISymbol symbol = iSymbolArray[n2];
                String address = symbol.getAddress().toHexAddressString();
                map.put(Long.decode(address), symbol.getName());
                ++n2;
            }
        }
        return ImmutableMap.copyOf(map);
    }

    private static String stripLeadingZeros(String address) {
        return REMOVE_ZEROS_PATTERN.matcher(address).replaceFirst("");
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable IBinaryParser.IBinaryObject getBinaryObject(File file) {
        Path filePath = new Path(file.toString());
        final ArrayList binaryParsers = new ArrayList();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.cdt.core.BinaryParser");
        Object object = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] children;
            IConfigurationElement element = object[n2];
            IConfigurationElement[] iConfigurationElementArray = children = element.getChildren("run");
            int n3 = children.length;
            int n4 = 0;
            while (n4 < n3) {
                final IConfigurationElement run = iConfigurationElementArray[n4];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        IBinaryParser binaryParser = (IBinaryParser)run.createExecutableExtension("class");
                        binaryParsers.add(binaryParser);
                    }

                    public void handleException(Throwable exception) {
                        Activator.logError("Error creating binary parser", exception);
                    }
                });
                ++n4;
            }
            ++n2;
        }
        int hintBufferSize = 0;
        for (IBinaryParser parser : binaryParsers) {
            if (parser.getHintBufferSize() <= hintBufferSize) continue;
            hintBufferSize = Math.max(hintBufferSize, parser.getHintBufferSize());
        }
        byte[] hintBuffer = new byte[hintBufferSize];
        if (hintBufferSize > 0) {
            try {
                Object object2 = null;
                object = null;
                try (FileInputStream is = new FileInputStream(file);){
                    int count = 0;
                    while (count < hintBufferSize) {
                        int bytesRead = ((InputStream)is).read(hintBuffer, count, hintBufferSize - count);
                        if (bytesRead < 0) break;
                        count += bytesRead;
                    }
                    if (count > 0 && count < hintBuffer.length) {
                        byte[] array = new byte[count];
                        System.arraycopy(hintBuffer, 0, array, 0, count);
                        hintBuffer = array;
                    }
                }
                catch (Throwable throwable) {
                    if (object2 == null) {
                        object2 = throwable;
                    } else if (object2 != throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                    throw object2;
                }
            }
            catch (IOException e) {
                Activator.logError("Error reading initial bytes of binary file", e);
                return null;
            }
        }
        for (IBinaryParser parser : binaryParsers) {
            if (!parser.isBinary(hintBuffer, (IPath)filePath)) continue;
            try {
                IBinaryParser.IBinaryFile binFile = parser.getBinary(hintBuffer, (IPath)filePath);
                if (!(binFile instanceof IBinaryParser.IBinaryObject)) continue;
                return (IBinaryParser.IBinaryObject)binFile;
            }
            catch (IOException e) {
                Activator.logError("Error parsing binary file", e);
            }
        }
        return null;
    }
}

