/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.actions;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.model.TmfImportHelper;
import org.eclipse.tracecompass.internal.tmf.ui.project.operations.SelectTracesOperation;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.core.util.Pair;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.tests.shared.ProjectModelTestData;
import org.eclipse.ui.PlatformUI;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SelectTracesOperationTest {
    private TmfExperimentElement fExperiment;
    private @NonNull TmfTraceElement[] fTraces = new TmfTraceElement[6];
    private TmfTraceElement[] fExpectedTimeRangeTraces = new TmfTraceElement[4];
    private final String EXPERIMENT_NAME = "test_select_trace";
    private static TmfProjectElement fProjectElement;
    private ITmfTimestamp fStartTimeRange;
    private ITmfTimestamp fEndTimeRange;

    @Before
    public void setUp() throws ParseException, CoreException {
        IProject project = TmfProjectRegistry.createProject((String)"Experiment Select Trace Test Project", null, null);
        fProjectElement = TmfProjectRegistry.getProject((IProject)project, (boolean)true);
        IFolder traceFolder = project.getFolder("Traces");
        ArrayList<Path> tracePaths = new ArrayList<Path>();
        tracePaths.add(new Path(TmfTestTrace.SYSLOG_1.getFullPath()));
        tracePaths.add(new Path(TmfTestTrace.SYSLOG_2.getFullPath()));
        tracePaths.add(new Path(TmfTestTrace.SYSLOG_3.getFullPath()));
        tracePaths.add(new Path(TmfTestTrace.SYSLOG_4.getFullPath()));
        tracePaths.add(new Path(TmfTestTrace.SYSLOG_5.getFullPath()));
        tracePaths.add(new Path(TmfTestTrace.SYSLOG_6.getFullPath()));
        for (IPath iPath : tracePaths) {
            IResource traceResource = TmfImportHelper.createLink((IFolder)traceFolder, (IPath)iPath, (String)iPath.lastSegment());
            traceResource.setPersistentProperty(TmfCommonConstants.TRACETYPE, "org.eclipse.linuxtools.tmf.tests.stubs.trace.text.testsyslog");
        }
        TmfTraceFolder tmfTraceFolder = fProjectElement.getTracesFolder();
        Assert.assertNotNull((Object)tmfTraceFolder);
        for (TmfTraceElement trace : tmfTraceFolder.getTraces()) {
            trace.refreshTraceType();
        }
        fProjectElement.refresh();
        int i = 0;
        while (i < this.fTraces.length) {
            this.fTraces[i] = Objects.requireNonNull((TmfTraceElement)tmfTraceFolder.getTraces().get(i));
            ++i;
        }
        i = 0;
        while (i < this.fExpectedTimeRangeTraces.length) {
            this.fExpectedTimeRangeTraces[i] = this.fTraces[i];
            ++i;
        }
        TmfTimestampFormat tmfTimestampFormat = new TmfTimestampFormat("yyyy-MM-dd HH:mm:ss");
        this.fStartTimeRange = TmfTimestamp.fromNanos((long)tmfTimestampFormat.parseValue("2017-01-01 02:00:00"));
        this.fEndTimeRange = TmfTimestamp.fromNanos((long)tmfTimestampFormat.parseValue("2017-01-01 05:05:00"));
        this.fExperiment = ProjectModelTestData.addExperiment(fProjectElement, "test_select_trace");
    }

    @After
    public void cleanUp() {
        TmfExperimentFolder experimentsFolder = fProjectElement.getExperimentsFolder();
        if (experimentsFolder != null) {
            IFolder experimentResource = this.fExperiment.getResource();
            IPath path = experimentResource.getLocation();
            if (path != null) {
                this.fExperiment.deleteSupplementaryFolder();
            }
            try {
                experimentResource.delete(true, null);
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Unable to delete experiment: " + this.fExperiment.getName(), (Throwable)e);
            }
        }
    }

    @Test
    public void testBasicOperation() throws Exception {
        Assert.assertNotNull((Object)this.fExperiment);
        Assert.assertNotNull((Object)this.fTraces);
        SelectTracesOperation selectTracesOperation = new SelectTracesOperation(Objects.requireNonNull(this.fExperiment), this.fTraces, new HashMap());
        PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)selectTracesOperation);
        this.validateTracesExperiment(false);
    }

    @Test
    public void testOperationTimeRange() throws Exception {
        Assert.assertNotNull((Object)this.fExperiment);
        Assert.assertNotNull((Object)this.fTraces);
        SelectTracesOperation selectTracesOperation = new SelectTracesOperation(Objects.requireNonNull(this.fExperiment), this.fTraces, new HashMap(), this.fStartTimeRange, this.fEndTimeRange);
        PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)selectTracesOperation);
        this.validateTracesExperiment(true);
    }

    private void validateTracesExperiment(boolean timeRangeFiltering) {
        List experimentTraces = this.fExperiment.getTraces();
        if (timeRangeFiltering) {
            Assert.assertEquals((long)this.fExpectedTimeRangeTraces.length, (long)experimentTraces.size());
            SelectTracesOperationTest.assertExperimentTraces(this.fExpectedTimeRangeTraces, experimentTraces);
        } else {
            Assert.assertEquals((long)experimentTraces.size(), (long)this.fTraces.length);
            SelectTracesOperationTest.assertExperimentTraces(this.fTraces, experimentTraces);
        }
    }

    private static void assertExperimentTraces(TmfTraceElement[] expectedTraces, List<TmfTraceElement> actualTraces) {
        HashMap<Pair, TmfTraceElement> expectedTracesMap = new HashMap<Pair, TmfTraceElement>();
        TmfTraceElement[] tmfTraceElementArray = expectedTraces;
        int n = expectedTraces.length;
        int n2 = 0;
        while (n2 < n) {
            TmfTraceElement traceElement = tmfTraceElementArray[n2];
            expectedTracesMap.put(new Pair((Object)traceElement.getName(), (Object)traceElement.getLocation()), traceElement);
            ++n2;
        }
        actualTraces.forEach(actualTraceElement -> Assert.assertNotNull(expectedTracesMap.get(new Pair((Object)actualTraceElement.getName(), (Object)actualTraceElement.getLocation()))));
    }
}

