/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.markers;

import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.tracecompass.internal.tmf.core.markers.Marker;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerSegment;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerSet;
import org.eclipse.tracecompass.internal.tmf.core.markers.SubMarker;
import org.eclipse.tracecompass.internal.tmf.ui.markers.ConfigurableMarkerEventSource;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.trace.AbstractTmfTraceAdapterFactory;
import org.eclipse.tracecompass.tmf.core.trace.ICyclesConverter;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceAdapterManager;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.eclipse.tracecompass.tmf.ui.markers.IMarkerReferenceProvider;
import org.eclipse.tracecompass.tmf.ui.markers.PeriodicMarkerEventSource;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEvent;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ConfigurableMarkerEventSourceTest {
    private static final int ALPHA = 10;
    private static final String COLOR_STR = "#010101";
    private static final RGBA COLOR = new RGBA(1, 1, 1, 10);
    private static final RGBA ODD_COLOR = new RGBA(1, 1, 1, 0);
    private static final String RED_STR = "red";
    private static final RGBA RED = new RGBA(255, 0, 0, 10);
    private static final String INVALID_STR = "invalid";
    private static final RGBA DEFAULT = new RGBA(0, 0, 0, 10);
    private static ITmfTrace fTrace;
    private static AbstractTmfTraceAdapterFactory fFactory;

    @BeforeClass
    public static void beforeClass() {
        fFactory = new TmfTraceStubAdapterFactory();
        TmfTraceAdapterManager.registerFactory((IAdapterFactory)fFactory, TmfTraceStub.class);
        fTrace = TmfTestTrace.A_TEST_10K.getTrace();
    }

    @AfterClass
    public static void afterClass() {
        if (fTrace != null) {
            fTrace.dispose();
        }
        TmfTraceAdapterManager.unregisterFactory((IAdapterFactory)fFactory);
        fFactory.dispose();
    }

    @Test
    public void test() {
        RGBA color;
        ConfigurableMarkerEventSource source = new ConfigurableMarkerEventSource(fTrace);
        MarkerSet set = new MarkerSet("name", "id");
        source.configure(set);
        Assert.assertEquals((long)0L, (long)source.getMarkerCategories().size());
        Marker.PeriodicMarker markerA = new Marker.PeriodicMarker("A", "A %d", "a", "ref.a", COLOR_STR, 10.0, "ms", Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(4L)), 20L, (RangeSet)ImmutableRangeSet.of((Range)Range.all()));
        set.addMarker((Marker)markerA);
        source.configure(set);
        Assert.assertEquals(Arrays.asList("A"), (Object)source.getMarkerCategories());
        List markerList = source.getMarkerList("A", 100000000L, 200000000L, 1L, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)13L, (long)markerList.size());
        int i = 0;
        while (i < markerList.size()) {
            long t = (long)(i + 9) * 10000000L;
            int index = i + 9 - 2;
            int labelIndex = index % 5;
            RGBA color2 = index % 2 == 0 ? COLOR : ODD_COLOR;
            ConfigurableMarkerEventSourceTest.validateMarker((IMarkerEvent)markerList.get(i), t, 10000000L, "A", String.format("A %d", labelIndex), color2);
            ++i;
        }
        SubMarker.SplitMarker markerB = new SubMarker.SplitMarker("B", "B %d", "b", COLOR_STR, Range.closed((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(1000L)), (RangeSet)ImmutableRangeSet.of((Range)Range.all()));
        markerA.addSubMarker((SubMarker)markerB);
        source.configure(set);
        Assert.assertEquals(Arrays.asList("A", "B"), (Object)source.getMarkerCategories());
        markerList = source.getMarkerList("B", 100000000L, 200000000L, 10000L, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)0L, (long)markerList.size());
        markerList = source.getMarkerList("B", 100000000L, 200000000L, 1L, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)10002L, (long)markerList.size());
        int i2 = 0;
        while (i2 < markerList.size()) {
            long t = (long)(i2 + 9999) * 10000L;
            int index = i2 + 9999 - 2000;
            int labelIndex = 1 + index % 1000;
            color = labelIndex % 2 == 0 ? COLOR : ODD_COLOR;
            ConfigurableMarkerEventSourceTest.validateMarker((IMarkerEvent)markerList.get(i2), t, 10000L, "B", String.format("B %d", labelIndex), color);
            ++i2;
        }
        Marker.PeriodicMarker markerC = new Marker.PeriodicMarker("C", "C %d", "c", "ref.c", COLOR_STR, 10.0, "cycles", Range.atLeast((Comparable)Long.valueOf(0L)), -10L, (RangeSet)ImmutableRangeSet.of((Range)Range.all()));
        set.addMarker((Marker)markerC);
        source.configure(set);
        Assert.assertEquals(Arrays.asList("A", "B", "C"), (Object)source.getMarkerCategories());
        markerList = source.getMarkerList("C", 1000L, 2000L, 1L, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)28L, (long)markerList.size());
        int i3 = 0;
        while (i3 < markerList.size()) {
            long t = (long)(i3 + 24) * 40L;
            int index = i3 + 24 - 25 + 1;
            color = index % 2 == 0 ? COLOR : ODD_COLOR;
            ConfigurableMarkerEventSourceTest.validateMarker((IMarkerEvent)markerList.get(i3), t, 40L, "C", String.format("C %d", index), color);
            ++i3;
        }
        Marker.PeriodicMarker markerD = new Marker.PeriodicMarker("D", "D %d", "d", "ref.d", COLOR_STR, 40.0, "ns", Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(49L)), 0L, (RangeSet)ImmutableRangeSet.builder().add(Range.closed((Comparable)Long.valueOf(30L), (Comparable)Long.valueOf(31L))).add(Range.singleton((Comparable)Long.valueOf(40L))).build());
        set.addMarker((Marker)markerD);
        source.configure(set);
        Assert.assertEquals(Arrays.asList("A", "B", "C", "D"), (Object)source.getMarkerCategories());
        markerList = source.getMarkerList("D", 0L, 4000L, 1L, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)6L, (long)markerList.size());
        int i4 = 0;
        long t = 0L;
        while (t < 4000L) {
            int index = (int)(t / 40L) % 50;
            if ((long)index == 30L || (long)index == 31L || (long)index == 40L) {
                IMarkerEvent marker = (IMarkerEvent)markerList.get(i4++);
                RGBA color3 = index % 2 == 0 ? COLOR : ODD_COLOR;
                ConfigurableMarkerEventSourceTest.validateMarker(marker, t, 40L, "D", String.format("D %d", index), color3);
            }
            t += 40L;
        }
        SubMarker.WeightedMarker markerE = new SubMarker.WeightedMarker("E");
        markerD.addSubMarker((SubMarker)markerE);
        MarkerSegment segmentE1 = new MarkerSegment("E1 %d", "e1", RED_STR, 2);
        markerE.addSegment(segmentE1);
        MarkerSegment segmentE2 = new MarkerSegment("E2 %d", "e2", "", 1);
        markerE.addSegment(segmentE2);
        MarkerSegment segmentE3 = new MarkerSegment("E3 %d", "e3", INVALID_STR, 3);
        markerE.addSegment(segmentE3);
        source.configure(set);
        Assert.assertEquals(Arrays.asList("A", "B", "C", "D", "E"), (Object)source.getMarkerCategories());
        markerList = source.getMarkerList("E", 0L, 2000L, 1L, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)6L, (long)markerList.size());
        i4 = 0;
        long t2 = 0L;
        while (t2 < 2000L) {
            int index = (int)(t2 / 40L) % 50;
            if ((long)index == 30L || (long)index == 31L || (long)index == 40L) {
                ConfigurableMarkerEventSourceTest.validateMarker((IMarkerEvent)markerList.get(i4++), t2, 13L, "E", String.format("E1 %d", 0), RED);
                ConfigurableMarkerEventSourceTest.validateMarker((IMarkerEvent)markerList.get(i4++), t2 + 20L, 20L, "E", String.format("E3 %d", 2), DEFAULT);
            }
            t2 += 40L;
        }
    }

    private static void validateMarker(IMarkerEvent marker, long time, long duration, String category, String label, RGBA color) {
        Assert.assertEquals((long)time, (long)marker.getTime());
        Assert.assertEquals((long)duration, (long)marker.getDuration());
        Assert.assertEquals((Object)category, (Object)marker.getCategory());
        Assert.assertEquals((Object)label, (Object)marker.getLabel());
        Assert.assertEquals((Object)color, (Object)marker.getColor());
        Assert.assertEquals((Object)false, (Object)marker.isForeground());
    }

    private static final class TmfTraceStubAdapterFactory
    extends AbstractTmfTraceAdapterFactory {
        private TmfTraceStubAdapterFactory() {
        }

        protected <T> @Nullable T getTraceAdapter(@NonNull ITmfTrace trace, Class<T> adapterType) {
            if (ICyclesConverter.class.equals(adapterType)) {
                ICyclesConverter adapter = new ICyclesConverter(){

                    public long cyclesToNanos(long cycles) {
                        return cycles * 4L;
                    }

                    public long nanosToCycles(long nanos) {
                        return nanos / 4L;
                    }
                };
                return adapterType.cast(adapter);
            }
            if (IMarkerReferenceProvider.class.equals(adapterType)) {
                IMarkerReferenceProvider adapter = new IMarkerReferenceProvider(){

                    public PeriodicMarkerEventSource.Reference getReference(String referenceId) {
                        if ("ref.c".equals(referenceId)) {
                            return new PeriodicMarkerEventSource.Reference(1000L, 0);
                        }
                        return null;
                    }
                };
                return adapterType.cast(adapter);
            }
            return null;
        }

        public Class<?>[] getAdapterList() {
            return new Class[]{ICyclesConverter.class, IMarkerReferenceProvider.class};
        }
    }
}

