/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace;

import java.io.File;
import java.io.IOException;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.FileSystemObjectImportStructureProvider;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.FileSystemObjectLeveledImportStructureProvider;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.GzipFile;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.GzipLeveledStructureProvider;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.IFileSystemObject;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.TarFile;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.TarLeveledStructureProvider;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ZipLeveledStructureProvider;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceCoreUtils;
import org.eclipse.tracecompass.tmf.core.util.Pair;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class ArchiveUtil {
    public static boolean isArchiveFile(File sourceFile) {
        String absolutePath = sourceFile.getAbsolutePath();
        return ArchiveUtil.isTarFile(absolutePath) || ArchiveUtil.isZipFile(absolutePath) || ArchiveUtil.isGzipFile(absolutePath);
    }

    private static boolean isZipFile(String fileName) {
        ZipFile specifiedZipSourceFile = ArchiveUtil.getSpecifiedZipSourceFile(fileName);
        if (specifiedZipSourceFile != null) {
            try {
                specifiedZipSourceFile.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean isTarFile(String fileName) {
        TarFile specifiedTarSourceFile = ArchiveUtil.getSpecifiedTarSourceFile(fileName);
        if (specifiedTarSourceFile != null) {
            try {
                specifiedTarSourceFile.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean isGzipFile(String fileName) {
        if (!fileName.isEmpty()) {
            Throwable throwable = null;
            Object var2_4 = null;
            GzipFile specifiedTarSourceFile = new GzipFile(fileName);
            if (specifiedTarSourceFile != null) {
                specifiedTarSourceFile.close();
            }
            try {
                return true;
            }
            catch (Throwable throwable2) {
                try {
                    if (specifiedTarSourceFile != null) {
                        specifiedTarSourceFile.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    try {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        return false;
    }

    private static ZipFile getSpecifiedZipSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        File file = new File(fileName);
        if (file.isDirectory()) {
            return null;
        }
        try {
            return new ZipFile(file);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static TarFile getSpecifiedTarSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        File tarCandidate = new File(fileName);
        if (tarCandidate.length() < 512L) {
            return null;
        }
        try {
            return new TarFile(tarCandidate);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static boolean ensureZipSourceIsValid(String archivePath) {
        ZipFile specifiedFile = ArchiveUtil.getSpecifiedZipSourceFile(archivePath);
        if (specifiedFile == null) {
            return false;
        }
        return ArchiveUtil.closeZipFile(specifiedFile);
    }

    static boolean closeZipFile(ZipFile file) {
        try {
            file.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    static boolean ensureTarSourceIsValid(String archivePath) {
        TarFile specifiedFile = ArchiveUtil.getSpecifiedTarSourceFile(archivePath);
        if (specifiedFile == null) {
            return false;
        }
        return ArchiveUtil.closeTarFile(specifiedFile);
    }

    static boolean ensureGzipSourceIsValid(String archivePath) {
        return ArchiveUtil.isGzipFile(archivePath);
    }

    static boolean closeTarFile(TarFile file) {
        try {
            file.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static Pair<IFileSystemObject, FileSystemObjectImportStructureProvider> getRootObjectAndProvider(File sourceFile, Shell shell) {
        if (sourceFile == null) {
            return null;
        }
        IFileSystemObject rootElement = null;
        FileSystemObjectImportStructureProvider importStructureProvider = null;
        if (!ArchiveUtil.isArchiveFile(sourceFile)) {
            importStructureProvider = new FileSystemObjectImportStructureProvider((IImportStructureProvider)FileSystemStructureProvider.INSTANCE, null);
            rootElement = importStructureProvider.getIFileSystemObject(sourceFile);
        } else {
            FileSystemObjectLeveledImportStructureProvider leveledImportStructureProvider = null;
            String archivePath = sourceFile.getAbsolutePath();
            if (ArchiveUtil.isTarFile(archivePath)) {
                if (ArchiveUtil.ensureTarSourceIsValid(archivePath)) {
                    TarFile tarFile = ArchiveUtil.getSpecifiedTarSourceFile(archivePath);
                    leveledImportStructureProvider = new FileSystemObjectLeveledImportStructureProvider(new TarLeveledStructureProvider(tarFile), archivePath);
                }
            } else if (ArchiveUtil.ensureZipSourceIsValid(archivePath)) {
                ZipFile zipFile = ArchiveUtil.getSpecifiedZipSourceFile(archivePath);
                leveledImportStructureProvider = new FileSystemObjectLeveledImportStructureProvider(new ZipLeveledStructureProvider(zipFile), archivePath);
            } else if (ArchiveUtil.ensureGzipSourceIsValid(archivePath)) {
                GzipFile zipFile = null;
                try {
                    zipFile = new GzipFile(archivePath);
                    leveledImportStructureProvider = new FileSystemObjectLeveledImportStructureProvider(new GzipLeveledStructureProvider(zipFile), archivePath);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (leveledImportStructureProvider == null) {
                return null;
            }
            rootElement = leveledImportStructureProvider.getRoot();
            importStructureProvider = leveledImportStructureProvider;
        }
        if (rootElement == null) {
            return null;
        }
        return new Pair((Object)rootElement, (Object)importStructureProvider);
    }

    public static IPath toValidNamesPath(String path) {
        Path newSafePath;
        Object newFullPath = newSafePath = TmfTraceCoreUtils.newSafePath((String)path);
        String[] segments = newSafePath.segments();
        int i = 0;
        while (i < segments.length) {
            String segment = TmfTraceCoreUtils.validateName((String)TmfTraceCoreUtils.safePathToString((String)segments[i]));
            newFullPath = i == 0 ? new Path(segment) : newFullPath.append(segment);
            ++i;
        }
        return newFullPath;
    }
}

