/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.internal.core.dom.parser.CompositeValue;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinary;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalCompositeAccess;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalInitList;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalPointer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalReference;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalTypeId;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecIncomplete;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.runtime.CoreException;

public final class ExecDeclarator
implements ICPPExecution {
    private final ICPPBinding declaredBinding;
    private final ICPPEvaluation initializerEval;

    public ExecDeclarator(ICPPBinding declaredBinding, ICPPEvaluation initializerEval) {
        this.declaredBinding = declaredBinding;
        this.initializerEval = initializerEval;
    }

    @Override
    public ICPPExecution executeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        if (!(this.declaredBinding instanceof ICPPVariable)) {
            return this;
        }
        ICPPVariable declaredVariable = (ICPPVariable)this.declaredBinding;
        IType type = declaredVariable.getType();
        ICPPEvaluation initialValue = this.createInitialValue(type, record, context);
        if (initialValue == null || initialValue == EvalFixed.INCOMPLETE) {
            return ExecIncomplete.INSTANCE;
        }
        record.update(this.declaredBinding, initialValue);
        return this;
    }

    public ICPPBinding getDeclaredBinding() {
        return this.declaredBinding;
    }

    private static ICPPEvaluation maybeUnwrapInitList(ICPPEvaluation eval, IType targetType) {
        if (!(eval instanceof EvalInitList)) {
            return eval;
        }
        EvalInitList initList = (EvalInitList)eval;
        ICPPEvaluation[] clauses = initList.getClauses();
        if (clauses.length != 1) {
            return eval;
        }
        if (targetType instanceof IArrayType) {
            return eval;
        }
        ICPPEvaluation clause = clauses[0];
        if (targetType instanceof ICPPClassType && !clause.getType().isSameType(targetType)) {
            return eval;
        }
        return clause;
    }

    private ICPPEvaluation createInitialValue(IType type, ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        if (this.initializerEval == null) {
            return ExecDeclarator.createDefaultInitializedCompositeValue(type);
        }
        IType nestedType = SemanticUtil.getNestedType(type, 13);
        ICPPEvaluation computedInitializerEval = this.initializerEval.computeForFunctionCall(record, context.recordStep());
        computedInitializerEval = ExecDeclarator.maybeUnwrapInitList(computedInitializerEval, nestedType);
        if (type instanceof ICPPReferenceType) {
            return this.createReferenceValue(record, context, computedInitializerEval);
        }
        if (nestedType instanceof IPointerType && !ExecDeclarator.isCStringType(nestedType)) {
            return this.createPointerValue(record, context, computedInitializerEval);
        }
        if (nestedType instanceof IArrayType && !ExecDeclarator.isCStringType(nestedType)) {
            if (computedInitializerEval instanceof EvalInitList) {
                IValue value = CompositeValue.create((EvalInitList)computedInitializerEval, (IArrayType)nestedType);
                return new EvalFixed(type, computedInitializerEval.getValueCategory(), value);
            }
            return EvalFixed.INCOMPLETE;
        }
        if (ExecDeclarator.isValueInitialization(computedInitializerEval)) {
            EvalTypeId defaultValue = new EvalTypeId(type, computedInitializerEval.getTemplateDefinition(), false, false, ICPPEvaluation.EMPTY_ARRAY);
            return new EvalFixed(type, defaultValue.getValueCategory(), defaultValue.getValue());
        }
        return new EvalFixed(type, computedInitializerEval.getValueCategory(), computedInitializerEval.getValue());
    }

    private static ICPPEvaluation createDefaultInitializedCompositeValue(IType type) {
        if (!(type instanceof ICPPClassType)) {
            return EvalFixed.INCOMPLETE;
        }
        ICPPClassType classType = (ICPPClassType)type;
        CompositeValue compositeValue = CompositeValue.create(classType);
        EvalFixed initialValue = new EvalFixed(type, IASTExpression.ValueCategory.PRVALUE, compositeValue);
        return initialValue;
    }

    private ICPPEvaluation createReferenceValue(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context, ICPPEvaluation computedInitializerEval) {
        ICPPEvaluation initValue = this.initializerEval;
        if (initValue instanceof EvalInitList) {
            initValue = ((EvalInitList)initValue).getClauses()[0];
        } else if (!(initValue instanceof EvalBinding)) {
            initValue = this.initializerEval.getValue().getSubValue(0);
        }
        IBinding templateDefinition = this.initializerEval.getTemplateDefinition();
        if (initValue instanceof EvalBinding) {
            return ExecDeclarator.createReferenceFromBinding(record, templateDefinition, (EvalBinding)initValue);
        }
        if (initValue instanceof EvalBinary && computedInitializerEval instanceof EvalCompositeAccess) {
            return ExecDeclarator.createReferenceFromCompositeAccess(record, templateDefinition, (EvalCompositeAccess)computedInitializerEval);
        }
        return EvalFixed.INCOMPLETE;
    }

    private ICPPEvaluation createPointerValue(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context, ICPPEvaluation computedInitializerEval) {
        ICPPEvaluation initValue = this.initializerEval.getValue().getSubValue(0);
        if (ExecDeclarator.isPointerToArray(initValue)) {
            EvalCompositeAccess arrayPointer = new EvalCompositeAccess(computedInitializerEval, 0);
            return ExecDeclarator.createPointerFromCompositeAccess(record, this.initializerEval.getTemplateDefinition(), arrayPointer);
        }
        if (computedInitializerEval instanceof EvalPointer) {
            return ((EvalPointer)computedInitializerEval).copy();
        }
        return EvalFixed.INCOMPLETE;
    }

    private static boolean isValueInitialization(ICPPEvaluation eval) {
        if (eval instanceof EvalInitList) {
            EvalInitList evalInitList = (EvalInitList)eval;
            return evalInitList.getClauses().length == 0;
        }
        return false;
    }

    private static boolean isPointerToArray(ICPPEvaluation eval) {
        return eval.getType() instanceof IArrayType;
    }

    private static ICPPEvaluation createReferenceFromBinding(ActivationRecord record, IBinding templateDefinition, EvalBinding evalBinding) {
        return new EvalReference(record, evalBinding.getBinding(), templateDefinition);
    }

    private static ICPPEvaluation createReferenceFromCompositeAccess(ActivationRecord record, IBinding templateDefinition, EvalCompositeAccess evalCompAccess) {
        return new EvalReference(record, evalCompAccess, templateDefinition);
    }

    private static ICPPEvaluation createPointerFromCompositeAccess(ActivationRecord record, IBinding templateDefinition, EvalCompositeAccess evalCompAccess) {
        return new EvalPointer(record, evalCompAccess, templateDefinition);
    }

    private static boolean isCStringType(IType type) {
        IQualifierType qualifierType;
        IType nestedType = null;
        if (type instanceof IArrayType) {
            nestedType = ((IArrayType)type).getType();
        } else if (type instanceof IPointerType) {
            nestedType = ((IPointerType)type).getType();
        }
        if (nestedType instanceof IQualifierType && (qualifierType = (IQualifierType)nestedType).isConst() && !qualifierType.isVolatile()) {
            return qualifierType.getType().isSameType(CPPBasicType.CHAR);
        }
        return false;
    }

    @Override
    public ICPPExecution instantiate(InstantiationContext context, int maxDepth) {
        ICPPBinding newDeclaredBinding;
        if (this.declaredBinding instanceof ICPPVariable) {
            ICPPVariable declaredVariable = (ICPPVariable)this.declaredBinding;
            newDeclaredBinding = CPPTemplates.createVariableSpecialization(context, declaredVariable);
        } else {
            newDeclaredBinding = (ICPPBinding)CPPTemplates.createSpecialization(context.getContextSpecialization(), this.declaredBinding);
        }
        ICPPEvaluation newInitializerEval = this.initializerEval == null ? null : this.initializerEval.instantiate(context, maxDepth);
        return new ExecDeclarator(newDeclaredBinding, newInitializerEval);
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putShort((short)6);
        buffer.marshalBinding(this.declaredBinding);
        buffer.marshalEvaluation(this.initializerEval, includeValue);
    }

    public static ICPPExecution unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        ICPPBinding declaredBinding = (ICPPBinding)buffer.unmarshalBinding();
        ICPPEvaluation initializerEval = buffer.unmarshalEvaluation();
        return new ExecDeclarator(declaredBinding, initializerEval);
    }
}

