/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEventStyleStrings;

public class TimeGraphLegend
extends TitleAreaDialog {
    private static final ImageDescriptor RESET_IMAGE = Activator.getDefault().getImageDescripterFromPath("icons/ovr16/undo_edit.gif");
    private final ITimeGraphPresentationProvider provider;
    private final LocalResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());

    public static void open(Shell parent, ITimeGraphPresentationProvider provider) {
        new TimeGraphLegend(parent, provider).open();
    }

    public TimeGraphLegend(Shell parent, ITimeGraphPresentationProvider provider) {
        super(parent);
        this.provider = provider;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dlgArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dlgArea, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        this.createStatesGroup(composite);
        this.setTitle(Messages.TmfTimeLegend_LEGEND);
        TimeGraphLegend.setDialogHelpAvailable((boolean)false);
        this.setHelpAvailable(false);
        composite.addDisposeListener(e -> this.fResourceManager.dispose());
        return composite;
    }

    private void createStatesGroup(Composite composite) {
        ScrolledComposite sc = new ScrolledComposite(composite, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        Group gs = new Group((Composite)sc, 256);
        sc.setContent((Control)gs);
        GridData gd = new GridData(4, 4, true, true);
        sc.setLayoutData((Object)gd);
        String stateTypeName = this.provider.getStateTypeName();
        StringBuffer buffer = new StringBuffer();
        if (!stateTypeName.isEmpty()) {
            buffer.append(stateTypeName);
            buffer.append(" ");
        }
        buffer.append(Messages.TmfTimeLegend_StateTypeName);
        gs.setText(buffer.toString());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 20;
        layout.marginBottom = 10;
        gs.setLayout((Layout)layout);
        StateItem[] stateItems = this.provider.getStateTable();
        int i = 0;
        while (i < stateItems.length) {
            new LegendEntry((Composite)gs, stateItems[i]);
            ++i;
        }
        sc.setMinSize(gs.computeSize(-1, -1));
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.TmfTimeLegend_TRACE_STATES_TITLE);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    private class LegendEntry
    extends Composite {
        private final Swatch fBar;
        private final Scale fScale;
        private final Button fReset;

        public LegendEntry(final Composite parent, final StateItem si) {
            super(parent, 0);
            RGB rgb = si.getStateColor();
            String name = si.getStateString();
            float width = ((Float)si.getStyleMap().getOrDefault(ITimeEventStyleStrings.heightFactor(), Float.valueOf(1.0f))).floatValue();
            this.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(4).create());
            this.setLayoutData(GridDataFactory.swtDefaults().grab(true, false).create());
            this.fBar = new Swatch(this, rgb);
            this.fBar.setToolTipText(Messages.TimeGraphLegend_swatchClick);
            this.fBar.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    Shell shell = new Shell();
                    ColorDialog cd = new ColorDialog(shell, 0);
                    cd.setRGB(LegendEntry.this.fBar.fColor.getRGB());
                    RGB color = cd.open();
                    LegendEntry.this.fBar.setColor(color);
                    si.setStateColor(color);
                    TimeGraphLegend.this.provider.refresh();
                }
            });
            this.fBar.addMouseTrackListener(new MouseTrackListener(){

                public void mouseHover(MouseEvent e) {
                }

                public void mouseExit(MouseEvent e) {
                    Shell shell = parent.getShell();
                    Cursor old = shell.getCursor();
                    shell.setCursor(new Cursor((Device)e.display, 0));
                    if (old != null) {
                        old.dispose();
                    }
                }

                public void mouseEnter(MouseEvent e) {
                    Shell shell = parent.getShell();
                    Cursor old = shell.getCursor();
                    shell.setCursor(new Cursor((Device)e.display, 21));
                    if (old != null) {
                        old.dispose();
                    }
                }
            });
            this.fBar.setLayoutData(GridDataFactory.swtDefaults().hint(30, 20).create());
            Label label = new Label((Composite)this, 0);
            label.setText(name);
            label.setLayoutData((Object)GridDataFactory.fillDefaults().hint(160, 20).grab(true, true).align(1, 0x1000000).create());
            this.fScale = new Scale((Composite)this, 0);
            this.fScale.setMaximum(100);
            this.fScale.setMinimum(1);
            this.fScale.setSelection((int)(100.0f * width));
            this.fScale.setToolTipText(Messages.TimeGraphLegend_widthTooltip);
            this.fScale.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    si.getStyleMap().put(ITimeEventStyleStrings.heightFactor(), Float.valueOf((float)LegendEntry.this.fScale.getSelection() * 0.01f));
                    TimeGraphLegend.this.provider.refresh();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.fScale.setLayoutData((Object)GridDataFactory.swtDefaults().hint(120, 20).create());
            this.fReset = new Button((Composite)this, 0x800000);
            this.fReset.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    si.reset();
                    LegendEntry.this.fBar.setColor(si.getStateColor());
                    LegendEntry.this.fScale.setSelection((int)(100.0f * ((Float)si.getStyleMap().getOrDefault(ITimeEventStyleStrings.heightFactor(), Float.valueOf(1.0f))).floatValue()));
                    TimeGraphLegend.this.provider.refresh();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.fReset.setToolTipText(Messages.TimeGraphLegend_resetTooltip);
            this.fReset.setImage(RESET_IMAGE.createImage());
            this.fReset.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).create());
        }

        public void dispose() {
            this.fReset.getImage().dispose();
            super.dispose();
        }
    }

    private class Swatch
    extends Canvas {
        private Color fColor;

        public Swatch(Composite parent, RGB rgb) {
            super(parent, 0x800000);
            this.fColor = TimeGraphLegend.this.fResourceManager.createColor(rgb);
            this.setForeground(this.fColor);
            this.addListener(9, new Listener(){

                public void handleEvent(Event event) {
                    Swatch.this.draw(event.gc);
                }
            });
        }

        public void setColor(RGB rgb) {
            if (rgb != null) {
                this.fColor = TimeGraphLegend.this.fResourceManager.createColor(rgb);
                this.setForeground(this.fColor);
                this.redraw();
            }
        }

        private void draw(GC gc) {
            Rectangle r = this.getClientArea();
            gc.setBackground(this.fColor);
            gc.fillRectangle(r);
            gc.setForeground(Display.getDefault().getSystemColor(2));
            gc.setLineWidth(2);
            gc.drawRectangle(1, 1, r.width - 2, r.height - 2);
        }
    }
}

