/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.EventIterator;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;

public class TimeGraphEntry
implements ITimeGraphEntry {
    private TimeGraphEntry fParent = null;
    private final List<@NonNull TimeGraphEntry> fChildren = new CopyOnWriteArrayList<TimeGraphEntry>();
    private String fName;
    private long fStartTime = -1L;
    private long fEndTime = -1L;
    private @NonNull List<ITimeEvent> fEventList = new ArrayList<ITimeEvent>();
    private @NonNull List<ITimeEvent> fZoomedEventList = new ArrayList<ITimeEvent>();
    private Comparator<ITimeGraphEntry> fComparator;
    private Sampling fSampling;

    public TimeGraphEntry(String name, long startTime, long endTime) {
        this.fName = name;
        this.fStartTime = startTime;
        this.fEndTime = endTime;
    }

    @Override
    public TimeGraphEntry getParent() {
        return this.fParent;
    }

    public void setParent(TimeGraphEntry entry) {
        this.fParent = entry;
    }

    @Override
    public synchronized boolean hasChildren() {
        return !this.fChildren.isEmpty();
    }

    public synchronized List<@NonNull TimeGraphEntry> getChildren() {
        return this.fChildren;
    }

    public synchronized void clearChildren() {
        this.fChildren.clear();
    }

    @Override
    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    @Override
    public long getStartTime() {
        return this.fStartTime;
    }

    @Override
    public long getEndTime() {
        return this.fEndTime;
    }

    public void updateEndTime(long endTime) {
        this.fEndTime = Math.max(endTime, this.fEndTime);
    }

    @Override
    public boolean hasTimeEvents() {
        return true;
    }

    public Iterator<@NonNull ITimeEvent> getTimeEventsIterator() {
        if (this.hasTimeEvents()) {
            return new EventIterator(this.fEventList, this.fZoomedEventList);
        }
        return null;
    }

    public Iterator<@NonNull ITimeEvent> getTimeEventsIterator(long startTime, long stopTime, long visibleDuration) {
        if (!this.hasTimeEvents()) {
            return null;
        }
        return new EventIterator(this.fEventList, this.fZoomedEventList, startTime, stopTime);
    }

    public void addEvent(ITimeEvent event) {
        int lastIndex = this.fEventList.size() - 1;
        if (lastIndex >= 0 && this.fEventList.get(lastIndex).getTime() == event.getTime()) {
            this.fEventList.set(lastIndex, event);
        } else {
            this.fEventList.add(event);
        }
        this.updateEntryBounds(event);
    }

    public void setEventList(List<ITimeEvent> eventList) {
        this.fEventList = eventList != null ? eventList : new ArrayList<ITimeEvent>();
    }

    public void setZoomedEventList(List<ITimeEvent> eventList) {
        if (eventList != null) {
            this.fZoomedEventList = eventList;
        } else {
            this.fZoomedEventList = new ArrayList<ITimeEvent>();
            this.fSampling = null;
        }
    }

    public void addZoomedEvent(ITimeEvent event) {
        long lastStart;
        long start = event.getTime();
        int lastIndex = this.fZoomedEventList.size() - 1;
        long l = lastStart = lastIndex >= 0 ? this.fZoomedEventList.get(lastIndex).getTime() : Long.MIN_VALUE;
        if (start > lastStart) {
            this.fZoomedEventList.add(event);
        } else if (start == lastStart) {
            this.fZoomedEventList.set(lastIndex, event);
        } else if (start < this.fZoomedEventList.get(0).getTime()) {
            this.fZoomedEventList.clear();
            this.fZoomedEventList.add(event);
        }
        this.updateEntryBounds(event);
    }

    private void updateEntryBounds(ITimeEvent event) {
        if (event instanceof NullTimeEvent) {
            return;
        }
        long start = event.getTime();
        if (this.fStartTime == -1L || start < this.fStartTime) {
            this.fStartTime = start;
        }
        long end = start + event.getDuration();
        if (this.fEndTime == -1L || end > this.fEndTime) {
            this.fEndTime = end;
        }
    }

    public synchronized void addChild(@NonNull TimeGraphEntry child) {
        if (this.fComparator == null) {
            this.addChild(this.fChildren.size(), child);
        } else {
            int i = Collections.binarySearch(this.fChildren, child, this.fComparator);
            i = i >= 0 ? i : -i - 1;
            this.addChild(i, child);
        }
    }

    public synchronized void addChild(int index, @NonNull TimeGraphEntry child) {
        if (child.getParent() == this) {
            return;
        }
        if (child.getParent() != null) {
            child.getParent().removeChild(child);
        }
        child.setParent(this);
        this.fChildren.add(index, child);
    }

    public synchronized void removeChild(@NonNull TimeGraphEntry child) {
        if (child.getParent() == this) {
            child.setParent(null);
        }
        this.fChildren.remove(child);
    }

    public synchronized void sortChildren(Comparator<ITimeGraphEntry> comparator) {
        this.fComparator = comparator;
        if (comparator == null) {
            return;
        }
        ArrayList<@NonNull TimeGraphEntry> copy = new ArrayList<TimeGraphEntry>(this.fChildren);
        copy.sort(comparator);
        this.fChildren.clear();
        this.fChildren.addAll(copy);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + '(' + this.fName + ')';
    }

    @Override
    public boolean matches(@NonNull Pattern pattern) {
        return pattern.matcher(this.fName).find();
    }

    public Sampling getSampling() {
        return this.fSampling;
    }

    public void setSampling(Sampling sampling) {
        this.fSampling = sampling;
    }

    public static class Sampling {
        private final long fZoomStart;
        private final long fZoomEnd;
        private final long fResolution;

        public Sampling(long zoomStart, long zoomEnd, long resolution) {
            this.fZoomStart = zoomStart;
            this.fZoomEnd = zoomEnd;
            this.fResolution = resolution;
        }

        public int hashCode() {
            return Objects.hash(this.fZoomStart, this.fZoomEnd, this.fResolution);
        }

        public boolean equals(Object arg0) {
            if (arg0 == this) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0 instanceof Sampling) {
                Sampling other = (Sampling)arg0;
                return this.fZoomStart == other.fZoomStart && this.fZoomEnd == other.fZoomEnd && this.fResolution == other.fResolution;
            }
            return false;
        }
    }
}

