/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.observable.masterdetail;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.map.ObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.internal.databinding.observable.masterdetail.DetailObservableHelper;
import org.eclipse.core.runtime.Assert;

public class DetailObservableMap<M, K, V>
extends ObservableMap<K, V>
implements IObserving {
    private boolean updating = false;
    private IObservableValue<M> master;
    private IObservableFactory<? super M, IObservableMap<K, V>> detailFactory;
    private IObservableMap<K, V> detailMap;
    private Object detailKeyType;
    private Object detailValueType;
    private IValueChangeListener<M> masterChangeListener = new IValueChangeListener<M>(){

        @Override
        public void handleValueChange(ValueChangeEvent<? extends M> event) {
            if (DetailObservableMap.this.isDisposed()) {
                return;
            }
            ObservableTracker.setIgnore(true);
            try {
                HashMap oldMap = new HashMap(DetailObservableMap.this.wrappedMap);
                DetailObservableMap.this.updateDetailMap();
                DetailObservableMap.this.fireMapChange(Diffs.computeMapDiff(oldMap, DetailObservableMap.this.wrappedMap));
            }
            finally {
                ObservableTracker.setIgnore(false);
            }
        }
    };
    private IMapChangeListener<K, V> detailChangeListener = new IMapChangeListener<K, V>(){

        @Override
        public void handleMapChange(MapChangeEvent<? extends K, ? extends V> event) {
            if (!DetailObservableMap.this.updating) {
                DetailObservableMap.this.fireMapChange(Diffs.unmodifiableDiff(event.diff));
            }
        }
    };

    public DetailObservableMap(IObservableFactory<? super M, IObservableMap<K, V>> detailFactory, IObservableValue<M> master, Object keyType, Object valueType) {
        super(master.getRealm(), Collections.emptyMap());
        Assert.isTrue((!master.isDisposed() ? 1 : 0) != 0, (String)"Master observable is disposed");
        this.master = master;
        this.detailFactory = detailFactory;
        this.detailKeyType = keyType;
        this.detailValueType = valueType;
        master.addDisposeListener(new IDisposeListener(){

            @Override
            public void handleDispose(DisposeEvent staleEvent) {
                DetailObservableMap.this.dispose();
            }
        });
        ObservableTracker.setIgnore(true);
        try {
            this.updateDetailMap();
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
        master.addValueChangeListener(this.masterChangeListener);
    }

    private void updateDetailMap() {
        M masterValue = this.master.getValue();
        if (this.detailMap != null) {
            this.detailMap.removeMapChangeListener(this.detailChangeListener);
            this.detailMap.dispose();
        }
        if (masterValue == null) {
            this.detailMap = null;
            this.wrappedMap = Collections.emptyMap();
        } else {
            ObservableTracker.setIgnore(true);
            try {
                this.detailMap = this.detailFactory.createObservable(masterValue);
            }
            finally {
                ObservableTracker.setIgnore(false);
            }
            DetailObservableHelper.warnIfDifferentRealms(this.getRealm(), this.detailMap.getRealm());
            this.wrappedMap = this.detailMap;
            if (this.detailKeyType != null) {
                Object innerKeyType = this.detailMap.getKeyType();
                Assert.isTrue((boolean)this.detailKeyType.equals(innerKeyType), (String)"Cannot change key type in a nested observable map");
            }
            if (this.detailValueType != null) {
                Object innerValueType = this.detailMap.getValueType();
                Assert.isTrue((boolean)this.detailValueType.equals(innerValueType), (String)"Cannot change value type in a nested observable map");
            }
            this.detailMap.addMapChangeListener(this.detailChangeListener);
        }
    }

    @Override
    public Object getKeyType() {
        return this.detailKeyType;
    }

    @Override
    public Object getValueType() {
        return this.detailValueType;
    }

    @Override
    public V put(K key, V value) {
        ObservableTracker.setIgnore(true);
        try {
            V v = this.detailMap.put(key, value);
            return v;
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        ObservableTracker.setIgnore(true);
        try {
            this.detailMap.putAll(map);
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
    }

    @Override
    public V remove(Object key) {
        ObservableTracker.setIgnore(true);
        try {
            V v = this.detailMap.remove(key);
            return v;
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
    }

    @Override
    public void clear() {
        ObservableTracker.setIgnore(true);
        try {
            this.detailMap.clear();
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
    }

    @Override
    public synchronized void dispose() {
        if (this.master != null) {
            this.master.removeValueChangeListener(this.masterChangeListener);
            this.master = null;
            this.masterChangeListener = null;
        }
        this.detailFactory = null;
        if (this.detailMap != null) {
            this.detailMap.removeMapChangeListener(this.detailChangeListener);
            this.detailMap.dispose();
            this.detailMap = null;
        }
        this.detailChangeListener = null;
        super.dispose();
    }

    @Override
    public Object getObserved() {
        if (this.detailMap instanceof IObserving) {
            return ((IObserving)((Object)this.detailMap)).getObserved();
        }
        return null;
    }
}

