/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.kernelmemoryusage;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelThreadInformationProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelmemoryusage.KernelMemoryAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.memory.MemoryUsageTreeModel;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernelmemoryusage.Messages;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.AbstractStateSystemAnalysisDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.TmfCommonXAxisResponseFactory;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.FilterTimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfCommonXAxisModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.internal.tmf.core.model.YModel;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

@NonNullByDefault
public class KernelMemoryUsageDataProvider
extends AbstractStateSystemAnalysisDataProvider
implements ITmfTreeXYDataProvider<MemoryUsageTreeModel> {
    public static final String ID = "org.eclipse.tracecompass.analysis.os.linux.core.kernelmemoryusage";
    private static final int TOTAL_TID = -2;
    private static final AtomicLong KERNEL_MEMORY_ENTRY_ID = new AtomicLong();
    private final KernelMemoryAnalysisModule fModule;
    private @Nullable KernelAnalysisModule fKernelModule;
    private final BiMap<Long, Integer> fIdToQuark = HashBiMap.create();
    private final long fTotalId = KERNEL_MEMORY_ENTRY_ID.getAndIncrement();
    private final Map<String, String> fProcessNameMap = new HashMap<String, String>();

    public static @Nullable KernelMemoryUsageDataProvider create(ITmfTrace trace) {
        KernelMemoryAnalysisModule module = (KernelMemoryAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelMemoryAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.core.kernelmemory");
        if (module != null) {
            module.schedule();
            return new KernelMemoryUsageDataProvider(trace, module);
        }
        return null;
    }

    private KernelMemoryUsageDataProvider(ITmfTrace trace, KernelMemoryAnalysisModule module) {
        super(trace);
        this.fModule = module;
    }

    public @NonNull TmfModelResponse<ITmfCommonXAxisModel> fetchXY(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        TmfModelResponse res = this.verifyParameters(this.fModule, filter, monitor);
        if (res != null) {
            return res;
        }
        ITmfStateSystem ss = Objects.requireNonNull(this.fModule.getStateSystem(), "Statesystem should have been verified by verifyParameters");
        long[] xValues = filter.getTimesRequested();
        long currentEnd = ss.getCurrentEndTime();
        boolean complete = ss.waitUntilBuilt(0L) || filter.getEnd() <= currentEnd;
        double[] totalKernelMemoryValues = new double[xValues.length];
        Map<Integer, double[]> selectedSeries = this.initSeries(filter);
        try {
            int i2 = 0;
            while (i2 < xValues.length) {
                if (monitor != null && monitor.isCanceled()) {
                    return TmfCommonXAxisResponseFactory.createCancelledResponse((String)CommonStatusMessage.TASK_CANCELLED);
                }
                long time = xValues[i2];
                if (time >= ss.getStartTime() && time <= currentEnd) {
                    List list = ss.getSubAttributes(-1, false);
                    List kernelState = ss.queryFullState(time);
                    for (Integer threadQuark : list) {
                        long value = KernelMemoryUsageDataProvider.extractValue(((ITmfStateInterval)kernelState.get(threadQuark)).getValue());
                        int n = i2;
                        totalKernelMemoryValues[n] = totalKernelMemoryValues[n] + (double)value;
                        double[] selectedThreadValues = selectedSeries.get(threadQuark);
                        if (selectedThreadValues == null) continue;
                        selectedThreadValues[i2] = value;
                    }
                }
                ++i2;
            }
            List endState = ss.queryFullState(Long.min(filter.getEnd(), currentEnd));
            double d = KernelMemoryUsageDataProvider.extractTotalValueShift(ss, endState);
            Arrays.setAll(totalKernelMemoryValues, i -> totalKernelMemoryValues[i] + d);
            for (Map.Entry entry : selectedSeries.entrySet()) {
                int lowestMemoryQuark = ss.optQuarkRelative(((Integer)entry.getKey()).intValue(), new String[]{"lowestMemory"});
                if (lowestMemoryQuark == -2) continue;
                double[] threadValues = (double[])entry.getValue();
                long shift = KernelMemoryUsageDataProvider.extractValue(((ITmfStateInterval)endState.get(lowestMemoryQuark)).getValue());
                Arrays.setAll(threadValues, i -> threadValues[i] - (double)shift);
            }
        }
        catch (StateSystemDisposedException e) {
            return TmfCommonXAxisResponseFactory.createFailedResponse((String)e.getMessage());
        }
        ImmutableMap.Builder ySeries = ImmutableMap.builder();
        String total = String.valueOf(this.getTrace().getName()) + ":total";
        ySeries.put((Object)total, (Object)new YModel(total, totalKernelMemoryValues));
        for (Map.Entry<Integer, double[]> entry : selectedSeries.entrySet()) {
            String selectedThreadName = String.valueOf(this.getTrace().getName()) + ':' + ss.getAttributeName(entry.getKey().intValue());
            ySeries.put((Object)selectedThreadName, (Object)new YModel(selectedThreadName, entry.getValue()));
        }
        return TmfCommonXAxisResponseFactory.create((String)Objects.requireNonNull(Messages.KernelMemoryUsageDataProvider_title), (long[])xValues, (Map)ySeries.build(), (boolean)complete);
    }

    private Map<Integer, double[]> initSeries(TimeQueryFilter filter) {
        if (filter instanceof SelectionTimeQueryFilter) {
            Collection selectedEntries = ((SelectionTimeQueryFilter)filter).getSelectedItems();
            HashMap<Integer, double[]> selectedSeries = new HashMap<Integer, double[]>();
            int length = filter.getTimesRequested().length;
            for (Long id : selectedEntries) {
                Integer quark = (Integer)this.fIdToQuark.get((Object)id);
                if (quark == null) continue;
                selectedSeries.put(quark, new double[length]);
            }
            return selectedSeries;
        }
        return Collections.emptyMap();
    }

    private static double extractTotalValueShift(ITmfStateSystem ss, List<ITmfStateInterval> endState) {
        double totalKernelMemoryValuesShift = 0.0;
        List threadQuarkList = ss.getQuarks(new String[]{"*", "lowestMemory"});
        for (Integer threadQuark : threadQuarkList) {
            ITmfStateInterval lowestMemoryInterval = endState.get(threadQuark);
            Object val = lowestMemoryInterval.getValue();
            totalKernelMemoryValuesShift -= (double)KernelMemoryUsageDataProvider.extractValue(val);
        }
        return totalKernelMemoryValuesShift;
    }

    private static long extractValue(@Nullable Object val) {
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        return 0L;
    }

    public TmfModelResponse<List<MemoryUsageTreeModel>> fetchTree(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        long end;
        long start = filter.getStart();
        if (start == (end = filter.getEnd())) {
            return new TmfModelResponse(Collections.emptyList(), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        this.fModule.waitForInitialization();
        ITmfStateSystem ss = this.fModule.getStateSystem();
        if (ss == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.STATE_SYSTEM_FAILED);
        }
        boolean complete = ss.waitUntilBuilt(0L);
        boolean filtered = false;
        if (filter instanceof FilterTimeQueryFilter) {
            filtered = ((FilterTimeQueryFilter)filter).isFiltered();
        }
        try {
            ArrayList<MemoryUsageTreeModel> nodes = new ArrayList<MemoryUsageTreeModel>();
            List memoryStates = ss.queryFullState(Long.max(start, ss.getStartTime()));
            List threadQuarkList = ss.getSubAttributes(-1, false);
            nodes.add(new MemoryUsageTreeModel(this.fTotalId, -1L, -2, this.getTrace().getName()));
            for (Integer threadQuark : threadQuarkList) {
                ITmfStateInterval threadMemoryInterval = (ITmfStateInterval)memoryStates.get(threadQuark);
                if (filtered && threadMemoryInterval.getEndTime() >= end) continue;
                String tidString = ss.getAttributeName(threadQuark.intValue());
                String procname = this.getProcessName(tidString);
                Long id = (Long)this.fIdToQuark.inverse().get((Object)threadQuark);
                if (id == null) {
                    id = KERNEL_MEMORY_ENTRY_ID.getAndIncrement();
                    this.fIdToQuark.put((Object)id, (Object)threadQuark);
                }
                nodes.add(new MemoryUsageTreeModel(id, this.fTotalId, KernelMemoryUsageDataProvider.parseTid(tidString), procname));
            }
            if (complete) {
                return new TmfModelResponse(nodes, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
            }
            return new TmfModelResponse(nodes, ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
        }
        catch (StateSystemDisposedException e) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.STATE_SYSTEM_FAILED);
        }
    }

    private static int parseTid(String tidString) {
        try {
            return Integer.parseInt(tidString);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private String getProcessName(String tid) {
        String execName = this.fProcessNameMap.get(tid);
        if (execName != null) {
            return execName;
        }
        if (tid.equals("other")) {
            this.fProcessNameMap.put(tid, tid);
            return tid;
        }
        KernelAnalysisModule kernelModule = this.fKernelModule;
        if (kernelModule == null) {
            kernelModule = (KernelAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)this.getTrace(), KernelAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        }
        if (kernelModule == null) {
            return tid;
        }
        this.fKernelModule = kernelModule;
        execName = KernelThreadInformationProvider.getExecutableName(kernelModule, Integer.parseInt(tid));
        if (execName == null) {
            return tid;
        }
        this.fProcessNameMap.put(tid, execName);
        return execName;
    }

    public String getId() {
        return ID;
    }
}

