/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.classic;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTConfig;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTInterval;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTNode;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HT_IO;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.IHistoryTree;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.LeafNode;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.ParentNode;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.classic.CoreNode;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;

public class HistoryTreeClassic
implements IHistoryTree {
    public static final int HISTORY_FILE_MAGIC_NUMBER = 100641024;
    private static final int FILE_VERSION = 9;
    private static final IHistoryTree.IHTNodeFactory CLASSIC_NODE_FACTORY = new IHistoryTree.IHTNodeFactory(){

        @Override
        public HTNode createCoreNode(HTConfig config, int seqNumber, int parentSeqNumber, long start) {
            return new CoreNode(config, seqNumber, parentSeqNumber, start);
        }

        @Override
        public HTNode createLeafNode(HTConfig config, int seqNumber, int parentSeqNumber, long start) {
            return new LeafNode(config, seqNumber, parentSeqNumber, start);
        }
    };
    private final HTConfig fConfig;
    private final @NonNull HT_IO fTreeIO;
    private long fTreeEnd;
    private int fNodeCount;
    private final @NonNull List<@NonNull HTNode> fLatestBranch;

    public HistoryTreeClassic(HTConfig conf) throws IOException {
        if (conf.getBlockSize() < 4096) {
            throw new IllegalArgumentException();
        }
        this.fConfig = conf;
        this.fTreeEnd = conf.getTreeStart();
        this.fNodeCount = 0;
        this.fLatestBranch = Collections.synchronizedList(new ArrayList());
        this.fTreeIO = new HT_IO(this.fConfig, true, CLASSIC_NODE_FACTORY);
        LeafNode firstNode = this.initNewLeafNode(-1, conf.getTreeStart());
        this.fLatestBranch.add(firstNode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HistoryTreeClassic(File existingStateFile, int expProviderVersion) throws IOException {
        long startTime;
        int rootNodeSeqNb;
        block19: {
            if (!existingStateFile.exists()) {
                throw new IOException("Selected state file does not exist");
            }
            if (existingStateFile.length() <= 0L) {
                throw new IOException("Empty target file");
            }
            Throwable throwable = null;
            Object var10_5 = null;
            try {
                FileInputStream fis = new FileInputStream(existingStateFile);
                try {
                    try (FileChannel fc = fis.getChannel();){
                        ByteBuffer buffer = ByteBuffer.allocate(4096);
                        buffer.order(ByteOrder.LITTLE_ENDIAN);
                        buffer.clear();
                        int res = fc.read(buffer);
                        if (res != 4096) {
                            throw new IOException("Invalid header size");
                        }
                        buffer.flip();
                        res = buffer.getInt();
                        if (res != 100641024) {
                            throw new IOException("Wrong magic number");
                        }
                        res = buffer.getInt();
                        if (res != 9) {
                            throw new IOException("Mismatching History Tree file format versions");
                        }
                        res = buffer.getInt();
                        if (res != expProviderVersion && expProviderVersion != -42) {
                            throw new IOException("Mismatching event handler versions");
                        }
                        int bs = buffer.getInt();
                        int maxc = buffer.getInt();
                        this.fNodeCount = buffer.getInt();
                        rootNodeSeqNb = buffer.getInt();
                        startTime = buffer.getLong();
                        this.fConfig = new HTConfig(existingStateFile, bs, maxc, expProviderVersion, startTime);
                    }
                    if (fis == null) break block19;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
                fis.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        this.fTreeIO = new HT_IO(this.fConfig, false, CLASSIC_NODE_FACTORY);
        this.fLatestBranch = this.buildLatestBranch(rootNodeSeqNb);
        this.fTreeEnd = this.getRootNode().getNodeEnd();
        if (startTime == this.getRootNode().getNodeStart()) return;
        throw new IOException("Inconsistent start times in thehistory file, it might be corrupted.");
    }

    private @NonNull List<@NonNull HTNode> buildLatestBranch(int rootNodeSeqNb) throws ClosedChannelException {
        ArrayList<@NonNull HTNode> list = new ArrayList<HTNode>();
        HTNode nextChildNode = this.fTreeIO.readNode(rootNodeSeqNb);
        list.add(nextChildNode);
        while (nextChildNode.getNodeType() == HTNode.NodeType.CORE) {
            nextChildNode = this.fTreeIO.readNode(((CoreNode)nextChildNode).getLatestChild());
            list.add(nextChildNode);
        }
        return Collections.synchronizedList(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeTree(long requestedEndTime) {
        List<HTNode> list = this.fLatestBranch;
        synchronized (list) {
            this.fTreeEnd = requestedEndTime;
            this.closeBranch(0, requestedEndTime);
            try {
                Throwable throwable = null;
                Object var5_6 = null;
                try (FileChannel fc = this.fTreeIO.getFcOut();){
                    ByteBuffer buffer = ByteBuffer.allocate(4096);
                    buffer.order(ByteOrder.LITTLE_ENDIAN);
                    buffer.clear();
                    fc.position(0L);
                    buffer.putInt(100641024);
                    buffer.putInt(9);
                    buffer.putInt(this.fConfig.getProviderVersion());
                    buffer.putInt(this.fConfig.getBlockSize());
                    buffer.putInt(this.fConfig.getMaxChildren());
                    buffer.putInt(this.fNodeCount);
                    buffer.putInt(this.fLatestBranch.get(0).getSequenceNumber());
                    buffer.putLong(this.fLatestBranch.get(0).getNodeStart());
                    buffer.flip();
                    int res = fc.write(buffer);
                    assert (res <= 4096);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("State system write error");
            }
        }
    }

    @Override
    public long getTreeStart() {
        return this.fConfig.getTreeStart();
    }

    @Override
    public long getTreeEnd() {
        return this.fTreeEnd;
    }

    @Override
    public int getNodeCount() {
        return this.fNodeCount;
    }

    @Override
    public HTNode getRootNode() {
        return this.fLatestBranch.get(0);
    }

    @VisibleForTesting
    protected List<@NonNull HTNode> getLatestBranch() {
        return ImmutableList.copyOf(this.fLatestBranch);
    }

    @VisibleForTesting
    protected @NonNull HTNode getNode(int seqNum) throws ClosedChannelException {
        for (HTNode node : this.fLatestBranch) {
            if (node.getSequenceNumber() != seqNum) continue;
            return node;
        }
        return this.fTreeIO.readNode(seqNum);
    }

    @VisibleForTesting
    protected @NonNull HT_IO getTreeIO() {
        return this.fTreeIO;
    }

    @Override
    public FileInputStream supplyATReader() {
        return this.fTreeIO.supplyATReader(this.getNodeCount());
    }

    @Override
    public File supplyATWriterFile() {
        return this.fConfig.getStateFile();
    }

    @Override
    public long supplyATWriterFilePos() {
        return 4096L + (long)this.getNodeCount() * (long)this.fConfig.getBlockSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTNode readNode(int seqNumber) throws ClosedChannelException {
        List<HTNode> list = this.fLatestBranch;
        synchronized (list) {
            for (HTNode node : this.fLatestBranch) {
                if (node.getSequenceNumber() != seqNumber) continue;
                return node;
            }
        }
        return this.fTreeIO.readNode(seqNumber);
    }

    @Override
    public void writeNode(HTNode node) {
        this.fTreeIO.writeNode(node);
    }

    @Override
    public void closeFile() {
        this.fTreeIO.closeFile();
    }

    @Override
    public void deleteFile() {
        this.fTreeIO.deleteFile();
    }

    @Override
    public void insertInterval(HTInterval interval) throws TimeRangeException {
        if (interval.getStartTime() < this.fConfig.getTreeStart()) {
            throw new TimeRangeException("Interval Start:" + interval.getStartTime() + ", Config Start:" + this.fConfig.getTreeStart());
        }
        this.tryInsertAtNode(interval, this.fLatestBranch.size() - 1);
    }

    private void tryInsertAtNode(HTInterval interval, int indexOfNode) {
        HTNode targetNode = this.fLatestBranch.get(indexOfNode);
        if (interval.getSizeOnDisk() > targetNode.getNodeFreeSpace()) {
            this.addSiblingNode(indexOfNode, interval.getStartTime());
            this.tryInsertAtNode(interval, this.fLatestBranch.size() - 1);
            return;
        }
        if (interval.getStartTime() < targetNode.getNodeStart()) {
            this.tryInsertAtNode(interval, indexOfNode - 1);
            return;
        }
        targetNode.addInterval(interval);
        if (interval.getEndTime() > this.fTreeEnd) {
            this.fTreeEnd = interval.getEndTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSiblingNode(int indexOfNode, long newNodeStartTime) {
        List<HTNode> list = this.fLatestBranch;
        synchronized (list) {
            long splitTime = this.fTreeEnd;
            if (indexOfNode >= this.fLatestBranch.size()) {
                throw new IllegalStateException();
            }
            if (indexOfNode == 0) {
                this.addNewRootNode(newNodeStartTime);
                return;
            }
            if (((ParentNode)this.fLatestBranch.get(indexOfNode - 1)).getNbChildren() == this.fConfig.getMaxChildren() || this.getLatestBranch().get(indexOfNode - 1).getNodeStart() > newNodeStartTime) {
                this.addSiblingNode(indexOfNode - 1, newNodeStartTime);
                return;
            }
            this.closeBranch(indexOfNode, splitTime);
            int i = indexOfNode;
            while (i < this.fLatestBranch.size()) {
                HTNode newNode;
                ParentNode prevNode = (ParentNode)this.fLatestBranch.get(i - 1);
                switch (this.fLatestBranch.get(i).getNodeType()) {
                    case CORE: {
                        newNode = this.initNewCoreNode(prevNode.getSequenceNumber(), newNodeStartTime);
                        break;
                    }
                    case LEAF: {
                        newNode = this.initNewLeafNode(prevNode.getSequenceNumber(), newNodeStartTime);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                prevNode.linkNewChild(newNode);
                this.fLatestBranch.set(i, newNode);
                ++i;
            }
        }
    }

    private void closeBranch(int shallowIndex, long splitTime) {
        int i = this.fLatestBranch.size() - 1;
        while (i >= shallowIndex) {
            HTNode closeNode = this.fLatestBranch.get(i);
            closeNode.closeThisNode(splitTime);
            this.fTreeIO.writeNode(closeNode);
            if (i > 0) {
                CoreNode prevNode = (CoreNode)this.fLatestBranch.get(i - 1);
                prevNode.closeChild(closeNode);
            }
            --i;
        }
    }

    private void addNewRootNode(long newNodeStartTime) {
        long splitTime = this.fTreeEnd;
        HTNode oldRootNode = this.fLatestBranch.get(0);
        ParentNode newRootNode = this.initNewCoreNode(-1, this.fConfig.getTreeStart());
        oldRootNode.setParentSequenceNumber(newRootNode.getSequenceNumber());
        this.closeBranch(0, splitTime);
        newRootNode.linkNewChild(oldRootNode);
        ((CoreNode)newRootNode).closeChild(oldRootNode);
        int depth = this.fLatestBranch.size();
        this.fLatestBranch.clear();
        this.fLatestBranch.add(newRootNode);
        int i = 1;
        while (i < depth) {
            ParentNode prevNode = (ParentNode)this.fLatestBranch.get(i - 1);
            ParentNode newNode = this.initNewCoreNode(prevNode.getSequenceNumber(), newNodeStartTime);
            prevNode.linkNewChild(newNode);
            this.fLatestBranch.add(newNode);
            ++i;
        }
        ParentNode prevNode = (ParentNode)this.fLatestBranch.get(depth - 1);
        LeafNode newNode = this.initNewLeafNode(prevNode.getSequenceNumber(), newNodeStartTime);
        prevNode.linkNewChild(newNode);
        this.fLatestBranch.add(newNode);
    }

    private @NonNull ParentNode initNewCoreNode(int parentSeqNumber, long startTime) {
        CoreNode newNode = new CoreNode(this.fConfig, this.fNodeCount, parentSeqNumber, startTime);
        ++this.fNodeCount;
        return newNode;
    }

    private @NonNull LeafNode initNewLeafNode(int parentSeqNumber, long startTime) {
        LeafNode newNode = new LeafNode(this.fConfig, this.fNodeCount, parentSeqNumber, startTime);
        ++this.fNodeCount;
        return newNode;
    }

    @Override
    public long getFileSize() {
        return this.fConfig.getStateFile().length();
    }

    public String toString() {
        return "Information on the current tree:\n\nBlocksize: " + this.fConfig.getBlockSize() + "\n" + "Max nb. of children per node: " + this.fConfig.getMaxChildren() + "\n" + "Number of nodes: " + this.fNodeCount + "\n" + "Depth of the tree: " + this.fLatestBranch.size() + "\n" + "Size of the treefile: " + this.getFileSize() + "\n" + "Root node has sequence number: " + this.fLatestBranch.get(0).getSequenceNumber() + "\n" + "'Latest leaf' has sequence number: " + this.fLatestBranch.get(this.fLatestBranch.size() - 1).getSequenceNumber();
    }
}

