/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILogicalStructureType;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class SelectLogicalStructureAction
extends Action {
    private VariablesView fView;
    private ILogicalStructureType fType;
    private ILogicalStructureType[] fAvailableTypes;

    public SelectLogicalStructureAction(VariablesView view, ILogicalStructureType type, IValue value, ILogicalStructureType[] availableTypes) {
        super(type.getDescription(value), 2);
        this.setView(view);
        this.fAvailableTypes = availableTypes;
        this.fType = type;
    }

    public void run() {
        this.valueChanged();
    }

    private void valueChanged() {
        if (!this.getView().isAvailable()) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getView().getViewer().getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                ILogicalStructureType type = null;
                IAction action = SelectLogicalStructureAction.this.getView().getAction("ToggleContentProviders");
                if (SelectLogicalStructureAction.this.isChecked()) {
                    type = SelectLogicalStructureAction.this.fType;
                    action.setChecked(true);
                }
                action.run();
                DebugPlugin.setDefaultStructureType((ILogicalStructureType[])SelectLogicalStructureAction.this.fAvailableTypes, (ILogicalStructureType)type);
                SelectLogicalStructureAction.this.getView().getViewer().refresh();
            }
        });
    }

    protected VariablesView getView() {
        return this.fView;
    }

    protected void setView(VariablesView view) {
        this.fView = view;
    }
}

