/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelTidAspect;
import org.eclipse.tracecompass.common.core.StreamUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.Attributes;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Activator;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Messages;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.actions.FollowThreadAction;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.ControlFlowCheckActiveProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.ControlFlowColumnComparators;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.ControlFlowEntry;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.ControlFlowPresentationProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.NaiveOptimizationAlgorithm;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.PackageMessages;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.interval.TmfStateInterval;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.util.Pair;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.ITimeGraphEntryActiveProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeLinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public class ControlFlowView
extends AbstractTimeGraphView {
    public static final @NonNull String ID = "org.eclipse.tracecompass.analysis.os.linux.views.controlflow";
    private static final String ICONS_PATH = "icons/";
    private static final String OPTIMIZE_ICON = "icons/elcl16/Optimization.png";
    private static final String PROCESS_COLUMN = Messages.ControlFlowView_processColumn;
    private static final String TID_COLUMN = Messages.ControlFlowView_tidColumn;
    private static final String PTID_COLUMN = Messages.ControlFlowView_ptidColumn;
    private static final String BIRTH_TIME_COLUMN = Messages.ControlFlowView_birthTimeColumn;
    private static final String INVISIBLE_COLUMN = Messages.ControlFlowView_invisibleColumn;
    private Action fOptimizationAction;
    private static final String NEXT_EVENT_ICON_PATH = "icons/elcl16/shift_r_edit.gif";
    private static final String PREV_EVENT_ICON_PATH = "icons/elcl16/shift_l_edit.gif";
    private static final String WILDCARD = "*";
    private static final String[] COLUMN_NAMES = new String[]{PROCESS_COLUMN, TID_COLUMN, PTID_COLUMN, BIRTH_TIME_COLUMN};
    private static final String[] FILTER_COLUMN_NAMES = new String[]{PROCESS_COLUMN, TID_COLUMN};
    private static final long BUILD_UPDATE_TIMEOUT = 500L;
    private static final Comparator<ITimeGraphEntry>[] COLUMN_COMPARATORS;
    private static final Function<Collection<ILinkEvent>, Map<Integer, Long>> UPDATE_SCHEDULING_COLUMN_ALGO;
    private static final int INITIAL_SORT_COLUMN_INDEX = 3;
    private final ISchedulingRule fSearchActionMutexRule = new ISchedulingRule(){

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    };
    private final Set<ITmfTrace> fFlatTraces = new HashSet<ITmfTrace>();
    private IAction fFlatAction;
    private IAction fHierarchicalAction;
    private final Map<ITmfTrace, TreeMultimap<Integer, ControlFlowEntry>> fEntryCache = new HashMap<ITmfTrace, TreeMultimap<Integer, ControlFlowEntry>>();

    static {
        UPDATE_SCHEDULING_COLUMN_ALGO = new NaiveOptimizationAlgorithm();
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)ControlFlowColumnComparators.PROCESS_NAME_COLUMN_COMPARATOR).add((Object)ControlFlowColumnComparators.TID_COLUMN_COMPARATOR).add((Object)ControlFlowColumnComparators.PTID_COLUMN_COMPARATOR).add((Object)ControlFlowColumnComparators.BIRTH_TIME_COLUMN_COMPARATOR);
        ImmutableList l = builder.build();
        COLUMN_COMPARATORS = l.toArray(new Comparator[l.size()]);
    }

    public ControlFlowView() {
        super(ID, (TimeGraphPresentationProvider)new ControlFlowPresentationProvider());
        this.setTreeColumns(COLUMN_NAMES, COLUMN_COMPARATORS, 3);
        this.setTreeLabelProvider(new ControlFlowTreeLabelProvider());
        this.setFilterColumns(FILTER_COLUMN_NAMES);
        this.setFilterLabelProvider(new ControlFlowFilterLabelProvider());
        this.setEntryComparator((Comparator)ControlFlowColumnComparators.BIRTH_TIME_COLUMN_COMPARATOR);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getTimeGraphViewer().getShowFilterDialogAction().getFilterDialog().addTimeGraphFilterCheckActiveButton((ITimeGraphEntryActiveProvider)new ControlFlowCheckActiveProvider(Messages.ControlFlowView_checkActiveLabel, Messages.ControlFlowView_checkActiveToolTip));
        this.getTimeGraphViewer().getShowFilterDialogAction().getFilterDialog().addTimeGraphFilterUncheckInactiveButton((ITimeGraphEntryActiveProvider)new ControlFlowCheckActiveProvider(Messages.ControlFlowView_uncheckInactiveLabel, Messages.ControlFlowView_uncheckInactiveToolTip));
    }

    protected void fillTimeGraphEntryContextMenu(@NonNull IMenuManager menuManager) {
        StructuredSelection sSel;
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        if (selection instanceof StructuredSelection && (sSel = (StructuredSelection)selection).getFirstElement() instanceof ControlFlowEntry) {
            ControlFlowEntry entry = (ControlFlowEntry)((Object)sSel.getFirstElement());
            menuManager.add((IAction)new FollowThreadAction((TmfView)this, entry.getName(), entry.getThreadId(), entry.getTrace()));
        }
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        IAction optimizationAction = this.getOptimizationAction();
        manager.appendToGroup("additions", optimizationAction);
        manager.appendToGroup("additions", (IContributionItem)new Separator());
        super.fillLocalToolBar(manager);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (section == null) {
            section = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        Action hideArrowsAction = this.getTimeGraphViewer().getHideArrowsAction(section);
        manager.appendToGroup("additions", (IAction)hideArrowsAction);
        Action followArrowBwdAction = this.getTimeGraphViewer().getFollowArrowBwdAction();
        followArrowBwdAction.setText(Messages.ControlFlowView_followCPUBwdText);
        followArrowBwdAction.setToolTipText(Messages.ControlFlowView_followCPUBwdText);
        manager.appendToGroup("additions", (IAction)followArrowBwdAction);
        Action followArrowFwdAction = this.getTimeGraphViewer().getFollowArrowFwdAction();
        followArrowFwdAction.setText(Messages.ControlFlowView_followCPUFwdText);
        followArrowFwdAction.setToolTipText(Messages.ControlFlowView_followCPUFwdText);
        manager.appendToGroup("additions", (IAction)followArrowFwdAction);
        SearchEventAction previousEventAction = new SearchEventAction(false, PackageMessages.ControlFlowView_PreviousEventJobName);
        previousEventAction.setText(PackageMessages.ControlFlowView_PreviousEventActionName);
        previousEventAction.setToolTipText(PackageMessages.ControlFlowView_PreviousEventActionTooltip);
        previousEventAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath(PREV_EVENT_ICON_PATH));
        manager.appendToGroup("additions", (IAction)previousEventAction);
        SearchEventAction nextEventAction = new SearchEventAction(true, PackageMessages.ControlFlowView_NextEventJobName);
        nextEventAction.setText(PackageMessages.ControlFlowView_NextEventActionName);
        nextEventAction.setToolTipText(PackageMessages.ControlFlowView_NextEventActionTooltip);
        nextEventAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath(NEXT_EVENT_ICON_PATH));
        manager.appendToGroup("additions", (IAction)nextEventAction);
    }

    private IAction getOptimizationAction() {
        if (this.fOptimizationAction == null) {
            this.fOptimizationAction = new OptimizationAction();
            this.fOptimizationAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath(OPTIMIZE_ICON));
            this.fOptimizationAction.setText(Messages.ControlFlowView_optimizeLabel);
            this.fOptimizationAction.setToolTipText(Messages.ControlFlowView_optimizeToolTip);
        }
        return this.fOptimizationAction;
    }

    protected void fillLocalMenu(IMenuManager manager) {
        super.fillLocalMenu(manager);
        MenuManager item = new MenuManager(Messages.ControlFlowView_threadPresentation);
        this.fFlatAction = this.createFlatAction();
        item.add(this.fFlatAction);
        this.fHierarchicalAction = this.createHierarchicalAction();
        item.add(this.fHierarchicalAction);
        manager.add((IContributionItem)item);
    }

    private IAction createHierarchicalAction() {
        Action action = new Action(Messages.ControlFlowView_hierarchicalViewLabel, 8){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Issues handling annotations - annotations may be inaccurate
             */
            public void run() {
                ITmfTrace parentTrace = ControlFlowView.this.getTrace();
                Set set = ControlFlowView.this.fFlatTraces;
                synchronized (set) {
                    ControlFlowView.this.fFlatTraces.remove(parentTrace);
                    @NonNull List entryList = ControlFlowView.this.getEntryList(parentTrace);
                    if (entryList != null) {
                        for (TimeGraphEntry traceEntry : entryList) {
                            ControlFlowView.addEntriesToHierarchicalTree(Iterables.filter((Iterable)traceEntry.getChildren(), ControlFlowEntry.class), traceEntry);
                        }
                    }
                }
                ControlFlowView.this.refresh();
            }
        };
        action.setChecked(true);
        action.setToolTipText(Messages.ControlFlowView_hierarchicalViewToolTip);
        return action;
    }

    private IAction createFlatAction() {
        Action action = new Action(Messages.ControlFlowView_flatViewLabel, 8){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Issues handling annotations - annotations may be inaccurate
             */
            public void run() {
                ITmfTrace parentTrace = ControlFlowView.this.getTrace();
                Set set = ControlFlowView.this.fFlatTraces;
                synchronized (set) {
                    ControlFlowView.this.fFlatTraces.add(parentTrace);
                    @NonNull List entryList = ControlFlowView.this.getEntryList(parentTrace);
                    if (entryList != null) {
                        for (TimeGraphEntry traceEntry : entryList) {
                            ControlFlowView.hierarchicalToFlatTree(traceEntry);
                        }
                    }
                }
                ControlFlowView.this.refresh();
            }
        };
        action.setToolTipText(Messages.ControlFlowView_flatViewToolTip);
        return action;
    }

    protected String getNextText() {
        return Messages.ControlFlowView_nextProcessActionNameText;
    }

    protected String getNextTooltip() {
        return Messages.ControlFlowView_nextProcessActionToolTipText;
    }

    protected String getPrevText() {
        return Messages.ControlFlowView_previousProcessActionNameText;
    }

    protected String getPrevTooltip() {
        return Messages.ControlFlowView_previousProcessActionToolTipText;
    }

    public Function<Collection<ILinkEvent>, Map<Integer, Long>> getUpdatedSchedulingColumn() {
        return UPDATE_SCHEDULING_COLUMN_ALGO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        super.traceClosed(signal);
        ITmfTrace parentTrace = signal.getTrace();
        Object object = this.fFlatTraces;
        synchronized (object) {
            this.fFlatTraces.remove(parentTrace);
        }
        object = this.fEntryCache;
        synchronized (object) {
            for (ITmfTrace trace : TmfTraceManager.getTraceSet((ITmfTrace)parentTrace)) {
                this.fEntryCache.remove(trace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        super.traceSelected(signal);
        Set<ITmfTrace> set = this.fFlatTraces;
        synchronized (set) {
            if (this.fFlatTraces.contains(signal.getTrace())) {
                this.fHierarchicalAction.setChecked(false);
                this.fFlatAction.setChecked(true);
            } else {
                this.fFlatAction.setChecked(false);
                this.fHierarchicalAction.setChecked(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildEntryList(ITmfTrace trace, ITmfTrace parentTrace, IProgressMonitor monitor) {
        ITmfStateSystem ssq = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)trace, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        if (ssq == null) {
            return;
        }
        ArrayList<ControlFlowEntry> entryList = new ArrayList<ControlFlowEntry>();
        HashMap<Pair, ControlFlowEntry> entryMap = new HashMap<Pair, ControlFlowEntry>();
        TreeMultimap execNamesPPIDs = TreeMultimap.create(Comparator.naturalOrder(), Comparator.comparing(ITmfStateInterval::getStartTime));
        TreeMultimap pidMap = TreeMultimap.create(Comparator.naturalOrder(), Comparator.comparing(TimeGraphEntry::getStartTime));
        Map<ITmfTrace, TreeMultimap<Integer, ControlFlowEntry>> map = this.fEntryCache;
        synchronized (map) {
            this.fEntryCache.put(trace, (TreeMultimap<Integer, ControlFlowEntry>)pidMap);
        }
        long start = ssq.getStartTime();
        this.setStartTime(Long.min(this.getStartTime(), start));
        TraceEntry traceEntry = new TraceEntry(trace, ssq, ssq.getCurrentEndTime() + 1L);
        this.addToEntryList(parentTrace, Collections.singletonList(traceEntry));
        boolean complete = false;
        while (!(complete || monitor.isCanceled() || ssq.isCancelled())) {
            Object threadQuark2;
            complete = ssq.waitUntilBuilt(500L);
            long end = ssq.getCurrentEndTime();
            if (start == end && !complete) continue;
            traceEntry.updateEndTime(end + 1L);
            this.setEndTime(Long.max(this.getEndTime(), end + 1L));
            ArrayList quarks = new ArrayList(ssq.getQuarks(new String[]{"Threads", WILDCARD, "Exec_name"}));
            quarks.addAll(ssq.getQuarks(new String[]{"Threads", WILDCARD, "PPID"}));
            long queryStart = Long.max(start, ssq.getStartTime());
            long queryEnd = Long.min(end, ssq.getCurrentEndTime());
            execNamesPPIDs.clear();
            try {
                for (ITmfStateInterval interval : ssq.query2D(quarks, queryStart, queryEnd)) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    execNamesPPIDs.put((Object)interval.getAttribute(), (Object)interval);
                }
            }
            catch (TimeRangeException e2) {
                Activator.getDefault().logError("CFV: incorrect query times for buildEntryList", e2);
                continue;
            }
            catch (StateSystemDisposedException e3) {
                return;
            }
            for (Object threadQuark2 : ssq.getQuarks(new String[]{"Threads", WILDCARD})) {
                String threadAttributeName = ssq.getAttributeName(((Integer)threadQuark2).intValue());
                Pair entryKey = Attributes.parseThreadAttributeName((String)threadAttributeName);
                int threadId = (Integer)entryKey.getFirst();
                if (threadId < 0) continue;
                int execNameQuark = ssq.optQuarkRelative(((Integer)threadQuark2).intValue(), new String[]{"Exec_name"});
                int ppidQuark = ssq.optQuarkRelative(((Integer)threadQuark2).intValue(), new String[]{"PPID"});
                NavigableSet ppidIterator = execNamesPPIDs.get((Object)ppidQuark);
                for (ITmfStateInterval execNameInterval : execNamesPPIDs.get((Object)execNameQuark)) {
                    if (execNameInterval.getValue() == null) {
                        entryMap.remove(entryKey);
                        continue;
                    }
                    ControlFlowEntry entry = (ControlFlowEntry)((Object)entryMap.get(entryKey));
                    long startTime = execNameInterval.getStartTime();
                    long endTime = execNameInterval.getEndTime() + 1L;
                    String execName = String.valueOf(execNameInterval.getValue());
                    int ppid = ControlFlowView.getPpid(ppidIterator, endTime);
                    if (entry == null) {
                        entry = new ControlFlowEntry((Integer)threadQuark2, trace, execName, threadId, ppid, startTime, endTime);
                        entryList.add(entry);
                        entryMap.put(entryKey, entry);
                    } else {
                        entry.setName(execName);
                        entry.setParentThreadId(ppid);
                        entry.updateEndTime(endTime);
                    }
                    Map<ITmfTrace, TreeMultimap<Integer, ControlFlowEntry>> map2 = this.fEntryCache;
                    synchronized (map2) {
                        pidMap.put((Object)threadId, (Object)entry);
                    }
                }
            }
            threadQuark2 = this.fFlatTraces;
            synchronized (threadQuark2) {
                if (this.fFlatTraces.contains(parentTrace)) {
                    ControlFlowView.addEntriesToFlatTree(entryList, traceEntry);
                } else {
                    ControlFlowView.addEntriesToHierarchicalTree(entryList, traceEntry);
                }
            }
            long resolution = Long.max(1L, (end - ssq.getStartTime()) / (long)this.getDisplayWidth());
            Iterable entries = Iterables.transform(entryList, e -> e);
            this.zoomEntries(entries, ssq.getStartTime(), end, resolution, monitor);
            if (parentTrace.equals(this.getTrace())) {
                this.refresh();
            }
            start = end;
        }
    }

    private static int getPpid(NavigableSet<ITmfStateInterval> ppidIterator, long t) {
        Object o;
        ITmfStateInterval ppidInterval = ppidIterator.lower((ITmfStateInterval)new TmfStateInterval(t, t + 1L, 0, (Object)0));
        if (ppidInterval != null && (o = ppidInterval.getValue()) instanceof Integer) {
            return (Integer)o;
        }
        return -1;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void hierarchicalToFlatTree(TimeGraphEntry traceEntry) {
        @NonNull List rootList = traceEntry.getChildren();
        StreamUtils.StreamFlattener sf = new StreamUtils.StreamFlattener(entry -> entry.getChildren().stream());
        Stream allEntries = rootList.stream().flatMap(arg_0 -> ((StreamUtils.StreamFlattener)sf).flatten(arg_0));
        List<@NonNull TimeGraphEntry> rootListToAdd = allEntries.filter(entry -> !rootList.contains(entry)).collect(Collectors.toList());
        rootList.forEach(TimeGraphEntry::clearChildren);
        rootListToAdd.forEach(entry -> {
            traceEntry.addChild(entry);
            entry.clearChildren();
        });
    }

    private static void addEntriesToFlatTree(List<@NonNull ControlFlowEntry> entryList, TimeGraphEntry traceEntry) {
        List rootList = traceEntry.getChildren();
        for (ControlFlowEntry entry : entryList) {
            if (rootList.contains((Object)entry)) continue;
            traceEntry.addChild((TimeGraphEntry)entry);
        }
    }

    private static void addEntriesToHierarchicalTree(Iterable<ControlFlowEntry> entryList, TimeGraphEntry traceEntry) {
        List rootList = traceEntry.getChildren();
        for (ControlFlowEntry entry : entryList) {
            boolean root;
            boolean bl = root = entry.getParent() == null || entry.getParent() == traceEntry;
            if (root && entry.getParentThreadId() > 0) {
                for (ControlFlowEntry parent : entryList) {
                    if (parent.getThreadId() != entry.getParentThreadId() || entry.getStartTime() > parent.getEndTime() || entry.getEndTime() < parent.getStartTime()) continue;
                    root = false;
                    if (rootList.contains((Object)entry)) {
                        traceEntry.removeChild((TimeGraphEntry)entry);
                    }
                    parent.addChild(entry);
                    break;
                }
            }
            if (!root || rootList.contains((Object)entry)) continue;
            traceEntry.addChild((TimeGraphEntry)entry);
        }
    }

    /*
     * Exception decompiling
     */
    protected void zoomEntries(@NonNull Iterable<@NonNull TimeGraphEntry> entries, long zoomStartTime, long zoomEndTime, long resolution, @NonNull IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Table<ITmfStateSystem, Integer, ControlFlowEntry> filterGroupEntries(Iterable<TimeGraphEntry> visible, long zoomStartTime, long zoomEndTime) {
        HashBasedTable quarksToEntries = HashBasedTable.create();
        for (ControlFlowEntry entry : Iterables.filter(visible, ControlFlowEntry.class)) {
            if (zoomStartTime > entry.getEndTime() || zoomEndTime < entry.getStartTime()) continue;
            quarksToEntries.put((Object)ControlFlowView.getStateSystem((ITimeGraphEntry)entry), (Object)entry.getThreadQuark(), (Object)entry);
        }
        return quarksToEntries;
    }

    private static ITmfStateSystem getStateSystem(ITimeGraphEntry controlFlowEntry) {
        ITimeGraphEntry parent = controlFlowEntry.getParent();
        while (parent != null) {
            if (parent instanceof TraceEntry) {
                return ((TraceEntry)parent).getStateSystem();
            }
            parent = parent.getParent();
        }
        return null;
    }

    private static List<ITimeEvent> createTimeEvents(ControlFlowEntry controlFlowEntry, Collection<ITmfStateInterval> value) {
        ArrayList<ITimeEvent> events = new ArrayList<ITimeEvent>(value.size());
        TimeEvent prev = null;
        for (ITmfStateInterval interval : value) {
            long prevEnd;
            TimeEvent event = ControlFlowView.createTimeEvent(interval, controlFlowEntry);
            if (prev != null && (prevEnd = prev.getTime() + prev.getDuration()) < event.getTime()) {
                events.add((ITimeEvent)new TimeEvent((ITimeGraphEntry)controlFlowEntry, prevEnd, event.getTime() - prevEnd));
            }
            prev = event;
            events.add((ITimeEvent)event);
        }
        return events;
    }

    private static TimeEvent createTimeEvent(ITmfStateInterval interval, ControlFlowEntry controlFlowEntry) {
        long startTime = interval.getStartTime();
        long duration = interval.getEndTime() - startTime + 1L;
        Object status = interval.getValue();
        if (status instanceof Integer) {
            return new TimeEvent((ITimeGraphEntry)controlFlowEntry, startTime, duration, ((Integer)status).intValue());
        }
        return new NullTimeEvent((ITimeGraphEntry)controlFlowEntry, startTime, duration);
    }

    /*
     * Exception decompiling
     */
    protected List<@NonNull ILinkEvent> getLinkList(long zoomStartTime, long zoomEndTime, long resolution, @NonNull IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<@NonNull ILinkEvent> createCpuArrows(TraceEntry entry, NavigableSet<ITmfStateInterval> intervals) throws StateSystemDisposedException {
        ITmfStateInterval last;
        long end;
        if (intervals.isEmpty()) {
            return Collections.emptyList();
        }
        ITmfStateSystem ss = entry.getStateSystem();
        ITmfStateInterval first = (ITmfStateInterval)intervals.first();
        long start = first.getStartTime() - 1L;
        if (start >= ss.getStartTime() && Objects.equals(first.getValue(), 0)) {
            intervals.add(ss.querySingleState(start, first.getAttribute()));
        }
        if ((end = (last = (ITmfStateInterval)intervals.last()).getEndTime() + 1L) <= ss.getCurrentEndTime() && Objects.equals(last.getValue(), 0)) {
            intervals.add(ss.querySingleState(end, last.getAttribute()));
        }
        ArrayList<@NonNull ILinkEvent> linkList = new ArrayList<ILinkEvent>();
        long prevEnd = 0L;
        long lastEnd = 0L;
        ControlFlowEntry prevEntry = null;
        for (ITmfStateInterval currentThreadInterval : intervals) {
            long time = currentThreadInterval.getStartTime();
            if (time != lastEnd) {
                prevEntry = null;
                prevEnd = 0L;
            }
            Integer tid = (Integer)currentThreadInterval.getValue();
            lastEnd = currentThreadInterval.getEndTime() + 1L;
            ControlFlowEntry nextEntry = null;
            if (tid == null || tid <= 0) continue;
            nextEntry = this.findEntry(entry.getTrace(), tid, time);
            if (prevEntry != null) {
                linkList.add((ILinkEvent)new TimeLinkEvent((ITimeGraphEntry)prevEntry, (ITimeGraphEntry)nextEntry, prevEnd, time - prevEnd, 0));
            }
            prevEntry = nextEntry;
            prevEnd = lastEnd;
        }
        return linkList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ControlFlowEntry findEntry(@NonNull ITmfTrace trace, int tid, long time) {
        Map<ITmfTrace, TreeMultimap<Integer, ControlFlowEntry>> map = this.fEntryCache;
        synchronized (map) {
            TreeMultimap<Integer, ControlFlowEntry> pidMap;
            block4: {
                pidMap = this.fEntryCache.get(trace);
                if (pidMap != null) break block4;
                return null;
            }
            return (ControlFlowEntry)((Object)Iterables.find((Iterable)pidMap.get((Object)tid), cfe -> cfe.getStartTime() <= time && time <= cfe.getEndTime(), null));
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private int getCurrentThread(long time) {
        @NonNull List entryList = this.getEntryList(this.getTrace());
        if (entryList == null) {
            return -1;
        }
        for (TimeGraphEntry entry : entryList) {
            TraceEntry traceEntry = (TraceEntry)entry;
            ITmfStateSystem ssq = traceEntry.getStateSystem();
            if (time < ssq.getStartTime() || time > ssq.getCurrentEndTime()) continue;
            List currentThreadQuarks = ssq.getQuarks(new String[]{"CPUs", WILDCARD, "Current_thread"});
            try {
                Iterator iterator = currentThreadQuarks.iterator();
                while (iterator.hasNext()) {
                    int statusQuark;
                    ITmfStateInterval statusInterval;
                    int currentThreadQuark = (Integer)iterator.next();
                    ITmfStateInterval currentThreadInterval = ssq.querySingleState(time, currentThreadQuark);
                    Integer currentThread = (Integer)currentThreadInterval.getValue();
                    if (currentThread == null || currentThread <= 0 || (statusInterval = ssq.querySingleState(time, statusQuark = ssq.getQuarkAbsolute(new String[]{"Threads", Integer.toString(currentThread)}))).getStartTime() != time) continue;
                    return currentThread;
                }
            }
            catch (AttributeNotFoundException e) {
                Activator.getDefault().logError(e.getMessage());
            }
            catch (StateSystemDisposedException stateSystemDisposedException) {
                // empty catch block
            }
        }
        return -1;
    }

    protected void synchingToTime(long time) {
        int currentThread = this.getCurrentThread(time);
        if (currentThread > 0) {
            ITimeGraphEntry[] iTimeGraphEntryArray = this.getTimeGraphViewer().getExpandedElements();
            int n = iTimeGraphEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ControlFlowEntry entry;
                ITimeGraphEntry element = iTimeGraphEntryArray[n2];
                if (element instanceof ControlFlowEntry && (entry = (ControlFlowEntry)element).getThreadId() == currentThread) {
                    this.getTimeGraphViewer().setSelection((ISelection)entry, true);
                    break;
                }
                ++n2;
            }
        }
    }

    private static /* synthetic */ void lambda$4(ControlFlowEntry controlFlowEntry, List list, TimeGraphEntry.Sampling sampling) {
        controlFlowEntry.setZoomedEventList(list);
        controlFlowEntry.setSampling(sampling);
    }

    private static class ControlFlowFilterLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private ControlFlowFilterLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof TraceEntry) {
                if (columnIndex == 0) {
                    return ((TraceEntry)((Object)element)).getName();
                }
                return "";
            }
            ControlFlowEntry entry = (ControlFlowEntry)((Object)element);
            if (columnIndex == 0) {
                return entry.getName();
            }
            if (columnIndex == 1) {
                return Integer.toString(entry.getThreadId());
            }
            return "";
        }
    }

    protected static class ControlFlowTreeLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        protected ControlFlowTreeLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof TraceEntry) {
                if (columnIndex == 0) {
                    return ((TraceEntry)((Object)element)).getName();
                }
                return "";
            }
            ControlFlowEntry entry = (ControlFlowEntry)((Object)element);
            if (COLUMN_NAMES[columnIndex].equals(Messages.ControlFlowView_processColumn)) {
                return entry.getName();
            }
            if (COLUMN_NAMES[columnIndex].equals(Messages.ControlFlowView_tidColumn)) {
                return Integer.toString(entry.getThreadId());
            }
            if (COLUMN_NAMES[columnIndex].equals(Messages.ControlFlowView_ptidColumn)) {
                if (entry.getParentThreadId() > 0) {
                    return Integer.toString(entry.getParentThreadId());
                }
            } else {
                if (COLUMN_NAMES[columnIndex].equals(Messages.ControlFlowView_birthTimeColumn)) {
                    return Utils.formatTime((long)entry.getStartTime(), (Utils.TimeFormat)Utils.TimeFormat.CALENDAR, (Utils.Resolution)Utils.Resolution.NANOSEC);
                }
                if (COLUMN_NAMES[columnIndex].equals(Messages.ControlFlowView_traceColumn)) {
                    return entry.getTrace().getName();
                }
                if (COLUMN_NAMES[columnIndex].equals(INVISIBLE_COLUMN)) {
                    return Long.toString(entry.getSchedulingPosition());
                }
            }
            return "";
        }
    }

    private final class OptimizationAction
    extends Action {
        private OptimizationAction() {
        }

        public void runWithEvent(Event event) {
            ITmfTrace parentTrace = ControlFlowView.this.getTrace();
            if (parentTrace == null) {
                return;
            }
            ControlFlowView.this.createFlatAction().run();
            List arrows = ControlFlowView.this.getTimeGraphViewer().getTimeGraphControl().getArrows();
            List currentList = ControlFlowView.this.getEntryList(parentTrace);
            if (currentList == null) {
                return;
            }
            Map<Integer, Long> orderedTidMap = ControlFlowView.this.getUpdatedSchedulingColumn().apply(arrows);
            for (TimeGraphEntry entry : currentList) {
                if (!(entry instanceof TraceEntry)) continue;
                for (TimeGraphEntry child : ((TraceEntry)entry).getChildren()) {
                    if (!(child instanceof ControlFlowEntry)) continue;
                    ControlFlowEntry cEntry = (ControlFlowEntry)child;
                    cEntry.setSchedulingPosition(orderedTidMap.getOrDefault(cEntry.getThreadId(), Long.MAX_VALUE));
                }
            }
            ControlFlowView.this.setEntryComparator((Comparator)ControlFlowColumnComparators.SCHEDULING_COLUMN_COMPARATOR);
            ControlFlowView.this.refresh();
        }
    }

    private class SearchEventAction
    extends Action {
        private final boolean ifDirection;
        private final String ifJobName;

        public SearchEventAction(boolean direction, String jobName) {
            this.ifDirection = direction;
            this.ifJobName = jobName;
        }

        public void run() {
            Job job = new Job(this.ifJobName){

                protected IStatus run(IProgressMonitor monitor) {
                    ITmfEvent event2;
                    long ts;
                    TimeGraphControl ctrl = ControlFlowView.this.getTimeGraphViewer().getTimeGraphControl();
                    ITimeGraphEntry traceEntry = ctrl.getSelectedTrace();
                    ITimeEvent selectedState = Utils.findEvent((ITimeGraphEntry)traceEntry, (long)(ts = ControlFlowView.this.getTimeGraphViewer().getSelectionBegin()), (int)0);
                    if (selectedState == null) {
                        return Status.OK_STATUS;
                    }
                    ITimeGraphEntry entry = selectedState.getEntry();
                    if (!(entry instanceof ControlFlowEntry)) {
                        return Status.OK_STATUS;
                    }
                    ControlFlowEntry cfEntry = (ControlFlowEntry)entry;
                    int tid = cfEntry.getThreadId();
                    ITmfTrace trace = cfEntry.getTrace();
                    ITmfContext ctx = trace.seekEvent(TmfTimestamp.fromNanos((long)ts));
                    long rank = ctx.getRank();
                    ctx.dispose();
                    Predicate<@NonNull ITmfEvent> predicate = event -> Objects.equals(tid, KernelTidAspect.INSTANCE.resolve(event));
                    ITmfEvent iTmfEvent = event2 = SearchEventAction.this.ifDirection ? TmfTraceUtils.getNextEventMatching((ITmfTrace)cfEntry.getTrace(), (long)rank, predicate, (IProgressMonitor)monitor) : TmfTraceUtils.getPreviousEventMatching((ITmfTrace)cfEntry.getTrace(), (long)rank, predicate, (IProgressMonitor)monitor);
                    if (event2 != null) {
                        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, event2.getTimestamp(), event2.getTimestamp(), ControlFlowView.this.getTrace()));
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setRule(ControlFlowView.this.fSearchActionMutexRule);
            job.schedule();
        }
    }

    private static class TraceEntry
    extends TimeGraphEntry {
        private final @NonNull ITmfTrace fTrace;
        private final @NonNull ITmfStateSystem fStateSystem;

        public TraceEntry(@NonNull ITmfTrace trace, ITmfStateSystem ssq, long endTime) {
            super(trace.getName(), ssq.getStartTime(), endTime);
            this.fTrace = trace;
            this.fStateSystem = ssq;
        }

        public boolean hasTimeEvents() {
            return false;
        }

        public @NonNull ITmfTrace getTrace() {
            return this.fTrace;
        }

        public @NonNull ITmfStateSystem getStateSystem() {
            return this.fStateSystem;
        }
    }
}

