/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.core.diff.FastDiffFilter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffChangeEvent;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.ResourceModelTraversalCalculator;
import org.eclipse.team.ui.mapping.SynchronizationContentProvider;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;

public class ResourceModelContentProvider
extends SynchronizationContentProvider
implements ITreePathContentProvider {
    private WorkbenchContentProvider provider;

    @Override
    protected ITreeContentProvider getDelegateContentProvider() {
        if (this.provider == null) {
            this.provider = new WorkbenchContentProvider();
        }
        return this.provider;
    }

    @Override
    protected String getModelProviderId() {
        return "org.eclipse.core.resources.modelProvider";
    }

    @Override
    protected Object getModelRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    @Override
    protected boolean isInScope(ISynchronizationScope scope, Object parent, Object elementOrPath) {
        Object object = this.internalGetElement(elementOrPath);
        if (object instanceof IResource) {
            IResource resource = (IResource)object;
            if (!resource.getProject().isAccessible()) {
                return false;
            }
            if (scope.contains(resource)) {
                return true;
            }
            if (this.hasChildrenInScope(scope, object, resource)) {
                return true;
            }
        }
        return false;
    }

    private boolean hasChildrenInScope(ISynchronizationScope scope, Object object, IResource resource) {
        if (!resource.isAccessible()) {
            return false;
        }
        IResource[] roots = scope.getRoots();
        int i = 0;
        while (i < roots.length) {
            IResource root = roots[i];
            if (resource.getFullPath().isPrefixOf(root.getFullPath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void init(ICommonContentExtensionSite site) {
        super.init(site);
        TeamUIPlugin.getPlugin().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    @Override
    public void dispose() {
        if (this.provider != null) {
            this.provider.dispose();
        }
        super.dispose();
        TeamUIPlugin.getPlugin().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.team.ui.default_layout")) {
            this.refresh();
        }
        super.propertyChange(event);
    }

    @Override
    protected Object[] getChildrenInContext(ISynchronizationContext context, Object parentOrPath, Object[] children) {
        Object parent = this.internalGetElement(parentOrPath);
        if (parent instanceof IResource) {
            IResource resource = (IResource)parent;
            if (resource.getType() == 4 && !resource.getProject().isAccessible()) {
                return new Object[0];
            }
            IResourceDiffTree diffTree = context.getDiffTree();
            children = this.getTraversalCalculator().filterChildren(diffTree, resource, parentOrPath, children);
            if (children.length != 0) {
                children = this.getChildrenInScope(context.getScope(), parentOrPath, children);
            }
            if (children.length != 0) {
                children = this.internalGetChildren(context, parentOrPath, children);
            }
            return children;
        }
        return super.getChildrenInContext(context, parentOrPath, children);
    }

    private Object[] internalGetChildren(ISynchronizationContext context, Object parent, Object[] children) {
        ArrayList<Object> result = new ArrayList<Object>(children.length);
        int i = 0;
        while (i < children.length) {
            Object object = children[i];
            if (parent instanceof TreePath) {
                TreePath tp = (TreePath)parent;
                object = tp.createChildPath(object);
            }
            if (this.isVisible(context, object)) {
                result.add(this.internalGetElement(object));
            }
            ++i;
        }
        return result.toArray(new Object[result.size()]);
    }

    @Override
    protected ResourceTraversal[] getTraversals(ISynchronizationContext context, Object elementOrPath) {
        Object object = this.internalGetElement(elementOrPath);
        ISynchronizationScope scope = context.getScope();
        ResourceMapping mapping = scope.getMapping(object);
        if (mapping != null) {
            ResourceTraversal[] traversals = scope.getTraversals(mapping);
            if (traversals == null) {
                return new ResourceTraversal[0];
            }
            return traversals;
        }
        if (object instanceof IResource) {
            IResource resource = (IResource)object;
            if (scope.contains(resource)) {
                ArrayList<ResourceTraversal> result = new ArrayList<ResourceTraversal>();
                ResourceTraversal[] traversals = scope.getTraversals();
                if (traversals == null) {
                    return result.toArray(new ResourceTraversal[result.size()]);
                }
                int i = 0;
                while (i < traversals.length) {
                    ResourceTraversal traversal = traversals[i];
                    if (traversal.contains(resource)) {
                        boolean include = false;
                        int depth = traversal.getDepth();
                        if (depth == 2) {
                            include = true;
                        } else {
                            IResource[] roots = traversal.getResources();
                            int j = 0;
                            while (j < roots.length) {
                                IResource root = roots[j];
                                if (root.equals((Object)resource)) {
                                    include = true;
                                    break;
                                }
                                if (root.getFullPath().equals((Object)resource.getFullPath().removeLastSegments(1)) && depth == 1) {
                                    include = true;
                                    depth = 0;
                                    break;
                                }
                                ++j;
                            }
                        }
                        if (include) {
                            int layoutDepth = this.getTraversalCalculator().getLayoutDepth(resource, this.internalGetPath(elementOrPath));
                            result.add(new ResourceTraversal(new IResource[]{resource}, Math.min(depth, layoutDepth), 0));
                        }
                    }
                    ++i;
                }
                return result.toArray(new ResourceTraversal[result.size()]);
            }
            ResourceMapping[] mappings = scope.getMappings("org.eclipse.core.resources.modelProvider");
            ArrayList<ResourceTraversal> result = new ArrayList<ResourceTraversal>();
            int i = 0;
            while (i < mappings.length) {
                ResourceTraversal[] traversals;
                ResourceMapping resourceMapping = mappings[i];
                Object element = resourceMapping.getModelObject();
                IResource root = this.getResource(element);
                if (root != null && resource.getFullPath().isPrefixOf(root.getFullPath()) && (mapping = scope.getMapping(element)) != null && (traversals = scope.getTraversals(mapping)) != null) {
                    result.addAll(Arrays.asList(traversals));
                }
                ++i;
            }
            return result.toArray(new ResourceTraversal[result.size()]);
        }
        return new ResourceTraversal[0];
    }

    private IResource getResource(Object element) {
        if (element instanceof IResource) {
            return (IResource)element;
        }
        return Utils.getResource(element);
    }

    @Override
    protected boolean hasChildrenInContext(ISynchronizationContext context, Object elementOrPath) {
        return this.getTraversalCalculator().hasChildren(context, elementOrPath);
    }

    @Override
    public void propertyChanged(IDiffTree tree, int property, final IPath[] paths) {
        Utils.asyncExec(new Runnable(){

            @Override
            public void run() {
                ISynchronizationContext context = ResourceModelContentProvider.this.getContext();
                if (context != null) {
                    ResourceModelContentProvider.this.updateLabels(context, paths);
                }
            }
        }, (StructuredViewer)this.getViewer());
    }

    private IResource[] getResources(ISynchronizationContext context, IPath[] paths) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        int i = 0;
        while (i < paths.length) {
            IPath path = paths[i];
            IResource resource = this.getResource(context, path);
            if (resource != null) {
                resources.add(resource);
            }
            ++i;
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    private IResource getResource(ISynchronizationContext context, IPath path) {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (resource != null) {
            return resource;
        }
        if (context != null) {
            IResourceDiffTree diffTree = context.getDiffTree();
            IDiff node = diffTree.getDiff(path);
            if (node != null) {
                return diffTree.getResource(node);
            }
            if (diffTree.getChildren(path).length > 0) {
                if (path.segmentCount() == 1) {
                    return ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                }
                if (path.segmentCount() > 1) {
                    return ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
                }
            }
        }
        return null;
    }

    protected StructuredViewer getStructuredViewer() {
        return (StructuredViewer)this.getViewer();
    }

    @Override
    public Object[] getChildren(Object parent) {
        if (parent instanceof ISynchronizationContext) {
            parent = this.getModelRoot();
        }
        return super.getChildren(parent);
    }

    @Override
    public boolean hasChildren(Object element) {
        if (element instanceof ISynchronizationContext) {
            element = this.getModelRoot();
        }
        return super.hasChildren(element);
    }

    @Override
    public Object[] getElements(Object parent) {
        if (parent instanceof ISynchronizationContext) {
            parent = this.getModelRoot();
        }
        return super.getElements(parent);
    }

    @Override
    public Object getParent(Object elementOrPath) {
        ISynchronizationContext context;
        Object element = this.internalGetElement(elementOrPath);
        if (element instanceof IProject && (context = this.getContext()) != null) {
            return context;
        }
        return super.getParent(elementOrPath);
    }

    @Override
    protected void refresh() {
        Utils.syncExec(new Runnable(){

            @Override
            public void run() {
                TreeViewer treeViewer = (TreeViewer)ResourceModelContentProvider.this.getViewer();
                treeViewer.refresh();
            }
        }, this.getViewer().getControl());
    }

    protected void updateLabels(ISynchronizationContext context, IPath[] paths) {
        Object[] resources = this.getResources(context, paths);
        if (resources.length > 0) {
            ((AbstractTreeViewer)this.getViewer()).update(resources, null);
        }
    }

    protected ResourceModelTraversalCalculator getTraversalCalculator() {
        return ResourceModelTraversalCalculator.getTraversalCalculator(this.getConfiguration());
    }

    @Override
    protected boolean isVisible(IDiff diff) {
        return super.isVisible(diff);
    }

    public Object[] getChildren(TreePath parentPath) {
        return this.getChildren((Object)parentPath);
    }

    public boolean hasChildren(TreePath path) {
        return this.hasChildren((Object)path);
    }

    public TreePath[] getParents(Object element) {
        TreePath path = this.getTraversalCalculator().getParentPath(this.getContext(), this.getModelProvider(), element);
        if (path != null) {
            return new TreePath[]{path};
        }
        return new TreePath[0];
    }

    private Object internalGetElement(Object elementOrPath) {
        if (elementOrPath instanceof TreePath) {
            TreePath tp = (TreePath)elementOrPath;
            return tp.getLastSegment();
        }
        return elementOrPath;
    }

    private TreePath internalGetPath(Object elementOrPath) {
        if (elementOrPath instanceof TreePath) {
            return (TreePath)elementOrPath;
        }
        return null;
    }

    @Override
    public void diffsChanged(final IDiffChangeEvent event, IProgressMonitor monitor) {
        Utils.syncExec(new Runnable(){

            @Override
            public void run() {
                ResourceModelContentProvider.this.handleChange(event);
            }
        }, (StructuredViewer)this.getViewer());
    }

    private void handleChange(IDiffChangeEvent event) {
        int i;
        ArrayList<Object> refreshes = new ArrayList<Object>();
        ArrayList<Object> additions = new ArrayList<Object>();
        ArrayList<Object> removals = new ArrayList<Object>();
        if (this.isFlatPresentation()) {
            Set existingResources = this.getVisibleResources();
            IResource[] changedResources = this.getChangedResources(event, existingResources);
            i = 0;
            while (i < changedResources.length) {
                IResource iResource = changedResources[i];
                if (event.getTree().getDiff(iResource.getFullPath()) != null) {
                    if (existingResources.contains(iResource)) {
                        refreshes.add(iResource);
                    } else {
                        additions.add(iResource);
                    }
                } else if (existingResources.contains(iResource)) {
                    removals.add(iResource);
                }
                ++i;
            }
        } else {
            IProject[] changedProjects = this.getChangedProjects(event);
            Set existingProjects = this.getVisibleProjects();
            i = 0;
            while (i < changedProjects.length) {
                IProject iProject = changedProjects[i];
                if (this.hasVisibleChanges(event.getTree(), (IResource)iProject)) {
                    if (existingProjects.contains(iProject)) {
                        refreshes.add(iProject);
                    } else {
                        additions.add(iProject);
                    }
                } else if (existingProjects.contains(iProject)) {
                    removals.add(iProject);
                }
                ++i;
            }
        }
        if (!(removals.isEmpty() && additions.isEmpty() && refreshes.isEmpty())) {
            TreeViewer viewer = (TreeViewer)this.getViewer();
            Tree tree = viewer.getTree();
            try {
                tree.setRedraw(false);
                if (!additions.isEmpty()) {
                    viewer.add(viewer.getInput(), additions.toArray());
                }
                if (!removals.isEmpty()) {
                    viewer.remove(viewer.getInput(), removals.toArray());
                }
                if (!refreshes.isEmpty()) {
                    for (Object e : refreshes) {
                        viewer.refresh(e);
                    }
                }
            }
            finally {
                tree.setRedraw(true);
            }
        }
    }

    private boolean isFlatPresentation() {
        ISynchronizePageConfiguration configuration = this.getConfiguration();
        if (configuration != null) {
            String p = (String)configuration.getProperty("org.eclipse.team.ui.pageLayout");
            return p != null && p.equals("org.eclipse.team.ui.flatLayout");
        }
        return false;
    }

    private boolean hasVisibleChanges(IDiffTree tree, IResource resource) {
        return tree.hasMatchingDiffs(resource.getFullPath(), new FastDiffFilter(){

            public boolean select(IDiff diff) {
                return ResourceModelContentProvider.this.isVisible(diff);
            }
        });
    }

    private IProject[] getChangedProjects(IDiffChangeEvent event) {
        HashSet<IProject> result = new HashSet<IProject>();
        IDiff[] changes = event.getChanges();
        int i = 0;
        while (i < changes.length) {
            IDiff diff = changes[i];
            IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
            if (resource != null) {
                result.add(resource.getProject());
            }
            ++i;
        }
        IDiff[] additions = event.getAdditions();
        int i2 = 0;
        while (i2 < additions.length) {
            IDiff diff = additions[i2];
            IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
            if (resource != null) {
                result.add(resource.getProject());
            }
            ++i2;
        }
        IPath[] removals = event.getRemovals();
        int i3 = 0;
        while (i3 < removals.length) {
            IPath path = removals[i3];
            if (path.segmentCount() > 0) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                result.add(project);
            }
            ++i3;
        }
        return result.toArray(new IProject[result.size()]);
    }

    private Set getVisibleProjects() {
        TreeViewer viewer = (TreeViewer)this.getViewer();
        Tree tree = viewer.getTree();
        TreeItem[] children = tree.getItems();
        HashSet<IResource> result = new HashSet<IResource>();
        int i = 0;
        while (i < children.length) {
            TreeItem control = children[i];
            Object data = control.getData();
            IResource resource = Utils.getResource(data);
            if (resource != null && resource.getType() == 4) {
                result.add(resource);
            }
            ++i;
        }
        return result;
    }

    private Set getVisibleResources() {
        TreeViewer viewer = (TreeViewer)this.getViewer();
        Tree tree = viewer.getTree();
        TreeItem[] children = tree.getItems();
        HashSet<IResource> result = new HashSet<IResource>();
        int i = 0;
        while (i < children.length) {
            TreeItem control = children[i];
            Object data = control.getData();
            IResource resource = Utils.getResource(data);
            if (resource != null) {
                result.add(resource);
            }
            ++i;
        }
        return result;
    }

    private IResource[] getChangedResources(IDiffChangeEvent event, Set existingResources) {
        HashSet<IResource> result = new HashSet<IResource>();
        IDiff[] changes = event.getChanges();
        int i = 0;
        while (i < changes.length) {
            IDiff diff = changes[i];
            IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
            if (resource != null) {
                result.add(resource);
            }
            ++i;
        }
        IDiff[] additions = event.getAdditions();
        int i2 = 0;
        while (i2 < additions.length) {
            IDiff diff = additions[i2];
            IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
            if (resource != null) {
                result.add(resource);
            }
            ++i2;
        }
        IPath[] removals = event.getRemovals();
        int i3 = 0;
        while (i3 < removals.length) {
            IPath path = removals[i3];
            if (path.segmentCount() > 0) {
                IResource resource2 = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                if (resource2 != null) {
                    result.add(resource2);
                } else {
                    for (IResource resource2 : existingResources) {
                        if (!resource2.getFullPath().equals((Object)path)) continue;
                        result.add(resource2);
                        break;
                    }
                }
            }
            ++i3;
        }
        return result.toArray(new IResource[result.size()]);
    }
}

