/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.ui.callgraph.statistics;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.statistics.AbstractSegmentsStatisticsViewer;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.CallGraphStatisticsAnalysis;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderManager;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderUtils;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class CallGraphStatisticsViewer
extends AbstractSegmentsStatisticsViewer {
    public CallGraphStatisticsViewer(Composite parent) {
        super(Objects.requireNonNull(parent));
        this.setLabelProvider((IBaseLabelProvider)new AbstractSegmentsStatisticsViewer.SegmentStoreStatisticsLabelProvider(){

            @Override
            public @NonNull String getColumnText(@Nullable Object element, int columnIndex) {
                if (columnIndex == 0 && element instanceof AbstractSegmentsStatisticsViewer.SegmentStoreStatisticsEntry) {
                    AbstractSegmentsStatisticsViewer.SegmentStoreStatisticsEntry entry = (AbstractSegmentsStatisticsViewer.SegmentStoreStatisticsEntry)((Object)element);
                    SymbolFormatter fe = new SymbolFormatter(CallGraphStatisticsViewer.this.getTrace());
                    return String.valueOf(fe.apply(entry));
                }
                return super.getColumnText(element, columnIndex);
            }
        });
    }

    @Override
    protected @Nullable TmfAbstractAnalysisModule createStatisticsAnalysiModule() {
        return new CallGraphStatisticsAnalysis();
    }

    private static final class SymbolFormatter
    implements Function<AbstractSegmentsStatisticsViewer.SegmentStoreStatisticsEntry, String> {
        private final @NonNull Collection<@NonNull ISymbolProvider> fSymbolProviders;

        public SymbolFormatter(@Nullable ITmfTrace trace) {
            this.fSymbolProviders = trace != null ? SymbolProviderManager.getInstance().getSymbolProviders(trace) : Collections.EMPTY_SET;
        }

        @Override
        public String apply(@Nullable AbstractSegmentsStatisticsViewer.SegmentStoreStatisticsEntry stat) {
            if (stat == null) {
                return "null";
            }
            String original = stat.getName();
            try {
                Long address = Long.decode(original);
                return SymbolProviderUtils.getSymbolText(this.fSymbolProviders, (long)address);
            }
            catch (NumberFormatException e) {
                return original;
            }
        }
    }
}

